/*
 * Decompiled with CFR 0.152.
 */
package org.helm.notation2.wsadapter;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.util.EntityUtils;
import org.helm.notation2.Monomer;
import org.helm.notation2.wsadapter.MonomerStoreConfiguration;
import org.helm.notation2.wsadapter.WSAdapterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonomerWSSaver {
    private static final Logger LOG = LoggerFactory.getLogger(MonomerWSSaver.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String saveMonomerToStore(Monomer monomer) {
        String res = "";
        CloseableHttpResponse response = null;
        try {
            response = WSAdapterUtils.putResource(monomer.toJSON(), MonomerStoreConfiguration.getInstance().getWebserviceNucleotidesPutFullURL());
            LOG.debug(response.getStatusLine().toString());
            JsonFactory jsonf = new JsonFactory();
            InputStream instream = response.getEntity().getContent();
            JsonParser jsonParser = jsonf.createParser(instream);
            while (!jsonParser.isClosed()) {
                JsonToken jsonToken = jsonParser.nextToken();
                if (!JsonToken.FIELD_NAME.equals((Object)jsonToken)) continue;
                String fieldName = jsonParser.getCurrentName();
                LOG.debug("Field name: " + fieldName);
                jsonParser.nextToken();
                if (!fieldName.equals("monomerShortName")) continue;
                res = jsonParser.getValueAsString();
                break;
            }
            EntityUtils.consume((HttpEntity)response.getEntity());
        }
        catch (Exception e) {
            LOG.error("Saving monomer failed!", (Throwable)e);
            String string = "";
            return string;
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                LOG.debug("Closing resources failed.", (Throwable)e);
                return res;
            }
        }
        return res;
    }
}

