/*
 * Decompiled with CFR 0.152.
 */
package org.helm.notation2.wsadapter;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.helm.notation2.Attachment;
import org.helm.notation2.AttachmentLoader;
import org.helm.notation2.Monomer;
import org.helm.notation2.exception.EncoderException;
import org.helm.notation2.exception.MonomerLoadingException;
import org.helm.notation2.tools.MolfileEncoder;
import org.helm.notation2.wsadapter.CategorizedMonomer;
import org.helm.notation2.wsadapter.MonomerStoreConfiguration;
import org.helm.notation2.wsadapter.WSAdapterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonomerWSLoader {
    private static final Logger LOG = LoggerFactory.getLogger(MonomerWSLoader.class);
    private final String[] knownPolymerTypes = new String[]{"PEPTIDE", "RNA", "CHEM"};
    private String polymerType;

    public MonomerWSLoader(String polymerType) throws IOException {
        if (!Arrays.asList(this.knownPolymerTypes).contains(polymerType)) {
            throw new IOException("Unknown polymerType '" + polymerType + "'. Supported types are " + this.knownPolymerTypes);
        }
        this.polymerType = polymerType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Monomer> loadMonomerStore(Map<String, Attachment> attachmentDB) throws IOException, URISyntaxException, EncoderException {
        Map<Object, Object> monomers = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        CloseableHttpClient httpclient = HttpClients.createDefault();
        CloseableHttpResponse response = null;
        try {
            HttpGet httpget = new HttpGet(new URIBuilder(MonomerStoreConfiguration.getInstance().getWebserviceMonomersFullURL() + this.polymerType).build());
            LOG.debug("Executing request " + httpget.getRequestLine());
            response = httpclient.execute((HttpUriRequest)httpget);
            LOG.debug(response.getStatusLine().toString());
            JsonFactory jsonf = new JsonFactory();
            InputStream instream = response.getEntity().getContent();
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new MonomerLoadingException("Response from the Webservice throws an error");
            }
            JsonParser jsonParser = jsonf.createJsonParser(instream);
            monomers = this.deserializeMonomerStore(jsonParser, attachmentDB);
            LOG.debug(monomers.size() + " " + this.polymerType + " monomers loaded");
            EntityUtils.consume((HttpEntity)response.getEntity());
        }
        finally {
            if (response != null) {
                response.close();
            }
            if (httpclient != null) {
                httpclient.close();
            }
        }
        return monomers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<CategorizedMonomer> loadMonomerCategorization() throws IOException, URISyntaxException {
        List<Object> config = new LinkedList();
        CloseableHttpClient httpclient = HttpClients.createDefault();
        CloseableHttpResponse response = null;
        try {
            response = WSAdapterUtils.getResource(MonomerStoreConfiguration.getInstance().getWebserviceEditorCategorizationFullURL());
            LOG.debug(response.getStatusLine().toString());
            JsonFactory jsonf = new JsonFactory();
            InputStream instream = response.getEntity().getContent();
            JsonParser jsonParser = jsonf.createJsonParser(instream);
            config = MonomerWSLoader.deserializeEditorCategorizationConfig(jsonParser);
            LOG.debug(config.size() + " categorization info entries loaded");
            EntityUtils.consume((HttpEntity)response.getEntity());
        }
        finally {
            if (response != null) {
                response.close();
            }
            if (httpclient != null) {
                httpclient.close();
            }
        }
        return config;
    }

    private Map<String, Monomer> deserializeMonomerStore(JsonParser parser, Map<String, Attachment> attachmentDB) throws JsonParseException, IOException, EncoderException {
        TreeMap<String, Monomer> monomers = new TreeMap<String, Monomer>(String.CASE_INSENSITIVE_ORDER);
        Monomer currentMonomer = null;
        parser.nextToken();
        while (parser.hasCurrentToken()) {
            String fieldName = parser.getCurrentName();
            JsonToken token = parser.getCurrentToken();
            if (JsonToken.START_OBJECT.equals((Object)token)) {
                currentMonomer = new Monomer();
            } else if (JsonToken.END_OBJECT.equals((Object)token)) {
                monomers.put(currentMonomer.getAlternateId(), currentMonomer);
            }
            if (fieldName != null) {
                switch (fieldName) {
                    case "id": {
                        parser.nextToken();
                        currentMonomer.setId(Integer.parseInt(parser.getText()));
                        break;
                    }
                    case "alternateId": {
                        parser.nextToken();
                        currentMonomer.setAlternateId(parser.getText());
                        break;
                    }
                    case "symbol": {
                        parser.nextToken();
                        currentMonomer.setAlternateId(parser.getText());
                        break;
                    }
                    case "naturalAnalog": {
                        parser.nextToken();
                        currentMonomer.setNaturalAnalog(parser.getText());
                        break;
                    }
                    case "name": {
                        parser.nextToken();
                        currentMonomer.setName(parser.getText());
                        break;
                    }
                    case "canSMILES": {
                        parser.nextToken();
                        currentMonomer.setCanSMILES(parser.getText());
                        break;
                    }
                    case "smiles": {
                        parser.nextToken();
                        currentMonomer.setCanSMILES(parser.getText());
                        break;
                    }
                    case "molfile": {
                        parser.nextToken();
                        try {
                            currentMonomer.setMolfile(MolfileEncoder.decode(parser.getText()));
                        }
                        catch (EncoderException e) {
                            LOG.info("Monomer file was not in the Base64-Format");
                            currentMonomer.setMolfile(parser.getText());
                        }
                        break;
                    }
                    case "monomerType": {
                        parser.nextToken();
                        currentMonomer.setMonomerType(parser.getText());
                        break;
                    }
                    case "polymerType": {
                        parser.nextToken();
                        currentMonomer.setPolymerType(parser.getText());
                        break;
                    }
                    case "attachmentList": {
                        currentMonomer.setAttachmentList(this.deserializeAttachmentList(parser, attachmentDB));
                        break;
                    }
                    case "rgroups": {
                        currentMonomer.setAttachmentList(this.deserializeAttachmentList(parser, attachmentDB));
                        break;
                    }
                    case "newMonomer": {
                        parser.nextToken();
                        currentMonomer.setNewMonomer(Boolean.parseBoolean(parser.getText()));
                        break;
                    }
                    case "adHocMonomer": {
                        parser.nextToken();
                        currentMonomer.setAdHocMonomer(Boolean.parseBoolean(parser.getText()));
                        break;
                    }
                }
            }
            parser.nextToken();
        }
        return monomers;
    }

    private List<Attachment> deserializeAttachmentList(JsonParser parser, Map<String, Attachment> attachmentDB) throws JsonParseException, IOException {
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        Attachment currentAttachment = null;
        while (!JsonToken.END_ARRAY.equals((Object)parser.nextToken())) {
            String fieldName = parser.getCurrentName();
            JsonToken token = parser.getCurrentToken();
            if (JsonToken.START_OBJECT.equals((Object)token)) {
                currentAttachment = new Attachment();
            } else if (JsonToken.END_OBJECT.equals((Object)token) && AttachmentLoader.validateAttachment(currentAttachment)) {
                currentAttachment.setCapGroupSMILES(attachmentDB.get(currentAttachment.getAlternateId()).getCapGroupSMILES());
                attachments.add(currentAttachment);
            }
            if (fieldName == null) continue;
            switch (fieldName) {
                case "id": {
                    parser.nextToken();
                    if (parser.getText() == null) break;
                    currentAttachment.setId(Integer.parseInt(parser.getText()));
                    break;
                }
                case "alternateId": {
                    parser.nextToken();
                    currentAttachment.setAlternateId(parser.getText());
                    break;
                }
                case "label": {
                    parser.nextToken();
                    currentAttachment.setLabel(parser.getText());
                    break;
                }
                case "capGroupName": {
                    parser.nextToken();
                    currentAttachment.setCapGroupName(parser.getText());
                    break;
                }
                case "capGroupSMILES": {
                    parser.nextToken();
                    currentAttachment.setCapGroupSMILES(parser.getText());
                    break;
                }
            }
        }
        return attachments;
    }

    private static List<CategorizedMonomer> deserializeEditorCategorizationConfig(JsonParser parser) throws JsonParseException, IOException {
        LinkedList<CategorizedMonomer> config = new LinkedList<CategorizedMonomer>();
        CategorizedMonomer currentMonomer = null;
        parser.nextToken();
        while (parser.hasCurrentToken()) {
            String fieldName = parser.getCurrentName();
            JsonToken token = parser.getCurrentToken();
            if (JsonToken.START_OBJECT.equals((Object)token)) {
                currentMonomer = new CategorizedMonomer();
            } else if (JsonToken.END_OBJECT.equals((Object)token)) {
                config.add(currentMonomer);
            }
            if (fieldName != null) {
                switch (fieldName) {
                    case "monomerID": {
                        parser.nextToken();
                        currentMonomer.setMonomerID(parser.getText());
                        break;
                    }
                    case "monomerName": {
                        parser.nextToken();
                        currentMonomer.setMonomerName(parser.getText());
                        break;
                    }
                    case "naturalAnalogon": {
                        parser.nextToken();
                        currentMonomer.setNaturalAnalogon(parser.getText());
                        break;
                    }
                    case "monomerType": {
                        parser.nextToken();
                        currentMonomer.setMonomerType(parser.getText());
                        break;
                    }
                    case "polymerType": {
                        parser.nextToken();
                        currentMonomer.setPolymerType(parser.getText());
                        break;
                    }
                    case "category": {
                        parser.nextToken();
                        currentMonomer.setCategory(parser.getText());
                        break;
                    }
                    case "shape": {
                        parser.nextToken();
                        currentMonomer.setShape(parser.getText());
                        break;
                    }
                    case "fontColor": {
                        parser.nextToken();
                        currentMonomer.setFontColor(parser.getText());
                        break;
                    }
                    case "backgroundColor": {
                        parser.nextToken();
                        currentMonomer.setBackgroundColor(parser.getText());
                        break;
                    }
                }
            }
            parser.nextToken();
        }
        return config;
    }
}

