/*
 * Decompiled with CFR 0.152.
 */
package org.helm.notation2.tools;

import java.io.IOException;
import java.util.List;
import org.helm.chemtoolkit.AbstractChemistryManipulator;
import org.helm.chemtoolkit.AbstractMolecule;
import org.helm.chemtoolkit.CTKException;
import org.helm.chemtoolkit.CTKSmilesException;
import org.helm.notation2.Attachment;
import org.helm.notation2.Chemistry;
import org.helm.notation2.Monomer;
import org.helm.notation2.exception.BuilderMoleculeException;
import org.helm.notation2.exception.ChemistryException;
import org.helm.notation2.exception.HELM2HandledException;
import org.helm.notation2.exception.NotationException;
import org.helm.notation2.parser.notation.HELM2Notation;
import org.helm.notation2.parser.notation.polymer.ChemEntity;
import org.helm.notation2.parser.notation.polymer.PolymerNotation;
import org.helm.notation2.tools.BuilderMolecule;
import org.helm.notation2.tools.HELM2NotationUtils;
import org.helm.notation2.tools.MethodsMonomerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SMILES {
    private static final Logger LOG = LoggerFactory.getLogger(SMILES.class);

    public static String getSMILESForAll(HELM2Notation helm2notation) throws BuilderMoleculeException, CTKException, ChemistryException {
        LOG.debug("Build single molecule(s)");
        List<AbstractMolecule> molecules = BuilderMolecule.buildMoleculefromPolymers(helm2notation.getListOfPolymers(), HELM2NotationUtils.getAllEdgeConnections(helm2notation.getListOfConnections()));
        LOG.debug("Built single molecule(s)");
        StringBuffer sb = new StringBuffer();
        for (AbstractMolecule molecule : molecules) {
            molecule = BuilderMolecule.mergeRgroups(molecule);
            sb.append(Chemistry.getInstance().getManipulator().convertMolecule(molecule, AbstractChemistryManipulator.StType.SMILES) + ".");
        }
        sb.setLength(sb.length() - 1);
        LOG.debug("SMILES-All :" + sb.toString());
        return sb.toString();
    }

    public static String getCanonicalSMILESForAll(HELM2Notation helm2notation) throws BuilderMoleculeException, CTKSmilesException, CTKException, NotationException, ChemistryException {
        LOG.debug("Build single molecule(s)");
        List<AbstractMolecule> molecules = BuilderMolecule.buildMoleculefromPolymers(helm2notation.getListOfPolymers(), helm2notation.getListOfConnections());
        LOG.debug("Built single molecule(s)");
        StringBuffer sb = new StringBuffer();
        for (AbstractMolecule molecule : molecules) {
            molecule = BuilderMolecule.mergeRgroups(molecule);
            sb.append(Chemistry.getInstance().getManipulator().canonicalize(Chemistry.getInstance().getManipulator().convertMolecule(molecule, AbstractChemistryManipulator.StType.SMILES)) + ".");
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    public static boolean containsGenericStructurePolymer(List<PolymerNotation> polymers) throws HELM2HandledException, ChemistryException, IOException, CTKException {
        for (PolymerNotation polymer : polymers) {
            if (!(polymer.getPolymerID() instanceof ChemEntity)) continue;
            Monomer monomer = MethodsMonomerUtils.getListOfHandledMonomers(polymer.getPolymerElements().getListOfElements()).get(0);
            if (null == monomer.getCanSMILES() || monomer.getCanSMILES().length() == 0) {
                return true;
            }
            if (!monomer.containAnyAtom()) continue;
            return true;
        }
        return false;
    }

    public static String getUniqueExtendedSMILES(String smiles) {
        return smiles;
    }

    public static String getCanonicalSMILESForPolymer(PolymerNotation polymer) throws BuilderMoleculeException, HELM2HandledException, CTKSmilesException, CTKException, NotationException, ChemistryException {
        AbstractMolecule molecule = BuilderMolecule.buildMoleculefromSinglePolymer(polymer).getMolecule();
        molecule = BuilderMolecule.mergeRgroups(molecule);
        return Chemistry.getInstance().getManipulator().canonicalize(Chemistry.getInstance().getManipulator().convertMolecule(molecule, AbstractChemistryManipulator.StType.SMILES));
    }

    public static String getSMILESforPolymer(PolymerNotation polymer) throws BuilderMoleculeException, HELM2HandledException, CTKSmilesException, CTKException, NotationException, ChemistryException {
        AbstractMolecule molecule = BuilderMolecule.buildMoleculefromSinglePolymer(polymer).getMolecule();
        molecule = BuilderMolecule.mergeRgroups(molecule);
        return Chemistry.getInstance().getManipulator().convertMolecule(molecule, AbstractChemistryManipulator.StType.SMILES);
    }

    public static String convertMolToSMILESWithAtomMapping(String molfile, List<Attachment> attachments) throws CTKException, ChemistryException {
        String smiles = Chemistry.getInstance().getManipulator().convertMolIntoSmilesWithAtomMapping(molfile);
        for (Attachment attachment : attachments) {
            int r = Integer.valueOf(attachment.getLabel().replaceAll("\\D+", ""));
            smiles = smiles.replace("[*:" + r + "]", "[" + attachment.getCapGroupName() + ":" + r + "]");
        }
        return smiles;
    }

    public static boolean isConnected(String molfile) throws CTKException, ChemistryException {
        return Chemistry.getInstance().getManipulator().isConnected(molfile);
    }
}

