/*
 * Decompiled with CFR 0.152.
 */
package org.helm.notation2.tools;

import org.helm.notation2.parser.notation.polymer.MonomerNotation;
import org.helm.notation2.parser.notation.polymer.MonomerNotationGroup;
import org.helm.notation2.parser.notation.polymer.MonomerNotationList;
import org.helm.notation2.parser.notation.polymer.MonomerNotationUnit;
import org.helm.notation2.parser.notation.polymer.MonomerNotationUnitRNA;
import org.helm.notation2.parser.notation.polymer.PolymerNotation;

public class PolymerUtils {
    public static int getTotalMonomerCount(PolymerNotation polymer) {
        int count = 0;
        for (MonomerNotation element : polymer.getPolymerElements().getListOfElements()) {
            count += PolymerUtils.getMonomerCountFromMonomerNotation(element);
        }
        return count;
    }

    private static int getMonomerCountFromMonomerNotation(MonomerNotation monomerNotation) {
        int multiply;
        try {
            multiply = Integer.parseInt(monomerNotation.getCount());
            if (multiply < 1) {
                multiply = 1;
            }
        }
        catch (NumberFormatException e) {
            multiply = 1;
        }
        if (monomerNotation instanceof MonomerNotationGroup) {
            return 1 * multiply;
        }
        if (monomerNotation instanceof MonomerNotationList) {
            int count = 0;
            for (MonomerNotation unit : ((MonomerNotationList)monomerNotation).getListofMonomerUnits()) {
                count += PolymerUtils.getMonomerCountFromMonomerNotation(unit);
            }
            return count * multiply;
        }
        if (monomerNotation instanceof MonomerNotationUnitRNA) {
            int count = 0;
            for (MonomerNotationUnit unit : ((MonomerNotationUnitRNA)monomerNotation).getContents()) {
                count += PolymerUtils.getMonomerCountFromMonomerNotation((MonomerNotation)unit);
            }
            return count * multiply;
        }
        return 1 * multiply;
    }
}

