/*
 * Decompiled with CFR 0.152.
 */
package org.helm.notation2.tools;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.helm.notation2.Monomer;
import org.helm.notation2.Nucleotide;
import org.helm.notation2.NucleotideFactory;
import org.helm.notation2.exception.ChemistryException;
import org.helm.notation2.exception.MonomerException;
import org.helm.notation2.exception.NotationException;
import org.helm.notation2.exception.NucleotideLoadingException;
import org.helm.notation2.tools.MethodsMonomerUtils;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NucleotideParser {
    public static final char MODIFICATION_START_SYMBOL = '[';
    public static final char MODIFICATION_END_SYMBOL = ']';
    public static final char BRANCH_START_SYMBOL = '(';
    public static final char BRANCH_END_SYMBOL = ')';
    @Deprecated
    public static final String DEFAULT_NOTATION_SOURCE = "HELM Notation";
    public static final int MINUMUM_MATCH_FRAGMENT_LENGTH = 2;
    public static Map<String, String> complementMap = new HashMap<String, String>();
    public static final String RNA_DESIGN_NONE = "NONE";
    public static final String RNA_DESIGN_TUSCHL_19_PLUS_2 = "TUSCHL_19_PLUS_2";
    public static final String RNA_DESIGN_DICER_27_R = "DICER_27_R";
    public static final String RNA_DESIGN_DICER_27_L = "DICER_27_L";
    public static final List<String> SUPPORTED_DESIGN_LIST;
    private static final String NUCLEOTIDE_SYMBOL_ELEMENT = "SYMBOL";
    private static final String NUCLEOTIDE_MONOMER_NOTATION_ELEMENT = "MONOMER_NOTATION";
    private static final String NUCLEOTIDE_ELEMENT = "NUCLEOTIDE";
    private static final String TEMPLATE_ELEMENT = "TEMPLATE";
    private static final String TEMPLATE_NOTATION_SOURCE_ATTRIBUTE = "notationSource";
    private static final Logger LOG;

    public static Map<String, Map<String, String>> getNucleotideTemplates(Element templatesElement) {
        TreeMap<String, Map<String, String>> map = new TreeMap<String, Map<String, String>>(String.CASE_INSENSITIVE_ORDER);
        List templates = templatesElement.getChildren();
        for (Element templateElement : templates) {
            String notationSource = templateElement.getAttributeValue(TEMPLATE_NOTATION_SOURCE_ATTRIBUTE);
            TreeMap<String, String> tmpMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
            map.put(notationSource, tmpMap);
            List nucleotides = templateElement.getChildren();
            for (Element nucleotideElement : nucleotides) {
                Nucleotide nucleotide = NucleotideParser.getNucleotide(nucleotideElement);
                tmpMap.put(nucleotide.getSymbol(), nucleotide.getNotation());
            }
        }
        return map;
    }

    public static Nucleotide getNucleotide(Element nucleotideElement) {
        Element symbolE = nucleotideElement.getChild(NUCLEOTIDE_SYMBOL_ELEMENT, nucleotideElement.getNamespace());
        Element notationE = nucleotideElement.getChild(NUCLEOTIDE_MONOMER_NOTATION_ELEMENT, nucleotideElement.getNamespace());
        return new Nucleotide(symbolE.getText(), notationE.getText());
    }

    public static Nucleotide getNucleotide(String nucleotideXML) throws JDOMException, IOException {
        Nucleotide nuc = null;
        if (nucleotideXML != null && nucleotideXML.length() > 0) {
            SAXBuilder builder = new SAXBuilder();
            ByteArrayInputStream bais = new ByteArrayInputStream(nucleotideXML.getBytes());
            Document doc = builder.build((InputStream)bais);
            Element root = doc.getRootElement();
            nuc = NucleotideParser.getNucleotide(root);
        }
        return nuc;
    }

    public static String getNucleotideTemplatesXML(Map<String, Map<String, String>> templates) {
        XMLOutputter outputer = new XMLOutputter(Format.getPrettyFormat());
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<NUCLEOTIDE_TEMPLATES xsi:schemaLocation=\"lmr NucleotideTemplateSchema.xsd\" xmlns=\"lmr\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n");
        Set<String> templateSet = templates.keySet();
        for (String template : templateSet) {
            Element templateElement = new Element(TEMPLATE_ELEMENT);
            Attribute att = new Attribute(TEMPLATE_NOTATION_SOURCE_ATTRIBUTE, template);
            templateElement.setAttribute(att);
            Map<String, String> nucMap = templates.get(template);
            Set<String> nucleotideSet = nucMap.keySet();
            Iterator<String> it = nucleotideSet.iterator();
            while (it.hasNext()) {
                Element nucleotideElement = new Element(NUCLEOTIDE_ELEMENT);
                templateElement.getChildren().add(nucleotideElement);
                String symbol = it.next();
                Element symbolElement = new Element(NUCLEOTIDE_SYMBOL_ELEMENT);
                symbolElement.setText(symbol);
                nucleotideElement.getChildren().add(symbolElement);
                String notation = nucMap.get(symbol);
                Element notationElement = new Element(NUCLEOTIDE_MONOMER_NOTATION_ELEMENT);
                notationElement.setText(notation);
                nucleotideElement.getChildren().add(notationElement);
            }
            String templateString = outputer.outputString(templateElement);
            sb.append(templateString);
        }
        sb.append("\n</NUCLEOTIDE_TEMPLATES>");
        return sb.toString();
    }

    public static List<String> getMonomerIDListFromNucleotide(String element) throws org.helm.notation2.parser.exceptionparser.NotationException {
        ArrayList<String> ids = new ArrayList<String>();
        char[] chars = element.toCharArray();
        int prevLetter = 0;
        for (int i = 0; i < chars.length; ++i) {
            int matchingPos;
            int letter = chars[i];
            if (letter == 91) {
                matchingPos = NucleotideParser.getMatchingBracketPosition(chars, i, '[', ']');
                ++i;
                if (matchingPos == -1) {
                    throw new org.helm.notation2.parser.exceptionparser.NotationException("Invalid Polymer Notation: modified monomer must be enclosed by square brackets");
                }
                ids.add(element.substring(i, matchingPos));
                i = matchingPos;
            } else if (letter == 40) {
                if (i == 0) {
                    throw new org.helm.notation2.parser.exceptionparser.NotationException("Invalid Polymer Notation: branch monomer is not allowed at the beginning of notation");
                }
                if (prevLetter == 41) {
                    throw new org.helm.notation2.parser.exceptionparser.NotationException("Invalid Polymer Notation: branch monomers cannot be connected with each other");
                }
                matchingPos = NucleotideParser.getMatchingBracketPosition(chars, i, '(', ')');
                ++i;
                if (matchingPos == -1) {
                    throw new org.helm.notation2.parser.exceptionparser.NotationException("Invalid Polymer Notation: modified monomer must be enclosed by brackets");
                }
                String el = element.substring(i, matchingPos);
                if (el.startsWith("[") && el.endsWith("]")) {
                    el = el.substring(1, el.length() - 1);
                }
                ids.add(el);
                i = matchingPos;
            } else {
                ids.add(element.substring(i, i + 1));
            }
            prevLetter = letter;
        }
        return ids;
    }

    public static Nucleotide convertToNucleotide(String id, boolean last) throws MonomerException, NotationException, ChemistryException, NucleotideLoadingException, org.helm.notation2.parser.exceptionparser.NotationException {
        Map<String, String> reverseNucMap = NucleotideFactory.getInstance().getReverseNucleotideTemplateMap();
        String tmpNotation = id;
        String symbol = null;
        if (last && id.endsWith(")")) {
            tmpNotation = id + "P";
        }
        if (reverseNucMap.containsKey(tmpNotation)) {
            symbol = reverseNucMap.get(tmpNotation);
        } else {
            char[] chars = id.toCharArray();
            String base = null;
            symbol = "X";
            for (int j = 0; j < chars.length; ++j) {
                Monomer monomer;
                int matchingPos;
                char letter = chars[j];
                if (letter == '[') {
                    matchingPos = NucleotideParser.getMatchingBracketPosition(chars, j, '[', ']');
                    ++j;
                    if (matchingPos == -1) {
                        throw new org.helm.notation2.parser.exceptionparser.NotationException("Invalid Polymer Notation: Could not find matching bracket");
                    }
                    j = matchingPos;
                    continue;
                }
                if (letter != '(') continue;
                matchingPos = NucleotideParser.getMatchingBracketPosition(chars, j, '(', ')');
                ++j;
                if (matchingPos == -1) {
                    throw new org.helm.notation2.parser.exceptionparser.NotationException("Invalid Polymer Notation: Could not find matching bracket");
                }
                base = id.substring(j, matchingPos);
                symbol = base.length() == 1 ? base : (null == (monomer = MethodsMonomerUtils.getMonomer("RNA", base, "")).getNaturalAnalog() ? "X" : monomer.getNaturalAnalog());
                j = matchingPos;
            }
        }
        Nucleotide nuc = new Nucleotide(symbol, id);
        return nuc;
    }

    public static int getMonomerCountForRNA(String notation) throws org.helm.notation2.parser.exceptionparser.NotationException {
        return NucleotideParser.getMonomerIDListFromNucleotide(notation).size();
    }

    public static boolean validateSimpleNotationForRNA(String polymerNotation) throws org.helm.notation2.parser.exceptionparser.NotationException {
        NucleotideParser.getMonomerIDListFromNucleotide(polymerNotation);
        return true;
    }

    public static int getMatchingBracketPosition(char[] characters, int position, char openingBracket, char closingBracket) {
        if (position < characters.length - 1 && characters[position] == openingBracket) {
            int currentPosition = position;
            int openingBracketCount = 1;
            do {
                char currentCharacter;
                if ((currentCharacter = characters[++currentPosition]) == openingBracket) {
                    ++openingBracketCount;
                    continue;
                }
                if (currentCharacter != closingBracket) continue;
                --openingBracketCount;
            } while (openingBracketCount > 0 && currentPosition < characters.length - 1);
            if (characters[currentPosition] == closingBracket) {
                return currentPosition;
            }
            return -1;
        }
        return -1;
    }

    static {
        complementMap.put("A", "U");
        complementMap.put("G", "C");
        complementMap.put("C", "G");
        complementMap.put("U", "A");
        complementMap.put("T", "A");
        complementMap.put("X", "X");
        SUPPORTED_DESIGN_LIST = new ArrayList<String>();
        SUPPORTED_DESIGN_LIST.add(RNA_DESIGN_NONE);
        SUPPORTED_DESIGN_LIST.add(RNA_DESIGN_TUSCHL_19_PLUS_2);
        SUPPORTED_DESIGN_LIST.add(RNA_DESIGN_DICER_27_L);
        SUPPORTED_DESIGN_LIST.add(RNA_DESIGN_DICER_27_R);
        LOG = LoggerFactory.getLogger(NucleotideParser.class);
    }
}

