/*
 * Decompiled with CFR 0.152.
 */
package org.helm.notation2.tools;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.helm.chemtoolkit.AbstractChemistryManipulator;
import org.helm.chemtoolkit.CTKException;
import org.helm.notation2.Attachment;
import org.helm.notation2.Chemistry;
import org.helm.notation2.DeepCopy;
import org.helm.notation2.Monomer;
import org.helm.notation2.MonomerFactory;
import org.helm.notation2.MonomerStore;
import org.helm.notation2.exception.ChemistryException;
import org.helm.notation2.exception.HELM2HandledException;
import org.helm.notation2.exception.MonomerException;
import org.helm.notation2.exception.MonomerLoadingException;
import org.helm.notation2.exception.NotationException;
import org.helm.notation2.parser.notation.polymer.MonomerNotation;
import org.helm.notation2.parser.notation.polymer.MonomerNotationGroup;
import org.helm.notation2.parser.notation.polymer.MonomerNotationList;
import org.helm.notation2.parser.notation.polymer.PolymerNotation;
import org.helm.notation2.tools.MonomerParser;
import org.helm.notation2.tools.Validation;
import org.jdom2.JDOMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MethodsMonomerUtils {
    private static final Logger LOG = LoggerFactory.getLogger(MethodsMonomerUtils.class);
    private static Map<String, Integer> seedMap = new HashMap<String, Integer>();

    private MethodsMonomerUtils() {
    }

    public static List<Monomer> getListOfHandledMonomers(List<MonomerNotation> monomerNotations) throws HELM2HandledException, ChemistryException {
        ArrayList<Monomer> items = new ArrayList<Monomer>();
        for (int i = 0; i < monomerNotations.size(); ++i) {
            MonomerNotation monomerNotation = monomerNotations.get(i);
            if (monomerNotation instanceof MonomerNotationGroup) {
                items.add(new Monomer(monomerNotation.getType(), monomerNotation.getType().equals("RNA") ? "Branch" : "Backbone", "X", "X"));
                continue;
            }
            if (monomerNotation instanceof MonomerNotationList) {
                throw new HELM2HandledException("Functions can't be called for HELM2 objects");
            }
            try {
                int count = Integer.parseInt(monomerNotation.getCount());
                if (count == 0) {
                    throw new HELM2HandledException("Functions can't be called for HELM2 objects");
                }
                for (int j = 0; j < count; ++j) {
                    items.addAll(Validation.getAllMonomers(monomerNotation, i));
                }
                continue;
            }
            catch (IOException | NumberFormatException | CTKException | MonomerException | NotationException e) {
                e.printStackTrace();
                throw new HELM2HandledException("Functions can't be called for HELM2 objects");
            }
        }
        return items;
    }

    public static List<Monomer> getListOfHandledMonomersOnlyBase(List<MonomerNotation> monomerNotations) throws HELM2HandledException, NotationException, ChemistryException {
        LOG.debug("Get all bases of the rna");
        ArrayList<Monomer> items = new ArrayList<Monomer>();
        for (MonomerNotation monomerNotation : monomerNotations) {
            if (monomerNotation instanceof MonomerNotationGroup) {
                throw new HELM2HandledException("Functions can't be called for HELM2 objects");
            }
            try {
                int count = Integer.parseInt(monomerNotation.getCount());
                if (count != 1) {
                    throw new HELM2HandledException("Functions can't be called for HELM2 objects");
                }
                items.addAll(Validation.getAllMonomersOnlyBase(monomerNotation));
            }
            catch (IOException | NumberFormatException | CTKException | MonomerException e) {
                e.printStackTrace();
                throw new HELM2HandledException("Functions can't be called for HELM2 objects");
            }
        }
        return items;
    }

    public static List<MonomerNotation> getListOfMonomerNotation(List<PolymerNotation> polymers) {
        ArrayList<MonomerNotation> items = new ArrayList<MonomerNotation>();
        for (PolymerNotation polymer : polymers) {
            items.addAll(polymer.getListMonomers());
        }
        return items;
    }

    public static List<Monomer> getListOfMonomer(List<MonomerNotation> monomerNotations) throws MonomerException, HELM2HandledException, CTKException, NotationException, ChemistryException, MonomerLoadingException {
        ArrayList<Monomer> items = new ArrayList<Monomer>();
        for (int i = 0; i < monomerNotations.size(); ++i) {
            items.addAll(Validation.getAllMonomers(monomerNotations.get(i), i));
        }
        return items;
    }

    public static Monomer getMonomer(String type, String id, String info) throws MonomerException, NotationException, ChemistryException {
        try {
            MonomerFactory monomerFactory;
            MonomerStore monomerStore;
            Monomer monomer;
            if (id.startsWith("[") && id.endsWith("]")) {
                id = id.substring(1, id.length() - 1);
            }
            if ((monomer = (monomerStore = (monomerFactory = MonomerFactory.getInstance()).getMonomerStore()).getMonomer(type, id)) == null) {
                if (monomerFactory.getSmilesMonomerDB().get(id) != null) {
                    monomer = monomerFactory.getSmilesMonomerDB().get(id);
                    return monomer;
                }
                monomer = monomerFactory.getSmilesMonomerDB().get(id);
                if (monomer == null) {
                    AbstractChemistryManipulator manipulator = Chemistry.getInstance().getManipulator();
                    if (manipulator.validateSMILES(id)) {
                        if (type.equals("CHEM")) {
                            monomer = MethodsMonomerUtils.generateTemporaryMonomer(id, type, "X");
                        } else if (type.equals("PEPTIDE")) {
                            monomer = MethodsMonomerUtils.generateTemporaryMonomer(id, type, "X");
                        } else if (type.equals("RNA")) {
                            monomer = MethodsMonomerUtils.generateTemporaryMonomer(id, type, info);
                        }
                    } else {
                        if (!(id.equals("?") || id.equals("X") || id.equals("N"))) {
                            throw new MonomerException("Defined Monomer is not in the database and also not valid SMILES " + id);
                        }
                        return new Monomer(type, "Undefined", id, id);
                    }
                    MonomerFactory.getInstance().getMonomerStore().addNewMonomer(monomer);
                    MonomerFactory.getInstance().getSmilesMonomerDB().put(monomer.getCanSMILES(), monomer);
                    MonomerFactory.getInstance().saveMonomerCache();
                    LOG.info("Monomer was added to the database");
                }
            }
            try {
                List<Attachment> idList = monomer.getAttachmentList();
                for (Attachment att : idList) {
                    if (att.getCapGroupSMILES() != null) continue;
                    MonomerParser.fillAttachmentInfo(att);
                }
            }
            catch (CTKException | JDOMException ex) {
                throw new MonomerException("Attachments could not be filled with default attachments");
            }
            return monomer;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new MonomerException("Defined Monomer is not in the database and also not a valid SMILES " + id);
        }
    }

    private static List<Attachment> extractAttachments(String smiles) throws MonomerLoadingException {
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        Pattern pattern = Pattern.compile("\\[(\\w+):([1-9]\\d*)\\]");
        Matcher matcher = pattern.matcher(smiles);
        while (matcher.find()) {
            Attachment att = new Attachment();
            LOG.debug("Group2 " + matcher.group(2) + " Group1 " + matcher.group(1));
            att.setAlternateId("R" + matcher.group(2) + "-" + matcher.group(1));
            att.setCapGroupName(matcher.group(1));
            att.setId(Integer.parseInt(matcher.group(2)) - 1);
            att.setLabel("R" + matcher.group(2));
            if (att.getCapGroupName().equals("OH")) {
                att.setCapGroupSMILES("O[*:" + matcher.group(2) + "]");
            } else if (att.getCapGroupName().equals("H")) {
                att.setCapGroupSMILES("[*:" + matcher.group(2) + "][H]");
            } else {
                throw new MonomerLoadingException("CapGroup is unknown");
            }
            attachments.add(att);
        }
        return attachments;
    }

    public static Monomer generateTemporaryMonomer(String id, String polymerType, String naturalAnalog) throws NotationException, MonomerLoadingException, ChemistryException {
        String uniqueSmiles = Chemistry.getInstance().getManipulator().convertExtendedSmiles(id);
        String alternateId = MethodsMonomerUtils.generateNextAdHocMonomerID(polymerType);
        Map<String, Attachment> ids = MonomerFactory.getInstance().getAttachmentDB();
        Attachment R1HAtt = ids.get("R1-H");
        Monomer m = null;
        m = polymerType.equals("CHEM") ? new Monomer(polymerType, "Undefined", naturalAnalog, alternateId) : (polymerType.equals("RNA") ? (naturalAnalog.equals("P") || naturalAnalog.equals("R") ? new Monomer(polymerType, "Backbone", naturalAnalog, alternateId) : new Monomer(polymerType, "Branch", naturalAnalog, alternateId)) : new Monomer(polymerType, "Backbone", naturalAnalog, alternateId));
        m.setAdHocMonomer(true);
        m.setCanSMILES(uniqueSmiles);
        m.setName("Dynamic");
        List<Object> al = new ArrayList();
        al = MethodsMonomerUtils.extractAttachments(uniqueSmiles);
        if (al.size() > 0) {
            m.setAttachmentList(al);
        } else {
            int start = 0;
            int pos = uniqueSmiles.indexOf("R", start);
            String number = "";
            while (pos >= 0) {
                String letter = uniqueSmiles.substring(++pos, pos + 1);
                while (letter.matches("\\d")) {
                    number = number + letter;
                    letter = uniqueSmiles.substring(++pos, pos + 1);
                }
                try {
                    Attachment tmpAtt = DeepCopy.copy(R1HAtt);
                    tmpAtt.setLabel("R" + number);
                    tmpAtt.setAlternateId("R" + number + "-H");
                    String oldSmi = tmpAtt.getCapGroupSMILES();
                    String newSmi = oldSmi.replace("R1", "R" + number);
                    tmpAtt.setCapGroupSMILES(newSmi);
                    al.add(tmpAtt);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    throw new NotationException("Unable to create attachment by copying from attachment database", ex);
                }
                start = pos;
                pos = uniqueSmiles.indexOf("R", start);
                number = "";
            }
            m.setAttachmentList(al);
        }
        try {
            MonomerFactory.getInstance().getMonomerStore().addNewMonomer(m);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new NotationException("Unable to add adhoc new monomer into monomer database", ex);
        }
        return m;
    }

    private static String getAdHocMonomerIDPrefix(String polymerType) {
        if (polymerType.equals("CHEM")) {
            return "CM#";
        }
        if (polymerType.equals("PEPTIDE")) {
            return "PM#";
        }
        if (polymerType.equals("RNA")) {
            return "NM#";
        }
        return "AM#";
    }

    private static String generateNextAdHocMonomerID(String polymerType) throws MonomerLoadingException, ChemistryException {
        Map<String, Monomer> internalMonomers = null;
        internalMonomers = MonomerFactory.getInstance().getMonomerDB().get(polymerType);
        Map<String, Monomer> monomers = MonomerFactory.getInstance().getMonomerStore().getMonomers(polymerType);
        Integer seed = seedMap.get(polymerType);
        if (seed == null) {
            seed = 0;
        }
        Integer n = seed;
        Integer n2 = seed = Integer.valueOf(seed + 1);
        seedMap.put(polymerType, seed);
        String result = MethodsMonomerUtils.getAdHocMonomerIDPrefix(polymerType) + seed;
        if (monomers != null && monomers.containsKey(result) || internalMonomers != null && internalMonomers.containsKey(result)) {
            return MethodsMonomerUtils.generateNextAdHocMonomerID(polymerType);
        }
        return result;
    }
}

