/*
 * Decompiled with CFR 0.152.
 */
package org.helm.notation2.tools;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.helm.notation2.exception.ChemistryException;
import org.helm.notation2.exception.HELM2HandledException;
import org.helm.notation2.exception.NotationException;
import org.helm.notation2.exception.ParserException;
import org.helm.notation2.exception.RNAUtilsException;
import org.helm.notation2.parser.ConverterHELM1ToHELM2;
import org.helm.notation2.parser.ParserHELM2;
import org.helm.notation2.parser.exceptionparser.ExceptionState;
import org.helm.notation2.parser.notation.HELM2Notation;
import org.helm.notation2.parser.notation.annotation.AnnotationNotation;
import org.helm.notation2.parser.notation.connection.ConnectionNotation;
import org.helm.notation2.parser.notation.grouping.GroupingNotation;
import org.helm.notation2.parser.notation.polymer.BlobEntity;
import org.helm.notation2.parser.notation.polymer.ChemEntity;
import org.helm.notation2.parser.notation.polymer.GroupEntity;
import org.helm.notation2.parser.notation.polymer.HELMEntity;
import org.helm.notation2.parser.notation.polymer.PeptideEntity;
import org.helm.notation2.parser.notation.polymer.PolymerNotation;
import org.helm.notation2.parser.notation.polymer.RNAEntity;
import org.helm.notation2.tools.PolymerUtils;
import org.helm.notation2.tools.RNAUtils;
import org.jdom2.JDOMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HELM2NotationUtils {
    public static final String DEFAULT_PADDING_CHAR = " ";
    public static final String DEFAULT_BASE_PAIR_CHAR = "|";
    static final Logger LOG = LoggerFactory.getLogger(HELM2NotationUtils.class);
    private static HELM2Notation helm2notation;

    private HELM2NotationUtils() {
    }

    public static final String toJSON(HELM2Notation helm2notation) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        String jsonINString = mapper.writeValueAsString((Object)helm2notation);
        jsonINString = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)helm2notation);
        return jsonINString;
    }

    public static final List<ConnectionNotation> getAllEdgeConnections(List<ConnectionNotation> connections) {
        ArrayList<ConnectionNotation> listEdgeConnection = new ArrayList<ConnectionNotation>();
        for (ConnectionNotation connection : connections) {
            if (connection.getrGroupSource().equals("pair")) continue;
            listEdgeConnection.add(connection);
        }
        return listEdgeConnection;
    }

    public static final List<ConnectionNotation> getAllBasePairConnections(List<ConnectionNotation> connections) {
        ArrayList<ConnectionNotation> listEdgeConnection = new ArrayList<ConnectionNotation>();
        for (ConnectionNotation connection : connections) {
            if (!connection.getrGroupSource().equals("pair")) continue;
            listEdgeConnection.add(connection);
        }
        return listEdgeConnection;
    }

    public static final List<PolymerNotation> getRNAPolymers(List<PolymerNotation> polymers) {
        ArrayList<PolymerNotation> rnaPolymers = new ArrayList<PolymerNotation>();
        for (PolymerNotation polymer : polymers) {
            if (!(polymer.getPolymerID() instanceof RNAEntity)) continue;
            rnaPolymers.add(polymer);
        }
        return rnaPolymers;
    }

    public static final List<PolymerNotation> getPeptidePolymers(List<PolymerNotation> polymers) {
        ArrayList<PolymerNotation> peptidePolymers = new ArrayList<PolymerNotation>();
        for (PolymerNotation polymer : polymers) {
            if (!(polymer.getPolymerID() instanceof PeptideEntity)) continue;
            peptidePolymers.add(polymer);
        }
        return peptidePolymers;
    }

    public static final List<PolymerNotation> getCHEMPolymers(List<PolymerNotation> polymers) {
        ArrayList<PolymerNotation> chemPolymers = new ArrayList<PolymerNotation>();
        for (PolymerNotation polymer : polymers) {
            if (!(polymer.getPolymerID() instanceof ChemEntity)) continue;
            chemPolymers.add(polymer);
        }
        return chemPolymers;
    }

    public static final List<PolymerNotation> getBLOBPolymers(List<PolymerNotation> polymers) {
        ArrayList<PolymerNotation> blobPolymers = new ArrayList<PolymerNotation>();
        for (PolymerNotation polymer : polymers) {
            if (!(polymer.getPolymerID() instanceof BlobEntity)) continue;
            blobPolymers.add(polymer);
        }
        return blobPolymers;
    }

    public static final void combineHELM2notation(HELM2Notation helm2notation, HELM2Notation newHELM2Notation) throws org.helm.notation2.parser.exceptionparser.NotationException {
        HELM2NotationUtils.helm2notation = helm2notation;
        Map<String, String> mapIds = HELM2NotationUtils.generateMapChangeIds(newHELM2Notation.getPolymerAndGroupingIDs());
        HELM2NotationUtils.section1(newHELM2Notation.getListOfPolymers(), mapIds);
        HELM2NotationUtils.section2(newHELM2Notation.getListOfConnections(), mapIds);
        HELM2NotationUtils.section3(newHELM2Notation.getListOfGroupings(), mapIds);
        HELM2NotationUtils.section4(newHELM2Notation.getListOfAnnotations(), mapIds);
    }

    private static Map<String, String> generateMapChangeIds(List<String> newIDs) {
        HashMap<String, String> mapIds = new HashMap<String, String>();
        List oldIds = helm2notation.getPolymerAndGroupingIDs();
        HashMap<String, String> mapOldIds = new HashMap<String, String>();
        for (String oldID : oldIds) {
            mapOldIds.put(oldID, "");
        }
        for (String newId : newIDs) {
            if (!mapOldIds.containsKey(newId)) continue;
            int i = 1;
            String type = newId.split("\\d")[0];
            while (mapOldIds.containsKey(type + i)) {
                ++i;
            }
            mapIds.put(newId, type + i);
        }
        return mapIds;
    }

    private static void section1(List<PolymerNotation> polymers, Map<String, String> mapIds) throws org.helm.notation2.parser.exceptionparser.NotationException {
        for (PolymerNotation polymer : polymers) {
            if (mapIds.containsKey(polymer.getPolymerID().getId())) {
                PolymerNotation newpolymer = new PolymerNotation(mapIds.get(polymer.getPolymerID().getId()));
                newpolymer = new PolymerNotation(newpolymer.getPolymerID(), polymer.getPolymerElements());
                helm2notation.addPolymer(newpolymer);
                continue;
            }
            helm2notation.addPolymer(polymer);
        }
    }

    private static void section2(List<ConnectionNotation> connections, Map<String, String> mapIds) throws org.helm.notation2.parser.exceptionparser.NotationException {
        for (ConnectionNotation connection : connections) {
            HELMEntity first = connection.getSourceId();
            String idFirst = first.getId();
            HELMEntity second = connection.getTargetId();
            String idSecond = second.getId();
            if (mapIds.containsKey(idFirst)) {
                first = new ConnectionNotation(mapIds.get(idFirst)).getSourceId();
            }
            if (mapIds.containsKey(idSecond)) {
                second = new ConnectionNotation(mapIds.get(idSecond)).getSourceId();
            }
            ConnectionNotation newConnection = new ConnectionNotation(first, second, connection.getSourceUnit(), connection.getrGroupSource(), connection.getTargetUnit(), connection.getrGroupTarget(), connection.getAnnotation());
            helm2notation.addConnection(newConnection);
        }
    }

    private static void section3(List<GroupingNotation> groupings, Map<String, String> mapIds) throws org.helm.notation2.parser.exceptionparser.NotationException {
        for (GroupingNotation grouping : groupings) {
            GroupEntity groupID = grouping.getGroupID();
            if (mapIds.containsKey(groupID.getId())) {
                groupID = new GroupingNotation(mapIds.get(groupID.getId())).getGroupID();
            }
            String details = grouping.toHELM2().split("\\(")[1].split("\\)")[0];
            details = HELM2NotationUtils.changeIDs(details, mapIds);
            helm2notation.addGrouping(new GroupingNotation(groupID, details));
        }
    }

    private static void section4(List<AnnotationNotation> annotations, Map<String, String> mapIds) {
        for (AnnotationNotation annotation : annotations) {
            String notation = annotation.getAnnotation();
            notation = HELM2NotationUtils.changeIDs(notation, mapIds);
            helm2notation.addAnnotation(new AnnotationNotation(notation));
        }
    }

    private static String changeIDs(String text, Map<String, String> mapIds) {
        String result = text;
        for (String key : mapIds.keySet()) {
            result = result.replace(key, mapIds.get(key));
        }
        return result;
    }

    public static final int getTotalMonomerCount(HELM2Notation helm2notation) {
        int result = 0;
        for (PolymerNotation polymer : helm2notation.getListOfPolymers()) {
            result += PolymerUtils.getTotalMonomerCount(polymer);
        }
        return result;
    }

    public static boolean hasNucleotideModification(List<PolymerNotation> polymers) throws org.helm.notation2.parser.exceptionparser.NotationException {
        for (PolymerNotation polymer : HELM2NotationUtils.getRNAPolymers(polymers)) {
            if (!RNAUtils.hasNucleotideModification(polymer)) continue;
            return true;
        }
        return false;
    }

    public static String[] getFormatedSirnaSequences(HELM2Notation helm2notation) throws org.helm.notation2.parser.exceptionparser.NotationException, RNAUtilsException, HELM2HandledException, NotationException, ChemistryException {
        return HELM2NotationUtils.getFormatedSirnaSequences(helm2notation, DEFAULT_PADDING_CHAR, DEFAULT_BASE_PAIR_CHAR);
    }

    public static String[] getFormatedSirnaSequences(HELM2Notation helm2notation, String paddingChar, String basePairChar) throws org.helm.notation2.parser.exceptionparser.NotationException, RNAUtilsException, HELM2HandledException, NotationException, ChemistryException {
        if (null == paddingChar || paddingChar.length() != 1) {
            throw new org.helm.notation2.parser.exceptionparser.NotationException("Padding string must be single character");
        }
        if (null == basePairChar || basePairChar.length() != 1) {
            throw new org.helm.notation2.parser.exceptionparser.NotationException("Base pair string must be single character");
        }
        List<PolymerNotation> rnaList = HELM2NotationUtils.getRNAPolymers(helm2notation.getListOfPolymers());
        int count = rnaList.size();
        if (count == 0) {
            return new String[0];
        }
        if (count == 1) {
            return new String[]{RNAUtils.getSequence(rnaList.get(0))};
        }
        if (count == 2) {
            Integer in;
            int i;
            String rna1Seq = null;
            String rna2Seq = null;
            String rna1Annotation = null;
            String rna2Annotation = null;
            PolymerNotation one = null;
            PolymerNotation two = null;
            for (PolymerNotation node : rnaList) {
                if (node.getPolymerID().getId().equals("RNA1")) {
                    rna1Seq = RNAUtils.getSequence(node);
                    rna1Annotation = node.getAnnotation();
                    one = node;
                    continue;
                }
                if (!node.getPolymerID().getId().equals("RNA2")) continue;
                rna2Seq = RNAUtils.getSequence(node);
                two = node;
                rna2Annotation = node.getAnnotation();
            }
            String reverseRna2Seq = RNAUtils.getReverseSequence(two);
            List<ConnectionNotation> connections = HELM2NotationUtils.getAllBasePairConnections(helm2notation.getListOfConnections());
            if (null == connections || connections.size() == 0) {
                return new String[]{rna1Seq, rna2Seq};
            }
            Map<Integer, Integer> monomerPositionMap = HELM2NotationUtils.getSirnaMonomerPositionMap(connections);
            HashMap<Integer, Integer> seqPositionMap = new HashMap<Integer, Integer>();
            Set<Integer> monomerSet = monomerPositionMap.keySet();
            for (Integer key : monomerSet) {
                Integer value = monomerPositionMap.get(key);
                Integer seqKey = new Integer(key / 3 + 1);
                Integer seqValue = new Integer(value / 3 + 1);
                seqPositionMap.put(seqKey, seqValue);
            }
            Set seqSet = seqPositionMap.keySet();
            ArrayList<Integer> seqList = new ArrayList<Integer>();
            for (Integer key : seqSet) {
                seqList.add(key);
            }
            Collections.sort(seqList);
            int rna1First = (Integer)seqList.get(0);
            int rna2Last = (Integer)seqPositionMap.get(seqList.get(0));
            int rna1Last = (Integer)seqList.get(seqList.size() - 1);
            int rna2First = (Integer)seqPositionMap.get(seqList.get(seqList.size() - 1));
            if (rna1Last - rna1First != rna2Last - rna2First) {
                throw new org.helm.notation2.parser.exceptionparser.NotationException("siRNA matching lengths are different");
            }
            int rna1LeftOverhang = rna1First - 1;
            int rna1RightOverhang = rna1Seq.length() - rna1Last;
            int rna2LeftOverhang = rna2Seq.length() - rna2Last;
            int rna2RightOverhang = rna2First - 1;
            StringBuffer[] sbs = new StringBuffer[3];
            for (i = 0; i < sbs.length; ++i) {
                sbs[i] = new StringBuffer();
            }
            if (rna1LeftOverhang >= rna2LeftOverhang) {
                sbs[0].append(rna1Seq);
                for (i = 0; i < rna1LeftOverhang; ++i) {
                    sbs[1].append(paddingChar);
                }
                for (i = rna1First; i < rna1Last + 1; ++i) {
                    in = new Integer(i);
                    if (seqPositionMap.containsKey(in)) {
                        sbs[1].append(basePairChar);
                        continue;
                    }
                    sbs[1].append(paddingChar);
                }
                for (i = 0; i < rna1LeftOverhang - rna2LeftOverhang; ++i) {
                    sbs[2].append(paddingChar);
                }
                sbs[2].append(reverseRna2Seq);
            } else {
                for (i = 0; i < rna2LeftOverhang - rna1LeftOverhang; ++i) {
                    sbs[0].append(paddingChar);
                }
                sbs[0].append(rna1Seq);
                for (i = 0; i < rna2LeftOverhang; ++i) {
                    sbs[1].append(paddingChar);
                }
                for (i = rna1First; i < rna1Last + 1; ++i) {
                    in = new Integer(i);
                    if (seqPositionMap.containsKey(in)) {
                        sbs[1].append(basePairChar);
                        continue;
                    }
                    sbs[1].append(paddingChar);
                }
                sbs[2].append(reverseRna2Seq);
            }
            if (rna1RightOverhang >= rna2RightOverhang) {
                for (i = 0; i < rna1RightOverhang; ++i) {
                    sbs[1].append(paddingChar);
                }
                for (i = 0; i < rna1RightOverhang - rna2RightOverhang; ++i) {
                    sbs[2].append(paddingChar);
                }
            } else {
                for (i = 0; i < rna2RightOverhang - rna1RightOverhang; ++i) {
                    sbs[0].append(paddingChar);
                }
                for (i = 0; i < rna2RightOverhang - rna1RightOverhang; ++i) {
                    sbs[1].append(paddingChar);
                }
            }
            if (rna1Annotation != null && rna1Annotation.equalsIgnoreCase("AS") || rna2Annotation != null && rna2Annotation.equalsIgnoreCase("SS")) {
                return new String[]{HELM2NotationUtils.reverseString(sbs[2].toString()), HELM2NotationUtils.reverseString(sbs[1].toString()), HELM2NotationUtils.reverseString(sbs[0].toString())};
            }
            return new String[]{sbs[0].toString(), sbs[1].toString(), sbs[2].toString()};
        }
        throw new org.helm.notation2.parser.exceptionparser.NotationException("Structure contains more than two RNA sequences");
    }

    private static Map<Integer, Integer> getSirnaMonomerPositionMap(List<ConnectionNotation> connections) throws org.helm.notation2.parser.exceptionparser.NotationException {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        for (ConnectionNotation connection : connections) {
            String source = connection.getSourceId().getId();
            String target = connection.getTargetId().getId();
            Integer int1 = new Integer(connection.getSourceUnit());
            Integer int2 = new Integer(connection.getTargetUnit());
            if (source.equals("RNA1") && target.equals("RNA2")) {
                map.put(int1, int2);
                continue;
            }
            if (source.equals("RNA2") && target.equals("RNA1")) {
                map.put(int2, int1);
                continue;
            }
            throw new org.helm.notation2.parser.exceptionparser.NotationException("Structure contains more than two RNA sequences");
        }
        return map;
    }

    private static String reverseString(String source) {
        int len = source.length();
        StringBuffer dest = new StringBuffer();
        for (int i = len - 1; i >= 0; --i) {
            dest.append(source.charAt(i));
        }
        return dest.toString();
    }

    public List<HELM2Notation> decompose(HELM2Notation helm2notation) {
        ArrayList<HELM2Notation> list = new ArrayList<HELM2Notation>();
        List<ConnectionNotation> allselfConnections = HELM2NotationUtils.getAllSelfCycleConnections(helm2notation.getListOfConnections());
        for (PolymerNotation polymer : helm2notation.getListOfPolymers()) {
            HELM2Notation single = new HELM2Notation();
            single.addPolymer(polymer);
            List<ConnectionNotation> selfConnections = HELM2NotationUtils.getSelfCycleConnections(polymer.getPolymerID().getId(), allselfConnections);
            for (ConnectionNotation selfConnection : selfConnections) {
                single.addConnection(selfConnection);
            }
            list.add(single);
        }
        return list;
    }

    private static List<ConnectionNotation> getAllSelfCycleConnections(List<ConnectionNotation> connections) {
        ArrayList<ConnectionNotation> listSelfCycle = new ArrayList<ConnectionNotation>();
        for (ConnectionNotation connection : connections) {
            if (!connection.getTargetId().getId().equals(connection.getSourceId().getId())) continue;
            listSelfCycle.add(connection);
        }
        return listSelfCycle;
    }

    private static List<ConnectionNotation> getSelfCycleConnections(String id, List<ConnectionNotation> connections) {
        ArrayList<ConnectionNotation> list = new ArrayList<ConnectionNotation>();
        for (ConnectionNotation connection : connections) {
            if (!connection.getSourceId().getId().equals(id)) continue;
            list.add(connection);
        }
        return list;
    }

    public static HELM2Notation readNotation(String notation) throws ParserException, JDOMException {
        if (!notation.contains("V2.0") && !notation.contains("v2.0")) {
            if (notation.endsWith("$")) {
                LOG.info("Convert HELM1 into HELM2");
                notation = new ConverterHELM1ToHELM2().doConvert(notation);
                LOG.info("Conversion was successful: " + notation);
            } else {
                LOG.info("Wrong HELM Input");
                throw new ParserException("HELMNotation is not valid");
            }
        }
        ParserHELM2 parser = new ParserHELM2();
        try {
            LOG.info("Parse HELM2");
            parser.parse(notation);
            LOG.info("Parsing was successful");
        }
        catch (ExceptionState e) {
            e.printStackTrace();
            throw new ParserException("HELMNotation is not valid: " + notation);
        }
        return parser.getHELM2Notation();
    }

    public static List<PolymerNotation> getListOfPolymersSpecificType(String str, List<PolymerNotation> polymers) {
        ArrayList<PolymerNotation> list = new ArrayList<PolymerNotation>();
        for (PolymerNotation polymer : polymers) {
            if (!polymer.getPolymerID().getType().equals(str)) continue;
            list.add(polymer);
        }
        return list;
    }
}

