/*
 * Decompiled with CFR 0.152.
 */
package org.helm.notation2.tools;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.helm.chemtoolkit.AbstractChemistryManipulator;
import org.helm.chemtoolkit.CTKException;
import org.helm.notation2.Chemistry;
import org.helm.notation2.Monomer;
import org.helm.notation2.MonomerFactory;
import org.helm.notation2.exception.ChemistryException;
import org.helm.notation2.exception.HELM1FormatException;
import org.helm.notation2.exception.MonomerLoadingException;
import org.helm.notation2.exception.NotationException;
import org.helm.notation2.exception.ValidationException;
import org.helm.notation2.parser.exceptionparser.HELM1ConverterException;
import org.helm.notation2.parser.notation.HELM2Notation;
import org.helm.notation2.parser.notation.annotation.AnnotationNotation;
import org.helm.notation2.parser.notation.connection.ConnectionNotation;
import org.helm.notation2.parser.notation.polymer.PolymerNotation;
import org.helm.notation2.tools.NucleotideParser;
import org.helm.notation2.tools.PermutationAndExpansion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HELM1Utils {
    private static final Logger LOG = LoggerFactory.getLogger(HELM1Utils.class);

    private HELM1Utils() {
    }

    public static String getStandard(HELM2Notation helm2notation) throws HELM1FormatException, MonomerLoadingException, CTKException, ValidationException, ChemistryException {
        try {
            String firstSection = HELM1Utils.setStandardHELMFirstSection(helm2notation);
            List<String> ListOfSecondAndThirdSection = HELM1Utils.setStandardHELMSecondSectionAndThirdSection(helm2notation.getListOfConnections());
            String fourthSection = HELM1Utils.setStandardHELMFourthSection(helm2notation.getListOfAnnotations());
            return firstSection + "$" + ListOfSecondAndThirdSection.get(0) + "$" + ListOfSecondAndThirdSection.get(1) + "$" + fourthSection + "$V2.0";
        }
        catch (NotationException | HELM1ConverterException | org.helm.notation2.parser.exceptionparser.NotationException e) {
            e.printStackTrace();
            throw new HELM1FormatException(e.getMessage());
        }
    }

    private static String setStandardHELMFirstSection(HELM2Notation helm2notation) throws HELM1ConverterException, MonomerLoadingException, NotationException, CTKException, HELM1FormatException, ValidationException, ChemistryException, org.helm.notation2.parser.exceptionparser.NotationException {
        StringBuilder notation = new StringBuilder();
        for (PolymerNotation polymer : helm2notation.getListOfPolymers()) {
            String id = polymer.getPolymerID().getId();
            String elementsToHELM = polymer.getPolymerElements().toHELM();
            Map<String, String> adHocList = HELM1Utils.findAdHocMonomers(elementsToHELM, polymer.getPolymerID().getType());
            Map<String, String> convert = HELM1Utils.convertAdHocMonomersIntoSMILES(adHocList);
            for (Map.Entry<String, String> e : convert.entrySet()) {
                elementsToHELM = elementsToHELM.replaceAll(e.getKey(), e.getValue());
            }
            notation.append(id + "{" + elementsToHELM + "}|");
        }
        notation.setLength(notation.length() - 1);
        return notation.toString();
    }

    private static List<String> setStandardHELMSecondSectionAndThirdSection(List<ConnectionNotation> connections) throws HELM1ConverterException {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder notationSecond = new StringBuilder();
        StringBuilder notationThird = new StringBuilder();
        for (ConnectionNotation connectionNotation : connections) {
            if (!connectionNotation.toHELM().equals("")) {
                notationSecond.append(connectionNotation.toHELM() + "|");
                continue;
            }
            notationThird.append(connectionNotation.toHELM2() + "|");
        }
        if (notationSecond.length() > 1) {
            notationSecond.setLength(notationSecond.length() - 1);
        }
        if (notationThird.length() > 1) {
            notationThird.setLength(notationThird.length() - 1);
        }
        result.add(notationSecond.toString());
        result.add(notationThird.toString());
        return result;
    }

    private static String setStandardHELMFourthSection(List<AnnotationNotation> annotations) {
        StringBuilder sb = new StringBuilder();
        for (AnnotationNotation annotation : annotations) {
            sb.append(annotation.toHELM2() + "|");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String getCanonical(HELM2Notation helm2notation) throws HELM1FormatException, ChemistryException {
        try {
            Object[] temp = HELM1Utils.setCanonicalHELMFirstSection(helm2notation);
            LOG.info("First Section of canonical HELM was generated");
            Map convertsortedIdstoIds = (Map)temp[0];
            String firstSection = (String)temp[1];
            String secondSection = HELM1Utils.setCanonicalHELMSecondSection(convertsortedIdstoIds, helm2notation.getListOfConnections());
            LOG.info("Second Section of canonical HELM was generated");
            return firstSection + "$" + secondSection + "$$$V2.0";
        }
        catch (IOException | ClassNotFoundException | ValidationException | HELM1ConverterException | org.helm.notation2.parser.exceptionparser.NotationException e) {
            e.printStackTrace();
            LOG.error("Canonical HELM 1 can not be generated due to HELM2 features");
            throw new HELM1FormatException("Canonical HELM 1 can not be generated due to HELM2 features " + e.getMessage() + e.getCause());
        }
    }

    private static Object[] setCanonicalHELMFirstSection(HELM2Notation helm2notation) throws HELM1ConverterException, HELM1FormatException, ClassNotFoundException, IOException, ValidationException, ChemistryException, org.helm.notation2.parser.exceptionparser.NotationException {
        HashMap<Object, String> idLabelMap = new HashMap<Object, String>();
        TreeMap labelIdMap = new TreeMap();
        for (PolymerNotation polymer : helm2notation.getListOfPolymers()) {
            List<Object> l;
            String id = polymer.getPolymerID().getId();
            String elementsToHELM = polymer.getPolymerElements().toHELM();
            Map<String, String> adHocList = HELM1Utils.findAdHocMonomers(elementsToHELM, polymer.getPolymerID().getType());
            Map<String, String> convert = HELM1Utils.convertAdHocMonomersIntoSMILES(adHocList);
            for (Map.Entry<String, String> e : convert.entrySet()) {
                elementsToHELM = elementsToHELM.replaceAll(e.getKey(), e.getValue());
            }
            elementsToHELM = elementsToHELM.replace("[", "");
            elementsToHELM = elementsToHELM.replace("]", "");
            idLabelMap.put(id, elementsToHELM);
            if (labelIdMap.containsKey(elementsToHELM)) {
                l = (List)labelIdMap.get(elementsToHELM);
                l.add(id);
                continue;
            }
            l = new ArrayList();
            l.add(id);
            labelIdMap.put(elementsToHELM, l);
        }
        Set sortedLabelSet = labelIdMap.keySet();
        ArrayList<List<String[]>> lol = new ArrayList<List<String[]>>();
        for (String key : sortedLabelSet) {
            List value = (List)labelIdMap.get(key);
            ArrayList<String[]> al = new ArrayList<String[]>();
            al.add(value.toArray(new String[0]));
            PermutationAndExpansion.expand(lol, al);
        }
        List<List<String>> nodeIdPermutations = PermutationAndExpansion.linearize(lol);
        ArrayList<String> notationList = new ArrayList<String>();
        HashMap<String, String> convertsortedIdstoIds = new HashMap<String, String>();
        for (List<String> sortedIdList : nodeIdPermutations) {
            String notation = "";
            int countCHEM = 0;
            int countPEPTIDE = 0;
            int countRNA = 0;
            for (String id : sortedIdList) {
                int count = 0;
                if (helm2notation.getPolymerNotation(id).getPolymerID().getType().equals("PEPTIDE")) {
                    count = ++countPEPTIDE;
                }
                if (helm2notation.getPolymerNotation(id).getPolymerID().getType().equals("CHEM")) {
                    count = ++countCHEM;
                }
                if (helm2notation.getPolymerNotation(id).getPolymerID().getType().equals("RNA")) {
                    count = ++countRNA;
                }
                notation = notation + helm2notation.getPolymerNotation(id).getPolymerID().getType() + count + "{" + helm2notation.getPolymerNotation(id).toHELM() + "}|";
                convertsortedIdstoIds.put(helm2notation.getPolymerNotation(id).getPolymerID().getId(), helm2notation.getPolymerNotation(id).getPolymerID().getType() + count);
            }
            notation = notation.substring(0, notation.length() - 1);
            notationList.add(notation);
        }
        Collections.sort(notationList);
        return new Object[]{convertsortedIdstoIds, notationList.get(0)};
    }

    private static String setCanonicalHELMSecondSection(Map<String, String> convertsortedIdstoIds, List<ConnectionNotation> connectionNotations) throws HELM1ConverterException {
        StringBuilder notation = new StringBuilder();
        for (ConnectionNotation connectionNotation : connectionNotations) {
            ArrayList<String> connections = new ArrayList<String>();
            String source = connectionNotation.getSourceId().getId();
            String target = connectionNotation.getTargetId().getId();
            if (connectionNotation.toHELM().equals("")) continue;
            connections.add(HELM1Utils.convertConnection(connectionNotation.toHELM(), source, target, convertsortedIdstoIds));
            connections.add(HELM1Utils.convertConnection(connectionNotation.toReverseHELM(), source, target, convertsortedIdstoIds));
            Collections.sort(connections);
            notation.append((String)connections.get(0) + "|");
        }
        if (notation.length() > 1) {
            notation.setLength(notation.length() - 1);
        }
        return notation.toString();
    }

    private static String convertConnection(String notation, String source, String target, Map<String, String> convertIds) throws HELM1ConverterException {
        try {
            String test = notation.replace(source, "one");
            test = test.replace(target, "two");
            test = test.replace("one", convertIds.get(source));
            test = test.replace("two", convertIds.get(target));
            return test;
        }
        catch (NullPointerException ex) {
            ex.printStackTrace();
            LOG.error("Connection can't be downgraded to HELM1-Format");
            throw new HELM1ConverterException("Connection can't be downgraded to HELM1-Format");
        }
    }

    private static Map<String, String> findAdHocMonomers(String elements, String type) throws HELM1FormatException, ValidationException, ChemistryException, org.helm.notation2.parser.exceptionparser.NotationException {
        try {
            HashMap<String, String> listMatches = new HashMap<String, String>();
            String[] listelements = elements.split("\\.");
            if (type == "RNA") {
                for (String element : listelements) {
                    List<String> monomerIds = NucleotideParser.getMonomerIDListFromNucleotide(element);
                    for (String id : monomerIds) {
                        Monomer monomer = MonomerFactory.getInstance().getMonomerStore().getMonomer(type, id);
                        if (!monomer.isAdHocMonomer()) continue;
                        listMatches.put(element, "[" + monomer.getCanSMILES() + "]");
                    }
                }
            } else {
                for (String element : listelements) {
                    Monomer monomer = MonomerFactory.getInstance().getMonomerStore().getMonomer(type, element.replace("[", "").replace("]", ""));
                    try {
                        if (!monomer.isAdHocMonomer()) continue;
                        listMatches.put(element, "[" + monomer.getCanSMILES() + "]");
                    }
                    catch (NullPointerException e) {
                        if (Chemistry.getInstance().getManipulator().validateSMILES(element.substring(1, element.length() - 1))) continue;
                        e.printStackTrace();
                        throw new ValidationException("SMILES as Monomer is not valid :" + element);
                    }
                }
            }
            return listMatches;
        }
        catch (MonomerLoadingException e) {
            e.printStackTrace();
            throw new HELM1FormatException(e.getMessage());
        }
    }

    private static Map<String, String> convertAdHocMonomersIntoSMILES(Map<String, String> monomersList) throws HELM1FormatException, ChemistryException {
        HashMap<String, String> convert = new HashMap<String, String>();
        try {
            for (Map.Entry<String, String> element : monomersList.entrySet()) {
                Monomer m = MonomerFactory.getInstance().getMonomerStore().getMonomer(element.getValue().toString(), element.getKey().toString());
                String smiles = m.getCanSMILES();
                AbstractChemistryManipulator manipulator = Chemistry.getInstance().getManipulator();
                String canSmiles = manipulator.canonicalize(smiles);
                convert.put(element.getKey().toString(), canSmiles);
            }
            return convert;
        }
        catch (CTKException | MonomerLoadingException e) {
            e.printStackTrace();
            throw new HELM1FormatException("SMILES for Monomer can not be found: ");
        }
    }
}

