/*
 * Decompiled with CFR 0.152.
 */
package org.helm.notation2.tools;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.helm.chemtoolkit.CTKException;
import org.helm.notation2.Monomer;
import org.helm.notation2.MonomerFactory;
import org.helm.notation2.exception.ChemistryException;
import org.helm.notation2.exception.HELM2HandledException;
import org.helm.notation2.exception.MonomerException;
import org.helm.notation2.exception.MonomerLoadingException;
import org.helm.notation2.exception.NotationException;
import org.helm.notation2.exception.RNAUtilsException;
import org.helm.notation2.parser.notation.HELM2Notation;
import org.helm.notation2.parser.notation.annotation.AnnotationNotation;
import org.helm.notation2.parser.notation.connection.ConnectionNotation;
import org.helm.notation2.parser.notation.grouping.GroupingNotation;
import org.helm.notation2.parser.notation.polymer.MonomerNotation;
import org.helm.notation2.parser.notation.polymer.MonomerNotationGroup;
import org.helm.notation2.parser.notation.polymer.MonomerNotationGroupElement;
import org.helm.notation2.parser.notation.polymer.MonomerNotationGroupMixture;
import org.helm.notation2.parser.notation.polymer.MonomerNotationGroupOr;
import org.helm.notation2.parser.notation.polymer.MonomerNotationList;
import org.helm.notation2.parser.notation.polymer.MonomerNotationUnit;
import org.helm.notation2.parser.notation.polymer.MonomerNotationUnitRNA;
import org.helm.notation2.parser.notation.polymer.PolymerNotation;
import org.helm.notation2.tools.HELM2NotationUtils;
import org.helm.notation2.tools.MethodsMonomerUtils;
import org.helm.notation2.tools.RNAUtils;
import org.jdom2.JDOMException;

public final class ChangeObjects {
    public static final void addAnnotation(AnnotationNotation notation, int position, HELM2Notation helm2notation) {
        helm2notation.getListOfAnnotations().add(position, notation);
    }

    public static final void changeAnnotation(AnnotationNotation notation, int position, HELM2Notation helm2notation) {
        helm2notation.getListOfAnnotations().set(position, notation);
    }

    public static final void deleteAnnotation(int position, HELM2Notation helm2notation) {
        helm2notation.getListOfAnnotations().remove(position);
    }

    public static final void deleteAllAnnotations(HELM2Notation helm2notation) {
        helm2notation.getListOfAnnotations().clear();
    }

    public static final void addConnection(ConnectionNotation notation, int position, HELM2Notation helm2notation) {
        helm2notation.getListOfConnections().add(position, notation);
    }

    public static final void changeConnection(int position, ConnectionNotation notation, HELM2Notation helm2notation) {
        helm2notation.getListOfConnections().set(position, notation);
    }

    public static final void deleteConnection(int position, HELM2Notation helm2notation) {
        helm2notation.getListOfConnections().remove(position);
    }

    public static final void addAnnotationToConnection(int position, String annotation, HELM2Notation helm2notation) {
        ((ConnectionNotation)helm2notation.getListOfConnections().get(position)).setAnnotation(annotation);
    }

    public static final void deleteAllConnections(HELM2Notation helm2notation) {
        helm2notation.getListOfConnections().clear();
    }

    public static final void addGroup(GroupingNotation notation, int position, HELM2Notation helm2notation) {
        helm2notation.getListOfGroupings().add(position, notation);
    }

    public static final void changeGroup(GroupingNotation notation, int position, HELM2Notation helm2notation) {
        helm2notation.getListOfGroupings().set(position, notation);
    }

    public static final void deleteGroup(int position, HELM2Notation helm2notation) {
        helm2notation.getListOfGroupings().remove(position);
    }

    public static final void deleteAllGroups(HELM2Notation helm2notation) {
        helm2notation.getListOfGroupings().clear();
    }

    public static final PolymerNotation addAnnotationToPolymer(PolymerNotation polymer, String annotation) {
        if (polymer.getAnnotation() != null) {
            return new PolymerNotation(polymer.getPolymerID(), polymer.getPolymerElements(), polymer.getAnnotation() + " | " + annotation);
        }
        return new PolymerNotation(polymer.getPolymerID(), polymer.getPolymerElements(), annotation);
    }

    public static final PolymerNotation removeAnnotationOfPolmyer(PolymerNotation polymer) {
        return new PolymerNotation(polymer.getPolymerID(), polymer.getPolymerElements(), null);
    }

    public static final PolymerNotation addMonomerNotation(int position, PolymerNotation polymer, MonomerNotation monomerNotation) {
        polymer.getPolymerElements().getListOfElements().add(position, monomerNotation);
        return polymer;
    }

    public static final void changeMonomerNotation(int position, PolymerNotation polymer, MonomerNotation not) {
        polymer.getPolymerElements().getListOfElements().set(position, not);
    }

    public static final void deleteMonomerNotation(int position, PolymerNotation polymer) throws org.helm.notation2.parser.exceptionparser.NotationException {
        MonomerNotation monomerNotation = (MonomerNotation)polymer.getPolymerElements().getListOfElements().get(position);
        if (polymer.getPolymerElements().getListOfElements().size() == 1) {
            throw new org.helm.notation2.parser.exceptionparser.NotationException(monomerNotation.toString() + " can't be removed. Polymer has to have at least one Monomer Notation");
        }
        polymer.getPolymerElements().getListOfElements().remove(monomerNotation);
    }

    public static final void addAnnotationToMonomerNotation(PolymerNotation polymer, int position, String annotation) {
        ((MonomerNotation)polymer.getPolymerElements().getListOfElements().get(position)).setAnnotation(annotation);
    }

    public static final void addCountToMonomerNotation(PolymerNotation polymer, int position, String count) {
        ((MonomerNotation)polymer.getPolymerElements().getListOfElements().get(position)).setCount(count);
    }

    public static final void deleteAnnotationFromMonomerNotation(PolymerNotation polymer, int position) {
        ((MonomerNotation)polymer.getPolymerElements().getListOfElements().get(position)).setAnnotation(null);
    }

    public static final void setCountToDefault(PolymerNotation polymer, int position) {
        ((MonomerNotation)polymer.getPolymerElements().getListOfElements().get(position)).setCount("1");
    }

    public static final void changePolymerNotation(int position, PolymerNotation polymer, HELM2Notation helm2notation) {
        helm2notation.getListOfPolymers().set(position, polymer);
    }

    public static final void deletePolymerNotation(int position, HELM2Notation helm2notation) {
        helm2notation.getListOfPolymers().remove(position);
    }

    public static final void addPolymerNotation(int position, PolymerNotation polymer, HELM2Notation helm2notation) {
        helm2notation.getListOfPolymers().add(position, polymer);
    }

    public static final void replaceMonomer(HELM2Notation helm2notation, String polymerType, String existingMonomerID, String newMonomerID) throws org.helm.notation2.parser.exceptionparser.NotationException, MonomerException, ChemistryException, CTKException, IOException, JDOMException {
        ChangeObjects.validateMonomerReplacement(polymerType, existingMonomerID, newMonomerID);
        for (int i = 0; i < helm2notation.getListOfPolymers().size(); ++i) {
            if (!((PolymerNotation)helm2notation.getListOfPolymers().get(i)).getPolymerID().getType().equals(polymerType)) continue;
            for (int j = 0; j < ((PolymerNotation)helm2notation.getListOfPolymers().get(i)).getPolymerElements().getListOfElements().size(); ++j) {
                MonomerNotation monomerNotation = ChangeObjects.replaceMonomerNotation((MonomerNotation)((PolymerNotation)helm2notation.getListOfPolymers().get(i)).getPolymerElements().getListOfElements().get(j), existingMonomerID, newMonomerID);
                if (monomerNotation == null) continue;
                ((PolymerNotation)helm2notation.getListOfPolymers().get(i)).getPolymerElements().getListOfElements().set(j, monomerNotation);
            }
        }
    }

    public static final MonomerNotation replaceMonomerNotation(MonomerNotation monomerNotation, String existingMonomerID, String newMonomerID) throws org.helm.notation2.parser.exceptionparser.NotationException, ChemistryException, CTKException, MonomerLoadingException {
        if (monomerNotation instanceof MonomerNotationUnitRNA) {
            List<String> result = ChangeObjects.generateIDForNucleotide((MonomerNotationUnitRNA)monomerNotation, existingMonomerID, newMonomerID);
            if (result.get(1) != null) {
                MonomerNotationUnitRNA newObject = new MonomerNotationUnitRNA(result.get(0), monomerNotation.getType());
                newObject.setCount(monomerNotation.getCount());
                if (monomerNotation.isAnnotationTrue()) {
                    newObject.setAnnotation(monomerNotation.getAnnotation());
                }
                return newObject;
            }
        } else if (monomerNotation instanceof MonomerNotationUnit) {
            if (monomerNotation.getUnit().equals(existingMonomerID)) {
                return ChangeObjects.produceMonomerNotationUnitWithOtherID(monomerNotation, newMonomerID);
            }
        } else if (monomerNotation instanceof MonomerNotationList) {
            if ((monomerNotation = ChangeObjects.replaceMonomerNotationList((MonomerNotationList)monomerNotation, existingMonomerID, newMonomerID)) != null) {
                return monomerNotation;
            }
        } else if (monomerNotation instanceof MonomerNotationGroup) {
            if ((monomerNotation = ChangeObjects.replaceMonomerNotationGroup((MonomerNotationGroup)monomerNotation, existingMonomerID, newMonomerID)) != null) {
                return monomerNotation;
            }
        } else {
            throw new org.helm.notation2.parser.exceptionparser.NotationException("Unknown MonomerNotation Type " + monomerNotation.getClass());
        }
        return null;
    }

    public static final MonomerNotationGroup replaceMonomerNotationGroup(MonomerNotationGroup monomerNotation, String existingMonomerID, String newMonomerID) throws org.helm.notation2.parser.exceptionparser.NotationException {
        Object newObject = null;
        boolean hasChanged = false;
        StringBuilder sb = new StringBuilder();
        String id = "";
        for (MonomerNotationGroupElement object : monomerNotation.getListOfElements()) {
            if (object.getMonomerNotation().getUnit().equals(existingMonomerID)) {
                hasChanged = true;
                id = ChangeObjects.generateGroupElement(newMonomerID, object.getValue());
            } else {
                id = ChangeObjects.generateGroupElement(object.getMonomerNotation().getUnit(), object.getValue());
            }
            if (monomerNotation instanceof MonomerNotationGroupOr) {
                sb.append(id + ",");
                continue;
            }
            sb.append(id + "+");
        }
        if (hasChanged) {
            sb.setLength(sb.length() - 1);
            newObject = monomerNotation instanceof MonomerNotationGroupOr ? new MonomerNotationGroupOr(sb.toString(), monomerNotation.getType()) : new MonomerNotationGroupMixture(sb.toString(), monomerNotation.getType());
        }
        return newObject;
    }

    public static final MonomerNotationUnit produceMonomerNotationUnitWithOtherID(MonomerNotation monomerNotation, String newID) throws org.helm.notation2.parser.exceptionparser.NotationException {
        MonomerNotationUnit result = new MonomerNotationUnit(newID, monomerNotation.getType());
        if (monomerNotation.isAnnotationTrue()) {
            result.setAnnotation(monomerNotation.getAnnotation());
        }
        result.setCount(monomerNotation.getCount());
        return result;
    }

    public static final MonomerNotationList replaceMonomerNotationList(MonomerNotationList object, String existingMonomerID, String newMonomerID) throws org.helm.notation2.parser.exceptionparser.NotationException, ChemistryException, CTKException, MonomerLoadingException {
        MonomerNotationList newObject = null;
        boolean hasChanged = false;
        StringBuilder sb = new StringBuilder();
        String id = "";
        for (MonomerNotation element : object.getListofMonomerUnits()) {
            if (element instanceof MonomerNotationUnitRNA) {
                List<String> result = ChangeObjects.generateIDForNucleotide((MonomerNotationUnitRNA)element, existingMonomerID, newMonomerID);
                id = result.get(0);
                if (result.get(1) != null) {
                    hasChanged = true;
                }
            } else if (element.getUnit().equals(existingMonomerID)) {
                hasChanged = true;
                id = ChangeObjects.generateIDMonomerNotation(newMonomerID, element.getCount(), element.getAnnotation());
            } else {
                id = ChangeObjects.generateIDMonomerNotation(element.getUnit(), element.getCount(), element.getAnnotation());
            }
            sb.append(id + ".");
        }
        if (hasChanged) {
            sb.setLength(sb.length() - 1);
            newObject = new MonomerNotationList(sb.toString(), object.getType());
            newObject.setCount(object.getCount());
            if (object.isAnnotationTrue()) {
                newObject.setAnnotation(object.getAnnotation());
            }
        }
        return newObject;
    }

    private static final String generateIDMonomerNotation(String id, String count, String annotation) {
        if (id.length() > 1) {
            id = "[" + id + "]";
        }
        String result = id;
        try {
            if (Integer.parseInt(count) != 1) {
                result = result + "'" + count + "'";
            }
        }
        catch (NumberFormatException e) {
            result = result + "'" + count + "'";
        }
        if (annotation != null) {
            result = result + "\"" + annotation + "\"";
        }
        return result;
    }

    private static final String generateIDRNA(String id, String count, String annotation) throws MonomerLoadingException, ChemistryException, CTKException {
        String result = id;
        if (result.startsWith("[") && result.endsWith("]")) {
            result = id.substring(1, id.length() - 1);
        }
        if (MonomerFactory.getInstance().getMonomerStore().getMonomer("RNA", result).getMonomerType().equals("Branch")) {
            if (id.length() > 1) {
                result = "[" + id + "]";
            }
            result = "(" + result + ")";
        } else if (id.length() > 1) {
            result = "[" + id + "]";
        }
        try {
            if (Integer.parseInt(count) != 1) {
                result = result + "'" + count + "'";
            }
        }
        catch (NumberFormatException e) {
            result = result + "'" + count + "'";
        }
        if (annotation != null) {
            result = result + "\"" + annotation + "\"";
        }
        return result;
    }

    private static final List<String> generateIDForNucleotide(MonomerNotationUnitRNA object, String existingMonomerID, String newMonomerID) throws MonomerLoadingException, ChemistryException, CTKException {
        ArrayList<String> result = new ArrayList<String>();
        String hasChanged = null;
        StringBuilder sb = new StringBuilder();
        String id = "";
        for (MonomerNotation element : object.getContents()) {
            if (element.getUnit().equals(existingMonomerID)) {
                hasChanged = "";
                id = ChangeObjects.generateIDRNA(newMonomerID, element.getCount(), element.getAnnotation());
            } else {
                id = ChangeObjects.generateIDRNA(element.getUnit(), element.getCount(), element.getAnnotation());
            }
            sb.append(id);
        }
        try {
            if (Integer.parseInt(object.getCount()) != 1) {
                sb.append("'" + object.getCount() + "'");
            }
        }
        catch (NumberFormatException e) {
            sb.append("'" + object.getCount() + "'");
        }
        if (object.getAnnotation() != null) {
            sb.append("\"" + object.getAnnotation() + "\"");
        }
        result.add(sb.toString());
        result.add(hasChanged);
        return result;
    }

    private static String generateGroupElement(String id, List<Double> list) {
        StringBuilder sb = new StringBuilder();
        if (list.size() == 1) {
            if (list.get(0) == -1.0) {
                sb.append(id + ":");
                sb.append("?-");
            } else if (list.get(0) == 1.0) {
                sb.append(id + ":");
            } else {
                sb.append(id + ":" + list.get(0) + "-");
            }
        } else {
            sb.append(id + ":");
            for (Double item : list) {
                sb.append(item + "-");
            }
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    private static boolean validateMonomerReplacement(String polymerType, String existingMonomerID, String newMonomerID) throws MonomerException, IOException, JDOMException, org.helm.notation2.parser.exceptionparser.NotationException, ChemistryException, CTKException {
        if (null == polymerType || polymerType.length() == 0) {
            throw new org.helm.notation2.parser.exceptionparser.NotationException("Polymer type is required for monomer replacement");
        }
        if (null == existingMonomerID || existingMonomerID.length() == 0) {
            throw new org.helm.notation2.parser.exceptionparser.NotationException("Existing monomer ID is required for monomer replacement");
        }
        if (null == newMonomerID || newMonomerID.length() == 0) {
            throw new org.helm.notation2.parser.exceptionparser.NotationException("New monomer ID is required for monomer replacement");
        }
        Map<String, Monomer> monomers = MonomerFactory.getInstance().getMonomerStore().getMonomers(polymerType);
        if (null == monomers || monomers.size() == 0) {
            throw new org.helm.notation2.parser.exceptionparser.NotationException("Unknown polymer type [" + polymerType + "] found");
        }
        if (!monomers.containsKey(existingMonomerID)) {
            throw new org.helm.notation2.parser.exceptionparser.NotationException("Existing monomer ID [" + existingMonomerID + "] is invalid in polymer type " + polymerType);
        }
        if (!monomers.containsKey(newMonomerID)) {
            throw new org.helm.notation2.parser.exceptionparser.NotationException("New monomer ID [" + newMonomerID + "] is invalid in polymer type " + polymerType);
        }
        Monomer existingMonomer = monomers.get(existingMonomerID);
        Monomer newMonomer = monomers.get(newMonomerID);
        if (polymerType.equals("RNA")) {
            if (existingMonomer.getMonomerType().equals(newMonomer.getMonomerType())) {
                if (existingMonomer.getMonomerType().equals("Backbone") && !existingMonomer.getNaturalAnalog().equals(newMonomer.getNaturalAnalog())) {
                    throw new org.helm.notation2.parser.exceptionparser.NotationException("Existing monomer natural analog [" + existingMonomer.getNaturalAnalog() + "] and new monomer natural analog [" + newMonomer.getNaturalAnalog() + "] are different");
                }
            } else {
                throw new org.helm.notation2.parser.exceptionparser.NotationException("Existing monomer type [" + existingMonomer.getMonomerType() + "] and new monomer type [" + newMonomer.getMonomerType() + "] are different");
            }
        }
        if (!newMonomer.attachmentEquals(existingMonomer)) {
            throw new org.helm.notation2.parser.exceptionparser.NotationException("Existing monomer attachment [" + existingMonomer.getAttachmentListString() + "] and new monomer attachement [" + newMonomer.getAttachmentListString() + "] are different");
        }
        return true;
    }

    public static final void replaceSMILESWithTemporaryIds(HELM2Notation helm2notation) throws org.helm.notation2.parser.exceptionparser.NotationException, HELM2HandledException, ChemistryException, CTKException, MonomerLoadingException, JDOMException {
        for (int i = 0; i < helm2notation.getListOfPolymers().size(); ++i) {
            MethodsMonomerUtils.getListOfHandledMonomers(((PolymerNotation)helm2notation.getListOfPolymers().get(i)).getListMonomers());
            for (int j = 0; j < ((PolymerNotation)helm2notation.getListOfPolymers().get(i)).getPolymerElements().getListOfElements().size(); ++j) {
                MonomerNotation monomerNotation = ChangeObjects.replaceSMILESWithTemporaryIdsMonomerNotation((MonomerNotation)((PolymerNotation)helm2notation.getListOfPolymers().get(i)).getPolymerElements().getListOfElements().get(j));
                if (monomerNotation == null) continue;
                ((PolymerNotation)helm2notation.getListOfPolymers().get(i)).getPolymerElements().getListOfElements().set(j, monomerNotation);
            }
        }
    }

    private static MonomerNotation replaceSMILESWithTemporaryIdsMonomerNotation(MonomerNotation monomerNotation) throws org.helm.notation2.parser.exceptionparser.NotationException, ChemistryException, CTKException, MonomerLoadingException, JDOMException {
        if (monomerNotation instanceof MonomerNotationUnitRNA) {
            List<String> result = ChangeObjects.generateIDForNucleotide((MonomerNotationUnitRNA)monomerNotation);
            if (result.get(1) != null) {
                MonomerNotationUnitRNA newObject = new MonomerNotationUnitRNA(result.get(0), monomerNotation.getType());
                newObject.setCount(monomerNotation.getCount());
                if (monomerNotation.isAnnotationTrue()) {
                    newObject.setAnnotation(monomerNotation.getAnnotation());
                }
                return newObject;
            }
        } else {
            if (monomerNotation instanceof MonomerNotationUnit) {
                return ChangeObjects.produceMonomerNotationUnitWithOtherID(monomerNotation);
            }
            if (monomerNotation instanceof MonomerNotationList) {
                if ((monomerNotation = ChangeObjects.replaceMonomerNotationList((MonomerNotationList)monomerNotation)) != null) {
                    return monomerNotation;
                }
            } else if (monomerNotation instanceof MonomerNotationGroup) {
                if ((monomerNotation = ChangeObjects.replaceMonomerNotationGroup((MonomerNotationGroup)monomerNotation)) != null) {
                    return monomerNotation;
                }
            } else {
                throw new org.helm.notation2.parser.exceptionparser.NotationException("Unknown MonomerNotation Type " + monomerNotation.getClass());
            }
        }
        return null;
    }

    private static MonomerNotation replaceMonomerNotationGroup(MonomerNotationGroup monomerNotationGroup) throws org.helm.notation2.parser.exceptionparser.NotationException, JDOMException, ChemistryException, CTKException, MonomerLoadingException {
        Object newObject = null;
        boolean hasChanged = false;
        StringBuilder sb = new StringBuilder();
        String id = "";
        for (MonomerNotationGroupElement object : monomerNotationGroup.getListOfElements()) {
            String newID = ChangeObjects.produceID(object.getMonomerNotation().getUnit(), object.getMonomerNotation().getType());
            if (newID != null) {
                newID = "[" + newID + "]";
                hasChanged = true;
                id = ChangeObjects.generateGroupElement(newID, object.getValue());
            } else {
                id = ChangeObjects.generateGroupElement(object.getMonomerNotation().getUnit(), object.getValue());
            }
            if (monomerNotationGroup instanceof MonomerNotationGroupOr) {
                sb.append(id + ",");
                continue;
            }
            sb.append(id + "+");
        }
        if (hasChanged) {
            sb.setLength(sb.length() - 1);
            newObject = monomerNotationGroup instanceof MonomerNotationGroupOr ? new MonomerNotationGroupOr(sb.toString(), monomerNotationGroup.getType()) : new MonomerNotationGroupMixture(sb.toString(), monomerNotationGroup.getType());
        }
        return newObject;
    }

    private static MonomerNotation replaceMonomerNotationList(MonomerNotationList monomerNotationList) throws org.helm.notation2.parser.exceptionparser.NotationException, JDOMException, ChemistryException, CTKException, MonomerLoadingException {
        MonomerNotationList newObject = null;
        boolean hasChanged = false;
        StringBuilder sb = new StringBuilder();
        String id = "";
        for (MonomerNotation element : monomerNotationList.getListofMonomerUnits()) {
            if (element instanceof MonomerNotationUnitRNA) {
                List<String> result = ChangeObjects.generateIDForNucleotide((MonomerNotationUnitRNA)element);
                id = result.get(0);
                if (result.get(1) != null) {
                    hasChanged = true;
                }
            } else {
                String newID = ChangeObjects.produceID(element.getUnit(), element.getType());
                if (newID != null) {
                    hasChanged = true;
                    id = ChangeObjects.generateIDMonomerNotation(newID, element.getCount(), element.getAnnotation());
                } else {
                    id = ChangeObjects.generateIDMonomerNotation(element.getUnit(), element.getCount(), element.getAnnotation());
                }
            }
            sb.append(id + ".");
        }
        if (hasChanged) {
            sb.setLength(sb.length() - 1);
            newObject = new MonomerNotationList(sb.toString(), monomerNotationList.getType());
            newObject.setCount(monomerNotationList.getCount());
            if (monomerNotationList.isAnnotationTrue()) {
                newObject.setAnnotation(monomerNotationList.getAnnotation());
            }
        }
        return newObject;
    }

    private static MonomerNotation produceMonomerNotationUnitWithOtherID(MonomerNotation monomerNotation) throws org.helm.notation2.parser.exceptionparser.NotationException, ChemistryException, CTKException, MonomerLoadingException {
        String newID = ChangeObjects.produceID(monomerNotation.getUnit(), monomerNotation.getType());
        if (newID != null) {
            MonomerNotationUnit result = new MonomerNotationUnit(newID, monomerNotation.getType());
            if (monomerNotation.isAnnotationTrue()) {
                result.setAnnotation(monomerNotation.getAnnotation());
            }
            result.setCount(monomerNotation.getCount());
            return result;
        }
        return null;
    }

    private static List<String> generateIDForNucleotide(MonomerNotationUnitRNA monomerNotationUnitRNA) throws MonomerLoadingException, ChemistryException, CTKException {
        ArrayList<String> result = new ArrayList<String>();
        String hasChanged = null;
        StringBuilder sb = new StringBuilder();
        String id = "";
        for (MonomerNotation element : monomerNotationUnitRNA.getContents()) {
            String newID = ChangeObjects.produceID(element.getUnit(), element.getType());
            if (newID != null) {
                hasChanged = "";
                id = ChangeObjects.generateIDRNA(newID, element.getCount(), element.getAnnotation());
            } else {
                id = ChangeObjects.generateIDRNA(element.getUnit(), element.getCount(), element.getAnnotation());
            }
            sb.append(id);
        }
        try {
            if (Integer.parseInt(monomerNotationUnitRNA.getCount()) != 1) {
                sb.append("'" + monomerNotationUnitRNA.getCount() + "'");
            }
        }
        catch (NumberFormatException e) {
            sb.append("'" + monomerNotationUnitRNA.getCount() + "'");
        }
        if (monomerNotationUnitRNA.getAnnotation() != null) {
            sb.append("\"" + monomerNotationUnitRNA.getAnnotation() + "\"");
        }
        result.add(sb.toString());
        result.add(hasChanged);
        return result;
    }

    private static String produceID(String oldID, String polymerType) throws MonomerLoadingException, ChemistryException, CTKException {
        HELM2NotationUtils.LOG.debug("SMILES string?: " + oldID);
        if (oldID.startsWith("[") && oldID.endsWith("]")) {
            oldID = oldID.substring(1, oldID.length() - 1);
        }
        if (MonomerFactory.getInstance().getMonomerStore().getMonomer(polymerType, oldID) == null) {
            return MonomerFactory.getInstance().getSmilesMonomerDB().get(oldID).getAlternateId();
        }
        return null;
    }

    public static void hybridize(HELM2Notation helm2notation) throws org.helm.notation2.parser.exceptionparser.NotationException, RNAUtilsException, HELM2HandledException, NotationException, ChemistryException {
        if (HELM2NotationUtils.getAllBasePairConnections(helm2notation.getListOfConnections()).isEmpty() && HELM2NotationUtils.getRNAPolymers(helm2notation.getListOfPolymers()).size() == 2) {
            List<ConnectionNotation> connections = RNAUtils.hybridize(HELM2NotationUtils.getRNAPolymers(helm2notation.getListOfPolymers()).get(0), HELM2NotationUtils.getRNAPolymers(helm2notation.getListOfPolymers()).get(1));
            for (ConnectionNotation connection : connections) {
                ChangeObjects.addConnection(connection, helm2notation.getListOfConnections().size(), helm2notation);
            }
        }
    }
}

