/*
 * Decompiled with CFR 0.152.
 */
package org.helm.notation2;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import org.helm.chemtoolkit.CTKException;
import org.helm.notation2.Attachment;
import org.helm.notation2.AttachmentLoader;
import org.helm.notation2.Chemistry;
import org.helm.notation2.DeepCopy;
import org.helm.notation2.Monomer;
import org.helm.notation2.MonomerCache;
import org.helm.notation2.MonomerStore;
import org.helm.notation2.NotationConstant;
import org.helm.notation2.exception.ChemistryException;
import org.helm.notation2.exception.EncoderException;
import org.helm.notation2.exception.MonomerException;
import org.helm.notation2.exception.MonomerLoadingException;
import org.helm.notation2.tools.MonomerParser;
import org.helm.notation2.wsadapter.MonomerStoreConfiguration;
import org.helm.notation2.wsadapter.MonomerWSLoader;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonomerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(MonomerFactory.class);
    public static final String NOTATION_DIRECTORY = NotationConstant.NOTATION_DIRECTORY;
    public static final String MONOMER_CACHE_FILE_NAME = "MonomerCache.ser";
    public static final String MONOMER_CACHE_FILE_PATH = NOTATION_DIRECTORY + System.getProperty("file.separator") + "MonomerCache.ser";
    public static final String MONOMER_DB_FILE_NAME = "MonomerDBGZEncoded.xml";
    public static final String MONOMER_DB_FILE_PATH = NOTATION_DIRECTORY + System.getProperty("file.separator") + "MonomerDBGZEncoded.xml";
    public static final String MONOMER_DB_XML_RESOURCE = "resources/MonomerDBGZEncoded.xml";
    public static final String MONOMER_DB_SCHEMA_RESOURCE = "resources/MonomerDBSchema.xsd";
    public static final String ATTACHMENTS_RESOURCE = "resources/Attachments.json";
    public static final String XML_SCHEMA_VALIDATION_FEATURE = "http://apache.org/xml/features/validation/schema";
    public static final String EXTERNAL_SCHEMA_LOCATION_KEY = "http://apache.org/xml/properties/schema/external-schemaLocation";
    public static final String DEFAULT_NAME_SPACE = "lmr";
    public static final String POLYMER_LIST_ELEMENT = "PolymerList";
    public static final String POLYMER_ELEMENT = "Polymer";
    public static final String POLYMER_TYPE_ATTRIBUTE = "polymerType";
    public static final String ATTACHMENT_LIST_ELEMENT = "AttachmentList";
    private static MonomerFactory instance;
    private static Map<String, Map<String, Monomer>> monomerDB;
    private static Map<String, Monomer> smilesMonomerDB;
    private static Map<String, Attachment> attachmentDB;
    private static SAXBuilder builder;
    private static java.util.logging.Logger logger;
    private static boolean dbChanged;
    protected MonomerStore monomerStore;

    public synchronized Map<String, Map<String, Monomer>> getMonomerDB() {
        return this.getMonomerDB(true);
    }

    public synchronized Map<String, Map<String, Monomer>> getMonomerDB(boolean includeNewMonomers) {
        if (includeNewMonomers) {
            return monomerDB;
        }
        TreeMap<String, Map<String, Monomer>> reducedMonomerDB = new TreeMap<String, Map<String, Monomer>>(String.CASE_INSENSITIVE_ORDER);
        for (String polymerType : monomerDB.keySet()) {
            Map<String, Monomer> monomerMap = monomerDB.get(polymerType);
            reducedMonomerDB.put(polymerType, this.excludeNewMonomers(monomerMap));
        }
        return reducedMonomerDB;
    }

    public synchronized MonomerStore getMonomerStore() {
        if (this.monomerStore == null) {
            this.monomerStore = new MonomerStore(monomerDB, smilesMonomerDB);
        }
        return this.monomerStore;
    }

    public synchronized Map<String, Attachment> getAttachmentDB() {
        return attachmentDB;
    }

    public synchronized Map<String, Monomer> getSmilesMonomerDB() {
        return this.getSmilesMonomerDB(true);
    }

    public synchronized Map<String, Monomer> getSmilesMonomerDB(boolean includeNewMonomers) {
        if (includeNewMonomers) {
            return smilesMonomerDB;
        }
        return this.excludeNewMonomersSmiles(smilesMonomerDB);
    }

    private synchronized Map<String, Monomer> excludeNewMonomersSmiles(Map<String, Monomer> monomerMap) {
        HashMap<String, Monomer> reducedMonomerMap = new HashMap<String, Monomer>();
        for (String identifier : monomerMap.keySet()) {
            Monomer monomer = monomerMap.get(identifier);
            if (monomer.isNewMonomer()) continue;
            reducedMonomerMap.put(identifier, monomer);
        }
        return reducedMonomerMap;
    }

    private synchronized Map<String, Monomer> excludeNewMonomers(Map<String, Monomer> monomerMap) {
        TreeMap<String, Monomer> reducedMonomerMap = new TreeMap<String, Monomer>(String.CASE_INSENSITIVE_ORDER);
        for (String identifier : monomerMap.keySet()) {
            Monomer monomer = monomerMap.get(identifier);
            if (monomer.isNewMonomer()) continue;
            reducedMonomerMap.put(identifier, monomer);
        }
        return reducedMonomerMap;
    }

    public synchronized List<String> getPolymerTypes() {
        ArrayList<String> l = new ArrayList<String>();
        l.addAll(monomerDB.keySet());
        Collections.sort(l);
        return l;
    }

    public synchronized List<String> getMonomerTypes() {
        ArrayList<String> monomerTypeList = new ArrayList<String>();
        Object[] col = monomerDB.values().toArray();
        for (int i = 0; i < col.length; ++i) {
            Map map = (Map)col[i];
            Monomer[] monomers = map.values().toArray(new Monomer[0]);
            for (int j = 0; j < monomers.length; ++j) {
                if (monomerTypeList.contains(monomers[j].getMonomerType())) continue;
                monomerTypeList.add(monomers[j].getMonomerType());
            }
        }
        Collections.sort(monomerTypeList);
        return monomerTypeList;
    }

    public synchronized Map<String, List<String>> getAttachmentLabelIDs() {
        ArrayList<String> ids;
        TreeMap<String, List<String>> labelMap = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
        Set<String> idSet = attachmentDB.keySet();
        for (String id : idSet) {
            String label = attachmentDB.get(id).getLabel();
            ids = (ArrayList<String>)labelMap.get(label);
            if (null == ids || ids.isEmpty()) {
                ids = new ArrayList<String>();
                ids.add(id);
                labelMap.put(label, ids);
                continue;
            }
            ids.add(id);
        }
        Set labelSet = labelMap.keySet();
        for (String label : labelSet) {
            ids = (List)labelMap.get(label);
            Collections.sort(ids);
        }
        return labelMap;
    }

    public static void setupBuilder() {
        URL schema = MonomerFactory.class.getResource(MONOMER_DB_SCHEMA_RESOURCE);
        builder = new SAXBuilder(false);
        builder.setFeature(XML_SCHEMA_VALIDATION_FEATURE, true);
        builder.setProperty(EXTERNAL_SCHEMA_LOCATION_KEY, (Object)("lmr " + schema.toString()));
    }

    private MonomerFactory() {
    }

    public static MonomerFactory getInstance() throws MonomerLoadingException, ChemistryException {
        if (null == instance) {
            MonomerFactory.refreshMonomerCache();
        } else if (MonomerStoreConfiguration.getInstance().isUseWebservice() && MonomerStoreConfiguration.getInstance().isUpdateAutomatic()) {
            MonomerFactory.refreshMonomerCache();
        }
        return instance;
    }

    public static void refreshMonomerCache() throws MonomerLoadingException, ChemistryException {
        MonomerFactory.initializeMonomerCache();
        instance = new MonomerFactory();
    }

    public static void setDBChanged(boolean isChanged) {
        dbChanged = isChanged;
    }

    public static boolean hasDBChanged() {
        return dbChanged;
    }

    public static void resetDBChanged() {
        dbChanged = false;
    }

    private static void serializeMonomerCache(MonomerCache monomerCache, String fileName) throws IOException {
        FileOutputStream fos = new FileOutputStream(fileName);
        ObjectOutputStream oos = new ObjectOutputStream(fos);
        oos.writeObject(monomerCache);
        oos.close();
        fos.close();
    }

    private static MonomerCache deserializeMonomerCache(String fileName) throws IOException, MonomerException {
        FileInputStream fis = new FileInputStream(fileName);
        MonomerCache cache = null;
        try (ObjectInputStream ois = new ObjectInputStream(fis);){
            cache = (MonomerCache)ois.readObject();
            for (Map.Entry<String, Monomer> e : cache.getSmilesMonomerDB().entrySet()) {
                e.getValue().setCanSMILES(e.getKey());
            }
            cache.setAttachmentDB(MonomerFactory.buildAttachmentDB());
        }
        fis.close();
        return cache;
    }

    public synchronized void addNewMonomer(Monomer monomer) throws IOException, MonomerException {
        monomer.setNewMonomer(true);
        this.addMonomer(monomerDB, smilesMonomerDB, monomer);
        dbChanged = true;
    }

    private void addMonomer(Map<String, Map<String, Monomer>> monomerDB, Map<String, Monomer> smilesMonomerDB, Monomer monomer) throws IOException, MonomerException {
        Map<String, Monomer> monomerMap = monomerDB.get(monomer.getPolymerType());
        if (null == monomerMap) {
            TreeMap<String, Monomer> map = new TreeMap<String, Monomer>(String.CASE_INSENSITIVE_ORDER);
            Monomer copyMonomer = DeepCopy.copy(monomer);
            map.put(monomer.getAlternateId(), copyMonomer);
            monomerDB.put(monomer.getPolymerType(), map);
        } else if (!monomerMap.containsKey(monomer.getAlternateId())) {
            monomerMap.put(monomer.getAlternateId(), monomer);
        }
        if (monomer.getCanSMILES() != null && monomer.getCanSMILES().length() > 0 && !smilesMonomerDB.containsKey(monomer.getCanSMILES())) {
            smilesMonomerDB.put(monomer.getCanSMILES(), monomer);
        }
        dbChanged = true;
    }

    public MonomerCache buildMonomerCacheFromXML(String monomerDBXML) throws MonomerException, IOException, JDOMException, ChemistryException, CTKException {
        ByteArrayInputStream bais = new ByteArrayInputStream(monomerDBXML.getBytes());
        return MonomerFactory.buildMonomerCacheFromXML(bais);
    }

    public synchronized void merge(MonomerCache remoteMonomerCache) throws IOException, MonomerException {
        Map<Monomer, Monomer> conflicts = this.getConflictedMonomerMap(remoteMonomerCache);
        if (conflicts.size() > 0) {
            throw new MonomerException("Local new monomer and remote monomer database conflict found");
        }
        Map<String, Map<String, Monomer>> monoDB = remoteMonomerCache.getMonomerDB();
        Set<String> polymerTypeSet = monoDB.keySet();
        for (String polymerType : polymerTypeSet) {
            Map<String, Monomer> map = monoDB.get(polymerType);
            Set<String> monomerSet = map.keySet();
            for (String id : monomerSet) {
                Monomer m = map.get(id);
                this.addMonomer(monomerDB, smilesMonomerDB, m);
            }
        }
        dbChanged = true;
    }

    public synchronized void setMonomerCache(MonomerCache remoteMonomerCache) throws IOException, MonomerException {
        monomerDB = remoteMonomerCache.getMonomerDB();
        attachmentDB = remoteMonomerCache.getAttachmentDB();
        smilesMonomerDB = remoteMonomerCache.getSmilesMonomerDB();
        dbChanged = true;
    }

    public synchronized Map<Monomer, Monomer> getConflictedMonomerMap(MonomerCache remoteMonomerCache) throws IOException, MonomerException {
        Map<String, Map<String, Monomer>> remoteMonomerDB = remoteMonomerCache.getMonomerDB();
        Map<String, Monomer> remoteSmilesDB = remoteMonomerCache.getSmilesMonomerDB();
        HashMap<Monomer, Monomer> map = new HashMap<Monomer, Monomer>();
        List<Monomer> newMonomers = this.getNewMonomers(monomerDB);
        if (newMonomers.size() > 0) {
            for (int i = 0; i < newMonomers.size(); ++i) {
                Monomer local = newMonomers.get(i);
                if (remoteMonomerDB.containsKey(local.getPolymerType())) {
                    Monomer remote;
                    Map<String, Monomer> monomers = remoteMonomerDB.get(local.getPolymerType());
                    if (monomers.containsKey(local.getAlternateId())) {
                        remote = monomers.get(local.getAlternateId());
                        if (local.getCanSMILES().equals(remote.getCanSMILES())) {
                            logger.log(Level.INFO, "Perfect Match");
                            continue;
                        }
                        map.put(local, remote);
                        continue;
                    }
                    if (remoteSmilesDB.containsKey(local.getCanSMILES())) {
                        remote = remoteSmilesDB.get(local.getCanSMILES());
                        map.put(local, remote);
                        continue;
                    }
                    logger.log(Level.INFO, "Really New");
                    continue;
                }
                logger.log(Level.INFO, "New Polymer Type");
            }
        }
        return map;
    }

    private List<Monomer> getNewMonomers(Map<String, Map<String, Monomer>> monomerDB) {
        ArrayList<Monomer> l = new ArrayList<Monomer>();
        Set<String> typeSet = monomerDB.keySet();
        for (String polymerType : typeSet) {
            Map<String, Monomer> map = monomerDB.get(polymerType);
            Object[] monomers = map.values().toArray();
            for (int j = 0; j < monomers.length; ++j) {
                Monomer m = (Monomer)monomers[j];
                if (!m.isNewMonomer()) continue;
                l.add(m);
            }
        }
        return l;
    }

    private static MonomerCache buildMonomerCacheFromWebService() throws MonomerException, IOException, JDOMException {
        Map<String, Map<String, Monomer>> newMonomerDB;
        Map<String, Attachment> newAttachmentDB = MonomerFactory.buildAttachmentDB();
        try {
            newMonomerDB = MonomerFactory.fetchMonomerDBFromWebService(newAttachmentDB);
        }
        catch (URISyntaxException | EncoderException e) {
            e.printStackTrace();
            throw new IOException("URISyntaxException prevents fetching monomers from webservice.");
        }
        Map<String, Monomer> newSmilesMonomerDB = MonomerFactory.buildSmilesMonomerDB(newMonomerDB);
        MonomerCache cache = new MonomerCache();
        cache.setMonomerDB(newMonomerDB);
        cache.setAttachmentDB(newAttachmentDB);
        cache.setSmilesMonomerDB(newSmilesMonomerDB);
        return cache;
    }

    private static Map<String, Map<String, Monomer>> fetchMonomerDBFromWebService(Map<String, Attachment> attachments) throws IOException, URISyntaxException, EncoderException {
        TreeMap<String, Map<String, Monomer>> monomerDB = new TreeMap<String, Map<String, Monomer>>(String.CASE_INSENSITIVE_ORDER);
        monomerDB.put("PEPTIDE", new MonomerWSLoader("PEPTIDE").loadMonomerStore(attachments));
        monomerDB.put("RNA", new MonomerWSLoader("RNA").loadMonomerStore(attachments));
        monomerDB.put("CHEM", new MonomerWSLoader("CHEM").loadMonomerStore(attachments));
        return monomerDB;
    }

    private static MonomerCache buildMonomerCacheFromWS() throws MonomerException, IOException, JDOMException {
        return MonomerFactory.buildMonomerCacheFromWebService();
    }

    private static MonomerCache buildMonomerCacheFromXML(InputStream monomerDBInputStream) throws MonomerException, IOException, JDOMException, ChemistryException, CTKException {
        if (null == builder) {
            MonomerFactory.setupBuilder();
        }
        Document doc = builder.build(monomerDBInputStream);
        Element root = doc.getRootElement();
        Element polymerList = root.getChild(POLYMER_LIST_ELEMENT, root.getNamespace());
        Map<String, Attachment> newAttachmentDB = MonomerFactory.buildAttachmentDB();
        Map<String, Map<String, Monomer>> newMonomerDB = MonomerFactory.buildMonomerDB(polymerList);
        Map<String, Monomer> newSmilesMonomerDB = MonomerFactory.buildSmilesMonomerDB(newMonomerDB);
        MonomerCache cache = new MonomerCache();
        cache.setMonomerDB(newMonomerDB);
        cache.setAttachmentDB(newAttachmentDB);
        cache.setSmilesMonomerDB(newSmilesMonomerDB);
        return cache;
    }

    private static Map<String, Attachment> buildAttachmentDB() throws IOException {
        TreeMap<String, Attachment> map = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        if (MonomerStoreConfiguration.getInstance().isUseExternalAttachments()) {
            map = AttachmentLoader.loadAttachments(new FileInputStream(MonomerStoreConfiguration.getInstance().getExternalAttachmentsPath()));
        } else {
            InputStream in = MonomerFactory.class.getResourceAsStream(ATTACHMENTS_RESOURCE);
            map = AttachmentLoader.loadAttachments(in);
        }
        return map;
    }

    private static String buildMonomerDbXMLFromCache(MonomerCache cache) throws MonomerException {
        XMLOutputter outputer = new XMLOutputter(Format.getPrettyFormat());
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + System.getProperty("line.separator") + "<MonomerDB xmlns=\"lmr\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">" + System.getProperty("line.separator"));
        Map<String, Map<String, Monomer>> mDB = cache.getMonomerDB();
        Element polymerListElement = new Element(POLYMER_LIST_ELEMENT);
        Set<String> polymerTypeSet = mDB.keySet();
        for (String polymerType : polymerTypeSet) {
            Element polymerElement = new Element(POLYMER_ELEMENT);
            Attribute att = new Attribute(POLYMER_TYPE_ATTRIBUTE, polymerType);
            polymerElement.setAttribute(att);
            polymerListElement.getChildren().add(polymerElement);
            Map<String, Monomer> monomerMap = mDB.get(polymerType);
            Set<String> monomerSet = monomerMap.keySet();
            for (String monomerID : monomerSet) {
                Monomer m = monomerMap.get(monomerID);
                Element monomerElement = MonomerParser.getMonomerElement(m);
                polymerElement.getChildren().add(monomerElement);
            }
        }
        String polymerListString = outputer.outputString(polymerListElement);
        sb.append(polymerListString + System.getProperty("line.separator"));
        Map<String, Attachment> aDB = cache.getAttachmentDB();
        Element attachmentListElement = new Element(ATTACHMENT_LIST_ELEMENT);
        Set<String> attachmentSet = aDB.keySet();
        for (String attachmentID : attachmentSet) {
            Attachment attachment = aDB.get(attachmentID);
            Element attachmentElement = MonomerParser.getAttachementElement(attachment);
            attachmentListElement.getChildren().add(attachmentElement);
        }
        String attachmentListString = outputer.outputString(attachmentListElement);
        sb.append(attachmentListString);
        sb.append(System.getProperty("line.separator") + "</MonomerDB>" + System.getProperty("line.separator"));
        return sb.toString();
    }

    private static void initializeMonomerCache() throws MonomerLoadingException, ChemistryException {
        MonomerCache cache = null;
        InputStream in = null;
        if (MonomerStoreConfiguration.getInstance().isUseWebservice()) {
            try {
                cache = MonomerFactory.buildMonomerCacheFromWS();
                MonomerFactory.validate(cache.getMonomerDB());
            }
            catch (IOException | CTKException | MonomerException | JDOMException e) {
                throw new MonomerLoadingException("Initializing MonomerStore failed because of " + e.getClass().getSimpleName(), e);
            }
            logger.log(Level.INFO, "WebService '' is used for monomer cache initialization");
        } else if (MonomerStoreConfiguration.getInstance().isUseExternalMonomers()) {
            try {
                in = new FileInputStream(MonomerStoreConfiguration.getInstance().getExternalMonomersPath());
                cache = MonomerFactory.buildMonomerCacheFromXML(in);
                MonomerFactory.validate(cache.getMonomerDB());
                logger.log(Level.INFO, MonomerStoreConfiguration.getInstance().getExternalMonomersPath() + " is used for monomer cache initialization");
            }
            catch (Exception e) {
                logger.log(Level.INFO, "Unable to use local monomer DB file: " + MonomerStoreConfiguration.getInstance().getExternalMonomersPath());
            }
        } else {
            File cacheFile = new File(MONOMER_CACHE_FILE_PATH);
            if (cacheFile.exists()) {
                try {
                    cache = MonomerFactory.deserializeMonomerCache(MONOMER_CACHE_FILE_PATH);
                    MonomerFactory.validate(cache.getMonomerDB());
                    logger.log(Level.INFO, MONOMER_CACHE_FILE_PATH + " is used for monomer cache initialization");
                }
                catch (Exception e) {
                    logger.log(Level.INFO, "Unable to use local monomer cache file: MonomerCache.ser");
                    cacheFile.delete();
                    logger.log(Level.INFO, "Deleted local monomer cache file: MonomerCache.ser");
                }
            }
            File localMonomerDBFile = new File(MONOMER_DB_FILE_PATH);
            if (null == cache && localMonomerDBFile.exists()) {
                try {
                    in = new FileInputStream(MONOMER_DB_FILE_PATH);
                    cache = MonomerFactory.buildMonomerCacheFromXML(in);
                    MonomerFactory.validate(cache.getMonomerDB());
                    logger.log(Level.INFO, MONOMER_DB_FILE_PATH + " is used for monomer cache initialization");
                }
                catch (Exception e) {
                    logger.log(Level.INFO, "Unable to use local monomer DB file: MonomerDBGZEncoded.xml");
                    localMonomerDBFile.delete();
                    logger.log(Level.INFO, "Deleted local monomer DB file: MonomerDBGZEncoded.xml");
                }
            }
            if (null == cache) {
                in = MonomerFactory.class.getResourceAsStream(MONOMER_DB_XML_RESOURCE);
                try {
                    LOG.info("BuildMonomerCacheFromXML");
                    cache = MonomerFactory.buildMonomerCacheFromXML(in);
                    MonomerFactory.validate(cache.getMonomerDB());
                }
                catch (IOException | CTKException | MonomerException | JDOMException e) {
                    throw new MonomerLoadingException("Initializing MonomerStore failed because of " + e.getClass().getSimpleName(), e);
                }
                logger.log(Level.INFO, "resources/MonomerDBGZEncoded.xml is used for monomer cache initialization");
            }
        }
        monomerDB = cache.getMonomerDB();
        attachmentDB = cache.getAttachmentDB();
        smilesMonomerDB = cache.getSmilesMonomerDB();
        dbChanged = true;
    }

    public void saveMonomerCache() throws IOException, MonomerException {
        File f = new File(NOTATION_DIRECTORY);
        if (!f.exists()) {
            f.mkdir();
        }
        MonomerCache cache = new MonomerCache();
        cache.setMonomerDB(this.getMonomerDB(false));
        cache.setAttachmentDB(this.getAttachmentDB());
        cache.setSmilesMonomerDB(this.getSmilesMonomerDB(false));
        MonomerFactory.serializeMonomerCache(cache, MONOMER_CACHE_FILE_PATH);
        String monomerDbXML = MonomerFactory.buildMonomerDbXMLFromCache(cache);
        FileOutputStream fos = new FileOutputStream(MONOMER_DB_FILE_PATH);
        fos.write(monomerDbXML.getBytes());
        fos.close();
    }

    private static Map<String, Map<String, Monomer>> buildMonomerDB(Element polymerList) throws MonomerException, IOException, JDOMException, CTKException, ChemistryException {
        TreeMap<String, Map<String, Monomer>> map = new TreeMap<String, Map<String, Monomer>>(String.CASE_INSENSITIVE_ORDER);
        List poplymers = polymerList.getChildren();
        for (Element polymer : poplymers) {
            Attribute polymerType = polymer.getAttribute(POLYMER_TYPE_ATTRIBUTE);
            TreeMap<String, Monomer> idMonomerMap = new TreeMap<String, Monomer>(String.CASE_INSENSITIVE_ORDER);
            List monomers = polymer.getChildren();
            for (Element monomer : monomers) {
                Monomer m = MonomerParser.getMonomer(monomer);
                if (!MonomerParser.validateMonomer(m)) continue;
                idMonomerMap.put(m.getAlternateId(), m);
            }
            map.put(polymerType.getValue(), idMonomerMap);
        }
        return map;
    }

    private static Map<String, Attachment> buildAttachmentDB(Element attachmentList) throws MonomerException, IOException, JDOMException, ChemistryException {
        TreeMap<String, Attachment> map = new TreeMap<String, Attachment>(String.CASE_INSENSITIVE_ORDER);
        List attachments = attachmentList.getChildren();
        for (Element attachment : attachments) {
            Attachment att = MonomerParser.getAttachment(attachment);
            if (!MonomerParser.validateAttachement(att)) continue;
            map.put(att.getAlternateId(), att);
        }
        return map;
    }

    private static Map<String, Monomer> buildSmilesMonomerDB(Map<String, Map<String, Monomer>> monomerDB) {
        HashMap<String, Monomer> map = new HashMap<String, Monomer>();
        Set<String> polymerSet = monomerDB.keySet();
        for (String polymer : polymerSet) {
            Map<String, Monomer> monomerMap = monomerDB.get(polymer);
            Set<String> monomerSet = monomerMap.keySet();
            for (String monomerID : monomerSet) {
                Monomer monomer = monomerMap.get(monomerID);
                String smiles = monomer.getCanSMILES();
                try {
                    Chemistry.getInstance().getManipulator().canonicalize(smiles);
                }
                catch (Exception e) {
                    smiles = monomer.getCanSMILES();
                }
                monomer.setCanSMILES(smiles);
                map.put(smiles, monomer);
            }
        }
        return map;
    }

    private static boolean validate(Map<String, Map<String, Monomer>> monomerDB) throws MonomerException, IOException, CTKException, ChemistryException {
        Set<String> polymers = monomerDB.keySet();
        for (String polymer : polymers) {
            Map<String, Monomer> monomerMap = monomerDB.get(polymer);
            Set<String> monomers = monomerMap.keySet();
            for (String monomer : monomers) {
                Monomer m = monomerMap.get(monomer);
                logger.info(m.getAlternateId());
                try {
                    MonomerParser.validateMonomer(m);
                }
                catch (Exception e) {
                    LOG.error("Monomer is invalide");
                    monomerDB.remove(monomer);
                }
            }
        }
        return true;
    }

    public static void finalizeMonomerCache() {
        monomerDB = null;
        attachmentDB = null;
        smilesMonomerDB = null;
        dbChanged = true;
        instance = null;
    }

    static {
        logger = java.util.logging.Logger.getLogger(MonomerFactory.class.toString());
        dbChanged = true;
    }
}

