/*
 * Decompiled with CFR 0.152.
 */
package org.helm.notation2;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.util.NoSuchElementException;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.helm.chemtoolkit.AbstractChemistryManipulator;
import org.helm.chemtoolkit.ManipulatorFactory;
import org.helm.notation2.exception.ChemistryException;

public final class Chemistry {
    private static final String CONFIG_FILE_PATH = System.getProperty("user.home") + System.getProperty("file.separator") + ".helm" + System.getProperty("file.separator") + "Chemistry.property";
    private static final String CHEMISTRY_PLUGIN = "chemistry";
    private static Chemistry _instance;
    public static String chemistry;
    private static AbstractChemistryManipulator manipulator;

    private Chemistry() throws ChemistryException {
        this.refresh();
        this.readConfigFile();
        try {
            manipulator = ManipulatorFactory.buildManipulator((String)chemistry);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
            throw new ChemistryException("Chemistry Engine could not be initialized");
        }
    }

    public String getChemistry() {
        return chemistry;
    }

    private void readConfigFile() {
        File configFile = new File(CONFIG_FILE_PATH);
        if (!configFile.exists()) {
            this.resetConfigToDefault();
        }
        try {
            PropertiesConfiguration conf = new PropertiesConfiguration(CONFIG_FILE_PATH);
            chemistry = conf.getString(CHEMISTRY_PLUGIN);
        }
        catch (ConfigurationException e) {
            this.resetConfigToDefault();
            e.printStackTrace();
        }
    }

    private void resetConfigToDefault() {
        chemistry = "org.helm.chemtoolkit.cdk.CDKManipulator";
    }

    public static Chemistry getInstance() throws ChemistryException {
        if (_instance == null) {
            _instance = new Chemistry();
        }
        return _instance;
    }

    public synchronized AbstractChemistryManipulator getManipulator() {
        return manipulator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        File configFile = new File(CONFIG_FILE_PATH);
        if (!configFile.exists()) {
            BufferedWriter writer = null;
            BufferedReader reader = null;
            try {
                String line;
                configFile.getParentFile().mkdirs();
                configFile.createNewFile();
                InputStream in = Chemistry.class.getResourceAsStream("/org/helm/notation2/resources/Chemistry.property");
                reader = new BufferedReader(new InputStreamReader(in));
                writer = new BufferedWriter(new FileWriter(configFile));
                while ((line = reader.readLine()) != null) {
                    writer.write(line + System.getProperty("line.separator"));
                }
            }
            catch (Exception e) {
                this.resetConfigToDefault();
                e.printStackTrace();
            }
            finally {
                try {
                    if (writer != null) {
                        writer.close();
                    }
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        try {
            PropertiesConfiguration conf = new PropertiesConfiguration(CONFIG_FILE_PATH);
            chemistry = conf.getString(CHEMISTRY_PLUGIN);
        }
        catch (NoSuchElementException | ConfigurationException e) {
            this.resetConfigToDefault();
            e.printStackTrace();
        }
    }
}

