/*
 * Decompiled with CFR 0.152.
 */
package org.helm.notation2.tools;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.helm.chemtoolkit.CTKException;
import org.helm.notation2.Monomer;
import org.helm.notation2.MonomerFactory;
import org.helm.notation2.exception.ChemistryException;
import org.helm.notation2.exception.HELM1FormatException;
import org.helm.notation2.exception.MonomerException;
import org.helm.notation2.exception.NotationException;
import org.helm.notation2.exception.ValidationException;
import org.helm.notation2.parser.notation.HELM2Notation;
import org.helm.notation2.parser.notation.polymer.MonomerNotation;
import org.helm.notation2.parser.notation.polymer.MonomerNotationUnit;
import org.helm.notation2.parser.notation.polymer.MonomerNotationUnitRNA;
import org.helm.notation2.tools.HELM1Utils;
import org.helm.notation2.tools.MethodsMonomerUtils;
import org.helm.notation2.tools.MonomerParser;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public final class xHelmNotationExporter {
    public static final String XHELM_ELEMENT = "Xhelm";
    public static final String MONOMER_LIST_ELEMENT = "Monomers";
    public static final String MONOMER_ELEMENT = "Monomer";
    public static final String HELM_NOTATION_ELEMENT = "HelmNotation";
    private static Set<Monomer> set = null;

    private xHelmNotationExporter() {
    }

    public static String getXHELM2(HELM2Notation helm2notation) throws MonomerException, IOException, JDOMException, ChemistryException {
        set = new HashSet<Monomer>();
        Element root = new Element(XHELM_ELEMENT);
        Document doc = new Document(root);
        Element helmElement = new Element(HELM_NOTATION_ELEMENT);
        helmElement.setText(helm2notation.toHELM2());
        root.addContent((Content)helmElement);
        Element monomerListElement = new Element(MONOMER_LIST_ELEMENT);
        for (MonomerNotation monomernotation : MethodsMonomerUtils.getListOfMonomerNotation(helm2notation.getListOfPolymers())) {
            if (monomernotation instanceof MonomerNotationUnitRNA) {
                for (MonomerNotationUnit unit : ((MonomerNotationUnitRNA)monomernotation).getContents()) {
                    xHelmNotationExporter.addAdHocMonomer((MonomerNotation)unit);
                }
                continue;
            }
            xHelmNotationExporter.addAdHocMonomer(monomernotation);
        }
        for (Monomer distinctmonomer : set) {
            Element monomerElement = MonomerParser.getMonomerElement(distinctmonomer);
            monomerListElement.getChildren().add(monomerElement);
        }
        root.addContent((Content)monomerListElement);
        XMLOutputter xmlOutput = new XMLOutputter();
        xmlOutput.setFormat(Format.getPrettyFormat());
        return xmlOutput.outputString(doc);
    }

    public static String getXHELM(HELM2Notation helm2notation) throws MonomerException, HELM1FormatException, IOException, JDOMException, NotationException, CTKException, ValidationException, ChemistryException {
        set = new HashSet<Monomer>();
        Element root = new Element(XHELM_ELEMENT);
        Document doc = new Document(root);
        Element helmElement = new Element(HELM_NOTATION_ELEMENT);
        helmElement.setText(HELM1Utils.getStandard(helm2notation));
        root.addContent((Content)helmElement);
        Element monomerListElement = new Element(MONOMER_LIST_ELEMENT);
        for (MonomerNotation monomernotation : MethodsMonomerUtils.getListOfMonomerNotation(helm2notation.getListOfPolymers())) {
            if (monomernotation instanceof MonomerNotationUnitRNA) {
                for (MonomerNotationUnit unit : ((MonomerNotationUnitRNA)monomernotation).getContents()) {
                    xHelmNotationExporter.addAdHocMonomer((MonomerNotation)unit);
                }
                continue;
            }
            xHelmNotationExporter.addAdHocMonomer(monomernotation);
        }
        for (Monomer distinctmonomer : set) {
            Element monomerElement = MonomerParser.getMonomerElement(distinctmonomer);
            monomerListElement.getChildren().add(monomerElement);
        }
        root.addContent((Content)monomerListElement);
        XMLOutputter xmlOutput = new XMLOutputter();
        xmlOutput.setFormat(Format.getPrettyFormat());
        return xmlOutput.outputString(doc);
    }

    private static void addAdHocMonomer(MonomerNotation monomerNotation) throws IOException, JDOMException, ChemistryException {
        Monomer monomer = MonomerFactory.getInstance().getMonomerStore().getMonomer(monomerNotation.getType(), monomerNotation.getUnit().replace("[", "").replace("]", ""));
        if (monomer.isAdHocMonomer()) {
            set.add(monomer);
        }
    }
}

