/*
 * Decompiled with CFR 0.152.
 */
package org.helm.notation2.tools;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.helm.chemtoolkit.CTKException;
import org.helm.notation2.Attachment;
import org.helm.notation2.MoleculeProperty;
import org.helm.notation2.Monomer;
import org.helm.notation2.MonomerFactory;
import org.helm.notation2.MonomerStore;
import org.helm.notation2.calculation.ExtinctionCoefficient;
import org.helm.notation2.calculation.MoleculePropertyCalculator;
import org.helm.notation2.exception.BuilderMoleculeException;
import org.helm.notation2.exception.ChemistryException;
import org.helm.notation2.exception.ConnectionNotationException;
import org.helm.notation2.exception.ExtinctionCoefficientException;
import org.helm.notation2.exception.FastaFormatException;
import org.helm.notation2.exception.GroupingNotationException;
import org.helm.notation2.exception.HELM1FormatException;
import org.helm.notation2.exception.HELM2HandledException;
import org.helm.notation2.exception.MonomerException;
import org.helm.notation2.exception.MonomerLoadingException;
import org.helm.notation2.exception.NotationException;
import org.helm.notation2.exception.NucleotideLoadingException;
import org.helm.notation2.exception.ParserException;
import org.helm.notation2.exception.PeptideUtilsException;
import org.helm.notation2.exception.PolymerIDsException;
import org.helm.notation2.exception.ValidationException;
import org.helm.notation2.parser.notation.HELM2Notation;
import org.helm.notation2.tools.FastaFormat;
import org.helm.notation2.tools.HELM1Utils;
import org.helm.notation2.tools.HELM2NotationUtils;
import org.helm.notation2.tools.Images;
import org.helm.notation2.tools.SMILES;
import org.helm.notation2.tools.SequenceConverter;
import org.helm.notation2.tools.Validation;
import org.helm.notation2.tools.xHelmNotationParser;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebService {
    private static final Logger LOG = LoggerFactory.getLogger(WebService.class);

    private Element getXHELMRootElement(String resource) throws JDOMException, IOException {
        ByteArrayInputStream stream = new ByteArrayInputStream(resource.getBytes());
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build((InputStream)stream);
        return doc.getRootElement();
    }

    private void updateMonomerStore(MonomerStore monomerStore) throws MonomerLoadingException, IOException, MonomerException, ChemistryException {
        for (Monomer monomer : monomerStore.getAllMonomersList()) {
            MonomerFactory.getInstance().getMonomerStore().addNewMonomer(monomer);
            MonomerFactory.getInstance().saveMonomerCache();
        }
    }

    private HELM2Notation readNotation(String notation) throws ParserException, JDOMException, IOException, MonomerException, ChemistryException {
        if (notation.contains("<Xhelm>")) {
            LOG.info("xhelm is used as input");
            String xhelm = notation;
            Element xHELMRootElement = this.getXHELMRootElement(xhelm);
            notation = xHelmNotationParser.getHELMNotationString(xHELMRootElement);
            MonomerStore store = xHelmNotationParser.getMonomerStore(xHELMRootElement);
            this.updateMonomerStore(store);
        }
        return HELM2NotationUtils.readNotation(notation);
    }

    private HELM2Notation validate(String helm) throws ValidationException, ChemistryException {
        try {
            HELM2Notation helm2notation = this.readNotation(helm);
            LOG.info("Validation of HELM is starting");
            Validation.validateNotationObjects(helm2notation);
            LOG.info("Validation was successful");
            return helm2notation;
        }
        catch (IOException | ConnectionNotationException | GroupingNotationException | MonomerException | NotationException | ParserException | PolymerIDsException | org.helm.notation2.parser.exceptionparser.NotationException | JDOMException e) {
            e.printStackTrace();
            LOG.info("Validation was not successful");
            LOG.error(e.getMessage());
            throw new ValidationException(e.getMessage());
        }
    }

    public void validateHELM(String helm) throws ValidationException, MonomerLoadingException, ChemistryException {
        this.validate(helm);
        this.setMonomerFactoryToDefault(helm);
    }

    public void validateSyntaxHELM(String helm) throws ChemistryException, ParserException, JDOMException, IOException, MonomerException {
        HELM2Notation helm2notation = this.readNotation(helm);
        this.setMonomerFactoryToDefault(helm);
    }

    public String convertStandardHELMToCanonicalHELM(String notation) throws HELM1FormatException, ValidationException, MonomerLoadingException, ChemistryException {
        String result = HELM1Utils.getCanonical(this.validate(notation));
        this.setMonomerFactoryToDefault(notation);
        return result;
    }

    public String convertIntoStandardHELM(String notation) throws HELM1FormatException, ValidationException, MonomerLoadingException, CTKException, ChemistryException {
        String result = HELM1Utils.getStandard(this.validate(notation));
        this.setMonomerFactoryToDefault(notation);
        return result;
    }

    public Float calculateExtinctionCoefficient(String notation) throws ExtinctionCoefficientException, ValidationException, MonomerLoadingException, ChemistryException {
        Float result = Float.valueOf(ExtinctionCoefficient.getInstance().calculate(this.validate(notation)));
        this.setMonomerFactoryToDefault(notation);
        return result;
    }

    public String generateFasta(String notation) throws FastaFormatException, ValidationException, MonomerLoadingException, ChemistryException {
        String result = FastaFormat.generateFasta(this.validate(notation));
        this.setMonomerFactoryToDefault(notation);
        return result;
    }

    public String generateHELMFromFastaNucleotide(String notation) throws FastaFormatException, org.helm.notation2.parser.exceptionparser.NotationException, ChemistryException, MonomerLoadingException, NucleotideLoadingException {
        String result = FastaFormat.generateRNAPolymersFromFastaFormatHELM1(notation).toHELM2();
        this.setMonomerFactoryToDefault(notation);
        return result;
    }

    public String generateHELMFromFastaPeptide(String notation) throws FastaFormatException, MonomerLoadingException, ChemistryException {
        String result = FastaFormat.generatePeptidePolymersFromFASTAFormatHELM1(notation).toHELM2();
        this.setMonomerFactoryToDefault(notation);
        return result;
    }

    public Double calculateMolecularWeight(String notation) throws MonomerLoadingException, BuilderMoleculeException, CTKException, ValidationException, ChemistryException {
        Double result = MoleculePropertyCalculator.getMolecularWeight(this.validate(notation));
        this.setMonomerFactoryToDefault(notation);
        return result;
    }

    public String getMolecularFormula(String notation) throws BuilderMoleculeException, CTKException, ValidationException, MonomerLoadingException, ChemistryException {
        String result = MoleculePropertyCalculator.getMolecularFormular(this.validate(notation));
        this.setMonomerFactoryToDefault(notation);
        return result;
    }

    public List<String> getMolecularProperties(String notation) throws BuilderMoleculeException, CTKException, ExtinctionCoefficientException, ValidationException, MonomerLoadingException, ChemistryException {
        MoleculeProperty result = MoleculePropertyCalculator.getMoleculeProperties(this.validate(notation));
        this.setMonomerFactoryToDefault(notation);
        return new LinkedList<String>(Arrays.asList(result.getMolecularFormula(), Double.toString(result.getMolecularWeight()), Double.toString(result.getExactMass()), Double.toString(result.getExtinctionCoefficient())));
    }

    public String readPeptide(String peptide) throws FastaFormatException, org.helm.notation2.parser.exceptionparser.NotationException, ChemistryException {
        return SequenceConverter.readPeptide(peptide).toHELM2();
    }

    public String readRNA(String rna) throws org.helm.notation2.parser.exceptionparser.NotationException, FastaFormatException, ChemistryException, NucleotideLoadingException {
        return SequenceConverter.readRNA(rna).toHELM2();
    }

    public byte[] generateImageForHELMMolecule(String notation) throws BuilderMoleculeException, CTKException, IOException, ValidationException, ChemistryException {
        byte[] result = Images.generateImageHELMMolecule(this.validate(notation));
        this.setMonomerFactoryToDefault(notation);
        return result;
    }

    public byte[] generateImageForMonomer(Monomer monomer, boolean showRgroups) throws BuilderMoleculeException, CTKException, ChemistryException {
        return Images.generateImageofMonomer(monomer, showRgroups);
    }

    public String generateJSON(String helm) throws ValidationException, MonomerLoadingException, ChemistryException, JsonProcessingException {
        String result = HELM2NotationUtils.toJSON(this.validate(helm));
        this.setMonomerFactoryToDefault(helm);
        return result;
    }

    public void refreshMonomerCache() throws MonomerLoadingException, ChemistryException {
        LOG.info("Refreshing monomer cache");
        MonomerFactory.refreshMonomerCache();
    }

    private void setMonomerFactoryToDefault(String helm) throws MonomerLoadingException, ChemistryException {
        if (helm.contains("<Xhelm>")) {
            LOG.info("Refresh local Monomer Store in case of Xhelm");
            MonomerFactory.refreshMonomerCache();
        }
    }

    public String generateNaturalAnalogSequencePeptide(String notation) throws HELM2HandledException, ValidationException, MonomerLoadingException, PeptideUtilsException, org.helm.notation2.parser.exceptionparser.NotationException, ChemistryException {
        String result = SequenceConverter.getPeptideNaturalAnalogSequenceFromNotation(this.validate(notation));
        this.setMonomerFactoryToDefault(notation);
        return result;
    }

    public String generateNaturalAnalogSequenceRNA(String notation) throws org.helm.notation2.parser.exceptionparser.NotationException, HELM2HandledException, ValidationException, MonomerLoadingException, ChemistryException {
        String result = SequenceConverter.getNucleotideNaturalAnalogSequenceFromNotation(this.validate(notation));
        this.setMonomerFactoryToDefault(notation);
        return result;
    }

    public String generateSMILESForHELM2(String notation) throws BuilderMoleculeException, CTKException, ChemistryException, ValidationException, MonomerLoadingException {
        String result = SMILES.getSMILESForAll(this.validate(notation));
        this.setMonomerFactoryToDefault(notation);
        return result;
    }

    public String generateCanSMILESForHELM2(String notation) throws BuilderMoleculeException, CTKException, ChemistryException, ValidationException, MonomerLoadingException, NotationException {
        String result = SMILES.getCanonicalSMILESForAll(this.validate(notation));
        this.setMonomerFactoryToDefault(notation);
        return result;
    }

    public String convertMolFileSMILESWithAtomMapping(String molfile, List<Attachment> attachments) throws CTKException, ChemistryException {
        return SMILES.convertMolToSMILESWithAtomMapping(molfile, attachments);
    }
}

