/*
 * Decompiled with CFR 0.152.
 */
package org.helm.notation2.tools;

import org.helm.chemtoolkit.AbstractChemistryManipulator;
import org.helm.chemtoolkit.CTKException;
import org.helm.notation2.Chemistry;
import org.helm.notation2.exception.BuilderMoleculeException;
import org.helm.notation2.exception.ChemistryException;
import org.helm.notation2.exception.NotationException;
import org.helm.notation2.parser.notation.HELM2Notation;
import org.helm.notation2.tools.SMILES;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MDLUtils {
    private static final Logger LOG = LoggerFactory.getLogger(MDLUtils.class);

    private MDLUtils() {
    }

    public static String generateMDL(HELM2Notation helm2notation) throws BuilderMoleculeException, CTKException, NotationException, ChemistryException {
        LOG.debug("Generate smiles representation for the whole HELM molecule");
        String smiles = SMILES.getSMILESForAll(helm2notation);
        LOG.debug("Convert smiles to mol");
        return Chemistry.getInstance().getManipulator().convert(smiles, AbstractChemistryManipulator.StType.SMILES);
    }
}

