/*
 * Decompiled with CFR 0.152.
 */
package org.helm.notation2.tools;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.helm.notation2.Monomer;
import org.helm.notation2.MonomerFactory;
import org.helm.notation2.exception.ChemistryException;
import org.helm.notation2.exception.MonomerException;
import org.helm.notation2.exception.MonomerLoadingException;
import org.helm.notation2.exception.NotationException;

public class AminoAcidParser {
    public static final String[] SEQUENCE_DELIMETERS = new String[]{".", ":", ",", ";"};

    public static List<String> getAminoAcidList(String peptideSequence) throws MonomerException, NotationException, MonomerLoadingException, ChemistryException {
        if (null == peptideSequence) {
            throw new NotationException("Peptide Sequence must be specified");
        }
        String cleanSeq = AminoAcidParser.cleanup(peptideSequence);
        Map<String, Monomer> peptideMap = MonomerFactory.getInstance().getMonomerDB().get("PEPTIDE");
        Set<String> keySet = peptideMap.keySet();
        ArrayList<String> l = new ArrayList<String>();
        int pos = 0;
        while (pos < cleanSeq.length()) {
            boolean found = false;
            for (String symbol : keySet) {
                if (!cleanSeq.startsWith(symbol, pos)) continue;
                found = true;
                l.add(symbol);
                pos += symbol.length();
                break;
            }
            if (found) continue;
            throw new NotationException("Sequence contains unknown amino acid starting at " + cleanSeq.substring(pos));
        }
        return l;
    }

    public static List<String> getAminoAcidList(String peptideSequence, String delimiter) throws MonomerException, NotationException, MonomerLoadingException, ChemistryException {
        if (null == peptideSequence) {
            throw new NotationException("Peptide Sequence must be specified");
        }
        if (null == delimiter || delimiter.length() == 0) {
            return AminoAcidParser.getAminoAcidList(peptideSequence);
        }
        if (!AminoAcidParser.isValidDelimiter(delimiter)) {
            throw new NotationException("Invalid sequence delimiter [" + delimiter + "], only the following are supported: [" + AminoAcidParser.getValidDelimiters() + "]");
        }
        ArrayList<String> blocks = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(peptideSequence, delimiter);
        while (st.hasMoreTokens()) {
            blocks.add(st.nextToken());
        }
        ArrayList<String> l = new ArrayList<String>();
        for (String block : blocks) {
            List<String> tmpL = AminoAcidParser.getAminoAcidList(block);
            l.addAll(tmpL);
        }
        return l;
    }

    public static String cleanup(String sequence) {
        String result = sequence.replaceAll("\\s", "");
        if (result.equals(result.toLowerCase())) {
            result = result.toUpperCase();
        }
        return result;
    }

    private static boolean isValidDelimiter(String delimeter) {
        for (String token : SEQUENCE_DELIMETERS) {
            if (!token.equals(delimeter)) continue;
            return true;
        }
        return false;
    }

    private static String getValidDelimiters() {
        StringBuffer sb = new StringBuffer();
        for (String token : SEQUENCE_DELIMETERS) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(token);
        }
        return sb.toString();
    }
}

