/*
 * Decompiled with CFR 0.152.
 */
package org.helm.notation2;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.helm.notation2.MonomerFactory;
import org.helm.notation2.NotationConstant;
import org.helm.notation2.exception.NotationException;
import org.helm.notation2.exception.NucleotideLoadingException;
import org.helm.notation2.tools.NucleotideParser;
import org.helm.notation2.wsadapter.MonomerStoreConfiguration;
import org.helm.notation2.wsadapter.NucleotideWSLoader;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

public class NucleotideFactory {
    public static final String NOTATION_DIRECTORY = NotationConstant.NOTATION_DIRECTORY;
    public static final String LOCAL_NUCLEOTIDE_TEMPLATE_FILE_NAME = "NucleotideTemplates.xml";
    public static final String LOCAL_NUCLEOTIDE_TEMPLATE_FILE_PATH = NOTATION_DIRECTORY + System.getProperty("file.separator") + "NucleotideTemplates.xml";
    public static final String NUCLEOTIDE_TEMPLATE_XML_RESOURCE = "resources/NucleotideTemplates.xml";
    public static final String NUCLEOTIDE_TEMPLATE_SCHEMA_RESOURCE = "resources/NucleotideTemplateSchema.xsd";
    public static final String XML_SCHEMA_VALIDATION_FEATURE = "http://apache.org/xml/features/validation/schema";
    public static final String EXTERNAL_SCHEMA_LOCATION_KEY = "http://apache.org/xml/properties/schema/external-schemaLocation";
    public static final String DEFAULT_NAME_SPACE = "lmr";
    private static NucleotideFactory instance;
    private static Map<String, Map<String, String>> nucleotideTemplates;
    private static Map<String, String> reverseNucleotideMap;
    private static SAXBuilder builder;
    private static Logger logger;

    public synchronized Map<String, Map<String, String>> getNucleotideTemplates() {
        return nucleotideTemplates;
    }

    public synchronized void setNucleotideTemplates(Map<String, Map<String, String>> newNucleotideTemplates) {
        nucleotideTemplates = newNucleotideTemplates;
        reverseNucleotideMap = NucleotideFactory.getReverseNucleotideTemplateMap("HELM Notation");
    }

    private static void setupBuilder() {
        URL schema = MonomerFactory.class.getResource(NUCLEOTIDE_TEMPLATE_SCHEMA_RESOURCE);
        builder = new SAXBuilder(true);
        builder.setFeature(XML_SCHEMA_VALIDATION_FEATURE, true);
        builder.setProperty(EXTERNAL_SCHEMA_LOCATION_KEY, (Object)("lmr " + schema.toString()));
    }

    private NucleotideFactory() {
    }

    public static NucleotideFactory getInstance() throws NucleotideLoadingException {
        if (null == instance) {
            if (MonomerStoreConfiguration.getInstance().isUseWebservice()) {
                NucleotideFactory.initializeNucleotideTemplatesFromWebService();
            } else if (MonomerStoreConfiguration.getInstance().isUseExternalNucleotides()) {
                NucleotideFactory.initalizeNucleotideTemplatesFromExternalFile();
            } else {
                NucleotideFactory.initializeNucleotideTemplates();
            }
            instance = new NucleotideFactory();
        }
        return instance;
    }

    private static Map<String, Map<String, String>> buildNucleotideTemplates(InputStream templatesInputStream) throws IOException, JDOMException {
        if (null == builder) {
            NucleotideFactory.setupBuilder();
        }
        Document doc = builder.build(templatesInputStream);
        Element root = doc.getRootElement();
        Map<String, Map<String, String>> templates = NucleotideParser.getNucleotideTemplates(root);
        return templates;
    }

    public Map<String, Map<String, String>> buildNucleotideTemplatesFromXML(String nucleotideTemplatesXML) throws IOException, JDOMException {
        ByteArrayInputStream bais = new ByteArrayInputStream(nucleotideTemplatesXML.getBytes());
        return NucleotideFactory.buildNucleotideTemplates(bais);
    }

    private static void initializeNucleotideTemplates() throws NucleotideLoadingException {
        InputStream in = null;
        File localFile = new File(LOCAL_NUCLEOTIDE_TEMPLATE_FILE_PATH);
        Map<String, Map<String, String>> templates = null;
        if (localFile.exists()) {
            try {
                in = new FileInputStream(localFile);
                templates = NucleotideFactory.buildNucleotideTemplates(in);
                NucleotideFactory.validate(templates);
                logger.log(Level.INFO, LOCAL_NUCLEOTIDE_TEMPLATE_FILE_PATH + " is used for nucleotide templates initialization");
            }
            catch (Exception e) {
                logger.log(Level.INFO, "Unable to use local nucleotide templates for initialization");
                localFile.delete();
                logger.log(Level.INFO, "Deleted local nucleotide templates file");
            }
        }
        if (null == templates) {
            in = NucleotideFactory.class.getResourceAsStream(NUCLEOTIDE_TEMPLATE_XML_RESOURCE);
            try {
                templates = NucleotideFactory.buildNucleotideTemplates(in);
                NucleotideFactory.validate(templates);
            }
            catch (IOException | NotationException | JDOMException e) {
                throw new NucleotideLoadingException("Initializing NucleotideStore failed because of " + e.getClass().getSimpleName(), e);
            }
            logger.log(Level.INFO, "resources/NucleotideTemplates.xml is used for nucleotide templates initialization");
        }
        nucleotideTemplates = templates;
        reverseNucleotideMap = NucleotideFactory.getReverseNucleotideTemplateMap("HELM Notation");
    }

    private static void initalizeNucleotideTemplatesFromExternalFile() throws NucleotideLoadingException {
        InputStream in = null;
        File externalFile = new File(MonomerStoreConfiguration.getInstance().getExternalNucleotidesPath());
        Map<String, Map<String, String>> templates = null;
        if (externalFile.exists()) {
            try {
                in = new FileInputStream(externalFile);
                templates = NucleotideFactory.buildNucleotideTemplates(in);
                NucleotideFactory.validate(templates);
                logger.log(Level.INFO, MonomerStoreConfiguration.getInstance().getExternalNucleotidesPath() + " is used for nucleotide templates initialization");
            }
            catch (Exception e) {
                logger.log(Level.INFO, "Unable to use external nucleotide templates for initialization");
            }
        }
        if (null == templates) {
            in = NucleotideFactory.class.getResourceAsStream(NUCLEOTIDE_TEMPLATE_XML_RESOURCE);
            try {
                templates = NucleotideFactory.buildNucleotideTemplates(in);
                NucleotideFactory.validate(templates);
            }
            catch (IOException | NotationException | JDOMException e) {
                throw new NucleotideLoadingException("Initializing NucleotideStore failed because of " + e.getClass().getSimpleName(), e);
            }
            logger.log(Level.INFO, "resources/NucleotideTemplates.xml is used for nucleotide templates initialization");
        }
        nucleotideTemplates = templates;
        reverseNucleotideMap = NucleotideFactory.getReverseNucleotideTemplateMap("HELM Notation");
    }

    public static void initializeNucleotideTemplatesFromWebService() throws NucleotideLoadingException {
        nucleotideTemplates = new TreeMap<String, Map<String, String>>(String.CASE_INSENSITIVE_ORDER);
        try {
            nucleotideTemplates.put("HELM Notation", new NucleotideWSLoader().loadNucleotideStore());
        }
        catch (IOException | URISyntaxException e) {
            throw new NucleotideLoadingException("Initializing NucleotideStore failed because of " + e.getClass().getSimpleName(), e);
        }
        reverseNucleotideMap = NucleotideFactory.getReverseNucleotideTemplateMap("HELM Notation");
    }

    public void saveNucleotideTemplates() throws IOException {
        File f = new File(NOTATION_DIRECTORY);
        if (!f.exists()) {
            f.mkdir();
        }
        String nucleotideTemplatesXML = NucleotideParser.getNucleotideTemplatesXML(this.getNucleotideTemplates());
        FileOutputStream fos = new FileOutputStream(LOCAL_NUCLEOTIDE_TEMPLATE_FILE_PATH);
        fos.write(nucleotideTemplatesXML.getBytes());
    }

    private static synchronized Map<String, String> getReverseNucleotideTemplateMap(String notationSource) {
        TreeMap<String, String> map = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        Map<String, String> normalMap = nucleotideTemplates.get(notationSource);
        if (normalMap != null) {
            Set<String> set = normalMap.keySet();
            for (String tmp : set) {
                map.put(normalMap.get(tmp), tmp);
            }
        }
        return map;
    }

    public synchronized Map<String, String> getReverseNucleotideTemplateMap() {
        return reverseNucleotideMap;
    }

    private static boolean validate(Map<String, Map<String, String>> templates) throws IOException, NotationException, JDOMException {
        Map<String, String> nucMap = templates.get("HELM Notation");
        Set<String> symbols = nucMap.keySet();
        for (String symbol : symbols) {
            String notation = nucMap.get(symbol);
            try {
                NucleotideParser.validateSimpleNotationForRNA(notation);
            }
            catch (Exception e) {
                throw new NotationException("Invalid notation " + notation + " for nucleotide " + symbol);
            }
        }
        return true;
    }

    static {
        logger = Logger.getLogger(NucleotideFactory.class.toString());
    }
}

