/*
 * Decompiled with CFR 0.152.
 */
package org.helm.notation2;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.TreeMap;
import org.helm.notation2.Attachment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttachmentLoader {
    private static final Logger LOG = LoggerFactory.getLogger(AttachmentLoader.class);

    private AttachmentLoader() {
    }

    public static Map<String, Attachment> loadAttachments(InputStream in) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        TypeReference<TreeMap<String, Attachment>> typeRef = new TypeReference<TreeMap<String, Attachment>>(){};
        try {
            TreeMap attachments = (TreeMap)mapper.readValue(in, (TypeReference)typeRef);
            LOG.info("Attachments could be loaded");
            for (Map.Entry entry : attachments.entrySet()) {
                Attachment currentAttachment = (Attachment)entry.getValue();
                if (AttachmentLoader.validateAttachment(currentAttachment)) continue;
                throw new IOException("Attachment is not valid: " + currentAttachment.getAlternateId());
            }
            return attachments;
        }
        catch (IOException e) {
            throw new IOException("Attachments in the given file can not be loaded.");
        }
    }

    public static boolean validateAttachment(Attachment currentAttachment) {
        try {
            currentAttachment.getId();
            if (currentAttachment.getAlternateId() == "null" || currentAttachment.getAlternateId().isEmpty()) {
                return false;
            }
            if (currentAttachment.getCapGroupName() == "null" || currentAttachment.getCapGroupName().isEmpty()) {
                return false;
            }
            if (currentAttachment.getCapGroupSMILES() == "null" || currentAttachment.getCapGroupSMILES().isEmpty()) {
                return false;
            }
            if (currentAttachment.getLabel().equals("null") || currentAttachment.getLabel().equals(" ")) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

