/*
 * Decompiled with CFR 0.152.
 */
package org.helm.notation2.tools;

import java.io.IOException;
import org.helm.chemtoolkit.AbstractChemistryManipulator;
import org.helm.chemtoolkit.AbstractMolecule;
import org.helm.chemtoolkit.CTKException;
import org.helm.notation2.Chemistry;
import org.helm.notation2.Monomer;
import org.helm.notation2.exception.BuilderMoleculeException;
import org.helm.notation2.exception.ChemistryException;
import org.helm.notation2.parser.notation.HELM2Notation;
import org.helm.notation2.tools.BuilderMolecule;
import org.helm.notation2.tools.SMILES;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Images {
    private static final int PICTURE_HEIGHT = 1000;
    private static final int PICTURE_WIDTH = 1000;
    private static final Logger LOG = LoggerFactory.getLogger(Images.class);

    private Images() {
    }

    public static byte[] generateImageofMonomer(Monomer monomer, boolean rgroupsInformation) throws BuilderMoleculeException, CTKException, ChemistryException {
        AbstractMolecule molecule;
        LOG.info("Image generation process of monomer starts");
        if (rgroupsInformation) {
            molecule = BuilderMolecule.getMoleculeForMonomer(monomer);
            LOG.info("Molecule was built");
        } else {
            molecule = BuilderMolecule.mergeRgroups(BuilderMolecule.getMoleculeForMonomer(monomer));
            LOG.info("Molecule was built and unused rgroups were merged into it");
        }
        String molFile = Chemistry.getInstance().getManipulator().convertMolecule(molecule, AbstractChemistryManipulator.StType.MOLFILE);
        LOG.info("Generate molfile for the built molecule");
        return Chemistry.getInstance().getManipulator().renderMol(molFile, AbstractChemistryManipulator.OutputType.PNG, 1000, 1000, (int)Long.parseLong("D3D3D3", 16));
    }

    public static byte[] generateImageHELMMolecule(HELM2Notation helm2notation) throws BuilderMoleculeException, CTKException, IOException, ChemistryException {
        LOG.info("Image generation process of HELM molecule starts");
        String smiles = SMILES.getSMILESForAll(helm2notation);
        LOG.info("Get for the whole HELMNotation the smiles representation");
        AbstractMolecule molecule = Chemistry.getInstance().getManipulator().getMolecule(smiles, null);
        LOG.info("Molecule was created using the smiles generation");
        String molFile = Chemistry.getInstance().getManipulator().convertMolecule(molecule, AbstractChemistryManipulator.StType.MOLFILE);
        LOG.info("Generate molfile for the built molecule(s)");
        return Chemistry.getInstance().getManipulator().renderMol(molFile, AbstractChemistryManipulator.OutputType.PNG, 1000, 1000, (int)Long.parseLong("D3D3D3", 16));
    }
}

