/*
 * Decompiled with CFR 0.152.
 */
package org.helm.notation2;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.util.Map;
import java.util.logging.Level;
import org.helm.notation2.Monomer;
import org.helm.notation2.MonomerFactory;
import org.helm.notation2.MonomerStore;
import org.helm.notation2.tools.NucleotideParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Nucleotide
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(Nucleotide.class);
    public static final int STARTING_POSITION_TYPE = 1;
    public static final int MIDDLE_POSITION_TYPE = 2;
    public static final int ENDING_POSITION_TYPE = 3;
    private int positionType = 2;
    private String symbol;
    private boolean modified;
    private String notation;
    private String naturalAnalog;

    public Nucleotide() {
    }

    public Nucleotide(String symbol, String notation) {
        this.symbol = symbol;
        this.notation = notation;
    }

    public Nucleotide(String notation, int postionType) {
        this.notation = notation;
        this.positionType = postionType;
    }

    public Nucleotide(String symbol, String notation, int postionType) {
        this.symbol = symbol;
        this.notation = notation;
        this.positionType = postionType;
    }

    public int getPositionType() {
        return this.positionType;
    }

    public void setPositionType(int positionType) {
        this.positionType = positionType;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public boolean isModified() {
        if (null != this.getNotation()) {
            if (this.getNotation().contains("[")) {
                return true;
            }
            if (this.getNotation().contains("(X)")) {
                return true;
            }
            if (this.getNotation().endsWith(")")) {
                return true;
            }
        }
        return false;
    }

    public boolean unmodifiedWithoutPhosphate() {
        if (this.getNotation() == null) {
            return true;
        }
        return !this.getNotation().contains("[") && !this.getNotation().contains("X");
    }

    @Deprecated
    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public String getNotation() {
        return this.notation;
    }

    public void setNotation(String notation) {
        this.notation = notation;
    }

    public String getNaturalAnalog() {
        MonomerFactory factory = null;
        try {
            factory = MonomerFactory.getInstance();
        }
        catch (Exception ex) {
            java.util.logging.Logger.getLogger(Nucleotide.class.getName()).log(Level.SEVERE, "Unable to initialize monomer factory", ex);
        }
        return this.getNaturalAnalog(factory.getMonomerStore());
    }

    public String getNaturalAnalog(MonomerStore monomerStore) {
        String baseNotation = null;
        String notation = this.getNotation();
        char[] notationChar = notation.toCharArray();
        for (int i = 0; i < notationChar.length; ++i) {
            int pos;
            if (notationChar[i] == '[') {
                i = pos = NucleotideParser.getMatchingBracketPosition(notationChar, i, '[', ']');
                continue;
            }
            if (notationChar[i] != '(') continue;
            pos = NucleotideParser.getMatchingBracketPosition(notationChar, i, '(', ')');
            baseNotation = notation.substring(i + 1, pos);
            break;
        }
        if (baseNotation == null) {
            return "X";
        }
        if (baseNotation.charAt(0) == '[' && baseNotation.charAt(baseNotation.length() - 1) == ']') {
            baseNotation = baseNotation.substring(1, baseNotation.length() - 1);
        }
        try {
            Map<String, Monomer> monomers = monomerStore.getMonomers("RNA");
            Monomer m = monomers.get(baseNotation);
            if (m == null) {
                Map<String, Monomer> smiles = monomerStore.getSmilesMonomerDB();
                m = smiles.get(baseNotation);
            }
            return m.getNaturalAnalog();
        }
        catch (Exception e) {
            LOG.info("Unable to get natural analog for " + baseNotation);
            return "X";
        }
    }

    @Deprecated
    public void setNaturalAnalog(String naturalAnalog) {
        this.naturalAnalog = naturalAnalog;
    }

    public Monomer getPhosphateMonomer() {
        MonomerFactory factory = null;
        try {
            factory = MonomerFactory.getInstance();
        }
        catch (Exception ex) {
            java.util.logging.Logger.getLogger(Nucleotide.class.getName()).log(Level.SEVERE, "Unable to initialize monomer factory", ex);
        }
        return this.getPhosphateMonomer(factory.getMonomerStore());
    }

    public Monomer getPhosphateMonomer(MonomerStore monomerStore) {
        String phosphateSymbol = this.getPhosphateSymbol();
        if (phosphateSymbol != null && !phosphateSymbol.equalsIgnoreCase("")) {
            try {
                Map<String, Monomer> monomers = monomerStore.getMonomers("RNA");
                Monomer m = monomers.get(phosphateSymbol);
                return m;
            }
            catch (Exception ex) {
                LOG.info("Unable to get phosphate monomer for " + phosphateSymbol);
                return null;
            }
        }
        return null;
    }

    public Monomer getBaseMonomer() {
        MonomerFactory factory = null;
        try {
            factory = MonomerFactory.getInstance();
        }
        catch (Exception ex) {
            java.util.logging.Logger.getLogger(Nucleotide.class.getName()).log(Level.SEVERE, "Unable to initialize monomer factory", ex);
        }
        return this.getBaseMonomer(factory.getMonomerStore());
    }

    public Monomer getBaseMonomer(MonomerStore monomerStore) {
        String baseSymbol = this.getBaseSymbol();
        if (baseSymbol != null && !baseSymbol.equalsIgnoreCase("")) {
            try {
                Map<String, Monomer> monomers = monomerStore.getMonomers("RNA");
                Monomer m = monomers.get(baseSymbol);
                return m;
            }
            catch (Exception ex) {
                LOG.info("Unable to get base monomer for " + baseSymbol);
                return null;
            }
        }
        return null;
    }

    public Monomer getSugarMonomer() {
        MonomerFactory factory = null;
        try {
            factory = MonomerFactory.getInstance();
        }
        catch (Exception ex) {
            java.util.logging.Logger.getLogger(Nucleotide.class.getName()).log(Level.SEVERE, "Unable to initialize monomer factory", ex);
        }
        return this.getSugarMonomer(factory.getMonomerStore());
    }

    public Monomer getSugarMonomer(MonomerStore monomerStore) {
        String sugarSymbol = this.getSugarSymbol();
        if (sugarSymbol != null && !sugarSymbol.equalsIgnoreCase("")) {
            try {
                Map<String, Monomer> monomers = monomerStore.getMonomers("RNA");
                Monomer m = monomers.get(sugarSymbol);
                return m;
            }
            catch (Exception ex) {
                LOG.info("Unable to get sugar monomer for " + sugarSymbol);
                return null;
            }
        }
        return null;
    }

    public String getLinkerNotation() {
        String pSymbol = this.getPhosphateSymbol();
        String result = null;
        result = null == pSymbol || pSymbol.length() == 0 ? "" : (pSymbol.length() > 1 ? "[" + pSymbol + "]" : pSymbol);
        return result;
    }

    public String getNucleosideNotation() {
        int linkerLen = this.getLinkerNotation().length();
        return this.notation.substring(0, this.notation.length() - linkerLen);
    }

    private String getPhosphateSymbol() {
        String phosphateSymbol = null;
        String ncNotation = this.getNotation();
        if (ncNotation.contains("(")) {
            int start = ncNotation.indexOf(")");
            phosphateSymbol = ncNotation.substring(start + 1);
            phosphateSymbol = phosphateSymbol.replaceAll("\\[|\\]", "");
        } else if (this.getPositionType() == 3) {
            if (ncNotation.startsWith("[")) {
                phosphateSymbol = ncNotation.substring(ncNotation.indexOf("]") + 1);
                phosphateSymbol = phosphateSymbol.replaceAll("\\[|\\]", "");
            } else {
                phosphateSymbol = ncNotation.substring(1);
            }
        } else if (ncNotation.endsWith("]")) {
            char[] chars = ncNotation.toCharArray();
            for (int i = chars.length; i > 0; --i) {
                String letter = String.valueOf(chars[i - 1]);
                if (!letter.equals("[")) continue;
                phosphateSymbol = ncNotation.substring(i);
                phosphateSymbol = phosphateSymbol.replaceAll("\\[|\\]", "");
                break;
            }
        } else {
            int pos = ncNotation.length() - 1;
            phosphateSymbol = ncNotation.substring(pos);
        }
        return phosphateSymbol;
    }

    private String getSugarSymbol() {
        String sugarSymbol = null;
        String ncNotation = this.getNotation();
        if (ncNotation.contains("(")) {
            int start = ncNotation.indexOf("(");
            sugarSymbol = ncNotation.substring(0, start);
            sugarSymbol = sugarSymbol.replaceAll("\\[|\\]", "");
        } else if (this.getPositionType() == 1) {
            if (ncNotation.endsWith("]")) {
                char[] chars = ncNotation.toCharArray();
                for (int i = chars.length; i > 0; --i) {
                    String letter = String.valueOf(chars[i - 1]);
                    if (!letter.equals("[")) continue;
                    sugarSymbol = ncNotation.substring(0, i);
                    sugarSymbol = sugarSymbol.replaceAll("\\[|\\]", "");
                    break;
                }
            } else {
                sugarSymbol = ncNotation.substring(0, ncNotation.length() - 1);
                sugarSymbol = sugarSymbol.replaceAll("\\[|\\]", "");
            }
        } else if (ncNotation.startsWith("[")) {
            sugarSymbol = ncNotation.substring(0, ncNotation.indexOf("]"));
            sugarSymbol = sugarSymbol.replaceAll("\\[|\\]", "");
        } else {
            sugarSymbol = ncNotation.substring(0, 1);
        }
        return sugarSymbol;
    }

    private String getBaseSymbol() {
        String ncNotation = this.getNotation();
        if (!ncNotation.contains("(")) {
            return null;
        }
        int start = ncNotation.indexOf("(");
        int end = ncNotation.indexOf(")");
        String baseSymbol = ncNotation.substring(start + 1, end);
        baseSymbol = baseSymbol.replaceAll("\\[|\\]", "");
        return baseSymbol;
    }

    public static Nucleotide fromJSON(String json) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            Nucleotide nuc = (Nucleotide)mapper.readValue(json, Nucleotide.class);
            return nuc;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String toJSON() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            String jsonINString = mapper.writeValueAsString((Object)this);
            jsonINString = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this);
            return jsonINString;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

