/*
 * Decompiled with CFR 0.152.
 */
package org.helm.notation2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.helm.notation2.DeepCopy;
import org.helm.notation2.Monomer;
import org.helm.notation2.MonomerFactory;
import org.helm.notation2.exception.MonomerException;
import org.helm.notation2.tools.SMILES;

public class MonomerStore {
    private Map<String, Map<String, Monomer>> monomerDB;
    private Map<String, Monomer> smilesMonomerDB;

    public MonomerStore(Map<String, Map<String, Monomer>> monomerDB, Map<String, Monomer> smilesMonomerDB) {
        this.monomerDB = monomerDB;
        this.smilesMonomerDB = smilesMonomerDB;
    }

    public MonomerStore() {
        this.monomerDB = new TreeMap<String, Map<String, Monomer>>(String.CASE_INSENSITIVE_ORDER);
        this.smilesMonomerDB = new HashMap<String, Monomer>();
    }

    public Map<String, Map<String, Monomer>> getMonomerDB() {
        return this.monomerDB;
    }

    public Map<String, Monomer> getSmilesMonomerDB() {
        return this.smilesMonomerDB;
    }

    public void addMonomer(Monomer monomer) throws IOException, MonomerException {
        this.addMonomer(monomer, false);
    }

    public void addMonomer(Monomer monomer, boolean dbChanged) throws IOException, MonomerException {
        boolean hasSmilesString;
        Map<String, Monomer> monomerMap = this.monomerDB.get(monomer.getPolymerType());
        String polymerType = monomer.getPolymerType();
        String alternateId = monomer.getAlternateId();
        String smilesString = monomer.getCanSMILES();
        try {
            smilesString = SMILES.getUniqueExtendedSMILES(smilesString);
        }
        catch (Exception e) {
            smilesString = monomer.getCanSMILES();
        }
        boolean bl = hasSmilesString = smilesString != null && smilesString.length() > 0;
        if (null == monomerMap) {
            monomerMap = new TreeMap<String, Monomer>(String.CASE_INSENSITIVE_ORDER);
            this.monomerDB.put(polymerType, monomerMap);
        }
        Monomer copyMonomer = DeepCopy.copy(monomer);
        if (hasSmilesString) {
            copyMonomer.setCanSMILES(smilesString);
        }
        boolean alreadyAdded = false;
        alreadyAdded = monomerMap.containsKey(alternateId);
        if (!alreadyAdded) {
            boolean alreadyInSMILESMap;
            monomerMap.put(alternateId, copyMonomer);
            boolean bl2 = alreadyInSMILESMap = hasSmilesString && this.smilesMonomerDB.containsKey(smilesString);
            if (!alreadyInSMILESMap) {
                this.smilesMonomerDB.put(smilesString, copyMonomer);
            }
        }
        if (dbChanged) {
            MonomerFactory.setDBChanged(true);
        }
    }

    public boolean hasMonomer(String polymerType, String alternateId) {
        return this.monomerDB.get(polymerType) != null && this.getMonomer(polymerType, alternateId) != null;
    }

    public Monomer getMonomer(String polymerType, String alternateId) {
        Map<String, Monomer> map1 = this.monomerDB.get(polymerType);
        return this.monomerDB.get(polymerType).get(alternateId);
    }

    public Monomer getMonomer(String smiles) {
        return this.smilesMonomerDB.get(smiles);
    }

    public Map<String, Monomer> getMonomers(String polymerType) {
        return this.monomerDB.get(polymerType);
    }

    public synchronized void addNewMonomer(Monomer monomer) throws IOException, MonomerException {
        monomer.setNewMonomer(true);
        this.addMonomer(monomer, true);
    }

    public boolean isMonomerStoreEmpty() {
        return this.monomerDB == null || this.monomerDB.values() == null || this.monomerDB.values().size() == 0;
    }

    public synchronized void clearMonomers() {
        this.monomerDB.clear();
        this.smilesMonomerDB.clear();
    }

    public String toString() {
        String str = "";
        for (Map<String, Monomer> val : this.monomerDB.values()) {
            for (Monomer mon : val.values()) {
                str = str + mon.getAlternateId() + "(" + mon.getPolymerType() + "); ";
            }
            str = str + System.getProperty("line.separator");
        }
        return str;
    }

    public Set<String> getPolymerTypeSet() {
        return this.monomerDB.keySet();
    }

    public List<Monomer> getAllMonomersList() {
        ArrayList<Monomer> monomers = new ArrayList<Monomer>();
        for (String polymerType : this.getPolymerTypeSet()) {
            Map<String, Monomer> map = this.getMonomers(polymerType);
            monomers.addAll(map.values());
        }
        return monomers;
    }
}

