/*
 * Decompiled with CFR 0.152.
 */
package org.helm.notation2.wsadapter;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.TreeMap;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.util.EntityUtils;
import org.helm.notation2.wsadapter.MonomerStoreConfiguration;
import org.helm.notation2.wsadapter.WSAdapterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NucleotideWSLoader {
    private static final Logger LOG = LoggerFactory.getLogger(NucleotideWSLoader.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> loadNucleotideStore() throws IOException, URISyntaxException {
        Map<Object, Object> nucleotides = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        LOG.debug("Loading nucleotide store by Webservice Loader");
        LOG.debug(MonomerStoreConfiguration.getInstance().toString());
        try (CloseableHttpResponse response = null;){
            response = WSAdapterUtils.getResource(MonomerStoreConfiguration.getInstance().getWebserviceNucleotidesFullURL());
            LOG.debug(response.getStatusLine().toString());
            JsonFactory jsonf = new JsonFactory();
            InputStream instream = response.getEntity().getContent();
            JsonParser jsonParser = jsonf.createJsonParser(instream);
            nucleotides = this.deserializeNucleotideStore(jsonParser);
            LOG.debug(nucleotides.size() + " nucleotides loaded");
            EntityUtils.consume((HttpEntity)response.getEntity());
        }
        return nucleotides;
    }

    private Map<String, String> deserializeNucleotideStore(JsonParser parser) throws JsonParseException, IOException {
        TreeMap<String, String> nucleotides = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        String currentNucleotideSymbol = "";
        String currentNucleotideNotation = "";
        boolean foundSymbol = false;
        boolean foundNotation = false;
        parser.nextToken();
        while (parser.hasCurrentToken()) {
            String fieldName = parser.getCurrentName();
            if (fieldName != null) {
                switch (fieldName) {
                    case "symbol": {
                        parser.nextToken();
                        currentNucleotideSymbol = parser.getText();
                        foundSymbol = true;
                        break;
                    }
                    case "notation": {
                        parser.nextToken();
                        currentNucleotideNotation = parser.getText();
                        foundNotation = true;
                        break;
                    }
                }
                if (foundSymbol && foundNotation) {
                    nucleotides.put(currentNucleotideSymbol, currentNucleotideNotation);
                    foundNotation = false;
                    foundSymbol = false;
                }
            }
            parser.nextToken();
        }
        return nucleotides;
    }
}

