/*
 * Decompiled with CFR 0.152.
 */
package org.helm.notation2.wsadapter;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.NoSuchElementException;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.helm.notation2.Chemistry;

public class MonomerStoreConfiguration {
    private static final String CONFIG_FILE_PATH = System.getProperty("user.home") + System.getProperty("file.separator") + ".helm" + System.getProperty("file.separator") + "MonomerStoreConfig.properties";
    private static final String USE_WEBSERVICE = "use.webservice";
    private static final String UPDATE_AUTOMATIC = "update.automatic";
    private static final String WEBSERVICE_MONOMERS_URL = "webservice.monomers.url";
    private static final String WEBSERVICE_MONOMERS_PATH = "webservice.monomers.path";
    private static final String WEBSERVICE_MONOMERS_PUT_PATH = "webservice.monomers.put.path";
    private static final String WEBSERVICE_EDITOR_CATEGORIZATION_URL = "webservice.editor.categorization.url";
    private static final String WEBSERVICE_EDITOR_CATEGORIZATION_PATH = "webservice.editor.categorization.path";
    private static final String WEBSERVICE_NUCLEOTIDES_URL = "webservice.nucleotides.url";
    private static final String WEBSERVICE_NUCLEOTIDES_PATH = "webservice.nucleotides.path";
    private static final String WEBSERVICE_NUCLEOTIDES_PUT_PATH = "webservice.nucleotides.put.path";
    private static final String USE_EXTERNAL_MONOMERS = "use.external.monomers";
    private static final String EXTERNAL_MONOMERS_PATH = "external.monomers.path";
    private static final String USE_EXTERNAL_NUCLEOTIDES = "use.external.nucleotides";
    private static final String EXTERNAL_NUCLEOTIDES_PATH = "external.nucleotides.path";
    private static final String USE_EXTERNAL_ATTACHMENTS = "use.external.attachments";
    private static final String EXTERNAL_ATTACHMENTS_PATH = "external.attachments.path";
    private static MonomerStoreConfiguration _instance;
    private boolean isUseWebservice;
    private boolean isUpdateAutomatic;
    private boolean isUseExternalMonomers;
    private boolean isUseExternalNucleotides;
    private boolean isUseExternalAttachments;
    private String externalMonomersPath;
    private String externalNucleotidesPath;
    private String externalAttachmentsPath;
    private String webserviceMonomersURL;
    private String webserviceMonomersPath;
    private String webserviceMonomersPutPath;
    private String webserviceNucleotidesURL;
    private String webserviceNucleotidesPath;
    private String webserviceNucleotidesPutPath;
    private String webserviceEditorCategorizationURL;
    private String webserviceEditorCategorizationPath;

    private MonomerStoreConfiguration() {
        this.refresh();
    }

    private void resetConfigToDefault() {
        this.isUseWebservice = false;
        this.isUpdateAutomatic = true;
        this.isUseExternalMonomers = false;
        this.isUseExternalNucleotides = false;
        this.setUseExternalAttachments(false);
        this.webserviceMonomersURL = "";
        this.webserviceMonomersPath = "";
        this.webserviceMonomersPutPath = "";
        this.webserviceEditorCategorizationURL = "";
        this.webserviceEditorCategorizationPath = "";
        this.externalNucleotidesPath = "";
        this.externalMonomersPath = "";
        this.setExternalAttachmentsPath("");
    }

    public static MonomerStoreConfiguration getInstance() {
        if (_instance == null) {
            _instance = new MonomerStoreConfiguration();
        }
        return _instance;
    }

    public boolean isUseWebservice() {
        return this.isUseWebservice;
    }

    public boolean isUpdateAutomatic() {
        return this.isUpdateAutomatic;
    }

    public void setUpdateAutomatic(boolean isUpdateAutomatic) {
        this.isUpdateAutomatic = isUpdateAutomatic;
    }

    public String getWebserviceMonomersURL() {
        return this.webserviceMonomersURL;
    }

    public String getWebserviceMonomersPath() {
        return this.webserviceMonomersPath;
    }

    public String getWebserviceNucleotidesURL() {
        return this.webserviceNucleotidesURL;
    }

    public String getWebserviceNucleotidesPath() {
        return this.webserviceNucleotidesPath;
    }

    public String getWebserviceMonomersFullURL() {
        return this.webserviceMonomersURL + "/" + this.webserviceMonomersPath;
    }

    public String getWebserviceNucleotidesFullURL() {
        return this.webserviceNucleotidesURL + "/" + this.webserviceNucleotidesPath;
    }

    public String getWebserviceNucleotidesPutFullURL() {
        return this.webserviceNucleotidesURL + "/" + this.webserviceNucleotidesPutPath;
    }

    public String getWebserviceMonomersPutFullURL() {
        return this.webserviceMonomersURL + "/" + this.webserviceMonomersPutPath;
    }

    public String getWebserviceEditorCategorizationURL() {
        return this.webserviceEditorCategorizationURL;
    }

    public String getWebserviceEditorCategorizationPath() {
        return this.webserviceEditorCategorizationPath;
    }

    public String getWebserviceEditorCategorizationFullURL() {
        return this.webserviceEditorCategorizationURL + "/" + this.webserviceEditorCategorizationPath;
    }

    public boolean isUseExternalMonomers() {
        return this.isUseExternalMonomers;
    }

    public boolean isUseExternalNucleotides() {
        return this.isUseExternalNucleotides;
    }

    public String getExternalNucleotidesPath() {
        return this.externalNucleotidesPath;
    }

    public String getExternalMonomersPath() {
        return this.externalMonomersPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        File configFile = new File(CONFIG_FILE_PATH);
        if (!configFile.exists()) {
            BufferedWriter writer = null;
            BufferedReader reader = null;
            try {
                String line;
                configFile.createNewFile();
                InputStream in = Chemistry.class.getResourceAsStream("/org/helm/notation2/resources/MonomerStoreConfig.properties");
                reader = new BufferedReader(new InputStreamReader(in));
                writer = new BufferedWriter(new FileWriter(configFile));
                while ((line = reader.readLine()) != null) {
                    writer.write(line + System.getProperty("line.separator"));
                }
            }
            catch (Exception e) {
                this.resetConfigToDefault();
                e.printStackTrace();
            }
            finally {
                try {
                    if (writer != null) {
                        writer.close();
                    }
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        try {
            PropertiesConfiguration conf = new PropertiesConfiguration(CONFIG_FILE_PATH);
            this.isUseWebservice = conf.getBoolean(USE_WEBSERVICE);
            this.isUpdateAutomatic = conf.getBoolean(UPDATE_AUTOMATIC);
            this.webserviceMonomersURL = conf.getString(WEBSERVICE_MONOMERS_URL);
            this.webserviceMonomersPath = conf.getString(WEBSERVICE_MONOMERS_PATH);
            this.webserviceMonomersPutPath = conf.getString(WEBSERVICE_MONOMERS_PUT_PATH);
            this.webserviceNucleotidesURL = conf.getString(WEBSERVICE_NUCLEOTIDES_URL);
            this.webserviceNucleotidesPath = conf.getString(WEBSERVICE_NUCLEOTIDES_PATH);
            this.webserviceNucleotidesPutPath = conf.getString(WEBSERVICE_NUCLEOTIDES_PUT_PATH);
            this.webserviceEditorCategorizationURL = conf.getString(WEBSERVICE_EDITOR_CATEGORIZATION_URL);
            this.webserviceEditorCategorizationPath = conf.getString(WEBSERVICE_EDITOR_CATEGORIZATION_PATH);
            this.isUseExternalMonomers = conf.getBoolean(USE_EXTERNAL_MONOMERS);
            this.externalMonomersPath = conf.getString(EXTERNAL_MONOMERS_PATH);
            this.isUseExternalNucleotides = conf.getBoolean(USE_EXTERNAL_NUCLEOTIDES);
            this.externalNucleotidesPath = conf.getString(EXTERNAL_NUCLEOTIDES_PATH);
            this.isUseExternalAttachments = conf.getBoolean(USE_EXTERNAL_ATTACHMENTS);
            this.externalAttachmentsPath = conf.getString(EXTERNAL_ATTACHMENTS_PATH);
        }
        catch (NoSuchElementException | ConfigurationException e) {
            this.resetConfigToDefault();
            e.printStackTrace();
        }
    }

    public String toString() {
        String lineSep = System.getProperty("line.separator");
        String res = String.format("Webservice configuration:%sUse Webservice: %s%sUpdate Automatic: %s%sGetMonomers: %s%sPutMonomers: %s%sGetNucleotides: %s%sPutNucleotides: %s%sCategorization config: %s%sUse external monomer xml file: %s%sMonomer xml file: %s%sUse external nucleotide xml file: %s%sNucleotide xml file:%s", lineSep, this.isUseWebservice(), lineSep, this.isUpdateAutomatic(), lineSep, this.getWebserviceMonomersFullURL(), lineSep, this.getWebserviceMonomersPutFullURL(), lineSep, this.getWebserviceNucleotidesFullURL(), lineSep, this.getWebserviceNucleotidesPutFullURL(), lineSep, this.getWebserviceEditorCategorizationFullURL(), lineSep, this.isUseExternalMonomers(), lineSep, this.getExternalMonomersPath(), lineSep, this.isUseExternalNucleotides(), lineSep, this.getExternalNucleotidesPath());
        return res;
    }

    public String getExternalAttachmentsPath() {
        return this.externalAttachmentsPath;
    }

    public void setExternalAttachmentsPath(String externalAttachmentsPath) {
        this.externalAttachmentsPath = externalAttachmentsPath;
    }

    public boolean isUseExternalAttachments() {
        return this.isUseExternalAttachments;
    }

    public void setUseExternalAttachments(boolean isUseExternalAttachments) {
        this.isUseExternalAttachments = isUseExternalAttachments;
    }
}

