/*
 * Decompiled with CFR 0.152.
 */
package org.helm.notation2.tools;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.helm.chemtoolkit.AbstractMolecule;
import org.helm.chemtoolkit.CTKException;
import org.helm.chemtoolkit.IAtomBase;
import org.helm.chemtoolkit.IBondBase;
import org.helm.notation2.Attachment;
import org.helm.notation2.Chemistry;
import org.helm.notation2.Monomer;
import org.helm.notation2.MonomerFactory;
import org.helm.notation2.exception.ChemistryException;
import org.helm.notation2.exception.EncoderException;
import org.helm.notation2.exception.MonomerException;
import org.helm.notation2.tools.MolfileEncoder;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonomerParser {
    private static final Logger LOG = LoggerFactory.getLogger(MonomerParser.class);
    public static final String MONOMER_ELEMENT = "Monomer";
    public static final String MONOMER_ID_ELEMENT = "MonomerID";
    public static final String MONOMER_SMILES_ELEMENT = "MonomerSmiles";
    public static final String MONOMER_MOL_FILE_ELEMENT = "MonomerMolFile";
    public static final String MONOMER_TYPE_ELEMENT = "MonomerType";
    public static final String POLYMER_TYPE_ELEMENT = "PolymerType";
    public static final String NATURAL_ANALOG_ELEMENT = "NaturalAnalog";
    public static final String MONOMER_NAME_ELEMENT = "MonomerName";
    public static final String ATTACHEMENTS_LIST_ELEMENT = "AttachmentList";
    public static final String ATTACHEMENTS_ELEMENT = "Attachments";
    public static final String ATTACHEMENT_ELEMENT = "Attachment";
    public static final String ATTACHEMENT_ID_ELEMENT = "AttachmentID";
    public static final String ATTACHEMENT_LABEL_ELEMENT = "AttachmentLabel";
    public static final String CAP_GROUP_NAME_ELEMENT = "CapGroupName";
    public static final String CAP_GROUP_SMILES_ELEMENT = "CapGroupSmiles";
    private static List<String> polymerTypes = new ArrayList<String>();
    protected static final String SMILES_EXTENSION_SEPARATOR_REGEX = "\\|";

    public static Attachment getAttachment(Element attachment) {
        Namespace ns = attachment.getNamespace();
        Attachment att = new Attachment();
        att.setAlternateId(attachment.getChildText(ATTACHEMENT_ID_ELEMENT, ns));
        att.setLabel(attachment.getChildText(ATTACHEMENT_LABEL_ELEMENT, ns));
        att.setCapGroupName(attachment.getChildText(CAP_GROUP_NAME_ELEMENT, ns));
        att.setCapGroupSMILES(attachment.getChildText(CAP_GROUP_SMILES_ELEMENT, ns));
        return att;
    }

    public static Element getAttachementElement(Attachment att) {
        Element e;
        Element attachment = new Element(ATTACHEMENT_ELEMENT);
        if (null != att.getAlternateId() && att.getAlternateId().length() > 0) {
            e = new Element(ATTACHEMENT_ID_ELEMENT);
            e.setText(att.getAlternateId());
            attachment.getChildren().add(e);
        }
        if (null != att.getLabel() && att.getLabel().length() > 0) {
            e = new Element(ATTACHEMENT_LABEL_ELEMENT);
            e.setText(att.getLabel());
            attachment.getChildren().add(e);
        }
        if (null != att.getCapGroupName() && att.getCapGroupName().length() > 0) {
            e = new Element(CAP_GROUP_NAME_ELEMENT);
            e.setText(att.getCapGroupName());
            attachment.getChildren().add(e);
        }
        if (null != att.getCapGroupSMILES() && att.getCapGroupSMILES().length() > 0) {
            e = new Element(CAP_GROUP_SMILES_ELEMENT);
            e.setText(att.getCapGroupSMILES());
            attachment.getChildren().add(e);
        }
        return attachment;
    }

    public static boolean validateAttachement(Attachment attachment) throws MonomerException, IOException, ChemistryException {
        String alternateId = attachment.getAlternateId();
        if (null == alternateId) {
            throw new MonomerException("Attachment must have unique ID");
        }
        String smiles = attachment.getCapGroupSMILES();
        if (null != smiles) {
            if (!Chemistry.getInstance().getManipulator().validateSMILES(smiles)) {
                throw new MonomerException("Attachment cap group SMILES is invalid");
            }
            List<String> labels = MonomerParser.getAttachmentLabels(smiles);
            if (null == labels || labels.size() != 1) {
                throw new MonomerException("Attachment must have one R group in SMILES");
            }
            if (!labels.get(0).equals(attachment.getLabel())) {
                throw new MonomerException("R group in monomer SMILES and R group label must match");
            }
        }
        return true;
    }

    public static Monomer getMonomer(Element monomer) throws MonomerException {
        Monomer m = new Monomer();
        Namespace ns = monomer.getNamespace();
        m.setAlternateId(monomer.getChildText(MONOMER_ID_ELEMENT, ns));
        m.setCanSMILES(monomer.getChildText(MONOMER_SMILES_ELEMENT, ns));
        String encodedMolfile = monomer.getChildText(MONOMER_MOL_FILE_ELEMENT, ns);
        String molfile = null;
        try {
            molfile = MolfileEncoder.decode(encodedMolfile);
        }
        catch (EncoderException ex) {
            throw new MonomerException("Invalid monomer molfile");
        }
        m.setMolfile(molfile);
        m.setMonomerType(monomer.getChildText(MONOMER_TYPE_ELEMENT, ns));
        m.setPolymerType(monomer.getChildText(POLYMER_TYPE_ELEMENT, ns));
        m.setNaturalAnalog(monomer.getChildText(NATURAL_ANALOG_ELEMENT, ns));
        m.setName(monomer.getChildText(MONOMER_NAME_ELEMENT, ns));
        Element attachmentElement = monomer.getChild(ATTACHEMENTS_ELEMENT, ns);
        if (null != attachmentElement) {
            List attachments = attachmentElement.getChildren(ATTACHEMENT_ELEMENT, ns);
            ArrayList<Attachment> l = new ArrayList<Attachment>();
            for (Element attachment : attachments) {
                Attachment att = MonomerParser.getAttachment(attachment);
                l.add(att);
            }
            m.setAttachmentList(l);
        }
        return m;
    }

    public static Element getMonomerElement(Monomer monomer) throws MonomerException {
        List<Attachment> l;
        Element e;
        Element element = new Element(MONOMER_ELEMENT);
        if (null != monomer.getAlternateId()) {
            e = new Element(MONOMER_ID_ELEMENT);
            e.setText(monomer.getAlternateId());
            element.getChildren().add(e);
        }
        if (null != monomer.getCanSMILES()) {
            e = new Element(MONOMER_SMILES_ELEMENT);
            e.setText(monomer.getCanSMILES());
            element.getChildren().add(e);
        }
        if (null != monomer.getMolfile()) {
            e = new Element(MONOMER_MOL_FILE_ELEMENT);
            String encodedMolfile = null;
            try {
                encodedMolfile = MolfileEncoder.encode(monomer.getMolfile());
            }
            catch (EncoderException ex) {
                throw new MonomerException("Invalid monomer molfile");
            }
            e.setText(encodedMolfile);
            element.getChildren().add(e);
        }
        if (null != monomer.getMonomerType()) {
            e = new Element(MONOMER_TYPE_ELEMENT);
            e.setText(monomer.getMonomerType());
            element.getChildren().add(e);
        }
        if (null != monomer.getPolymerType()) {
            e = new Element(POLYMER_TYPE_ELEMENT);
            e.setText(monomer.getPolymerType());
            element.getChildren().add(e);
        }
        if (null != monomer.getNaturalAnalog()) {
            e = new Element(NATURAL_ANALOG_ELEMENT);
            e.setText(monomer.getNaturalAnalog());
            element.getChildren().add(e);
        }
        if (null != monomer.getName()) {
            e = new Element(MONOMER_NAME_ELEMENT);
            e.setText(monomer.getName());
            element.getChildren().add(e);
        }
        if (null != (l = monomer.getAttachmentList()) && l.size() > 0) {
            Element attachments = new Element(ATTACHEMENTS_ELEMENT);
            for (int i = 0; i < l.size(); ++i) {
                Attachment att = l.get(i);
                Element attachment = MonomerParser.getAttachementElement(att);
                attachments.getChildren().add(attachment);
            }
            element.getChildren().add(attachments);
        }
        return element;
    }

    public static List<Monomer> getMonomerList(String monomerXMLString) throws JDOMException, IOException, MonomerException, CTKException, ChemistryException {
        ArrayList<Monomer> l = new ArrayList<Monomer>();
        if (null != monomerXMLString && monomerXMLString.length() > 0) {
            SAXBuilder builder = new SAXBuilder();
            ByteArrayInputStream bais = new ByteArrayInputStream(monomerXMLString.getBytes());
            Document doc = builder.build((InputStream)bais);
            Element root = doc.getRootElement();
            List monomers = root.getChildren();
            for (Element monomer : monomers) {
                Monomer m = MonomerParser.getMonomer(monomer);
                if (!MonomerParser.validateMonomer(m)) continue;
                l.add(m);
            }
        }
        return l;
    }

    public static Monomer getMonomer(String monomerXMLString) throws JDOMException, IOException, MonomerException {
        Monomer m = null;
        if (monomerXMLString != null && monomerXMLString.length() > 0) {
            SAXBuilder builder = new SAXBuilder();
            ByteArrayInputStream bais = new ByteArrayInputStream(monomerXMLString.getBytes());
            Document doc = builder.build((InputStream)bais);
            Element root = doc.getRootElement();
            m = MonomerParser.getMonomer(root);
        }
        return m;
    }

    public static boolean validateMonomer(Monomer monomer) throws MonomerException, IOException, CTKException, ChemistryException {
        List<String> attachmentLabels;
        String alternateId;
        if (null == monomer) {
            throw new MonomerException("Monomer is null");
        }
        String polymerType = monomer.getPolymerType();
        if (null == polymerType) {
            throw new MonomerException("Monomer has no polymer type defined");
        }
        if (!polymerTypes.contains(polymerType)) {
            throw new MonomerException("Unknown polymer type '" + polymerType + "'");
        }
        String monomerType = monomer.getMonomerType();
        if (null == monomerType) {
            throw new MonomerException("Monomer has no monomer type defined");
        }
        if (polymerType.equals("CHEM")) {
            if (!monomerType.equals("Undefined")) {
                throw new MonomerException("Valid monomer type for chemical structures can only be 'Undefined'");
            }
        } else if (!monomerType.equals("Backbone") && !monomerType.equals("Branch")) {
            throw new MonomerException("Valid monomer type for simple polymer can only be 'Backbone' or 'Branch'");
        }
        if (null == (alternateId = monomer.getAlternateId()) || alternateId.length() == 0) {
            throw new MonomerException("Monomer has no monomerID defined");
        }
        String smiles = monomer.getCanSMILES();
        String molfile = monomer.getMolfile();
        List<Attachment> attachments = monomer.getAttachmentList();
        if (!(polymerType.equals("CHEM") || null != smiles && null != molfile && null != attachments && attachments.size() != 0)) {
            throw new MonomerException("Monomers for specific polymer type must have structure info");
        }
        String errorNote = alternateId + " (" + polymerType + ")";
        if (null != smiles && smiles.length() > 0) {
            int i;
            boolean validSmiles = Chemistry.getInstance().getManipulator().validateSMILES(smiles);
            if (!validSmiles) {
                throw new MonomerException("Monomer SMILES must be valid: " + errorNote);
            }
            attachmentLabels = MonomerParser.getAttachmentLabels(smiles);
            boolean unique = MonomerParser.areAttachmentLabelsUnique(attachmentLabels);
            if (!unique) {
                throw new MonomerException("Attachment labels on monomer must be unique: " + errorNote);
            }
            if (attachmentLabels.size() != attachments.size()) {
                throw new MonomerException("Attachment label number on monomer must match attachment number: " + errorNote);
            }
            for (i = 0; i < attachments.size(); ++i) {
                Attachment att = attachments.get(i);
                MonomerParser.validateAttachement(att);
            }
            for (i = 0; i < attachmentLabels.size(); ++i) {
                String label = attachmentLabels.get(i);
                boolean found = false;
                for (int j = 0; j < attachments.size(); ++j) {
                    Attachment att = attachments.get(j);
                    if (!att.getAlternateId().startsWith(label)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                throw new MonomerException("Attachment label in SMILES is not found in attachment list: " + errorNote);
            }
        }
        if (monomer.getAlternateId().length() > 0 && !monomer.getPolymerType().equals("CHEM")) {
            String naturalAnalog = monomer.getNaturalAnalog();
            if (null == naturalAnalog) {
                throw new MonomerException("Modified monomer must have natural analog defined: " + errorNote);
            }
            if (naturalAnalog.length() != 1) {
                throw new MonomerException("Natural analog must be single letter: " + errorNote);
            }
        }
        if (monomer.getAttachmentList() == null || monomer.getAttachmentList().size() == 0) {
            throw new MonomerException("Monomer must have at least one attachment: " + errorNote);
        }
        if (null != smiles && smiles.length() > 0) {
            AbstractMolecule molecule = Chemistry.getInstance().getManipulator().getMolecule(smiles, null);
            attachmentLabels = MonomerParser.getAttachmentLabels(smiles);
            for (int i = 0; i < attachmentLabels.size(); ++i) {
                String rgroupId = attachmentLabels.get(i).substring(1);
                IAtomBase atom = null;
                atom = molecule.getRGroupAtom(Integer.parseInt(rgroupId), true);
                if (atom == null) {
                    throw new MonomerException("Molecule does not contain the specified Rgroup");
                }
                if (atom.getIBondCount() != 1) {
                    throw new MonomerException("R group can only connect with one atom in monomer: " + errorNote);
                }
                IBondBase bond = atom.getIBond(0);
                if (bond.getType() == 1) continue;
                throw new MonomerException("R group can only connect with another atom via single bond in monomer: " + errorNote);
            }
        }
        return true;
    }

    private static List<String> getAttachmentLabels(String smiles) {
        String extendedSmiles = MonomerParser.getExtension(smiles);
        ArrayList<String> list = new ArrayList<String>();
        if (extendedSmiles != null) {
            Integer n;
            Integer currIndex = 0;
            char[] items = extendedSmiles.toCharArray();
            ArrayList<Integer> indexes = new ArrayList<Integer>();
            while (extendedSmiles.indexOf("_R", (int)currIndex) > 0) {
                currIndex = extendedSmiles.indexOf("_R", (int)currIndex);
                indexes.add(currIndex);
                Integer n2 = currIndex;
                n = currIndex = Integer.valueOf(currIndex + 1);
            }
            for (int k = 0; k < items.length; ++k) {
                if (items[k] != 'R') continue;
                indexes.add(currIndex + k);
                n = currIndex;
                Integer n3 = currIndex = Integer.valueOf(currIndex + 1);
            }
            String[] tokens = extendedSmiles.split("R", -1);
            if (tokens.length > 1) {
                for (int i = 1; i < tokens.length; ++i) {
                    String letter;
                    String token = tokens[i];
                    char[] chars = token.toCharArray();
                    String numbers = "";
                    for (int j = 0; j < chars.length && (letter = String.valueOf(chars[j])).matches("[0-9]"); ++j) {
                        numbers = numbers + letter;
                    }
                    if (numbers.length() <= 0) continue;
                    list.add("R" + numbers);
                }
            }
        }
        if (extendedSmiles == null) {
            Pattern pattern = Pattern.compile("\\[\\*:([1-9]\\d*)\\]|\\[\\w+:([1-9]\\d*)\\]");
            Matcher matcher = pattern.matcher(smiles);
            while (matcher.find()) {
                String replace = "";
                if (matcher.group(1) != null) {
                    replace = matcher.group(1);
                }
                if (matcher.group(2) != null) {
                    replace = matcher.group(2);
                }
                list.add("R" + replace);
            }
        }
        return list;
    }

    private static String getExtension(String smiles) {
        String result = null;
        try {
            String[] components = smiles.split(SMILES_EXTENSION_SEPARATOR_REGEX);
            result = components[1];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return result;
    }

    private static boolean areAttachmentLabelsUnique(List<String> labels) {
        TreeMap<String, String> map = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        for (int i = 0; i < labels.size(); ++i) {
            map.put(labels.get(i), labels.get(i));
        }
        return labels.size() == map.size();
    }

    public static void validateAttachmentLabel(String label) throws MonomerException {
        if (label.equalsIgnoreCase("pair")) {
            return;
        }
        char[] chars = label.toCharArray();
        if (!String.valueOf(chars[0]).equals("R")) {
            throw new MonomerException("Invalid Attachment Label format");
        }
        for (int i = 1; i < chars.length; ++i) {
            char c = chars[i];
            if (String.valueOf(c).matches("[0-9]")) continue;
            throw new MonomerException("Invalid Attachment Label format");
        }
    }

    public static void fillAttachmentInfo(Attachment att) throws MonomerException, IOException, JDOMException, ChemistryException, CTKException {
        Map<String, Attachment> attachmentMap = MonomerFactory.getInstance().getAttachmentDB();
        Attachment attach = attachmentMap.get(att.getAlternateId());
        att.setLabel(attach.getLabel());
        att.setCapGroupSMILES(attach.getCapGroupSMILES());
        att.setCapGroupName(attach.getCapGroupName());
    }

    static {
        polymerTypes = Arrays.asList(Monomer.SUPPORTED_POLYMER_TYPES);
    }
}

