/*
 * Decompiled with CFR 0.152.
 */
package org.helm.notation2.tools;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.helm.chemtoolkit.AbstractMolecule;
import org.helm.chemtoolkit.AttachmentList;
import org.helm.chemtoolkit.CTKException;
import org.helm.chemtoolkit.IAtomBase;
import org.helm.notation2.Attachment;
import org.helm.notation2.Chemistry;
import org.helm.notation2.Monomer;
import org.helm.notation2.RgroupStructure;
import org.helm.notation2.exception.BuilderMoleculeException;
import org.helm.notation2.exception.ChemistryException;
import org.helm.notation2.exception.HELM2HandledException;
import org.helm.notation2.parser.notation.connection.ConnectionNotation;
import org.helm.notation2.parser.notation.polymer.BlobEntity;
import org.helm.notation2.parser.notation.polymer.ChemEntity;
import org.helm.notation2.parser.notation.polymer.GroupEntity;
import org.helm.notation2.parser.notation.polymer.PeptideEntity;
import org.helm.notation2.parser.notation.polymer.PolymerNotation;
import org.helm.notation2.parser.notation.polymer.RNAEntity;
import org.helm.notation2.tools.MethodsMonomerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BuilderMolecule {
    private static final Logger LOG = LoggerFactory.getLogger(BuilderMolecule.class);

    private BuilderMolecule() {
    }

    public static RgroupStructure buildMoleculefromSinglePolymer(PolymerNotation polymernotation) throws BuilderMoleculeException, HELM2HandledException, ChemistryException {
        LOG.info("Build molecule for single Polymer " + polymernotation.getPolymerID().getId());
        if (polymernotation.getPolymerID() instanceof BlobEntity) {
            LOG.error("Molecule can't be build for BLOB");
            throw new BuilderMoleculeException("Molecule can't be build for BLOB");
        }
        if (polymernotation.getPolymerID() instanceof ChemEntity) {
            List<Monomer> validMonomers = MethodsMonomerUtils.getListOfHandledMonomers(polymernotation.getPolymerElements().getListOfElements());
            return BuilderMolecule.buildMoleculefromCHEM(polymernotation.getPolymerID().getId(), validMonomers);
        }
        if (polymernotation.getPolymerID() instanceof RNAEntity || polymernotation.getPolymerID() instanceof PeptideEntity) {
            List<Monomer> validMonomers = MethodsMonomerUtils.getListOfHandledMonomers(polymernotation.getPolymerElements().getListOfElements());
            return BuilderMolecule.buildMoleculefromPeptideOrRNA(polymernotation.getPolymerID().getId(), validMonomers);
        }
        LOG.error("Molecule can't be build for unknown polymer type");
        throw new BuilderMoleculeException("Molecule can't be build for unknown polymer type");
    }

    public static List<AbstractMolecule> buildMoleculefromPolymers(List<PolymerNotation> polymers, List<ConnectionNotation> connections) throws BuilderMoleculeException, ChemistryException {
        LOG.info("Building process for the all polymers is starting");
        HashMap<String, PolymerNotation> map = new HashMap<String, PolymerNotation>();
        HashMap<String, RgroupStructure> mapMolecules = new HashMap<String, RgroupStructure>();
        HashMap<String, String> mapConnections = new HashMap<String, String>();
        HashMap<String, Map> mapIAtomBase = new HashMap<String, Map>();
        ArrayList<AbstractMolecule> listMolecules = new ArrayList<AbstractMolecule>();
        RgroupStructure current = new RgroupStructure();
        AbstractMolecule molecule = null;
        LOG.info("Build for each polymer a single molecule");
        for (PolymerNotation polymerNotation : polymers) {
            map.put(polymerNotation.getPolymerID().getId(), polymerNotation);
            try {
                current = BuilderMolecule.buildMoleculefromSinglePolymer(polymerNotation);
                mapMolecules.put(polymerNotation.getPolymerID().getId(), current);
                mapIAtomBase.put(polymerNotation.getPolymerID().getId(), current.getMolecule().getRgroups());
            }
            catch (CTKException | HELM2HandledException e) {
                throw new BuilderMoleculeException(e.getMessage());
            }
        }
        LOG.info("Connect the single molecules together");
        for (ConnectionNotation connectionNotation : connections) {
            int target;
            int source;
            LOG.info("Connection: " + connectionNotation.toString());
            if (connectionNotation.getSourceId() instanceof GroupEntity || connectionNotation.getTargetId() instanceof GroupEntity) {
                LOG.error("Molecule can't be build for group connection");
                throw new BuilderMoleculeException("Molecule can't be build for group connection");
            }
            String idFirst = connectionNotation.getSourceId().getId();
            String idSecond = connectionNotation.getTargetId().getId();
            if (mapMolecules.get(idFirst) == null) {
                idFirst = (String)mapConnections.get(idFirst);
            }
            if (mapMolecules.get(idSecond) == null) {
                idSecond = (String)mapConnections.get(idSecond);
            }
            RgroupStructure one = (RgroupStructure)mapMolecules.get(idFirst);
            RgroupStructure two = (RgroupStructure)mapMolecules.get(idSecond);
            mapMolecules.remove(idFirst);
            mapMolecules.remove(idSecond);
            try {
                source = Integer.parseInt(connectionNotation.getSourceUnit());
                target = Integer.parseInt(connectionNotation.getTargetUnit());
            }
            catch (NumberFormatException e) {
                throw new BuilderMoleculeException("Connection has to be unambiguous");
            }
            if (connectionNotation.getrGroupSource().equals("?") || connectionNotation.getrGroupTarget().equals("?")) {
                throw new BuilderMoleculeException("Connection's R groups have to be known");
            }
            String rgroupOne = connectionNotation.getrGroupSource();
            String rgroupTwo = connectionNotation.getrGroupTarget();
            if (idFirst.equals(idSecond)) {
                try {
                    LOG.debug("Self-cycle connection: " + connectionNotation.toString());
                    molecule = Chemistry.getInstance().getManipulator().merge(one.getMolecule(), one.getRgroupMap().get(connectionNotation.getSourceId().getId() + ":" + source + ":" + rgroupOne), one.getMolecule(), one.getRgroupMap().get(connectionNotation.getTargetId().getId() + ":" + target + ":" + rgroupTwo));
                    one.getRgroupMap().remove(connectionNotation.getSourceId().getId() + ":" + source + ":" + rgroupOne);
                    one.getRgroupMap().remove(connectionNotation.getSourceId().getId() + ":" + source + ":" + rgroupTwo);
                    mapMolecules.put(idFirst, one);
                    continue;
                }
                catch (CTKException e) {
                    throw new BuilderMoleculeException(e.getMessage());
                }
            }
            try {
                LOG.info("MERGE");
                molecule = Chemistry.getInstance().getManipulator().merge(one.getMolecule(), one.getRgroupMap().get(connectionNotation.getSourceId().getId() + ":" + source + ":" + rgroupOne), two.getMolecule(), two.getRgroupMap().get(connectionNotation.getTargetId().getId() + ":" + target + ":" + rgroupTwo));
                LOG.info("Merge completed");
                RgroupStructure actual = new RgroupStructure();
                actual.setMolecule(molecule);
                HashMap<String, IAtomBase> rgroupMap = new HashMap<String, IAtomBase>();
                one.getRgroupMap().remove(connectionNotation.getSourceId().getId() + ":" + source + ":" + rgroupOne);
                two.getRgroupMap().remove(connectionNotation.getTargetId().getId() + ":" + target + ":" + rgroupTwo);
                rgroupMap.putAll(one.getRgroupMap());
                rgroupMap.putAll(two.getRgroupMap());
                actual.setRgroupMap(rgroupMap);
                mapMolecules.put(idFirst + idSecond, actual);
            }
            catch (CTKException e) {
                throw new BuilderMoleculeException(e.getMessage());
            }
            mapConnections.put(connectionNotation.getSourceId().getId(), idFirst + idSecond);
            mapConnections.put(connectionNotation.getTargetId().getId(), idFirst + idSecond);
            for (Map.Entry e : mapConnections.entrySet()) {
                if (!e.getValue().equals(idFirst) && !e.getValue().equals(idSecond)) continue;
                mapConnections.put((String)e.getKey(), idFirst + idSecond);
            }
        }
        for (Map.Entry entry : mapMolecules.entrySet()) {
            listMolecules.add(((RgroupStructure)entry.getValue()).getMolecule());
        }
        return listMolecules;
    }

    private static RgroupStructure buildMoleculefromCHEM(String id, List<Monomer> validMonomers) throws BuilderMoleculeException, ChemistryException {
        LOG.info("Build molecule for chemical component");
        if (validMonomers.size() == 1) {
            try {
                Monomer monomer = validMonomers.get(0);
                String input = BuilderMolecule.getInput(monomer);
                if (input != null) {
                    List<Attachment> listAttachments = monomer.getAttachmentList();
                    AttachmentList list = new AttachmentList();
                    for (Attachment attachment : listAttachments) {
                        list.add((Object)new org.helm.chemtoolkit.Attachment(attachment.getAlternateId(), attachment.getLabel(), attachment.getCapGroupName(), attachment.getCapGroupSMILES()));
                    }
                    AbstractMolecule molecule = Chemistry.getInstance().getManipulator().getMolecule(input, list);
                    RgroupStructure result = new RgroupStructure();
                    result.setMolecule(molecule);
                    result.setRgroupMap(BuilderMolecule.generateRgroupMap(id + ":" + "1", molecule));
                    return result;
                }
                LOG.error("Chemical molecule should have canonical smiles");
                throw new BuilderMoleculeException("Chemical molecule should have canoncial smiles");
            }
            catch (NullPointerException ex) {
                throw new BuilderMoleculeException("Monomer is not stored in the monomer database");
            }
            catch (IOException | CTKException e) {
                LOG.error("Molecule can't be built " + e.getMessage());
                throw new BuilderMoleculeException("Molecule can't be built " + e.getMessage());
            }
        }
        LOG.error("Chemical molecule should contain exactly one monomer");
        throw new BuilderMoleculeException("Chemical molecule should contain exactly one monomer");
    }

    private static Map<String, IAtomBase> generateRgroupMap(String detail, AbstractMolecule molecule) throws CTKException {
        HashMap<String, IAtomBase> rgroupMap = new HashMap<String, IAtomBase>();
        for (Map.Entry e : molecule.getRgroups().entrySet()) {
            rgroupMap.put(detail + ":" + (String)e.getKey(), (IAtomBase)e.getValue());
        }
        return rgroupMap;
    }

    private static RgroupStructure buildMoleculefromPeptideOrRNA(String id, List<Monomer> validMonomers) throws BuilderMoleculeException, ChemistryException {
        try {
            String input = null;
            AbstractMolecule currentMolecule = null;
            input = BuilderMolecule.getInput(validMonomers.get(0));
            AbstractMolecule prevMolecule = Chemistry.getInstance().getManipulator().getMolecule(input, BuilderMolecule.generateAttachmentList(validMonomers.get(0).getAttachmentList()));
            AbstractMolecule firstMolecule = null;
            Monomer prevMonomer = null;
            RgroupStructure first = new RgroupStructure();
            RgroupStructure current = new RgroupStructure();
            int prev = 1;
            if (validMonomers.size() == 0 || validMonomers == null) {
                LOG.error("Polymer (Peptide/RNA) has no contents");
                throw new BuilderMoleculeException("Polymer (Peptide/RNA) has no contents");
            }
            int i = 0;
            for (Monomer currentMonomer : validMonomers) {
                LOG.debug("Monomer " + currentMonomer.getAlternateId());
                ++i;
                if (prevMonomer != null) {
                    HashMap<String, IAtomBase> map;
                    input = BuilderMolecule.getInput(currentMonomer);
                    currentMolecule = Chemistry.getInstance().getManipulator().getMolecule(input, BuilderMolecule.generateAttachmentList(currentMonomer.getAttachmentList()));
                    current.setMolecule(currentMolecule);
                    current.setRgroupMap(BuilderMolecule.generateRgroupMap(id + ":" + String.valueOf(i), currentMolecule));
                    if (currentMonomer.getMonomerType().equals("Backbone")) {
                        prevMolecule = Chemistry.getInstance().getManipulator().merge(first.getMolecule(), first.getRgroupMap().get(id + ":" + prev + ":R2"), current.getMolecule(), current.getRgroupMap().get(id + ":" + i + ":R1"));
                        first.getRgroupMap().remove(id + ":" + prev + ":R2");
                        current.getRgroupMap().remove(id + ":" + i + ":R1");
                        first.setMolecule(prevMolecule);
                        map = new HashMap<String, IAtomBase>();
                        map.putAll(first.getRgroupMap());
                        map.putAll(current.getRgroupMap());
                        first.setRgroupMap(map);
                        prev = i;
                        continue;
                    }
                    if (currentMonomer.getMonomerType().equals("Branch")) {
                        prevMolecule = Chemistry.getInstance().getManipulator().merge(first.getMolecule(), first.getRgroupMap().get(id + ":" + prev + ":R3"), current.getMolecule(), current.getRgroupMap().get(id + ":" + i + ":R1"));
                        first.getRgroupMap().remove(id + ":" + prev + ":R3");
                        current.getRgroupMap().remove(id + ":" + i + ":R1");
                        first.setMolecule(prevMolecule);
                        map = new HashMap();
                        map.putAll(first.getRgroupMap());
                        map.putAll(current.getRgroupMap());
                        first.setRgroupMap(map);
                        continue;
                    }
                    LOG.error("Intra connection is unknown");
                    throw new BuilderMoleculeException("Intra connection is unknown");
                }
                prevMonomer = currentMonomer;
                input = BuilderMolecule.getInput(prevMonomer);
                firstMolecule = prevMolecule = Chemistry.getInstance().getManipulator().getMolecule(input, BuilderMolecule.generateAttachmentList(prevMonomer.getAttachmentList()));
                first.setMolecule(firstMolecule);
                first.setRgroupMap(BuilderMolecule.generateRgroupMap(id + ":" + String.valueOf(i), firstMolecule));
            }
            LOG.debug(first.getRgroupMap().keySet().toString());
            return first;
        }
        catch (IOException | CTKException e) {
            LOG.error("Polymer(Peptide/RNA) molecule can't be built " + e.getMessage());
            throw new BuilderMoleculeException("Polymer(Peptide/RNA) molecule can't be built " + e.getMessage());
        }
    }

    private static AttachmentList generateAttachmentList(List<Attachment> listAttachments) {
        AttachmentList list = new AttachmentList();
        for (Attachment attachment : listAttachments) {
            list.add((Object)new org.helm.chemtoolkit.Attachment(attachment.getAlternateId(), attachment.getLabel(), attachment.getCapGroupName(), attachment.getCapGroupSMILES()));
        }
        return list;
    }

    public static AbstractMolecule mergeRgroups(AbstractMolecule molecule) throws BuilderMoleculeException, ChemistryException {
        try {
            boolean flag = true;
            for (int i = molecule.getAttachments().size() - 1; i > -1; --i) {
                org.helm.chemtoolkit.Attachment attachment = molecule.getAttachments().get(i);
                int groupId = AbstractMolecule.getIdFromLabel((String)attachment.getLabel());
                AbstractMolecule rMol = Chemistry.getInstance().getManipulator().getMolecule(attachment.getSmiles(), null);
                molecule = Chemistry.getInstance().getManipulator().merge(molecule, molecule.getRGroupAtom(groupId, true), rMol, rMol.getRGroupAtom(groupId, true));
            }
            return molecule;
        }
        catch (IOException | NullPointerException | CTKException e) {
            throw new BuilderMoleculeException("Unused rgroups can't be merged into the molecule" + e.getMessage());
        }
    }

    public static AbstractMolecule getMoleculeForMonomer(Monomer monomer) throws BuilderMoleculeException, ChemistryException {
        String input = BuilderMolecule.getInput(monomer);
        if (input != null) {
            List<Attachment> listAttachments = monomer.getAttachmentList();
            AttachmentList list = new AttachmentList();
            for (Attachment attachment : listAttachments) {
                list.add((Object)new org.helm.chemtoolkit.Attachment(attachment.getAlternateId(), attachment.getLabel(), attachment.getCapGroupName(), attachment.getCapGroupSMILES()));
            }
            try {
                return Chemistry.getInstance().getManipulator().getMolecule(input, list);
            }
            catch (IOException | CTKException e) {
                throw new BuilderMoleculeException("Molecule can't be built for the given monomer");
            }
        }
        return null;
    }

    public static AbstractMolecule getMolecule(String smiles) throws IOException, CTKException, ChemistryException {
        return Chemistry.getInstance().getManipulator().getMolecule(smiles, null);
    }

    private static String getInput(Monomer monomer) {
        String input = null;
        if (monomer.getMolfile() != null) {
            LOG.info("Use molfile for monomer generation");
            input = monomer.getMolfile();
        }
        if (input == null && monomer.getCanSMILES() != null) {
            LOG.info("Use smiles for monomer generation " + monomer.getCanSMILES());
            input = monomer.getCanSMILES();
        }
        return input;
    }
}

