/*
 * Decompiled with CFR 0.152.
 */
package org.helm.notation2.calculation;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.helm.chemtoolkit.AbstractMolecule;
import org.helm.chemtoolkit.CTKException;
import org.helm.notation2.Chemistry;
import org.helm.notation2.MoleculeProperty;
import org.helm.notation2.calculation.ExtinctionCoefficient;
import org.helm.notation2.exception.BuilderMoleculeException;
import org.helm.notation2.exception.ChemistryException;
import org.helm.notation2.exception.ExtinctionCoefficientException;
import org.helm.notation2.parser.notation.HELM2Notation;
import org.helm.notation2.tools.BuilderMolecule;
import org.helm.notation2.tools.HELM2NotationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MoleculePropertyCalculator {
    private static final Logger LOG = LoggerFactory.getLogger(MoleculePropertyCalculator.class);

    private MoleculePropertyCalculator() {
    }

    private static List<AbstractMolecule> buildMolecule(HELM2Notation helm2notation) throws BuilderMoleculeException, ChemistryException {
        return BuilderMolecule.buildMoleculefromPolymers(helm2notation.getListOfPolymers(), HELM2NotationUtils.getAllEdgeConnections(helm2notation.getListOfConnections()));
    }

    public static double getMolecularWeight(HELM2Notation helm2notation) throws BuilderMoleculeException, CTKException, ChemistryException {
        List<AbstractMolecule> molecules = MoleculePropertyCalculator.buildMolecule(helm2notation);
        return MoleculePropertyCalculator.calculateMolecularWeight(molecules);
    }

    private static double calculateMolecularWeight(List<AbstractMolecule> molecules) throws BuilderMoleculeException, CTKException, ChemistryException {
        Double result = 0.0;
        for (AbstractMolecule molecule : molecules) {
            molecule = BuilderMolecule.mergeRgroups(molecule);
            result = result + Chemistry.getInstance().getManipulator().getMoleculeInfo(molecule).getMolecularWeight();
        }
        return result;
    }

    public static double getExactMass(HELM2Notation helm2notation) throws BuilderMoleculeException, CTKException, ChemistryException {
        List<AbstractMolecule> molecules = MoleculePropertyCalculator.buildMolecule(helm2notation);
        return MoleculePropertyCalculator.calculateExactMass(molecules);
    }

    private static double calculateExactMass(List<AbstractMolecule> molecules) throws CTKException, ChemistryException, BuilderMoleculeException {
        Double result = 0.0;
        for (AbstractMolecule molecule : molecules) {
            molecule = BuilderMolecule.mergeRgroups(molecule);
            result = result + Chemistry.getInstance().getManipulator().getMoleculeInfo(molecule).getExactMass();
        }
        return result;
    }

    public static String getMolecularFormular(HELM2Notation helm2notation) throws BuilderMoleculeException, CTKException, ChemistryException {
        List<AbstractMolecule> molecules = MoleculePropertyCalculator.buildMolecule(helm2notation);
        LOG.info("Build process is finished");
        return MoleculePropertyCalculator.calculateMolecularFormula(molecules);
    }

    private static String calculateMolecularFormula(List<AbstractMolecule> molecules) throws BuilderMoleculeException, CTKException, ChemistryException {
        Map<String, Integer> atomNumberMap = new TreeMap<String, Integer>();
        for (AbstractMolecule molecule : molecules) {
            LOG.info(molecule.getMolecule().toString());
            atomNumberMap = MoleculePropertyCalculator.generateAtomNumberMap(molecule, atomNumberMap);
        }
        LOG.info("GET map");
        StringBuilder sb = new StringBuilder();
        Set atoms = atomNumberMap.keySet();
        for (String atom : atoms) {
            String num = atomNumberMap.get(atom).toString();
            if (num.equals("1")) {
                num = "";
            }
            sb.append(atom);
            sb.append(num.toString());
        }
        return sb.toString();
    }

    public static MoleculeProperty getMoleculeProperties(HELM2Notation helm2notation) throws BuilderMoleculeException, CTKException, ExtinctionCoefficientException, ChemistryException {
        MoleculeProperty result = new MoleculeProperty();
        List<AbstractMolecule> molecules = MoleculePropertyCalculator.buildMolecule(helm2notation);
        result.setMolecularFormula(MoleculePropertyCalculator.calculateMolecularFormula(molecules));
        result.setMolecularWeight(MoleculePropertyCalculator.calculateMolecularWeight(molecules));
        result.setExactMass(MoleculePropertyCalculator.calculateExactMass(molecules));
        result.setExtinctionCoefficient(ExtinctionCoefficient.getInstance().calculate(helm2notation));
        return result;
    }

    private static Map<String, Integer> generateAtomNumberMap(AbstractMolecule molecule, Map<String, Integer> mapAtoms) throws BuilderMoleculeException, CTKException, ChemistryException {
        molecule = BuilderMolecule.mergeRgroups(molecule);
        LOG.info("Merge group is finished");
        String formula = Chemistry.getInstance().getManipulator().getMoleculeInfo(molecule).getMolecularFormula();
        String atom = "";
        String number = "";
        for (int i = 0; i < formula.length(); ++i) {
            String oneChar = String.valueOf(formula.charAt(i));
            if (oneChar.matches("[A-Z]")) {
                if (atom.length() == 0) {
                    atom = oneChar;
                    continue;
                }
                if (number == "") {
                    number = "1";
                }
                if (mapAtoms.get(atom) != null) {
                    mapAtoms.put(atom, mapAtoms.get(atom) + Integer.valueOf(number));
                } else {
                    mapAtoms.put(atom, Integer.valueOf(number));
                }
                atom = oneChar;
                number = "";
                continue;
            }
            if (oneChar.matches("[a-z]")) {
                if (atom.length() <= 0) continue;
                atom = atom + oneChar;
                continue;
            }
            number = number.length() == 0 ? oneChar : number + oneChar;
        }
        if (number == "") {
            number = "1";
        }
        if (mapAtoms.get(atom) != null) {
            mapAtoms.put(atom, mapAtoms.get(atom) + Integer.valueOf(number));
        } else {
            mapAtoms.put(atom, Integer.valueOf(number));
        }
        return mapAtoms;
    }
}

