/*
 * Decompiled with CFR 0.152.
 */
package org.helm.notation2;

import org.helm.notation2.tools.NucleotideParser;

public class SimpleNotationGroupIterator {
    protected char[] characters;
    protected String notationString;
    protected int position;

    public SimpleNotationGroupIterator(String notationString) {
        this.characters = notationString.toCharArray();
        this.notationString = notationString;
        this.position = 0;
    }

    public boolean hasNextGroup() {
        return this.position < this.characters.length;
    }

    public String nextGroup() {
        int currentPosition = this.position;
        do {
            char currentCharacter;
            if ((currentCharacter = this.characters[currentPosition]) == '[') {
                currentPosition = NucleotideParser.getMatchingBracketPosition(this.characters, currentPosition, '[', ']');
            } else if (currentCharacter == '(') {
                currentPosition = NucleotideParser.getMatchingBracketPosition(this.characters, currentPosition, '(', ')');
            } else if (currentCharacter != '.') {
                ++currentPosition;
            }
            if (currentPosition >= 0) continue;
            currentPosition = this.characters.length;
        } while (currentPosition < this.characters.length && this.characters[currentPosition] != '.');
        String token = this.notationString.substring(this.position, currentPosition);
        this.position = currentPosition + 1;
        return token;
    }
}

