/*
 * Decompiled with CFR 0.152.
 */
package org.helm.notation2.wsadapter;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WSAdapterUtils {
    private static final Logger LOG = LoggerFactory.getLogger(WSAdapterUtils.class);

    private WSAdapterUtils() {
    }

    protected static CloseableHttpResponse putResource(String json, String fullURL) throws ClientProtocolException, IOException, URISyntaxException {
        try (CloseableHttpClient httpclient = HttpClients.createDefault();){
            HttpPut httpput = new HttpPut(new URIBuilder(fullURL).build());
            httpput.setHeader("Content-Type", "application/json;charset=UTF-8");
            httpput.setEntity((HttpEntity)new StringEntity(json, "UTF-8"));
            LOG.debug("Executing request " + httpput.getRequestLine());
            CloseableHttpResponse closeableHttpResponse = httpclient.execute((HttpUriRequest)httpput);
            return closeableHttpResponse;
        }
    }

    protected static CloseableHttpResponse getResource(String fullURL) throws IOException, URISyntaxException {
        URI uri = new URIBuilder(fullURL).build();
        try (CloseableHttpClient httpclient = HttpClients.createDefault();){
            HttpGet httpget = new HttpGet(uri);
            LOG.debug("Executing request " + httpget.getRequestLine());
            CloseableHttpResponse closeableHttpResponse = httpclient.execute((HttpUriRequest)httpget);
            return closeableHttpResponse;
        }
    }
}

