/*
 * Decompiled with CFR 0.152.
 */
package org.helm.notation2.tools;

import java.util.List;
import org.helm.notation2.Monomer;
import org.helm.notation2.exception.ChemistryException;
import org.helm.notation2.exception.HELM2HandledException;
import org.helm.notation2.exception.PeptideUtilsException;
import org.helm.notation2.parser.notation.polymer.PeptideEntity;
import org.helm.notation2.parser.notation.polymer.PolymerNotation;
import org.helm.notation2.tools.FastaFormat;
import org.helm.notation2.tools.MethodsMonomerUtils;

public final class PeptideUtils {
    private PeptideUtils() {
    }

    public static String getNaturalAnalogueSequence(PolymerNotation polymer) throws HELM2HandledException, PeptideUtilsException, ChemistryException {
        PeptideUtils.checkPeptidePolymer(polymer);
        return FastaFormat.generateFastaFromPeptide(MethodsMonomerUtils.getListOfHandledMonomers(polymer.getListMonomers()));
    }

    public static String getSequence(PolymerNotation polymer) throws HELM2HandledException, PeptideUtilsException, ChemistryException {
        PeptideUtils.checkPeptidePolymer(polymer);
        StringBuilder sb = new StringBuilder();
        List<Monomer> monomers = MethodsMonomerUtils.getListOfHandledMonomers(polymer.getListMonomers());
        for (Monomer monomer : monomers) {
            String id = monomer.getAlternateId();
            if (id.length() > 1) {
                id = "[" + id + "]";
            }
            sb.append(id);
        }
        return sb.toString();
    }

    private static void checkPeptidePolymer(PolymerNotation polymer) throws PeptideUtilsException {
        if (!(polymer.getPolymerID() instanceof PeptideEntity)) {
            throw new PeptideUtilsException("Polymer is not a peptide");
        }
    }
}

