/*
 * Decompiled with CFR 0.152.
 */
package org.helm.notation2.tools;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.helm.chemtoolkit.CTKException;
import org.helm.notation2.Monomer;
import org.helm.notation2.MonomerFactory;
import org.helm.notation2.Nucleotide;
import org.helm.notation2.NucleotideFactory;
import org.helm.notation2.exception.AnalogSequenceException;
import org.helm.notation2.exception.ChemistryException;
import org.helm.notation2.exception.FastaFormatException;
import org.helm.notation2.exception.HELM2HandledException;
import org.helm.notation2.exception.MonomerException;
import org.helm.notation2.exception.NotationException;
import org.helm.notation2.exception.NucleotideLoadingException;
import org.helm.notation2.parser.notation.HELM2Notation;
import org.helm.notation2.parser.notation.polymer.HELMEntity;
import org.helm.notation2.parser.notation.polymer.MonomerNotation;
import org.helm.notation2.parser.notation.polymer.MonomerNotationGroup;
import org.helm.notation2.parser.notation.polymer.MonomerNotationGroupElement;
import org.helm.notation2.parser.notation.polymer.MonomerNotationGroupMixture;
import org.helm.notation2.parser.notation.polymer.MonomerNotationGroupOr;
import org.helm.notation2.parser.notation.polymer.MonomerNotationList;
import org.helm.notation2.parser.notation.polymer.MonomerNotationUnit;
import org.helm.notation2.parser.notation.polymer.MonomerNotationUnitRNA;
import org.helm.notation2.parser.notation.polymer.PeptideEntity;
import org.helm.notation2.parser.notation.polymer.PolymerElements;
import org.helm.notation2.parser.notation.polymer.PolymerListElements;
import org.helm.notation2.parser.notation.polymer.PolymerNotation;
import org.helm.notation2.parser.notation.polymer.RNAEntity;
import org.helm.notation2.tools.AminoAcidParser;
import org.helm.notation2.tools.MethodsMonomerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FastaFormat {
    private static HELM2Notation helm2notation = null;
    private static final Logger LOG = LoggerFactory.getLogger(FastaFormat.class);
    private static Map<String, String> nucleotides = null;
    private static Map<String, String> transformNucleotides = null;
    private static Map<String, Monomer> nucleotidesNaturalAnalog = null;
    private static Map<String, Monomer> aminoacids = null;

    private FastaFormat() {
    }

    public static HELM2Notation generatePeptidePolymersFromFASTAFormatHELM1(String fasta) throws FastaFormatException, ChemistryException {
        PolymerNotation polymer;
        helm2notation = new HELM2Notation();
        if (null == fasta) {
            LOG.error("Peptide Sequence must be specified");
            throw new FastaFormatException("Peptide Sequence must be specified");
        }
        FastaFormat.initMapAminoAcid();
        StringBuilder elements = new StringBuilder();
        int counter = 0;
        try {
            polymer = new PolymerNotation("PEPTIDE1");
        }
        catch (org.helm.notation2.parser.exceptionparser.NotationException e) {
            e.printStackTrace();
            throw new FastaFormatException(e.getMessage());
        }
        String annotation = "";
        for (String line : fasta.split("\n")) {
            if (line.startsWith(">")) {
                if (++counter > 1) {
                    helm2notation.addPolymer(new PolymerNotation(polymer.getPolymerID(), (PolymerElements)FastaFormat.generateElementsOfPeptide(elements.toString(), (HELMEntity)polymer.getPolymerID()), annotation));
                    elements = new StringBuilder();
                    try {
                        polymer = new PolymerNotation("PEPTIDE" + counter);
                    }
                    catch (org.helm.notation2.parser.exceptionparser.NotationException e) {
                        e.printStackTrace();
                        throw new FastaFormatException(e.getMessage());
                    }
                }
                annotation = line.substring(1);
                continue;
            }
            line = FastaFormat.cleanup(line);
            elements.append(line);
        }
        helm2notation.addPolymer(new PolymerNotation(polymer.getPolymerID(), (PolymerElements)FastaFormat.generateElementsOfPeptide(elements.toString(), (HELMEntity)polymer.getPolymerID()), annotation));
        return helm2notation;
    }

    public static HELM2Notation generateRNAPolymersFromFastaFormatHELM1(String fasta) throws FastaFormatException, org.helm.notation2.parser.exceptionparser.NotationException, ChemistryException, NucleotideLoadingException {
        PolymerNotation polymer;
        helm2notation = new HELM2Notation();
        if (null == fasta) {
            LOG.error("Nucleotide Sequence must be specified");
            throw new FastaFormatException("Nucleotide Sequence must be specified");
        }
        FastaFormat.initMapNucleotides();
        StringBuilder elements = new StringBuilder();
        int counter = 0;
        try {
            polymer = new PolymerNotation("RNA1");
        }
        catch (org.helm.notation2.parser.exceptionparser.NotationException e) {
            e.printStackTrace();
            throw new FastaFormatException(e.getMessage());
        }
        String annotation = "";
        for (String line : fasta.split("\n")) {
            if (line.startsWith(">")) {
                if (++counter > 1) {
                    if (!FastaFormat.isNormalDirection(elements.toString())) {
                        annotation = annotation + " 3'-5'";
                    }
                    helm2notation.addPolymer(new PolymerNotation(polymer.getPolymerID(), (PolymerElements)FastaFormat.generateElementsforRNA(elements.toString(), (HELMEntity)polymer.getPolymerID()), annotation));
                    elements = new StringBuilder();
                    try {
                        polymer = new PolymerNotation("RNA" + counter);
                    }
                    catch (org.helm.notation2.parser.exceptionparser.NotationException e) {
                        e.printStackTrace();
                        throw new FastaFormatException(e.getMessage());
                    }
                }
                annotation = line.substring(1);
                continue;
            }
            line = FastaFormat.cleanup(line);
            elements.append(line);
        }
        if (!FastaFormat.isNormalDirection(elements.toString())) {
            annotation = annotation + " 3'-5'";
        }
        helm2notation.addPolymer(new PolymerNotation(polymer.getPolymerID(), (PolymerElements)FastaFormat.generateElementsforRNA(elements.toString(), (HELMEntity)polymer.getPolymerID()), annotation));
        return helm2notation;
    }

    private static void initMapNucleotides() throws FastaFormatException {
        try {
            nucleotides = NucleotideFactory.getInstance().getNucleotideTemplates().get("HELM Notation");
        }
        catch (IOException e) {
            e.printStackTrace();
            LOG.error("NucleotideFactory can not be initialized");
            throw new FastaFormatException(e.getMessage());
        }
    }

    private static void initMapTransformNucleotides() {
        transformNucleotides = new HashMap<String, String>();
        for (Map.Entry<String, String> e : nucleotides.entrySet()) {
            transformNucleotides.put(e.getValue().toString(), e.getKey().toString());
        }
    }

    private static void initMapNucleotidesNaturalAnalog() throws FastaFormatException, ChemistryException {
        try {
            nucleotidesNaturalAnalog = MonomerFactory.getInstance().getMonomerDB().get("RNA");
        }
        catch (IOException e) {
            e.printStackTrace();
            LOG.error("Nucleotides can not be initialized");
            throw new FastaFormatException(e.getMessage());
        }
    }

    private static void initMapAminoAcid() throws FastaFormatException, ChemistryException {
        try {
            aminoacids = MonomerFactory.getInstance().getMonomerDB().get("PEPTIDE");
        }
        catch (IOException e) {
            e.printStackTrace();
            LOG.error("AminoAcids can not be initialized");
            throw new FastaFormatException(e.getMessage());
        }
    }

    protected static PolymerListElements generateElementsOfPeptide(String sequence, HELMEntity entity) throws FastaFormatException, ChemistryException {
        FastaFormat.initMapAminoAcid();
        sequence = FastaFormat.cleanup(sequence);
        try {
            PolymerListElements elements = new PolymerListElements(entity);
            List<String> aaList = AminoAcidParser.getAminoAcidList(sequence);
            for (String aa : aaList) {
                if (aa.length() > 1) {
                    aa = "[" + aa + "]";
                }
                elements.addMonomerNotation(aa);
            }
            return elements;
        }
        catch (IOException | MonomerException | NotationException | org.helm.notation2.parser.exceptionparser.NotationException e) {
            e.printStackTrace();
            LOG.error("PolymerListElements can not be initialized");
            throw new FastaFormatException("PolymerListElements can not be initialized " + e.getMessage());
        }
    }

    protected static PolymerListElements generateElementsforRNA(String sequence, HELMEntity entity) throws FastaFormatException, org.helm.notation2.parser.exceptionparser.NotationException, ChemistryException, NucleotideLoadingException {
        FastaFormat.initMapNucleotides();
        FastaFormat.initMapNucleotidesNaturalAnalog();
        PolymerListElements elements = new PolymerListElements(entity);
        sequence = FastaFormat.cleanup(sequence);
        sequence = FastaFormat.prepareSequence(sequence);
        List<Nucleotide> normalNucleotideList = FastaFormat.getNormalList(sequence);
        for (Nucleotide nucleotide : normalNucleotideList) {
            elements.addMonomerNotation(nucleotide.getNotation());
        }
        String id = elements.getCurrentMonomerNotation().getUnit();
        try {
            elements.changeMonomerNotation((MonomerNotation)new MonomerNotationUnitRNA(id.substring(0, id.length() - 1), "RNA"));
        }
        catch (org.helm.notation2.parser.exceptionparser.NotationException e) {
            e.printStackTrace();
            throw new FastaFormatException("PolymerListElements can not be initialized " + e.getMessage());
        }
        return elements;
    }

    private static List<Nucleotide> getNormalList(String sequence) throws org.helm.notation2.parser.exceptionparser.NotationException, NucleotideLoadingException {
        if (null == sequence) {
            throw new org.helm.notation2.parser.exceptionparser.NotationException("Sequence must be specified");
        }
        Map<String, Map<String, String>> templates = NucleotideFactory.getInstance().getNucleotideTemplates();
        Map<String, String> nucleotides = null;
        nucleotides = templates.get("HELM Notation");
        Set<String> keySet = nucleotides.keySet();
        ArrayList<Nucleotide> l = new ArrayList<Nucleotide>();
        int pos = 0;
        while (pos < sequence.length()) {
            boolean found = false;
            for (String symbol : keySet) {
                if (!sequence.startsWith(symbol, pos)) continue;
                found = true;
                String notation = nucleotides.get(symbol);
                Nucleotide nuc = new Nucleotide(symbol, notation);
                l.add(nuc);
                pos += symbol.length();
                break;
            }
            if (found) continue;
            throw new org.helm.notation2.parser.exceptionparser.NotationException("Sequence contains unknown nucleotide starting at " + sequence.substring(pos));
        }
        return l;
    }

    private static String cleanup(String sequence) {
        String result = sequence.replaceAll("\\s", "");
        if (result.equals(result.toLowerCase())) {
            result = result.toUpperCase();
        }
        return result;
    }

    public static String generateFastaFromPeptidePolymer(List<PolymerNotation> polymers) throws FastaFormatException, ChemistryException {
        FastaFormat.initMapAminoAcid();
        StringBuilder fasta = new StringBuilder();
        for (PolymerNotation polymer : polymers) {
            String header = polymer.getPolymerID().getId();
            if (polymer.getAnnotation() != null) {
                header = polymer.getAnnotation();
            }
            fasta.append(">" + header + "\n");
            try {
                fasta.append(FastaFormat.generateFastaFromPeptide(MethodsMonomerUtils.getListOfHandledMonomers(polymer.getListMonomers())) + "\n");
            }
            catch (HELM2HandledException e) {
                e.printStackTrace();
                throw new FastaFormatException(e.getMessage());
            }
        }
        return fasta.toString();
    }

    protected static String generateFastaFromPeptide(List<Monomer> monomers) {
        StringBuilder fasta = new StringBuilder();
        for (Monomer monomer : monomers) {
            fasta.append(monomer.getNaturalAnalog());
        }
        return fasta.toString();
    }

    public static String generateFastaFromRNAPolymer(List<PolymerNotation> polymers) throws FastaFormatException, ChemistryException {
        StringBuilder fasta = new StringBuilder();
        for (PolymerNotation polymer : polymers) {
            String header = polymer.getPolymerID().getId();
            if (polymer.getAnnotation() != null) {
                header = polymer.getAnnotation();
            }
            fasta.append(">" + header + "\n");
            try {
                fasta.append(FastaFormat.generateFastaFromRNA(MethodsMonomerUtils.getListOfHandledMonomers(polymer.getListMonomers())) + "\n");
            }
            catch (HELM2HandledException e) {
                e.printStackTrace();
                throw new FastaFormatException(e.getMessage());
            }
        }
        return fasta.toString();
    }

    protected static String generateFastaFromRNA(List<Monomer> monomers) {
        StringBuilder fasta = new StringBuilder();
        for (Monomer monomer : monomers) {
            if (!monomer.getMonomerType().equals("Branch")) continue;
            fasta.append(monomer.getNaturalAnalog());
        }
        return fasta.toString();
    }

    public static String generateFasta(HELM2Notation helm2Notation2) throws FastaFormatException, ChemistryException {
        ArrayList<PolymerNotation> polymersPeptides = new ArrayList<PolymerNotation>();
        ArrayList<PolymerNotation> polymerNucleotides = new ArrayList<PolymerNotation>();
        StringBuilder fasta = new StringBuilder();
        for (PolymerNotation polymer : helm2Notation2.getListOfPolymers()) {
            if (polymer.getPolymerID() instanceof RNAEntity) {
                polymerNucleotides.add(polymer);
            }
            if (!(polymer.getPolymerID() instanceof PeptideEntity)) continue;
            polymersPeptides.add(polymer);
        }
        fasta.append(FastaFormat.generateFastaFromPeptidePolymer(polymersPeptides));
        fasta.append(FastaFormat.generateFastaFromRNAPolymer(polymerNucleotides));
        return fasta.toString();
    }

    public static HELM2Notation convertIntoAnalogSequence(HELM2Notation helm2Notation) throws FastaFormatException, AnalogSequenceException, ChemistryException, CTKException {
        FastaFormat.initMapAminoAcid();
        FastaFormat.initMapNucleotides();
        FastaFormat.initMapNucleotidesNaturalAnalog();
        FastaFormat.initMapTransformNucleotides();
        List polymers = helm2Notation.getListOfPolymers();
        for (int i = 0; i < helm2Notation.getListOfPolymers().size(); ++i) {
            if (((PolymerNotation)helm2Notation.getListOfPolymers().get(i)).getPolymerID() instanceof RNAEntity) {
                helm2Notation.getListOfPolymers().set(i, FastaFormat.convertRNAIntoAnalogSequence((PolymerNotation)polymers.get(i)));
            }
            if (!(((PolymerNotation)helm2Notation.getListOfPolymers().get(i)).getPolymerID() instanceof PeptideEntity)) continue;
            helm2Notation.getListOfPolymers().set(i, FastaFormat.convertPeptideIntoAnalogSequence((PolymerNotation)polymers.get(i)));
        }
        return helm2Notation;
    }

    private static PolymerNotation convertPeptideIntoAnalogSequence(PolymerNotation polymer) throws AnalogSequenceException {
        for (int i = 0; i < polymer.getPolymerElements().getListOfElements().size(); ++i) {
            polymer.getPolymerElements().getListOfElements().set(i, FastaFormat.generateMonomerNotationPeptide((MonomerNotation)polymer.getPolymerElements().getListOfElements().get(i)));
        }
        return polymer;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static MonomerNotation generateMonomerNotationPeptide(MonomerNotation current) throws AnalogSequenceException {
        MonomerNotationUnit change = null;
        try {
            if (current instanceof MonomerNotationUnit) {
                String id = aminoacids.get(current.getUnit().replace("[", "").replace("]", "")).getNaturalAnalog();
                change = new MonomerNotationUnit(id, current.getType());
                change.setCount(current.getCount());
                if (current.getAnnotation() != null) {
                    change.setAnnotation(current.getAnnotation());
                }
            } else if (current instanceof MonomerNotationGroup) {
                if (current instanceof MonomerNotationGroupOr) {
                    StringBuilder sb = new StringBuilder();
                    String id = current.getUnit();
                    for (String element : id.split(",")) {
                        sb.append(aminoacids.get(element.replace("[", "").replace("]", "")).getNaturalAnalog() + ",");
                    }
                    sb.setLength(sb.length() - 1);
                    change = new MonomerNotationList(sb.toString(), current.getType());
                } else {
                    if (!(current instanceof MonomerNotationGroupMixture)) throw new AnalogSequenceException("MonomerNotationGroup is unknown" + current.getClass());
                    StringBuilder sb = new StringBuilder();
                    String id = current.getUnit();
                    for (String element : id.split("\\+")) {
                        sb.append(aminoacids.get(element.replace("[", "").replace("]", "")).getNaturalAnalog() + "+");
                    }
                    sb.setLength(sb.length() - 1);
                    change = new MonomerNotationList(sb.toString(), current.getType());
                }
            } else {
                if (!(current instanceof MonomerNotationList)) throw new AnalogSequenceException("MonomerNotation is unknown" + current.getClass());
                StringBuilder sb = new StringBuilder();
                String id = current.getUnit();
                for (String element : id.split("\\.")) {
                    sb.append(aminoacids.get(element.replace("[", "").replace("]", "")).getNaturalAnalog() + ".");
                }
                sb.setLength(sb.length() - 1);
                change = new MonomerNotationList(sb.toString(), current.getType());
            }
            change.setCount(current.getCount());
            if (current.getAnnotation() == null) return change;
            change.setAnnotation(current.getAnnotation());
            return change;
        }
        catch (org.helm.notation2.parser.exceptionparser.NotationException e) {
            e.printStackTrace();
            throw new AnalogSequenceException("MonomerNotation can not be converted to its natural analogue sequence " + e.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static MonomerNotation generateMonomerNotationRNA(MonomerNotation current) throws AnalogSequenceException {
        MonomerNotationUnit change = null;
        try {
            if (current instanceof MonomerNotationUnit) {
                change = new MonomerNotationUnit(FastaFormat.changeIdForRNA(current), current.getType());
            } else if (current instanceof MonomerNotationGroup) {
                if (current instanceof MonomerNotationGroupOr) {
                    StringBuilder sb = new StringBuilder();
                    for (MonomerNotationGroupElement element : ((MonomerNotationGroup)current).getListOfElements()) {
                        sb.append(FastaFormat.changeIdForRNA(element.getMonomerNotation()) + ",");
                    }
                    sb.setLength(sb.length() - 1);
                    change = new MonomerNotationGroupOr(sb.toString(), current.getType());
                } else {
                    if (!(current instanceof MonomerNotationGroupMixture)) throw new AnalogSequenceException("Unknown MonomerNotationGroup " + current.getClass());
                    StringBuilder sb = new StringBuilder();
                    for (MonomerNotationGroupElement element : ((MonomerNotationGroup)current).getListOfElements()) {
                        sb.append(FastaFormat.changeIdForRNA(element.getMonomerNotation()) + "+");
                    }
                    sb.setLength(sb.length() - 1);
                    change = new MonomerNotationGroupMixture(sb.toString(), current.getType());
                }
            } else {
                if (!(current instanceof MonomerNotationList)) throw new AnalogSequenceException("Unknown MonomerNotation " + current.getClass());
                StringBuilder sb = new StringBuilder();
                for (MonomerNotation element : ((MonomerNotationList)current).getListofMonomerUnits()) {
                    sb.append(FastaFormat.changeIdForRNA(element) + ".");
                }
                sb.setLength(sb.length() - 1);
                change = new MonomerNotationList(sb.toString(), current.getType());
            }
            change.setCount(current.getCount());
            if (current.getAnnotation() == null) return change;
            change.setAnnotation(current.getAnnotation());
            return change;
        }
        catch (org.helm.notation2.parser.exceptionparser.NotationException e) {
            e.printStackTrace();
            throw new AnalogSequenceException("Notation object can not be built");
        }
    }

    private static PolymerNotation convertRNAIntoAnalogSequence(PolymerNotation polymer) throws AnalogSequenceException {
        for (int i = 0; i < polymer.getPolymerElements().getListOfElements().size(); ++i) {
            polymer.getPolymerElements().getListOfElements().set(i, FastaFormat.generateMonomerNotationRNA((MonomerNotation)polymer.getPolymerElements().getListOfElements().get(i)));
        }
        return polymer;
    }

    private static String changeIdForRNA(MonomerNotation monomerNotation) {
        if (monomerNotation instanceof MonomerNotationUnitRNA) {
            StringBuilder changeid = new StringBuilder();
            for (MonomerNotation not : ((MonomerNotationUnitRNA)monomerNotation).getContents()) {
                Monomer monomer = nucleotidesNaturalAnalog.get(not.getUnit().replace("[", "").replace("]", ""));
                String id = monomer.getNaturalAnalog();
                if (monomer.getMonomerType().equals("Branch")) {
                    id = "(" + id + ")";
                }
                changeid.append(id);
            }
            return changeid.toString();
        }
        Monomer monomer = nucleotidesNaturalAnalog.get(monomerNotation.getUnit().replace("[", "").replace("]", ""));
        String id = monomer.getNaturalAnalog();
        if (monomer.getMonomerType().equals("Branch")) {
            id = "(" + id + ")";
        }
        return id;
    }

    public static boolean isNormalDirection(String sequence) {
        return !sequence.startsWith("3");
    }

    private static String prepareSequence(String sequence) {
        String result = sequence;
        result = result.replace("-", "");
        result = result.replace("5'", "");
        result = result.replace("3'", "");
        if (!FastaFormat.isNormalDirection(sequence)) {
            result = new StringBuffer(result).reverse().toString();
        }
        return result;
    }
}

