/*
 * Decompiled with CFR 0.152.
 */
package org.helm.notation2.wsadapter;

import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.util.EntityUtils;
import org.helm.notation2.Nucleotide;
import org.helm.notation2.wsadapter.MonomerStoreConfiguration;
import org.helm.notation2.wsadapter.WSAdapterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NucleotideWSSaver {
    private static final Logger LOG = LoggerFactory.getLogger(NucleotideWSSaver.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String saveNucleotideToStore(Nucleotide nucleotide) {
        String res = "";
        CloseableHttpResponse response = null;
        try {
            response = WSAdapterUtils.putResource(nucleotide.toJSON(), MonomerStoreConfiguration.getInstance().getWebserviceNucleotidesPutFullURL());
            LOG.debug(response.getStatusLine().toString());
            EntityUtils.consume((HttpEntity)response.getEntity());
        }
        catch (Exception e) {
            LOG.error("Saving nucleotide failed!", (Throwable)e);
            String string = "";
            return string;
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                LOG.debug("Closing resources failed.", (Throwable)e);
                return res;
            }
        }
        return res;
    }
}

