/*
 * Decompiled with CFR 0.152.
 */
package org.helm.notation2.tools;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.helm.chemtoolkit.CTKException;
import org.helm.notation2.Chemistry;
import org.helm.notation2.InterConnections;
import org.helm.notation2.Monomer;
import org.helm.notation2.MonomerFactory;
import org.helm.notation2.MonomerStore;
import org.helm.notation2.exception.AttachmentException;
import org.helm.notation2.exception.ChemistryException;
import org.helm.notation2.exception.ConnectionNotationException;
import org.helm.notation2.exception.GroupingNotationException;
import org.helm.notation2.exception.HELM2HandledException;
import org.helm.notation2.exception.MonomerException;
import org.helm.notation2.exception.MonomerLoadingException;
import org.helm.notation2.exception.NotationException;
import org.helm.notation2.exception.PolymerIDsException;
import org.helm.notation2.parser.notation.HELM2Notation;
import org.helm.notation2.parser.notation.ValidationMethod;
import org.helm.notation2.parser.notation.connection.ConnectionNotation;
import org.helm.notation2.parser.notation.grouping.GroupingElement;
import org.helm.notation2.parser.notation.grouping.GroupingNotation;
import org.helm.notation2.parser.notation.polymer.GroupEntity;
import org.helm.notation2.parser.notation.polymer.HELMEntity;
import org.helm.notation2.parser.notation.polymer.MonomerNotation;
import org.helm.notation2.parser.notation.polymer.MonomerNotationGroup;
import org.helm.notation2.parser.notation.polymer.MonomerNotationGroupElement;
import org.helm.notation2.parser.notation.polymer.MonomerNotationList;
import org.helm.notation2.parser.notation.polymer.MonomerNotationUnit;
import org.helm.notation2.parser.notation.polymer.MonomerNotationUnitRNA;
import org.helm.notation2.parser.notation.polymer.PolymerNotation;
import org.helm.notation2.tools.MethodsMonomerUtils;
import org.helm.notation2.tools.NucleotideParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Validation {
    private static final Logger LOG = LoggerFactory.getLogger(Validation.class);

    private Validation() {
    }

    public static void validateNotationObjects(HELM2Notation helm2notation) throws PolymerIDsException, MonomerException, GroupingNotationException, ConnectionNotationException, NotationException, ChemistryException, MonomerLoadingException, org.helm.notation2.parser.exceptionparser.NotationException {
        LOG.info("Validation process is starting");
        if (!Validation.validateUniquePolymerIDs(helm2notation)) {
            LOG.info("Polymer IDS have to be unique");
            throw new PolymerIDsException("Polymer IDs have to be unique");
        }
        if (!Validation.validateMonomers(MethodsMonomerUtils.getListOfMonomerNotation(helm2notation.getListOfPolymers()))) {
            LOG.info("Monomers have to be valid");
            throw new MonomerException("Monomers have to be valid");
        }
        if (!Validation.validateGrouping(helm2notation)) {
            LOG.info("Group information is not valid");
            throw new GroupingNotationException("Group notation is not valid");
        }
        if (!Validation.validateConnections(helm2notation)) {
            LOG.info("Connection information is not valid");
            throw new ConnectionNotationException("Connection notation is not valid");
        }
    }

    protected static boolean validateMonomers(List<MonomerNotation> mon) throws ChemistryException, MonomerLoadingException, org.helm.notation2.parser.exceptionparser.NotationException {
        for (MonomerNotation monomerNotation : mon) {
            if (Validation.isMonomerValid(monomerNotation.getUnit(), monomerNotation.getType())) continue;
            return false;
        }
        return true;
    }

    public static boolean validateConnections(HELM2Notation helm2notation) throws NotationException, ChemistryException {
        try {
            LOG.info("Validation of Connection section starts");
            List listConnections = helm2notation.getListOfConnections();
            List listPolymerIDs = helm2notation.getPolymerAndGroupingIDs();
            InterConnections interconnection = new InterConnections();
            boolean specific = true;
            for (ConnectionNotation connection : listConnections) {
                Validation.checkPolymerIDSConnection(connection, listPolymerIDs);
                if (connection.getSourceId() instanceof GroupEntity || connection.getTargetId() instanceof GroupEntity) {
                    specific = false;
                }
                PolymerNotation source = helm2notation.getPolymerNotation(connection.getSourceId().getId());
                String sourceUnit = connection.getSourceUnit();
                PolymerNotation target = helm2notation.getPolymerNotation(connection.getTargetId().getId());
                String targetUnit = connection.getTargetUnit();
                if (Validation.isConnectionSpecific(connection) && specific) {
                    specific = true;
                    int occurenceOne = Integer.parseInt(sourceUnit);
                    int occurenceTwo = Integer.parseInt(targetUnit);
                    List<Monomer> listMonomersOne = Validation.getAllMonomers(source.getMonomerNotation(occurenceOne), occurenceOne);
                    List<Monomer> listMonomersTwo = Validation.getAllMonomers(target.getMonomerNotation(occurenceTwo), occurenceTwo);
                    Validation.checkAttachment(listMonomersOne, listMonomersTwo, connection, helm2notation, interconnection, specific);
                    continue;
                }
                List<Integer> listMonomerOccurencesOne = Validation.getOccurencesOfMonomerNotation(sourceUnit, connection.getSourceId(), helm2notation);
                List<Integer> listMonomerOccurencesTwo = Validation.getOccurencesOfMonomerNotation(targetUnit, connection.getTargetId(), helm2notation);
                if (listMonomerOccurencesOne.isEmpty()) {
                    for (Integer occurenceTwo : listMonomerOccurencesTwo) {
                        List<Monomer> listMonomersTwo = Validation.getAllMonomers(target.getMonomerNotation(occurenceTwo.intValue()), occurenceTwo);
                        Validation.checkSingleAttachment(listMonomersTwo, connection.getrGroupTarget(), helm2notation, connection, interconnection, connection.getTargetId().getId());
                    }
                }
                for (Integer occurenceOne : listMonomerOccurencesOne) {
                    List<Monomer> listMonomersOne = Validation.getAllMonomers(source.getMonomerNotation(occurenceOne.intValue()), occurenceOne);
                    Validation.checkSingleAttachment(listMonomersOne, connection.getrGroupSource(), helm2notation, connection, interconnection, connection.getSourceId().getId());
                    for (Integer occurenceTwo : listMonomerOccurencesTwo) {
                        List<Monomer> listMonomersTwo = Validation.getAllMonomers(target.getMonomerNotation(occurenceTwo.intValue()), occurenceTwo);
                        Validation.checkSingleAttachment(listMonomersTwo, connection.getrGroupTarget(), helm2notation, connection, interconnection, connection.getTargetId().getId());
                        Validation.checkAttachment(listMonomersOne, listMonomersTwo, connection, helm2notation, interconnection, false);
                    }
                }
            }
            return true;
        }
        catch (IOException | CTKException | AttachmentException | HELM2HandledException | MonomerException | PolymerIDsException | org.helm.notation2.parser.exceptionparser.NotationException e) {
            e.printStackTrace();
            LOG.info(e.getMessage());
            return false;
        }
    }

    private static boolean isConnectionSpecific(ConnectionNotation connectionNotation) {
        String connection = connectionNotation.getSourceUnit() + ":" + connectionNotation.getrGroupSource() + "-" + connectionNotation.getTargetUnit() + ":" + connectionNotation.getrGroupTarget();
        return connection.matches("\\d+:R\\d-\\d+:R\\d|\\d+:pair-\\d+:pair");
    }

    private static List<Integer> getOccurencesOfMonomerNotation(String sourceUnit, HELMEntity e, HELM2Notation helm2notation) throws org.helm.notation2.parser.exceptionparser.NotationException, AttachmentException {
        ArrayList<Integer> occurences = new ArrayList<Integer>();
        try {
            occurences.add(Integer.parseInt(sourceUnit));
            return occurences;
        }
        catch (NumberFormatException ex) {
            MonomerNotation mon = ValidationMethod.decideWhichMonomerNotation((String)sourceUnit, (String)e.getType());
            if (mon instanceof MonomerNotationUnit) {
                PolymerNotation polymerNotation = helm2notation.getPolymerNotation(e.getId());
                if (sourceUnit.equals("?")) {
                    return occurences;
                }
                occurences.addAll(Validation.findElementInPolymer(sourceUnit, polymerNotation));
                if (occurences.isEmpty()) {
                    throw new AttachmentException("Monomer is not there");
                }
            } else if (mon instanceof MonomerNotationGroup || mon instanceof MonomerNotationList) {
                PolymerNotation polymerNotation = helm2notation.getPolymerNotation(e.getId());
                HashMap<String, String> elements = new HashMap<String, String>();
                for (MonomerNotationGroupElement groupElement : ((MonomerNotationGroup)mon).getListOfElements()) {
                    elements.put(groupElement.getMonomerNotation().getUnit(), "");
                }
                for (String e1 : elements.keySet()) {
                    try {
                        int i = Integer.parseInt(e1);
                        elements.put(e1, "1");
                        occurences.add(i);
                    }
                    catch (NumberFormatException ex1) {
                        List<Integer> foundMonomers = Validation.findElementInPolymer(e1, polymerNotation);
                        if (foundMonomers.size() <= 0) continue;
                        elements.put(e1, "1");
                        occurences.addAll(foundMonomers);
                    }
                }
                if (occurences.size() < elements.size() || elements.containsValue("")) {
                    throw new AttachmentException("Not all Monomers are there");
                }
            }
            return occurences;
        }
    }

    private static List<Integer> findElementInPolymer(String e1, PolymerNotation polymerNotation) {
        ArrayList<Integer> occurences = new ArrayList<Integer>();
        int j = 0;
        for (int i = 0; i < polymerNotation.getPolymerElements().getListOfElements().size(); ++i) {
            MonomerNotation el = (MonomerNotation)polymerNotation.getPolymerElements().getListOfElements().get(i);
            if (el instanceof MonomerNotationUnitRNA) {
                for (MonomerNotationUnit unit : ((MonomerNotationUnitRNA)el).getContents()) {
                    ++j;
                    if (!unit.getUnit().equals(e1)) continue;
                    occurences.add(j);
                }
                continue;
            }
            ++j;
            if (!((MonomerNotation)polymerNotation.getPolymerElements().getListOfElements().get(i)).getUnit().equals(e1)) continue;
            occurences.add(i + 1);
        }
        return occurences;
    }

    public static boolean validateGrouping(HELM2Notation helm2notation) {
        List listGroupings = helm2notation.getListOfGroupings();
        List listPolymerIDs = helm2notation.getPolymerAndGroupingIDs();
        for (GroupingNotation grouping : listGroupings) {
            for (GroupingElement groupingElement : grouping.getAmbiguity().getListOfElements()) {
                if (listPolymerIDs.contains(groupingElement.getID().getId())) continue;
                LOG.info("Element of Group: " + groupingElement.getID().getId() + " does not exist");
                return false;
            }
        }
        return true;
    }

    public static boolean validateUniquePolymerIDs(HELM2Notation helm2notation) {
        List listPolymerIDs = helm2notation.getPolymerAndGroupingIDs();
        HashMap<String, String> uniqueId = new HashMap<String, String>();
        for (String polymerID : listPolymerIDs) {
            uniqueId.put(polymerID, "");
        }
        if (listPolymerIDs.size() > uniqueId.size()) {
            LOG.info("Polymer node IDs are not unique");
            return false;
        }
        return true;
    }

    private static void checkExistenceOfPolymerID(String str, List<String> listPolymerIDs) throws PolymerIDsException {
        if (!listPolymerIDs.contains(str)) {
            LOG.info("Polymer Id does not exist");
            throw new PolymerIDsException("Polymer ID does not exist");
        }
    }

    private static boolean isMonomerValid(String str, String type) throws ChemistryException, MonomerLoadingException, org.helm.notation2.parser.exceptionparser.NotationException {
        LOG.info("Is Monomer valid: " + str);
        MonomerFactory monomerFactory = null;
        monomerFactory = MonomerFactory.getInstance();
        MonomerStore monomerStore = monomerFactory.getMonomerStore();
        if (monomerStore.hasMonomer(type, str)) {
            LOG.info("Monomer is located in the database: " + str);
            return true;
        }
        if (str.charAt(0) == '[' && str.charAt(str.length() - 1) == ']' && monomerStore.hasMonomer(type, str.substring(1, str.length() - 1))) {
            LOG.info("Monomer is located in the database: " + str);
            return true;
        }
        if (type.equals("BLOB")) {
            LOG.info("Blob's Monomer Type: " + str);
            return true;
        }
        if (type.equals("PEPTIDE") && str.equals("X")) {
            LOG.info("Unknown monomer type for peptide: " + str);
            return true;
        }
        if (type.equals("RNA") && str.equals("N")) {
            LOG.info("Unknown monomer type for rna: " + str);
            return true;
        }
        if (str.equals("?") || str.equals("_")) {
            LOG.info("Unknown types: " + str);
            return true;
        }
        if (type.equals("RNA")) {
            List<String> elements = NucleotideParser.getMonomerIDListFromNucleotide(str);
            for (String element : elements) {
                if (monomerStore.hasMonomer(type, element)) continue;
                if (element.startsWith("[") && element.endsWith("]")) {
                    element = element.substring(1, element.length() - 1);
                }
                if (Chemistry.getInstance().getManipulator().validateSMILES(element)) continue;
                return false;
            }
            LOG.info("Nucleotide type for RNA: " + str);
            return true;
        }
        LOG.info("SMILES Check");
        if (str.charAt(0) == '[' && str.charAt(str.length() - 1) == ']') {
            str = str.substring(1, str.length() - 1);
        }
        return Chemistry.getInstance().getManipulator().validateSMILES(str);
    }

    private static void checkPolymerIDSConnection(ConnectionNotation not, List<String> listPolymerIDs) throws PolymerIDsException {
        Validation.checkExistenceOfPolymerID(not.getSourceId().getId(), listPolymerIDs);
        Validation.checkExistenceOfPolymerID(not.getTargetId().getId(), listPolymerIDs);
    }

    public static List<Monomer> getAllMonomers(MonomerNotation not, int position) throws HELM2HandledException, MonomerException, NotationException, ChemistryException, CTKException, MonomerLoadingException {
        ArrayList<Monomer> monomers;
        block4: {
            MonomerStore monomerStore;
            block6: {
                block5: {
                    block3: {
                        monomers = new ArrayList<Monomer>();
                        MonomerFactory monomerFactory = MonomerFactory.getInstance();
                        monomerStore = monomerFactory.getMonomerStore();
                        if (!(not instanceof MonomerNotationUnitRNA)) break block3;
                        monomers.addAll(Validation.getMonomersRNA((MonomerNotationUnitRNA)not, monomerStore, position));
                        break block4;
                    }
                    if (!(not instanceof MonomerNotationUnit)) break block5;
                    String id = not.getUnit();
                    monomers.add(MethodsMonomerUtils.getMonomer(not.getType(), id, ""));
                    break block4;
                }
                if (!(not instanceof MonomerNotationGroup)) break block6;
                for (MonomerNotationGroupElement groupElement : ((MonomerNotationGroup)not).getListOfElements()) {
                    String id = groupElement.getMonomerNotation().getUnit();
                    monomers.add(MethodsMonomerUtils.getMonomer(not.getType(), id, ""));
                }
                break block4;
            }
            if (!(not instanceof MonomerNotationList)) break block4;
            for (MonomerNotation listElement : ((MonomerNotationList)not).getListofMonomerUnits()) {
                if (listElement instanceof MonomerNotationUnitRNA) {
                    monomers.addAll(Validation.getMonomersRNA((MonomerNotationUnitRNA)listElement, monomerStore, position));
                    continue;
                }
                String id = listElement.getUnit();
                monomers.add(MethodsMonomerUtils.getMonomer(not.getType(), id, ""));
            }
        }
        return monomers;
    }

    public static List<Monomer> getAllMonomersOnlyBase(MonomerNotation not) throws HELM2HandledException, MonomerException, NotationException, ChemistryException, CTKException, MonomerLoadingException {
        ArrayList<Monomer> monomers;
        block7: {
            MonomerStore monomerStore;
            block9: {
                block8: {
                    block6: {
                        LOG.debug("Get base for " + not);
                        monomers = new ArrayList<Monomer>();
                        MonomerFactory monomerFactory = MonomerFactory.getInstance();
                        monomerStore = monomerFactory.getMonomerStore();
                        LOG.debug("Which MonomerNotationType " + not.getClass());
                        if (!(not instanceof MonomerNotationUnitRNA)) break block6;
                        LOG.debug("MonomerNotationUnitRNA");
                        monomers.addAll(Validation.getMonomersRNAOnlyBase((MonomerNotationUnitRNA)not, monomerStore));
                        break block7;
                    }
                    if (!(not instanceof MonomerNotationUnit)) break block8;
                    String id = not.getUnit();
                    if (id.startsWith("[") && id.endsWith("]")) {
                        id = id.substring(1, id.length() - 1);
                    }
                    monomers.add(MethodsMonomerUtils.getMonomer(not.getType(), id, ""));
                    break block7;
                }
                if (!(not instanceof MonomerNotationGroup)) break block9;
                LOG.debug("MonomerNotationGroup");
                for (MonomerNotationGroupElement groupElement : ((MonomerNotationGroup)not).getListOfElements()) {
                    String id = groupElement.getMonomerNotation().getUnit();
                    if (id.startsWith("[") && id.endsWith("]")) {
                        id = id.substring(1, id.length() - 1);
                    }
                    monomers.add(MethodsMonomerUtils.getMonomer(not.getType(), id, ""));
                }
                break block7;
            }
            if (!(not instanceof MonomerNotationList)) break block7;
            LOG.debug("MonomerNotationList");
            for (MonomerNotation listElement : ((MonomerNotationList)not).getListofMonomerUnits()) {
                if (listElement instanceof MonomerNotationUnitRNA) {
                    monomers.addAll(Validation.getMonomersRNAOnlyBase((MonomerNotationUnitRNA)listElement, monomerStore));
                    continue;
                }
                String id = listElement.getUnit();
                if (id.startsWith("[") && id.endsWith("]")) {
                    id = id.substring(1, id.length() - 1);
                }
                monomers.add(MethodsMonomerUtils.getMonomer(not.getType(), id, ""));
            }
        }
        return monomers;
    }

    private static void checkAttachmentPoint(Monomer mon, String str) throws AttachmentException {
        if (!(mon.getAttachmentListString().contains(str) || str.equals("?") || str.equals("pair") || mon.getAlternateId().equals("?"))) {
            LOG.info("Attachment point for source is not there");
            throw new AttachmentException("Attachment point for source is not there: " + str);
        }
    }

    private static void checkAttachment(List<Monomer> listMonomersOne, List<Monomer> listMonomersTwo, ConnectionNotation not, HELM2Notation helm2notation, InterConnections interconnection, boolean spec) throws AttachmentException {
        boolean specific = spec;
        if (listMonomersOne.size() > 1 || listMonomersTwo.size() > 1) {
            specific = false;
        }
        for (Monomer monomerOne : listMonomersOne) {
            for (Monomer monomerTwo : listMonomersTwo) {
                String detailtarget;
                String detailsource;
                if (monomerOne.getPolymerType().equals("RNA") && monomerTwo.getPolymerType().equals("RNA") && not.getrGroupSource().equals("pair") && not.getrGroupTarget().equals("pair")) {
                    LOG.info("RNA strand connection");
                    if (!(monomerOne.getMonomerType().equals("Branch") | monomerTwo.getMonomerType().equals("Branch"))) {
                        LOG.info("RNA strand connection is not valid");
                        throw new AttachmentException("RNA strand connection is not valid");
                    }
                    detailsource = not.getSourceUnit() + "$" + not.getrGroupSource();
                    detailtarget = not.getTargetUnit() + "$" + not.getrGroupTarget();
                    if (helm2notation.getSimplePolymer(not.getSourceId().getId()).getMapIntraConnection().containsKey(detailsource)) {
                        LOG.info("Attachment point is already occupied");
                        throw new AttachmentException("Attachment point is already occupied");
                    }
                    if (helm2notation.getSimplePolymer(not.getTargetId().getId()).getMapIntraConnection().containsKey(detailtarget)) {
                        LOG.info("Attachment point is already occupied");
                        throw new AttachmentException("Attachment point is already occupied");
                    }
                }
                detailsource = not.getSourceUnit() + "$" + not.getrGroupSource();
                detailtarget = not.getTargetUnit() + "$" + not.getrGroupTarget();
                detailsource = not.getSourceId().getId() + "$" + detailsource;
                detailtarget = not.getTargetId().getId() + "$" + detailtarget;
                if (interconnection.hasKey(detailsource)) {
                    LOG.info("Attachment point is already occupied");
                    throw new AttachmentException("Attachment point is already occupied");
                }
                if (interconnection.hasKey(detailtarget)) {
                    LOG.info("Attachment point is already occupied");
                    throw new AttachmentException("Attachment point is already occupied");
                }
                detailsource = not.getSourceId().getId() + "$" + not.getSourceUnit() + "$" + not.getrGroupSource();
                detailtarget = not.getTargetId().getId() + "$" + not.getTargetUnit() + "$" + not.getrGroupTarget();
                if (!specific) continue;
                interconnection.addConnection(detailsource, "");
                interconnection.addConnection(detailtarget, "");
            }
        }
    }

    private static boolean checkSingleAttachment(List<Monomer> monomers, String rGroup, HELM2Notation helm2notation, ConnectionNotation not, InterConnections interconnection, String id) throws AttachmentException {
        for (Monomer monomer : monomers) {
            Validation.checkAttachmentPoint(monomer, rGroup);
            String detail = not.getSourceUnit() + "$" + not.getrGroupSource();
            if (helm2notation.getSimplePolymer(id).getMapIntraConnection().containsKey(detail)) {
                throw new AttachmentException("Attachment point is already occupied");
            }
            detail = id + "$" + detail;
            if (!interconnection.hasKey(detail)) continue;
            throw new AttachmentException("Attachment point is already occupied");
        }
        return true;
    }

    private static List<Monomer> getMonomersRNA(MonomerNotationUnitRNA rna, MonomerStore monomerStore, int position) throws HELM2HandledException {
        try {
            ArrayList<Monomer> monomers = new ArrayList<Monomer>();
            for (int index = 0; index < rna.getContents().size(); ++index) {
                String id = ((MonomerNotationUnit)rna.getContents().get(index)).getUnit();
                if (((MonomerNotationUnit)rna.getContents().get(index)).getUnit().startsWith("[") && ((MonomerNotationUnit)rna.getContents().get(index)).getUnit().endsWith("]")) {
                    id = id.substring(1, id.length() - 1);
                }
                if (rna.getContents().size() == 1 && position == 0) {
                    monomers.add(MethodsMonomerUtils.getMonomer(rna.getType(), id, "P"));
                    continue;
                }
                monomers.add(MethodsMonomerUtils.getMonomer(rna.getType(), id, (String)rna.getInformation().get(index)));
            }
            return monomers;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HELM2HandledException(e.getMessage());
        }
    }

    private static List<Monomer> getMonomersRNAOnlyBase(MonomerNotationUnitRNA rna, MonomerStore monomerStore) throws HELM2HandledException {
        try {
            ArrayList<Monomer> monomers = new ArrayList<Monomer>();
            for (MonomerNotationUnit unit : rna.getContents()) {
                String id = unit.getUnit().replace("[", "");
                id = id.replace("]", "");
                Monomer mon = MethodsMonomerUtils.getMonomer(rna.getType(), id, "");
                if (!mon.getMonomerType().equals("Branch")) continue;
                monomers.add(mon);
            }
            return monomers;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HELM2HandledException(e.getMessage());
        }
    }
}

