/*
 * Decompiled with CFR 0.152.
 */
package org.helm.notation2.tools;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.helm.chemtoolkit.CTKException;
import org.helm.notation2.Nucleotide;
import org.helm.notation2.exception.ChemistryException;
import org.helm.notation2.exception.FastaFormatException;
import org.helm.notation2.exception.HELM2HandledException;
import org.helm.notation2.exception.NotationException;
import org.helm.notation2.exception.NucleotideLoadingException;
import org.helm.notation2.exception.RNAUtilsException;
import org.helm.notation2.parser.notation.HELM2Notation;
import org.helm.notation2.parser.notation.annotation.AnnotationNotation;
import org.helm.notation2.parser.notation.connection.ConnectionNotation;
import org.helm.notation2.parser.notation.polymer.HELMEntity;
import org.helm.notation2.parser.notation.polymer.PolymerElements;
import org.helm.notation2.parser.notation.polymer.PolymerNotation;
import org.helm.notation2.tools.ChangeObjects;
import org.helm.notation2.tools.FastaFormat;
import org.helm.notation2.tools.NucleotideParser;
import org.helm.notation2.tools.RNAUtils;
import org.helm.notation2.tools.SequenceConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SiRNANotation {
    public static Map<String, String> complementMap = new HashMap<String, String>();
    private static final Logger LOG;

    public static HELM2Notation getSiRNANotation(String senseSeq, String antiSenseSeq) throws org.helm.notation2.parser.exceptionparser.NotationException, FastaFormatException, HELM2HandledException, RNAUtilsException, NotationException, ChemistryException, CTKException, NucleotideLoadingException {
        return SiRNANotation.getSirnaNotation(senseSeq, antiSenseSeq, "NONE");
    }

    public static HELM2Notation getSirnaNotation(String senseSeq, String antiSenseSeq, String rnaDesignType) throws org.helm.notation2.parser.exceptionparser.NotationException, FastaFormatException, HELM2HandledException, RNAUtilsException, NotationException, ChemistryException, CTKException, NucleotideLoadingException {
        HELM2Notation helm2notation = null;
        if (senseSeq != null && senseSeq.length() > 0) {
            helm2notation = SequenceConverter.readRNA(senseSeq);
        }
        if (antiSenseSeq != null && antiSenseSeq.length() > 0) {
            PolymerNotation antisense = new PolymerNotation("RNA2");
            antisense = new PolymerNotation(antisense.getPolymerID(), (PolymerElements)FastaFormat.generateElementsforRNA(antiSenseSeq, (HELMEntity)antisense.getPolymerID()));
            helm2notation.addPolymer(antisense);
        }
        SiRNANotation.validateSiRNADesign((PolymerNotation)helm2notation.getListOfPolymers().get(0), (PolymerNotation)helm2notation.getListOfPolymers().get(1), rnaDesignType);
        helm2notation.getListOfConnections().addAll(SiRNANotation.hybridization((PolymerNotation)helm2notation.getListOfPolymers().get(0), (PolymerNotation)helm2notation.getListOfPolymers().get(1), rnaDesignType));
        ChangeObjects.addAnnotation(new AnnotationNotation("RNA1{ss}|RNA2{as}"), 0, helm2notation);
        return helm2notation;
    }

    private static List<ConnectionNotation> hybridization(PolymerNotation one, PolymerNotation two, String rnaDesignType) throws org.helm.notation2.parser.exceptionparser.NotationException, HELM2HandledException, RNAUtilsException, NotationException, ChemistryException, NucleotideLoadingException {
        List<ConnectionNotation> connections = new ArrayList<ConnectionNotation>();
        if (one.getPolymerElements().getListOfElements() != null && one.getPolymerElements().getListOfElements().size() > 0 && two.getPolymerElements().getListOfElements() != null && two.getPolymerElements().getListOfElements().size() > 0) {
            String analogSeqSS = RNAUtils.getNaturalAnalogSequence(one).replaceAll("T", "U");
            String analogSeqAS = RNAUtils.getNaturalAnalogSequence(two).replaceAll("T", "U");
            if ("NONE".equalsIgnoreCase(rnaDesignType)) {
                String normalCompAS = RNAUtils.getNaturalAnalogSequence(RNAUtils.getComplement(two)).replace("T", "U");
                String maxMatch = RNAUtils.getMaxMatchFragment(analogSeqSS, new StringBuilder(normalCompAS).reverse().toString());
                if (maxMatch.length() > 0) {
                    int ssStart = analogSeqSS.indexOf(maxMatch);
                    int normalCompStart = new StringBuilder(normalCompAS).reverse().toString().indexOf(maxMatch);
                    int asStart = analogSeqAS.length() - maxMatch.length() - normalCompStart;
                    for (int i = 0; i < maxMatch.length(); ++i) {
                        int ssPos = (i + ssStart) * 3 + 2;
                        int asPos = (asStart + maxMatch.length() - 1 - i) * 3 + 2;
                        String details = ssPos + ":pair-" + asPos + ":pair";
                        ConnectionNotation connection = new ConnectionNotation((HELMEntity)one.getPolymerID(), (HELMEntity)two.getPolymerID(), details);
                        connections.add(connection);
                    }
                }
            } else if ("TUSCHL_19_PLUS_2".equalsIgnoreCase(rnaDesignType)) {
                int matchLength = 19;
                connections = SiRNANotation.hybridizationWithLengthFromStart(one, two, analogSeqSS, analogSeqAS, matchLength);
            } else if ("DICER_27_R".equalsIgnoreCase(rnaDesignType)) {
                int matchLength = 25;
                connections = SiRNANotation.hybridizationWithLengthFromStart(one, two, analogSeqSS, analogSeqAS, matchLength);
            } else if ("DICER_27_L".equalsIgnoreCase(rnaDesignType)) {
                int matchLength = 25;
                connections = SiRNANotation.hybridizationWithLengthFromStart(one, two, analogSeqSS, analogSeqAS, matchLength);
            } else {
                new RNAUtilsException("RNA-Design-Type " + rnaDesignType + " is unknown");
            }
        }
        return connections;
    }

    private static List<ConnectionNotation> hybridizationWithLengthFromStart(PolymerNotation one, PolymerNotation two, String senseAnalogSeq, String antisenseAnalogSeq, int lengthFromStart) throws org.helm.notation2.parser.exceptionparser.NotationException {
        ArrayList<ConnectionNotation> connections = new ArrayList<ConnectionNotation>();
        for (int i = 0; i < lengthFromStart; ++i) {
            int ssPos = i * 3 + 2;
            int asPos = (lengthFromStart - 1 - i) * 3 + 2;
            String ssChar = String.valueOf(senseAnalogSeq.charAt(i));
            String asChar = String.valueOf(antisenseAnalogSeq.charAt(lengthFromStart - 1 - i));
            if (!complementMap.get(ssChar).equalsIgnoreCase(asChar)) continue;
            String details = ssPos + ":pair-" + asPos + ":pair";
            ConnectionNotation connection = new ConnectionNotation((HELMEntity)one.getPolymerID(), (HELMEntity)two.getPolymerID(), details);
            connections.add(connection);
        }
        return connections;
    }

    private static boolean validateSiRNADesign(PolymerNotation one, PolymerNotation two, String rnaDesignType) throws RNAUtilsException, HELM2HandledException, org.helm.notation2.parser.exceptionparser.NotationException, ChemistryException {
        if ("NONE".equalsIgnoreCase(rnaDesignType)) {
            return true;
        }
        if (!NucleotideParser.SUPPORTED_DESIGN_LIST.contains(rnaDesignType)) {
            throw new org.helm.notation2.parser.exceptionparser.NotationException("Unsupported RNA Design Type '" + rnaDesignType + "'");
        }
        List<Nucleotide> senseNucList = RNAUtils.getNucleotideList(one);
        List<Nucleotide> antisenseNucList = RNAUtils.getNucleotideList(two);
        if (rnaDesignType.equals("TUSCHL_19_PLUS_2")) {
            if (senseNucList.size() != 21) {
                throw new org.helm.notation2.parser.exceptionparser.NotationException("Sense strand for Tuschl 19+2 design must have 21 nucleotides");
            }
            if (antisenseNucList.size() != 21) {
                throw new org.helm.notation2.parser.exceptionparser.NotationException("Antisense strand for Tuschl 19+2 design must have 21 nucleotides");
            }
        } else if (rnaDesignType.equals("DICER_27_R")) {
            if (senseNucList.size() != 25) {
                throw new org.helm.notation2.parser.exceptionparser.NotationException("Sense strand for Dicer 27R design must have 25 nucleotides");
            }
            if (antisenseNucList.size() != 27) {
                throw new org.helm.notation2.parser.exceptionparser.NotationException("Antisense strand for Dicer 27R design must have 27 nucleotides");
            }
        } else if (rnaDesignType.equals("DICER_27_L")) {
            if (senseNucList.size() != 27) {
                throw new org.helm.notation2.parser.exceptionparser.NotationException("Sense strand for Dicer 27L design must have 27 nucleotides");
            }
            if (antisenseNucList.size() != 25) {
                throw new org.helm.notation2.parser.exceptionparser.NotationException("Antisense strand for Dicer 27L design must have 25 nucleotides");
            }
        }
        return true;
    }

    static {
        complementMap.put("A", "U");
        complementMap.put("G", "C");
        complementMap.put("C", "G");
        complementMap.put("U", "A");
        complementMap.put("T", "A");
        complementMap.put("X", "X");
        LOG = LoggerFactory.getLogger(SiRNANotation.class);
    }
}

