/*
 * Decompiled with CFR 0.152.
 */
package org.helm.notation2.tools;

import java.util.List;
import org.helm.notation2.exception.ChemistryException;
import org.helm.notation2.exception.FastaFormatException;
import org.helm.notation2.exception.HELM2HandledException;
import org.helm.notation2.exception.NotationException;
import org.helm.notation2.exception.NucleotideLoadingException;
import org.helm.notation2.exception.PeptideUtilsException;
import org.helm.notation2.exception.RNAUtilsException;
import org.helm.notation2.parser.notation.HELM2Notation;
import org.helm.notation2.parser.notation.polymer.HELMEntity;
import org.helm.notation2.parser.notation.polymer.PeptideEntity;
import org.helm.notation2.parser.notation.polymer.PolymerElements;
import org.helm.notation2.parser.notation.polymer.PolymerNotation;
import org.helm.notation2.tools.FastaFormat;
import org.helm.notation2.tools.PeptideUtils;
import org.helm.notation2.tools.RNAUtils;

public final class SequenceConverter {
    private SequenceConverter() {
    }

    public static HELM2Notation readPeptide(String notation) throws FastaFormatException, org.helm.notation2.parser.exceptionparser.NotationException, ChemistryException {
        HELM2Notation helm2notation = new HELM2Notation();
        PolymerNotation polymer = new PolymerNotation("PEPTIDE1");
        helm2notation.addPolymer(new PolymerNotation(polymer.getPolymerID(), (PolymerElements)FastaFormat.generateElementsOfPeptide(notation, (HELMEntity)polymer.getPolymerID())));
        return helm2notation;
    }

    public static HELM2Notation readRNA(String notation) throws FastaFormatException, org.helm.notation2.parser.exceptionparser.NotationException, ChemistryException, NucleotideLoadingException {
        HELM2Notation helm2notation = new HELM2Notation();
        PolymerNotation polymer = new PolymerNotation("RNA1");
        if (!FastaFormat.isNormalDirection(notation)) {
            String annotation = "3'-5'";
            helm2notation.addPolymer(new PolymerNotation(polymer.getPolymerID(), (PolymerElements)FastaFormat.generateElementsforRNA(notation, (HELMEntity)polymer.getPolymerID()), annotation));
        } else {
            helm2notation.addPolymer(new PolymerNotation(polymer.getPolymerID(), (PolymerElements)FastaFormat.generateElementsforRNA(notation, (HELMEntity)polymer.getPolymerID())));
        }
        return helm2notation;
    }

    public static String getNucleotideSequenceFromNotation(HELM2Notation helm2notation) throws org.helm.notation2.parser.exceptionparser.NotationException, NucleotideLoadingException, HELM2HandledException, ChemistryException {
        List polymers = helm2notation.getListOfPolymers();
        StringBuffer sb = new StringBuffer();
        for (PolymerNotation polymer : polymers) {
            try {
                sb.append(RNAUtils.getNucleotideSequence(polymer) + " ");
            }
            catch (RNAUtilsException e) {
                e.printStackTrace();
                throw new org.helm.notation2.parser.exceptionparser.NotationException("Input complex notation contains non-nucleic acid polymer");
            }
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    public static String getPeptideSequenceFromNotation(HELM2Notation helm2notation) throws HELM2HandledException, PeptideUtilsException, NotationException, ChemistryException {
        List polymers = helm2notation.getListOfPolymers();
        StringBuffer sb = new StringBuffer();
        for (PolymerNotation polymer : polymers) {
            sb.append(PeptideUtils.getSequence(polymer) + " ");
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    public static String getNucleotideNaturalAnalogSequenceFromNotation(HELM2Notation helm2Notation) throws org.helm.notation2.parser.exceptionparser.NotationException, HELM2HandledException, ChemistryException {
        List polymers = helm2Notation.getListOfPolymers();
        StringBuffer sb = new StringBuffer();
        for (PolymerNotation polymer : polymers) {
            try {
                sb.append(RNAUtils.getNaturalAnalogSequence(polymer) + " ");
            }
            catch (RNAUtilsException e) {
                e.printStackTrace();
                throw new org.helm.notation2.parser.exceptionparser.NotationException("Input complex notation contains non-nucleid acid polymer");
            }
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    public static String getPeptideNaturalAnalogSequenceFromNotation(HELM2Notation helm2Notation) throws HELM2HandledException, PeptideUtilsException, org.helm.notation2.parser.exceptionparser.NotationException, ChemistryException {
        List polymers = helm2Notation.getListOfPolymers();
        StringBuffer sb = new StringBuffer();
        for (PolymerNotation polymer : polymers) {
            if (!(polymer.getPolymerID() instanceof PeptideEntity)) {
                throw new org.helm.notation2.parser.exceptionparser.NotationException("Input complex notation contains non-peptide polymer(s)");
            }
            sb.append(PeptideUtils.getNaturalAnalogueSequence(polymer) + " ");
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }
}

