/*
 * Decompiled with CFR 0.152.
 */
package org.helm.notation2.tools;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.helm.notation2.Nucleotide;
import org.helm.notation2.NucleotideFactory;
import org.helm.notation2.exception.ChemistryException;
import org.helm.notation2.exception.FastaFormatException;
import org.helm.notation2.exception.HELM2HandledException;
import org.helm.notation2.exception.MonomerException;
import org.helm.notation2.exception.NotationException;
import org.helm.notation2.exception.NucleotideLoadingException;
import org.helm.notation2.exception.RNAUtilsException;
import org.helm.notation2.parser.notation.connection.ConnectionNotation;
import org.helm.notation2.parser.notation.polymer.HELMEntity;
import org.helm.notation2.parser.notation.polymer.MonomerNotation;
import org.helm.notation2.parser.notation.polymer.MonomerNotationGroup;
import org.helm.notation2.parser.notation.polymer.MonomerNotationGroupElement;
import org.helm.notation2.parser.notation.polymer.MonomerNotationList;
import org.helm.notation2.parser.notation.polymer.MonomerNotationUnit;
import org.helm.notation2.parser.notation.polymer.MonomerNotationUnitRNA;
import org.helm.notation2.parser.notation.polymer.PolymerNotation;
import org.helm.notation2.parser.notation.polymer.RNAEntity;
import org.helm.notation2.tools.ChangeObjects;
import org.helm.notation2.tools.FastaFormat;
import org.helm.notation2.tools.MethodsMonomerUtils;
import org.helm.notation2.tools.NucleotideParser;
import org.helm.notation2.tools.PolymerUtils;
import org.helm.notation2.tools.SequenceConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RNAUtils {
    private static final Logger LOG = LoggerFactory.getLogger(RNAUtils.class);
    private static Map<String, String> complementMap = null;
    public static final int MINUMUM_MATCH_FRAGMENT_LENGTH = 2;

    private RNAUtils() {
    }

    private static void initComplementMap() {
        complementMap = new HashMap<String, String>();
        complementMap.put("A", "U");
        complementMap.put("G", "C");
        complementMap.put("C", "G");
        complementMap.put("U", "A");
        complementMap.put("T", "A");
        complementMap.put("X", "X");
    }

    public static String getReverseSequence(PolymerNotation polymer) throws RNAUtilsException, HELM2HandledException, NotationException, ChemistryException {
        StringBuilder sb = new StringBuilder(RNAUtils.getNaturalAnalogSequence(polymer));
        return sb.reverse().toString();
    }

    public static String getNaturalAnalogSequence(PolymerNotation polymer) throws HELM2HandledException, RNAUtilsException, ChemistryException {
        RNAUtils.checkRNA(polymer);
        return FastaFormat.generateFastaFromRNA(MethodsMonomerUtils.getListOfHandledMonomers(polymer.getListMonomers()));
    }

    public static boolean areAntiparallel(PolymerNotation polymerOne, PolymerNotation polymerTwo) throws RNAUtilsException, HELM2HandledException, ChemistryException, NucleotideLoadingException {
        RNAUtils.checkRNA(polymerOne);
        RNAUtils.checkRNA(polymerTwo);
        PolymerNotation antiparallel = RNAUtils.getAntiparallel(polymerOne);
        String sequenceOne = FastaFormat.generateFastaFromRNA(MethodsMonomerUtils.getListOfHandledMonomers(antiparallel.getListMonomers()));
        String sequenceTwo = FastaFormat.generateFastaFromRNA(MethodsMonomerUtils.getListOfHandledMonomers(polymerTwo.getListMonomers()));
        return sequenceOne.equals(sequenceTwo);
    }

    public static String getMaxMatchFragment(String seq1, String seq2) throws org.helm.notation2.parser.exceptionparser.NotationException {
        return RNAUtils.getMaxMatchFragment(seq1, seq2, 2);
    }

    public static String getMaxMatchFragment(String seq1, String seq2, int minLength) throws org.helm.notation2.parser.exceptionparser.NotationException {
        String shortSeq;
        String longSeq;
        if (null == seq1 || null == seq2) {
            throw new org.helm.notation2.parser.exceptionparser.NotationException("Both sequences must not be null ");
        }
        if (!seq1.equals(seq1.toUpperCase()) || !seq2.equals(seq2.toUpperCase())) {
            throw new org.helm.notation2.parser.exceptionparser.NotationException("Both sequences must be natural nucleotide sequence in upper case ");
        }
        if (seq1.length() > seq2.length()) {
            longSeq = seq1;
            shortSeq = seq2;
        } else {
            longSeq = seq2;
            shortSeq = seq1;
        }
        longSeq = longSeq.replaceAll("T", "U");
        shortSeq = shortSeq.replaceAll("T", "U");
        int min = 2;
        if (minLength > min) {
            min = minLength;
        }
        for (int len = shortSeq.length(); len > min; --len) {
            for (int i = 0; i <= shortSeq.length() - len; ++i) {
                String tmp = shortSeq.substring(i, i + len);
                if (!longSeq.contains(tmp)) continue;
                return tmp;
            }
        }
        return "";
    }

    public static void removeLastP(PolymerNotation polymer) throws RNAUtilsException, org.helm.notation2.parser.exceptionparser.NotationException, HELM2HandledException {
        RNAUtils.checkRNA(polymer);
        MonomerNotation lastObject = (MonomerNotation)polymer.getPolymerElements().getListOfElements().get(polymer.getPolymerElements().getListOfElements().size() - 1);
        if (lastObject instanceof MonomerNotationGroup || lastObject instanceof MonomerNotationList) {
            throw new HELM2HandledException("HELM2 features are involved");
        }
        if (RNAUtils.hasPhosphat((MonomerNotationUnitRNA)lastObject)) {
            MonomerNotationUnitRNA lastObjectwithoutPhosphat = new MonomerNotationUnitRNA(lastObject.getUnit().substring(0, lastObject.getUnit().length() - 1), "RNA");
            ChangeObjects.changeMonomerNotation(polymer.getPolymerElements().getListOfElements().size() - 1, polymer, (MonomerNotation)lastObjectwithoutPhosphat);
            LOG.info("Last phosphate was removed from the last nucleotide");
        }
    }

    private static boolean hasPhosphat(MonomerNotationUnitRNA monomerNotationUnitRNA) {
        if (((MonomerNotationUnit)monomerNotationUnitRNA.getContents().get(monomerNotationUnitRNA.getContents().size() - 1)).getUnit().endsWith("P")) {
            LOG.info("MonomerNotationUnitRNA " + monomerNotationUnitRNA.getUnit() + " has a phosphate");
            return true;
        }
        LOG.info("MonomerNotationUnitRNA " + monomerNotationUnitRNA.getUnit() + " has no phosphate");
        return false;
    }

    public static void addLastP(PolymerNotation polymer) throws RNAUtilsException, org.helm.notation2.parser.exceptionparser.NotationException, HELM2HandledException {
        RNAUtils.checkRNA(polymer);
        MonomerNotation lastObject = (MonomerNotation)polymer.getPolymerElements().getListOfElements().get(polymer.getPolymerElements().getListOfElements().size() - 1);
        if (lastObject instanceof MonomerNotationGroup || lastObject instanceof MonomerNotationList) {
            throw new HELM2HandledException("HELM2 features are involved");
        }
        if (!RNAUtils.hasPhosphat((MonomerNotationUnitRNA)lastObject)) {
            MonomerNotationUnitRNA lastObjectwithPhosphat = new MonomerNotationUnitRNA(lastObject.getUnit() + "P", "RNA");
            ChangeObjects.changeMonomerNotation(polymer.getPolymerElements().getListOfElements().size() - 1, polymer, (MonomerNotation)lastObjectwithPhosphat);
            LOG.info("Phosphate was added to the last nucleotide");
        }
    }

    public static PolymerNotation getAntiparallel(PolymerNotation polymer) throws RNAUtilsException, ChemistryException, NucleotideLoadingException {
        RNAUtils.checkRNA(polymer);
        try {
            PolymerNotation reversePolymer = SequenceConverter.readRNA(RNAUtils.generateAntiparallel(polymer)).getCurrentPolymer();
            reversePolymer = new PolymerNotation(reversePolymer.getPolymerID(), reversePolymer.getPolymerElements(), "Antiparallel to " + polymer.getPolymerID().getId());
            return reversePolymer;
        }
        catch (FastaFormatException | HELM2HandledException | org.helm.notation2.parser.exceptionparser.NotationException e) {
            e.printStackTrace();
            throw new RNAUtilsException("The reverse polymer can not be built");
        }
    }

    private static String generateAntiparallel(PolymerNotation polymer) throws HELM2HandledException, RNAUtilsException, ChemistryException {
        return RNAUtils.generateComplement(polymer).reverse().toString();
    }

    public static PolymerNotation getInverse(PolymerNotation polymer) throws RNAUtilsException, NotationException, ChemistryException, NucleotideLoadingException {
        RNAUtils.checkRNA(polymer);
        try {
            PolymerNotation inverse = (PolymerNotation)SequenceConverter.readRNA(RNAUtils.generateInverse(polymer).toString()).getListOfPolymers().get(0);
            inverse = new PolymerNotation(inverse.getPolymerID(), inverse.getPolymerElements(), "Inverse to " + polymer.getPolymerID().getId());
            return inverse;
        }
        catch (FastaFormatException | HELM2HandledException | org.helm.notation2.parser.exceptionparser.NotationException e) {
            e.printStackTrace();
            throw new RNAUtilsException("The inverse strand can not be built");
        }
    }

    public static PolymerNotation getReverseComplement(PolymerNotation polymer) throws RNAUtilsException, NotationException, ChemistryException, NucleotideLoadingException {
        RNAUtils.checkRNA(polymer);
        try {
            PolymerNotation complementReversePolymer = (PolymerNotation)SequenceConverter.readRNA(RNAUtils.generateReverseComplement(polymer).toString()).getListOfPolymers().get(0);
            complementReversePolymer = new PolymerNotation(complementReversePolymer.getPolymerID(), complementReversePolymer.getPolymerElements(), "ReverseComplement to " + polymer.getPolymerID().getId());
            return complementReversePolymer;
        }
        catch (FastaFormatException | HELM2HandledException | org.helm.notation2.parser.exceptionparser.NotationException e) {
            e.printStackTrace();
            throw new RNAUtilsException("Complement polymer can not be built");
        }
    }

    private static StringBuilder generateReverseComplement(PolymerNotation polymer) throws HELM2HandledException, RNAUtilsException, NotationException, ChemistryException {
        RNAUtils.initComplementMap();
        String sequence = RNAUtils.getNaturalAnalogSequence(polymer);
        StringBuilder sb = new StringBuilder();
        for (char c : sequence.toCharArray()) {
            sb.append(complementMap.get(String.valueOf(c)));
        }
        return sb.reverse();
    }

    private static StringBuilder generateInverse(PolymerNotation polymer) throws HELM2HandledException, RNAUtilsException, NotationException, ChemistryException {
        RNAUtils.initComplementMap();
        String sequence = RNAUtils.getNaturalAnalogSequence(polymer);
        StringBuilder sb = new StringBuilder(sequence);
        return sb.reverse();
    }

    private static StringBuilder generateComplement(PolymerNotation polymer) throws HELM2HandledException, RNAUtilsException, ChemistryException {
        RNAUtils.initComplementMap();
        String sequence = RNAUtils.getNaturalAnalogSequence(polymer);
        StringBuilder sb = new StringBuilder();
        for (char c : sequence.toCharArray()) {
            sb.append(complementMap.get(String.valueOf(c)));
        }
        return sb;
    }

    public static PolymerNotation getComplement(PolymerNotation polymer) throws RNAUtilsException, ChemistryException, NucleotideLoadingException {
        RNAUtils.checkRNA(polymer);
        try {
            PolymerNotation complementPolymer = (PolymerNotation)SequenceConverter.readRNA(RNAUtils.generateComplement(polymer).toString()).getListOfPolymers().get(0);
            complementPolymer = new PolymerNotation(complementPolymer.getPolymerID(), complementPolymer.getPolymerElements(), "NormalComplement to " + polymer.getPolymerID().getId());
            return complementPolymer;
        }
        catch (FastaFormatException | HELM2HandledException | org.helm.notation2.parser.exceptionparser.NotationException e) {
            e.printStackTrace();
            throw new RNAUtilsException("Complement polymer can not be built");
        }
    }

    public static boolean hasNucleotideModification(PolymerNotation polymer) throws org.helm.notation2.parser.exceptionparser.NotationException {
        for (MonomerNotation current : polymer.getPolymerElements().getListOfElements()) {
            if (!RNAUtils.hasModification(current)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasModification(MonomerNotation monomerNotation) throws org.helm.notation2.parser.exceptionparser.NotationException {
        if (monomerNotation instanceof MonomerNotationUnitRNA) {
            if (RNAUtils.hasModification((MonomerNotationUnitRNA)monomerNotation)) {
                return true;
            }
        } else if (monomerNotation instanceof MonomerNotationGroup) {
            for (MonomerNotationGroupElement element : ((MonomerNotationGroup)monomerNotation).getListOfElements()) {
                if (!RNAUtils.hasModification(element.getMonomerNotation())) continue;
                return true;
            }
        } else if (monomerNotation instanceof MonomerNotationList) {
            for (MonomerNotation element : ((MonomerNotationList)monomerNotation).getListofMonomerUnits()) {
                if (!RNAUtils.hasModification(element)) continue;
                return true;
            }
        } else {
            throw new org.helm.notation2.parser.exceptionparser.NotationException("Unknown MonomerNotation Type " + monomerNotation.getClass());
        }
        return false;
    }

    private static boolean hasModification(MonomerNotationUnitRNA monomerNotation) {
        return monomerNotation.getUnit().contains("[") || monomerNotation.getUnit().contains("(X)") || monomerNotation.getUnit().endsWith(")");
    }

    public static List<ConnectionNotation> hybridizeAntiparallel(PolymerNotation one, PolymerNotation two) throws RNAUtilsException, org.helm.notation2.parser.exceptionparser.NotationException, HELM2HandledException, ChemistryException, NucleotideLoadingException {
        RNAUtils.checkRNA(one);
        RNAUtils.checkRNA(two);
        ArrayList<ConnectionNotation> connections = new ArrayList<ConnectionNotation>();
        if (RNAUtils.areAntiparallel(one, two)) {
            for (int i = 0; i < PolymerUtils.getTotalMonomerCount(one); ++i) {
                int backValue = PolymerUtils.getTotalMonomerCount(one) - i;
                int firstValue = i + 1;
                String details = firstValue + ":pair-" + backValue + ":pair";
                ConnectionNotation connection = new ConnectionNotation((HELMEntity)one.getPolymerID(), (HELMEntity)two.getPolymerID(), details);
                connections.add(connection);
            }
            return connections;
        }
        throw new RNAUtilsException("The given RNAs are not antiparallel to each other");
    }

    public static String getSequence(PolymerNotation one) throws RNAUtilsException, HELM2HandledException, ChemistryException {
        RNAUtils.checkRNA(one);
        List<Nucleotide> nucleotideList = RNAUtils.getNucleotideList(one);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < nucleotideList.size(); ++i) {
            sb.append(nucleotideList.get(i).getNaturalAnalog());
        }
        return sb.toString();
    }

    public static String getModifiedNucleotideSequence(PolymerNotation polymer) throws RNAUtilsException, HELM2HandledException, ChemistryException {
        RNAUtils.checkRNA(polymer);
        List<Nucleotide> nucleotides = RNAUtils.getNucleotideList(polymer);
        StringBuilder sb = new StringBuilder();
        for (Nucleotide nucleotide : nucleotides) {
            sb.append(nucleotide.getSymbol());
        }
        return sb.toString();
    }

    public static List<ConnectionNotation> hybridize(PolymerNotation one, PolymerNotation two) throws RNAUtilsException, org.helm.notation2.parser.exceptionparser.NotationException, HELM2HandledException, NotationException, ChemistryException {
        RNAUtils.initComplementMap();
        RNAUtils.checkRNA(one);
        RNAUtils.checkRNA(two);
        ArrayList<ConnectionNotation> connections = new ArrayList<ConnectionNotation>();
        String seq1 = RNAUtils.getSequence(one).replaceAll("T", "U");
        String seq2 = RNAUtils.getSequence(two).replaceAll("T", "U");
        char[] chars = seq2.toCharArray();
        StringBuffer sb = new StringBuffer();
        for (int i = chars.length; i > 0; --i) {
            String symbol = String.valueOf(chars[i - 1]);
            String compSymbol = complementMap.get(symbol);
            sb.append(compSymbol);
        }
        String compSeq2 = sb.toString();
        String maxSeqMatch = RNAUtils.getMaxMatchFragment(seq1, compSeq2);
        int seqMatchLength = maxSeqMatch.length();
        int seq1NucStart = -1;
        int seq1MonomerStart = 0;
        int seq2NucStart = -1;
        int seq2MonomerStart = 0;
        List<Nucleotide> seq1NucList = RNAUtils.getNucleotideList(one);
        List<Nucleotide> seq2NucList = RNAUtils.getNucleotideList(two);
        if (seqMatchLength > 0) {
            int i;
            seq1NucStart = seq1.indexOf(maxSeqMatch);
            for (int i2 = 0; i2 < seq1NucStart; ++i2) {
                Nucleotide nuc = seq1NucList.get(i2);
                int monomerCount = NucleotideParser.getMonomerCountForRNA(nuc.getNotation());
                seq1MonomerStart += monomerCount;
            }
            int compSeq2NucStart = compSeq2.indexOf(maxSeqMatch);
            seq2NucStart = seq2.length() - seqMatchLength - compSeq2NucStart;
            for (i = 0; i < seq2NucStart; ++i) {
                Nucleotide nuc = seq2NucList.get(i);
                int monomerCount = NucleotideParser.getMonomerCountForRNA(nuc.getNotation());
                seq2MonomerStart += monomerCount;
            }
            for (i = 0; i < seqMatchLength; ++i) {
                Nucleotide nuc1 = seq1NucList.get(i + seq1NucStart);
                if (null == nuc1.getBaseMonomer()) {
                    throw new org.helm.notation2.parser.exceptionparser.NotationException("Nucleotide without base cannot be hybridized with others");
                }
                seq1MonomerStart = i == 0 ? (seq1MonomerStart += 2) : (seq1MonomerStart += 3);
                Nucleotide nuc2 = seq2NucList.get(i + seq2NucStart);
                if (null == nuc2.getBaseMonomer()) {
                    throw new org.helm.notation2.parser.exceptionparser.NotationException("Nucleotide without base cannot be hybridized with others");
                }
                if (i == 0) {
                    seq2MonomerStart += 2;
                    continue;
                }
                seq2MonomerStart += 3;
            }
            for (i = seqMatchLength; i > 0; --i) {
                int seq1MonomerPos = seq1MonomerStart - (i - 1) * 3;
                int seq2MonomerPos = seq2MonomerStart - (seqMatchLength - i) * 3;
                String details = seq1MonomerPos + ":pair-" + seq2MonomerPos + ":pair";
                ConnectionNotation connection = new ConnectionNotation((HELMEntity)one.getPolymerID(), (HELMEntity)two.getPolymerID(), details);
                connections.add(connection);
            }
        }
        return connections;
    }

    private static void checkRNA(PolymerNotation polymer) throws RNAUtilsException {
        if (!(polymer.getPolymerID() instanceof RNAEntity)) {
            throw new RNAUtilsException("Functions can only be called for RNA/DNA");
        }
    }

    public static String getNucleotideSequence(PolymerNotation polymer) throws org.helm.notation2.parser.exceptionparser.NotationException, RNAUtilsException, HELM2HandledException, NucleotideLoadingException, ChemistryException {
        List<Nucleotide> nucleotides = RNAUtils.getNucleotideList(polymer);
        StringBuffer sb = new StringBuffer();
        int count = 0;
        Map<String, String> reverseNucMap = NucleotideFactory.getInstance().getReverseNucleotideTemplateMap();
        for (Nucleotide nuc : nucleotides) {
            String nucleotide = nuc.getNotation();
            String nucleoside = nuc.getNucleosideNotation();
            String linker = nuc.getLinkerNotation();
            if (count == 0 && nucleoside.length() == 0) {
                sb.append(nuc.getPhosphateMonomer().getAlternateId());
                ++count;
                continue;
            }
            if (count == nucleotides.size() - 1 && linker.length() == 0) {
                nucleotide = nucleotide + "P";
            }
            if (!reverseNucMap.containsKey(nucleotide)) {
                throw new org.helm.notation2.parser.exceptionparser.NotationException("Unknown nucleotide found for " + nucleotide + " : missing nucleotide template");
            }
            sb.append(reverseNucMap.get(nucleotide));
            ++count;
        }
        return sb.toString();
    }

    public static List<Nucleotide> getNucleotideList(PolymerNotation polymer) throws RNAUtilsException, HELM2HandledException, ChemistryException {
        RNAUtils.checkRNA(polymer);
        ArrayList<Nucleotide> nucleotides = new ArrayList<Nucleotide>();
        List monomerNotations = polymer.getPolymerElements().getListOfElements();
        for (int i = 0; i < monomerNotations.size(); ++i) {
            MonomerNotation monomerNotation = (MonomerNotation)monomerNotations.get(i);
            if (!(monomerNotation instanceof MonomerNotationUnitRNA) || Integer.parseInt(monomerNotation.getCount()) != 1) {
                LOG.info("MonomerNotation contains HELM2 Elements " + monomerNotation);
                throw new HELM2HandledException("HELM2 Elements are involved");
            }
            try {
                boolean last = false;
                if (i == monomerNotations.size() - 1) {
                    last = true;
                }
                nucleotides.add(NucleotideParser.convertToNucleotide(monomerNotation.getUnit(), last));
                continue;
            }
            catch (MonomerException | NotationException | NucleotideLoadingException | org.helm.notation2.parser.exceptionparser.NotationException e) {
                e.printStackTrace();
                throw new RNAUtilsException("Nucleotide can not be read " + e.getMessage());
            }
        }
        return nucleotides;
    }

    public static String getTrimmedNucleotideSequence(PolymerNotation polymer) throws RNAUtilsException, HELM2HandledException, ChemistryException {
        RNAUtils.checkRNA(polymer);
        List<Nucleotide> list = RNAUtils.getNucleotideList(polymer);
        int start = 0;
        Nucleotide na = list.get(start);
        while (null == na.getBaseMonomer()) {
            na = list.get(++start);
        }
        int end = list.size() - 1;
        na = list.get(end);
        while (null == na.getBaseMonomer()) {
            na = list.get(--end);
        }
        StringBuffer sb = new StringBuffer();
        for (int i = start; i <= end; ++i) {
            sb.append(list.get(i).getNaturalAnalog());
        }
        return sb.toString();
    }
}

