/*
 * Decompiled with CFR 0.152.
 */
package org.helm.notation2.tools;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.IOUtils;
import org.helm.notation2.exception.EncoderException;
import org.helm.notation2.tools.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MolfileEncoder {
    private static final Logger LOG = LoggerFactory.getLogger(MolfileEncoder.class);

    public static String encode(String string) throws EncoderException {
        String result = null;
        if (null != string) {
            result = MolfileEncoder.compress(string);
            return result;
        }
        return null;
    }

    public static String decode(String encodedString) throws EncoderException {
        String result = null;
        if (null != encodedString) {
            result = MolfileEncoder.decompress(encodedString);
            return result;
        }
        return null;
    }

    private static String compress(String str) throws EncoderException {
        String string;
        ByteArrayOutputStream rstBao = null;
        GZIPOutputStream zos = null;
        try {
            rstBao = new ByteArrayOutputStream();
            zos = new GZIPOutputStream(rstBao);
            zos.write(str.getBytes());
            IOUtils.closeQuietly((OutputStream)zos);
            byte[] bytes = rstBao.toByteArray();
            string = Base64.encodeToString(bytes, false);
        }
        catch (Exception e) {
            try {
                throw new EncoderException("Molfile could not be compressed. " + str);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(zos);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)zos);
        return string;
    }

    private static String decompress(String str) throws EncoderException {
        String string;
        Object result = null;
        byte[] bytes = Base64.decode(str);
        GZIPInputStream zi = null;
        try {
            String read;
            zi = new GZIPInputStream(new ByteArrayInputStream(bytes));
            InputStreamReader reader = new InputStreamReader(zi);
            BufferedReader in = new BufferedReader(reader);
            StringBuilder sb = new StringBuilder();
            while ((read = in.readLine()) != null) {
                sb.append(read + "\n");
            }
            String molfile = sb.toString();
            reader.close();
            in.close();
            zi.close();
            string = molfile;
        }
        catch (IOException e) {
            try {
                throw new EncoderException("Molfile could not be decompressed. " + str);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(zi);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)zi);
        return string;
    }
}

