/*
 * Decompiled with CFR 0.152.
 */
package org.helm.notation2.calculation;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.helm.notation2.Monomer;
import org.helm.notation2.exception.CalculationException;
import org.helm.notation2.exception.ChemistryException;
import org.helm.notation2.exception.ExtinctionCoefficientException;
import org.helm.notation2.exception.HELM2HandledException;
import org.helm.notation2.exception.NotationException;
import org.helm.notation2.parser.notation.HELM2Notation;
import org.helm.notation2.parser.notation.polymer.PolymerNotation;
import org.helm.notation2.tools.MethodsMonomerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExtinctionCoefficient {
    private static final int UNIT = 1000;
    private static final Logger LOG = LoggerFactory.getLogger(ExtinctionCoefficient.class);
    public static final int RNA_UNIT_TYPE = 1;
    public static final int PEPTIDE_UNIT_TYPE = 2;
    private static Map<String, Float> monoNucleotideMap = new HashMap<String, Float>();
    private static Map<String, Float> diNucleotideMap = new HashMap<String, Float>();
    private static Map<String, Float> aminoAcidMap = new HashMap<String, Float>();
    private static String rnaPropertyFile = "/org/helm/notation2/resources/RNAExtinctionCoefficient.properties";
    private static String peptidePropertyFile = "/org/helm/notation2/resources/PEPTIDEExtinctionCoefficient.properties";
    private static ExtinctionCoefficient instance;

    private ExtinctionCoefficient() {
    }

    public static ExtinctionCoefficient getInstance() throws ExtinctionCoefficientException {
        if (null == instance) {
            instance = new ExtinctionCoefficient();
            try {
                ExtinctionCoefficient.initMaps();
            }
            catch (IOException ex) {
                throw new ExtinctionCoefficientException("Unable to initalize extinction coefficient property files");
            }
        }
        return instance;
    }

    private static void initMaps() throws IOException {
        InputStream ris = ExtinctionCoefficient.class.getResourceAsStream(rnaPropertyFile);
        Properties rp = new Properties();
        rp.load(ris);
        Enumeration<?> re = rp.propertyNames();
        while (re.hasMoreElements()) {
            String key = (String)re.nextElement();
            String value = rp.getProperty(key);
            Float f = new Float(value);
            int len = key.length();
            if (len == 1) {
                monoNucleotideMap.put(key, f);
                continue;
            }
            if (len != 2) continue;
            diNucleotideMap.put(key, f);
        }
        ris.close();
        InputStream pis = ExtinctionCoefficient.class.getResourceAsStream(peptidePropertyFile);
        Properties pp = new Properties();
        pp.load(pis);
        Enumeration<?> pe = pp.propertyNames();
        while (pe.hasMoreElements()) {
            String key = (String)pe.nextElement();
            String value = pp.getProperty(key);
            Float f = new Float(value);
            aminoAcidMap.put(key, f);
        }
        pis.close();
    }

    public String getUnit(int unitType) {
        switch (unitType) {
            case 1: {
                return this.getRnaUnit();
            }
            case 2: {
                return this.getPeptideUnit();
            }
        }
        return null;
    }

    public String getRnaUnit() {
        return "mM-1cm-1";
    }

    public String getPeptideUnit() {
        return "M-1cm-1";
    }

    public String getDefaultUnit() {
        return this.getRnaUnit();
    }

    public int getDefaultUnitType() {
        return 1;
    }

    public float calculate(HELM2Notation helm2notation) throws ExtinctionCoefficientException, ChemistryException {
        return this.calculate(helm2notation, this.getDefaultUnitType());
    }

    public float calculate(HELM2Notation helm2notation, int unitType) throws ExtinctionCoefficientException, ChemistryException {
        LOG.debug("ExtinctionCalculation is starting with the unitType: " + unitType);
        float result = 0.0f;
        List polymerNodes = helm2notation.getListOfPolymers();
        for (PolymerNotation polymerNode : polymerNodes) {
            String polymerType = polymerNode.getPolymerID().getType();
            float ext = 0.0f;
            ArrayList<PolymerNotation> not = new ArrayList<PolymerNotation>();
            not.add(polymerNode);
            if (polymerType.equals("RNA")) {
                try {
                    ext = ExtinctionCoefficient.calculateExtinctionFromRNA(MethodsMonomerUtils.getListOfHandledMonomersOnlyBase(polymerNode.getPolymerElements().getListOfElements()));
                }
                catch (IOException | CalculationException | HELM2HandledException | NotationException e) {
                    throw new ExtinctionCoefficientException(e.getMessage());
                }
                if (unitType == 2) {
                    ext *= 1000.0f;
                }
            } else if (polymerType.equals("PEPTIDE")) {
                try {
                    ext = ExtinctionCoefficient.calculateExtinctionFromPeptide(MethodsMonomerUtils.getListOfHandledMonomers(polymerNode.getPolymerElements().getListOfElements()));
                }
                catch (IOException | HELM2HandledException e) {
                    throw new ExtinctionCoefficientException(e.getMessage());
                }
                if (unitType == 1) {
                    ext /= 1000.0f;
                }
            }
            result += ext;
        }
        return result;
    }

    private static float calculateExtinctionFromRNA(List<Monomer> monomers) throws CalculationException, IOException {
        LOG.debug("ExtinctionCalculation of RNA");
        float resultSingle = 0.0f;
        float resultDi = 0.0f;
        String previous = "";
        if (monomers.size() == 0) {
            throw new CalculationException("Input sequence cannot be null");
        }
        if (monomers.size() == 1) {
            if (monoNucleotideMap.containsKey(monomers.get(0).getNaturalAnalog())) {
                return monoNucleotideMap.get(monomers.get(0).getNaturalAnalog()).floatValue();
            }
            throw new CalculationException("Unknown nucleotide found");
        }
        for (int i = 0; i < monomers.size(); ++i) {
            Float value;
            if (i > 0 && i < monomers.size() - 1 && monoNucleotideMap.containsKey(monomers.get(i).getNaturalAnalog())) {
                value = Float.valueOf(monoNucleotideMap.get(monomers.get(i).getNaturalAnalog()).floatValue());
                resultSingle = (float)((double)resultSingle + (double)value.floatValue() * 1.0);
            }
            if (previous != "" && diNucleotideMap.containsKey(previous + monomers.get(i).getNaturalAnalog())) {
                value = Float.valueOf(diNucleotideMap.get(previous + monomers.get(i).getNaturalAnalog()).floatValue());
                resultDi = (float)((double)resultDi + (double)value.floatValue() * 1.0);
            }
            previous = monomers.get(i).getNaturalAnalog();
        }
        resultSingle = BigDecimal.valueOf(resultSingle).floatValue();
        resultDi = BigDecimal.valueOf(resultDi).floatValue();
        return 2.0f * resultDi - resultSingle;
    }

    private static float calculateExtinctionFromPeptide(List<Monomer> monomers) throws IOException, HELM2HandledException {
        if (null == monomers || monomers.isEmpty()) {
            return 0.0f;
        }
        HashMap<String, Integer> countMap = new HashMap<String, Integer>();
        for (Monomer monomer : monomers) {
            if (!aminoAcidMap.containsKey(monomer.getAlternateId())) continue;
            int count = 1;
            if (countMap.containsKey(monomer.getAlternateId())) {
                count += ((Integer)countMap.get(monomer.getAlternateId())).intValue();
            }
            countMap.put(monomer.getAlternateId(), count);
        }
        float result = 0.0f;
        Set keys = countMap.keySet();
        for (String key : keys) {
            int count = (Integer)countMap.get(key);
            float factor = aminoAcidMap.get(key).floatValue();
            result += factor * (float)count;
        }
        return BigDecimal.valueOf(result).floatValue();
    }
}

