/*
 * Decompiled with CFR 0.152.
 */
package org.helm.notation2;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.helm.chemtoolkit.AbstractMolecule;
import org.helm.chemtoolkit.CTKException;
import org.helm.chemtoolkit.IAtomBase;
import org.helm.chemtoolkit.MoleculeInfo;
import org.helm.notation2.Attachment;
import org.helm.notation2.Chemistry;
import org.helm.notation2.MoleculeProperty;
import org.helm.notation2.exception.ChemistryException;
import org.helm.notation2.tools.BuilderMolecule;

public class Monomer
implements Serializable {
    public static final String NUCLIEC_ACID_POLYMER_TYPE = "RNA";
    public static final String PEPTIDE_POLYMER_TYPE = "PEPTIDE";
    public static final String CHEMICAL_POLYMER_TYPE = "CHEM";
    public static final String[] SUPPORTED_POLYMER_TYPES = new String[]{"RNA", "PEPTIDE", "CHEM"};
    public static final String BACKBONE_MOMONER_TYPE = "Backbone";
    public static final String BRANCH_MOMONER_TYPE = "Branch";
    public static final String UNDEFINED_MOMONER_TYPE = "Undefined";
    public static final String STARTING_NAME = "5";
    public static final String ATTACHMENT_LIST_DELIMITER = "$";
    private int id;
    private String alternateId;
    private String naturalAnalog;
    private String name = "";
    private String canSMILES;
    private String molfile;
    private String monomerType;
    private String polymerType;
    private List<Attachment> attachmentList = new ArrayList<Attachment>();
    private boolean newMonomer;
    private boolean adHocMonomer;
    public static final String ID_A = "A";
    public static final String ID_G = "G";
    public static final String ID_C = "C";
    public static final String ID_U = "U";
    public static final String ID_T = "T";
    public static final String ID_R = "R";
    public static final String ID_dR = "dR";
    public static final String ID_P = "P";
    public static final String ID_X = "X";
    public static final String ID_ALA = "Ala";
    public static final String ID_ARG = "Arg";
    public static final String ID_ASN = "Asn";
    public static final String ID_ASP = "Asp";
    public static final String ID_CYS = "Cys";
    public static final String ID_GLU = "Glu";
    public static final String ID_GLN = "Gln";
    public static final String ID_GLY = "Gly";
    public static final String ID_HIS = "His";
    public static final String ID_ILE = "Ile";
    public static final String ID_LEU = "Leu";
    public static final String ID_LYS = "Lys";
    public static final String ID_MET = "Met";
    public static final String ID_PHE = "Phe";
    public static final String ID_PRO = "Pro";
    public static final String ID_SER = "Ser";
    public static final String ID_THR = "Thr";
    public static final String ID_TRP = "Trp";
    public static final String ID_TYR = "Tyr";
    public static final String ID_VAL = "Val";
    public static final String ID_CHEMICAL_STRUCTURE = "chemical structure";

    public Monomer() {
    }

    public Monomer(String polymerType, String monomerType, String naturalAnalog, String alternateId) {
        this.setPolymerType(polymerType);
        this.setMonomerType(monomerType);
        this.setNaturalAnalog(naturalAnalog);
        this.setAlternateId(alternateId);
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getAlternateId() {
        return this.alternateId;
    }

    public void setAlternateId(String alternateId) {
        this.alternateId = alternateId;
    }

    public String getNaturalAnalog() {
        if (this.alternateId.length() == 1) {
            return this.alternateId;
        }
        return this.naturalAnalog;
    }

    public void setNaturalAnalog(String naturalAnalog) {
        this.naturalAnalog = naturalAnalog;
    }

    public void setAdHocMonomer(boolean adHocMonomer) {
        this.adHocMonomer = adHocMonomer;
    }

    public boolean isAdHocMonomer() {
        return this.adHocMonomer;
    }

    public String getCanSMILES() {
        return this.canSMILES;
    }

    public void setCanSMILES(String canSMILES) {
        this.canSMILES = canSMILES;
    }

    public String getMonomerType() {
        return this.monomerType;
    }

    public void setMonomerType(String monomerType) {
        this.monomerType = monomerType;
    }

    public String getPolymerType() {
        return this.polymerType;
    }

    public void setPolymerType(String polymerType) {
        this.polymerType = polymerType;
    }

    public List<Attachment> getAttachmentList() {
        return this.attachmentList;
    }

    public void setAttachmentList(List<Attachment> attachmentList) {
        this.attachmentList = attachmentList;
    }

    public String getMolfile() {
        return this.molfile;
    }

    public void setMolfile(String molfile) {
        this.molfile = molfile;
    }

    public Attachment getAttachment(String label) {
        for (Attachment attachment : this.attachmentList) {
            if (!attachment.getLabel().equalsIgnoreCase(label)) continue;
            return attachment;
        }
        return null;
    }

    public MoleculeProperty getCapMoleculeInfo(String label) throws CTKException, ChemistryException, IOException {
        for (Attachment attachment : this.attachmentList) {
            if (!attachment.getLabel().equalsIgnoreCase(label)) continue;
            String capSmi = attachment.getCapGroupSMILES();
            MoleculeInfo info = Chemistry.getInstance().getManipulator().getMoleculeInfo(Chemistry.getInstance().getManipulator().getMolecule(capSmi, null));
            MoleculeProperty moleculeinfo = new MoleculeProperty();
            moleculeinfo.setExactMass(info.getExactMass());
            moleculeinfo.setMolecularFormula(info.getMolecularFormula());
            moleculeinfo.setMolecularWeight(info.getMolecularWeight());
            return moleculeinfo;
        }
        return null;
    }

    public boolean addAttachment(Attachment attachment) {
        boolean isExist = false;
        for (Attachment a : this.attachmentList) {
            if (!a.getLabel().equalsIgnoreCase(attachment.getLabel())) continue;
            isExist = true;
        }
        if (!isExist) {
            return this.attachmentList.add(attachment);
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isModified() {
        return this.alternateId.length() > 1;
    }

    public boolean isSameType(Monomer m) {
        String analog2;
        String analog1 = this.getNaturalAnalog();
        if (null == analog1) {
            analog1 = this.getAlternateId();
        }
        if (null == (analog2 = m.getNaturalAnalog())) {
            analog2 = m.getAlternateId();
        }
        return this.getMonomerType().equals(m.getMonomerType()) && this.getPolymerType().equals(m.getPolymerType()) && analog1.equals(analog2);
    }

    public String getAttachmentListString() {
        StringBuilder sb = new StringBuilder();
        List<Attachment> al = this.getAttachmentList();
        ArrayList<String> l = new ArrayList<String>();
        for (Attachment a : al) {
            l.add(a.getAlternateId());
        }
        Collections.sort(l);
        for (int i = 0; i < l.size(); ++i) {
            if (sb.length() > 0) {
                sb.append(ATTACHMENT_LIST_DELIMITER);
            }
            sb.append((String)l.get(i));
        }
        return sb.toString();
    }

    public boolean isNewMonomer() {
        return this.newMonomer;
    }

    public void setNewMonomer(boolean newMonomer) {
        this.newMonomer = newMonomer;
    }

    public boolean attachmentEquals(Monomer monomer) {
        String tmpListString = this.getAttachmentListString();
        String monomerListString = monomer.getAttachmentListString();
        return tmpListString.equals(monomerListString);
    }

    public boolean attachmentContains(Monomer monomer) {
        String monomerListString;
        String tmpListString = this.getAttachmentListString();
        int index = tmpListString.indexOf(monomerListString = monomer.getAttachmentListString());
        return index >= 0;
    }

    public boolean containAnyAtom() throws IOException, CTKException, ChemistryException {
        boolean containsA = false;
        String smiles = this.getCanSMILES();
        if (null != smiles && smiles.length() > 0) {
            AbstractMolecule mol = BuilderMolecule.getMolecule(smiles);
            List atoms = mol.getIAtomArray();
            for (IAtomBase atom : atoms) {
                String symbol = atom.getMolAtom().toString();
                if (!"[A]".contains(symbol)) continue;
                containsA = true;
                break;
            }
        }
        return containsA;
    }

    public static Monomer fromJSON(String json) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            Monomer mon = (Monomer)mapper.readValue(json, Monomer.class);
            return mon;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String toJSON() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            String jsonINString = mapper.writeValueAsString((Object)this);
            jsonINString = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this);
            return jsonINString;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

