/*
 * Decompiled with CFR 0.152.
 */
package org.helm.chemtoolkit.chemaxon;

import chemaxon.formats.MolImporter;
import chemaxon.marvin.MolPrinter;
import chemaxon.marvin.calculations.ElementalAnalyserPlugin;
import chemaxon.marvin.io.MolExportException;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageOutputStream;
import org.helm.chemtoolkit.AbstractChemistryManipulator;
import org.helm.chemtoolkit.AbstractMolecule;
import org.helm.chemtoolkit.AttachmentList;
import org.helm.chemtoolkit.CTKException;
import org.helm.chemtoolkit.CTKSmilesException;
import org.helm.chemtoolkit.IAtomBase;
import org.helm.chemtoolkit.IBondBase;
import org.helm.chemtoolkit.IChemObjectBase;
import org.helm.chemtoolkit.IStereoElementBase;
import org.helm.chemtoolkit.MoleculeInfo;
import org.helm.chemtoolkit.chemaxon.ChemAtom;
import org.helm.chemtoolkit.chemaxon.ChemBond;
import org.helm.chemtoolkit.chemaxon.ChemMolecule;
import org.helm.chemtoolkit.chemaxon.ChemStereoElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChemaxonManipulator
extends AbstractChemistryManipulator {
    private static final Logger LOG = LoggerFactory.getLogger(ChemaxonManipulator.class);
    public static final String UNIQUE_SMILES_FORMAT = "smiles:u";
    public static final String SMILES_FORMAT = "smiles";
    private static final String MOL_FORMAT = "mol";
    public static final String CHEMAXON_EXTENDEND_SMILES_FORMAT = "cxsmiles:u-e";

    public String convert(String data, AbstractChemistryManipulator.StType type) throws CTKException {
        String result = null;
        switch (type) {
            case SMILES: {
                result = this.convertSMILES2MolFile(data);
                break;
            }
            case MOLFILE: {
                result = this.convertMolFile2SMILES(data);
                break;
            }
            case SEQUENCE: {
                try {
                    result = this.molecule2MolFile(this.getMolecule(data));
                }
                catch (MolExportException e) {
                    new CTKException(e.getMessage(), (Throwable)e);
                }
                catch (IOException e) {
                    new CTKException(e.getMessage(), (Throwable)e);
                }
                break;
            }
        }
        return result;
    }

    private String molecule2MolFile(Molecule molecule) throws MolExportException {
        molecule.clean(2, null);
        molecule.dearomatize();
        return molecule.exportToFormat(MOL_FORMAT);
    }

    private String molecule2SMILES(Molecule molecule) throws MolExportException {
        molecule.dearomatize();
        return molecule.exportToFormat(SMILES_FORMAT);
    }

    public boolean validateSMILES(String smiles) {
        try {
            Molecule mol = this.getMolecule(smiles);
            for (int i = 0; i < mol.getAtomCount(); ++i) {
                MolAtom a = mol.getAtom(i);
                a.valenceCheck();
                if (!a.hasValenceError()) continue;
                return false;
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public MoleculeInfo getMoleculeInfo(AbstractMolecule aMolecule) throws CTKException {
        MoleculeInfo moleculeInfo;
        Molecule molecule = ((ChemMolecule)aMolecule).getMolecule();
        try {
            ElementalAnalyserPlugin plugin = new ElementalAnalyserPlugin();
            plugin.setMolecule(molecule);
            plugin.run();
            moleculeInfo = new MoleculeInfo();
            moleculeInfo.setMolecularFormula(plugin.getFormula());
            moleculeInfo.setMolecularWeight(plugin.getMass());
            moleculeInfo.setExactMass(plugin.getExactMass());
        }
        catch (PluginException e) {
            throw new CTKException("unable to analyse molecule", (Throwable)e);
        }
        return moleculeInfo;
    }

    private String convertSMILES2MolFile(String smiles) throws CTKException {
        String result = null;
        try {
            Molecule molecule = this.getMolecule(smiles);
            molecule.clean(2, null);
            molecule.dearomatize();
            result = molecule.exportToFormat(MOL_FORMAT);
        }
        catch (IOException e) {
            throw new CTKSmilesException("invalid SMILES!", (Throwable)e);
        }
        return result;
    }

    private String convertMolFile2SMILES(String molfile) throws CTKException {
        String result = null;
        try {
            Molecule molecule = this.getMolecule(molfile);
            result = molecule.exportToFormat(SMILES_FORMAT);
        }
        catch (IOException e) {
            throw new CTKSmilesException("invalid molfile!", (Throwable)e);
        }
        return result;
    }

    public String canonicalize(String smiles) throws CTKException, CTKSmilesException {
        String result = null;
        try {
            Molecule molecule = this.getMolecule(smiles);
            molecule.implicitizeHydrogens(255);
            result = molecule.toFormat(UNIQUE_SMILES_FORMAT);
        }
        catch (IOException e) {
            throw new CTKSmilesException("invalid SMILES!", (Throwable)e);
        }
        return result;
    }

    private Molecule getMolecule(String data) throws IOException {
        Molecule molecule = null;
        if (data != null) {
            ByteArrayInputStream is = new ByteArrayInputStream(data.getBytes());
            MolImporter importer = new MolImporter((InputStream)is);
            molecule = importer.read();
            molecule.clean(2, null);
        }
        return molecule;
    }

    public byte[] renderMol(String molFile, AbstractChemistryManipulator.OutputType outputType, int width, int height, int rgb) throws CTKException {
        byte[] result;
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             ImageOutputStream ios = ImageIO.createImageOutputStream(baos);){
            int scaledw = width / 2;
            int scaledh = scaledw * 3 / 6;
            BufferedImage image = new BufferedImage(scaledw, scaledh, 2);
            Graphics2D g = image.createGraphics();
            Rectangle drawArea = new Rectangle(-1, -1, scaledw + 1, scaledh + 1);
            g.draw(drawArea);
            Molecule mol = this.getMolecule(molFile);
            mol.hydrogenize(false);
            MolPrinter printer = new MolPrinter((MoleculeGraph)mol);
            printer.setImplicitH("all");
            System.out.println(printer.getImplicitH());
            printer.setScale(printer.maxScale(drawArea));
            printer.setBackgroundColor(new Color(rgb));
            g.setBackground(new Color(rgb));
            printer.paint((Graphics)g, drawArea);
            ImageIO.write((RenderedImage)image, outputType.toString(), ios);
            result = baos.toByteArray();
        }
        catch (IOException e) {
            throw new CTKException("unable to invoke the outputstream");
        }
        return result;
    }

    public byte[] renderSequence(String sequence, AbstractChemistryManipulator.OutputType outputType, int width, int height, int rgb) throws CTKException {
        return null;
    }

    public AbstractMolecule getMolecule(String smiles, AttachmentList attachments) throws IOException {
        ChemMolecule molecule = new ChemMolecule(this.getMolecule(smiles), attachments);
        return molecule;
    }

    public IBondBase bindAtoms(IAtomBase atom1, IAtomBase atom2) throws CTKException {
        ChemBond bond = null;
        if (!(atom1 instanceof ChemAtom) || !(atom1 instanceof ChemAtom)) {
            throw new CTKException("invalid atoms");
        }
        bond = new ChemBond(new MolBond(((ChemAtom)atom1).getMolAtom(), ((ChemAtom)atom2).getMolAtom()));
        return bond;
    }

    public IStereoElementBase getStereoInformation(AbstractMolecule molecule, IAtomBase rGroup, IAtomBase atom1, IAtomBase atom2) throws CTKException {
        if (molecule instanceof ChemMolecule && rGroup instanceof ChemAtom && atom1 instanceof ChemAtom && atom2 instanceof ChemAtom) {
            MolAtom rAtom = (MolAtom)rGroup.getMolAtom();
            MolBond chiralBond = rAtom.getBond(0);
            MolBond mergedBond = chiralBond.cloneBond((MolAtom)atom2.getMolAtom(), (MolAtom)atom1.getMolAtom());
            return new ChemStereoElement(mergedBond);
        }
        throw new CTKException("invalid input data");
    }

    public String convertMolecule(AbstractMolecule container, AbstractChemistryManipulator.StType type) throws CTKException {
        String result = null;
        Molecule molecule = (Molecule)container.getMolecule();
        switch (type) {
            case SMILES: {
                try {
                    result = this.molecule2SMILES(molecule);
                    break;
                }
                catch (MolExportException e) {
                    throw new CTKException("unable to export molecule to SMILES!", (Throwable)e);
                }
            }
            case MOLFILE: {
                try {
                    result = this.molecule2MolFile(molecule);
                    break;
                }
                catch (MolExportException e) {
                    throw new CTKException("unable to export molecule to molfile!", (Throwable)e);
                }
            }
        }
        return result;
    }

    protected boolean setStereoInformation(AbstractMolecule firstContainer, IAtomBase firstRgroup, AbstractMolecule secondContainer, IAtomBase secondRgroup, IAtomBase atom1, IAtomBase atom2) throws CTKException {
        boolean isStereo = super.setStereoInformation(firstContainer, firstRgroup, secondContainer, secondRgroup, atom1, atom2);
        if (!isStereo) {
            firstContainer.addIBase((IChemObjectBase)this.bindAtoms(atom1, atom2));
        }
        return isStereo;
    }
}

