/*
 * Decompiled with CFR 0.152.
 */
package org.helm.chemtoolkit.chemaxon;

import chemaxon.struc.CEdge;
import chemaxon.struc.CNode;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.helm.chemtoolkit.AbstractMolecule;
import org.helm.chemtoolkit.AttachmentList;
import org.helm.chemtoolkit.CTKException;
import org.helm.chemtoolkit.IAtomBase;
import org.helm.chemtoolkit.IBondBase;
import org.helm.chemtoolkit.IChemObjectBase;
import org.helm.chemtoolkit.chemaxon.ChemAtom;
import org.helm.chemtoolkit.chemaxon.ChemBond;
import org.helm.chemtoolkit.chemaxon.ChemStereoElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChemMolecule
extends AbstractMolecule {
    private static final Logger LOG = LoggerFactory.getLogger(ChemMolecule.class);
    private Molecule molecule;

    public Molecule getMolecule() {
        return this.molecule;
    }

    public ChemMolecule(Molecule molecule) {
        this.molecule = molecule;
    }

    public ChemMolecule(Molecule molecule, AttachmentList attachments) {
        this(molecule);
        this.atoms = new ArrayList();
        for (MolAtom a : molecule.getAtomArray()) {
            this.atoms.add(new ChemAtom(a));
        }
        this.attachments = attachments != null ? attachments.cloneList() : new AttachmentList();
    }

    public void removeINode(IAtomBase node) throws CTKException {
        if (node instanceof ChemAtom) {
            if (!this.atoms.contains(node)) {
                throw new CTKException("the atom not found in the molecule");
            }
        } else {
            throw new CTKException("invalid atom");
        }
        this.molecule.removeNode((CNode)((ChemAtom)node).getMolAtom());
        this.atoms.remove(node);
    }

    public void addIBase(IChemObjectBase node) {
        if (node instanceof ChemMolecule) {
            ChemMolecule nodeMolecule = (ChemMolecule)node;
            for (IAtomBase atom : nodeMolecule.getIAtomArray()) {
                this.molecule.add((CNode)((ChemAtom)atom).getMolAtom());
                this.atoms.add(atom);
            }
            for (MolBond bond : nodeMolecule.getMolecule().getBondArray()) {
                this.molecule.add((CEdge)bond);
            }
        } else if (node instanceof ChemAtom) {
            this.molecule.add((CNode)((ChemAtom)node).getMolAtom());
            this.atoms.add((ChemAtom)node);
        } else if (node instanceof ChemBond) {
            this.molecule.add((CEdge)((ChemBond)node).getMolBond());
        }
        if (node instanceof ChemStereoElement) {
            this.molecule.add((CEdge)((ChemStereoElement)node).getStereoElement());
        }
    }

    public void dearomatize() throws CTKException {
        try {
            this.molecule.dearomatize();
        }
        catch (IllegalArgumentException e) {
            throw new CTKException(e.getMessage(), (Throwable)e);
        }
    }

    public Map<String, IAtomBase> getRgroups() throws CTKException {
        this.molecule.dearomatize();
        return super.getRgroups();
    }

    public List<IBondBase> getIBondArray() {
        MolBond[] parent = this.molecule.getBondArray();
        ArrayList<IBondBase> target = new ArrayList<IBondBase>();
        for (int i = 0; i < parent.length; ++i) {
            target.add(new ChemBond(parent[i]));
        }
        return target;
    }

    public AbstractMolecule cloneMolecule() {
        ChemMolecule cloned = new ChemMolecule(this.molecule.cloneMolecule(), this.attachments.cloneList());
        return cloned;
    }

    public void generateCoordinates(int dem) throws CTKException {
        this.molecule.clean(dem, null);
    }

    public void changeAtomLabel(int index, int toIndex) throws CTKException {
        for (IAtomBase atom : this.getIAtomArray()) {
            if (atom.getFlag() == AbstractMolecule.Flag.PROCESSED || atom.getRgroup() != index) continue;
            atom.setRgroup(toIndex);
        }
    }

    public boolean isSingleStereo(IAtomBase atom) throws CTKException {
        if (atom instanceof ChemAtom) {
            MolAtom rAtom = (MolAtom)atom.getMolAtom();
            int bondCount = rAtom.getBondCount();
            if (bondCount != 1) {
                throw new CTKException("RGroup is allowed to have single connection to other atom");
            }
            MolBond bond = rAtom.getBond(0);
            int bondType = bond.getFlags() & 0x30;
            return bondType == 16 || bondType == 32 || bondType == 48;
        }
        throw new CTKException("invalid atom!");
    }

    public void removeIBase(IChemObjectBase node) {
        if (node instanceof ChemBond) {
            this.molecule.removeEdge((CEdge)((ChemBond)node).getMolBond());
        }
        if (node instanceof ChemStereoElement) {
            this.molecule.removeEdge((CEdge)((ChemStereoElement)node).getStereoElement());
        }
    }
}

