/*
 * Decompiled with CFR 0.152.
 */
package org.helm.chemtoolkit.chemaxon;

import chemaxon.struc.MolAtom;
import org.helm.chemtoolkit.AbstractMolecule;
import org.helm.chemtoolkit.IAtomBase;
import org.helm.chemtoolkit.IBondBase;
import org.helm.chemtoolkit.chemaxon.ChemBond;

public class ChemAtom
extends IAtomBase {
    private MolAtom atom;

    public MolAtom getMolAtom() {
        return this.atom;
    }

    public ChemAtom(MolAtom atom) {
        this.atom = atom;
        this.flag = AbstractMolecule.Flag.NONE;
    }

    public int getIBondCount() {
        return this.atom.getBondCount();
    }

    public int getIAtno() {
        return this.atom.getAtno();
    }

    public int getRgroup() {
        return this.atom.getRgroup();
    }

    public IBondBase getIBond(int arg0) {
        return new ChemBond(this.atom.getBond(arg0));
    }

    public IAtomBase clone() {
        return new ChemAtom((MolAtom)this.atom.clone());
    }

    public boolean compare(Object obj) {
        if (!(obj instanceof ChemAtom)) {
            return false;
        }
        MolAtom toCompare = ((ChemAtom)((Object)obj)).getMolAtom();
        return this.atom.equals(toCompare);
    }

    public void setRgroup(int rGroup) {
        this.atom.setRgroup(rGroup);
        this.flag = AbstractMolecule.Flag.PROCESSED;
    }
}

