/*
 * Decompiled with CFR 0.152.
 */
package org.helm.chemtoolkit.cdk;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.imageio.ImageIO;
import org.helm.chemtoolkit.AbstractChemistryManipulator;
import org.helm.chemtoolkit.AbstractMolecule;
import org.helm.chemtoolkit.AttachmentList;
import org.helm.chemtoolkit.CTKException;
import org.helm.chemtoolkit.CTKSmilesException;
import org.helm.chemtoolkit.IAtomBase;
import org.helm.chemtoolkit.IBondBase;
import org.helm.chemtoolkit.IChemObjectBase;
import org.helm.chemtoolkit.IStereoElementBase;
import org.helm.chemtoolkit.MoleculeInfo;
import org.helm.chemtoolkit.cdk.CDKAtom;
import org.helm.chemtoolkit.cdk.CDKBond;
import org.helm.chemtoolkit.cdk.CDKMolecule;
import org.helm.chemtoolkit.cdk.CDKStereoElement;
import org.openscience.cdk.aromaticity.Aromaticity;
import org.openscience.cdk.aromaticity.ElectronDonation;
import org.openscience.cdk.atomtype.CDKAtomTypeMatcher;
import org.openscience.cdk.depict.DepictionGenerator;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.exception.InvalidSmilesException;
import org.openscience.cdk.graph.ConnectivityChecker;
import org.openscience.cdk.graph.CycleFinder;
import org.openscience.cdk.graph.Cycles;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBioPolymer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IMolecularFormula;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.interfaces.IStereoElement;
import org.openscience.cdk.interfaces.ITetrahedralChirality;
import org.openscience.cdk.io.MDLV2000Reader;
import org.openscience.cdk.io.MDLV2000Writer;
import org.openscience.cdk.layout.StructureDiagramGenerator;
import org.openscience.cdk.silent.Bond;
import org.openscience.cdk.silent.SilentChemObjectBuilder;
import org.openscience.cdk.smiles.SmilesGenerator;
import org.openscience.cdk.smiles.SmilesParser;
import org.openscience.cdk.stereo.TetrahedralChirality;
import org.openscience.cdk.tools.CDKHydrogenAdder;
import org.openscience.cdk.tools.ProteinBuilderTool;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.openscience.cdk.tools.manipulator.AtomTypeManipulator;
import org.openscience.cdk.tools.manipulator.MolecularFormulaManipulator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CDKManipulator
extends AbstractChemistryManipulator {
    private static final Logger LOG = LoggerFactory.getLogger(CDKManipulator.class);
    private final DepictionGenerator depictionGenerator = new DepictionGenerator();

    private String normalize(String smiles) {
        String result = null;
        String[] components = smiles.split("\\|");
        result = components[0];
        return result;
    }

    public boolean validateSMILES(String smiles) {
        smiles = this.normalize(smiles);
        SmilesParser smilesParser = new SmilesParser(SilentChemObjectBuilder.getInstance());
        try {
            IAtomContainer molecule = smilesParser.parseSmiles(smiles);
            if (molecule.getAtomCount() == 0) {
                throw new InvalidSmilesException("invalid smiles!");
            }
        }
        catch (InvalidSmilesException e) {
            return false;
        }
        return true;
    }

    public MoleculeInfo getMoleculeInfo(AbstractMolecule aMolecule) throws CTKException {
        IAtomContainer molecule = (IAtomContainer)aMolecule.getMolecule();
        MoleculeInfo moleculeInfo = new MoleculeInfo();
        moleculeInfo.setMolecularWeight(AtomContainerManipulator.getNaturalExactMass((IAtomContainer)molecule));
        moleculeInfo.setMolecularFormula(MolecularFormulaManipulator.getString((IMolecularFormula)MolecularFormulaManipulator.getMolecularFormula((IAtomContainer)molecule)));
        moleculeInfo.setExactMass(MolecularFormulaManipulator.getMajorIsotopeMass((IMolecularFormula)MolecularFormulaManipulator.getMolecularFormula((IAtomContainer)molecule)));
        return moleculeInfo;
    }

    private String convertSMILES2MolFile(String smiles) throws CTKException {
        String result = null;
        try (StringWriter stringWriter = new StringWriter();
             MDLV2000Writer writer = new MDLV2000Writer((Writer)stringWriter);){
            try {
                IAtomContainer molecule = this.getIAtomContainer(smiles);
                writer.writeMolecule(molecule);
                result = stringWriter.toString();
            }
            catch (InvalidSmilesException e) {
                throw new CTKSmilesException("invalid smiles", (Throwable)e);
            }
            catch (CDKException e) {
                throw new CTKException("unable to generate coordinates", (Throwable)e);
            }
            catch (Exception e) {
                throw new CTKException("unable to write molecule", (Throwable)e);
            }
        }
        catch (IOException e) {
            throw new CTKException("unable to invoke the MDL writer", (Throwable)e);
        }
        return result;
    }

    public String convertMolIntoSmilesWithAtomMapping(String molfile) throws CTKException {
        IAtomContainer molecule = null;
        molecule = this.getIAtomContainerFromMolFile(molfile);
        SmilesGenerator sg = new SmilesGenerator(2066177);
        try {
            String smiles = sg.create(molecule);
            smiles = smiles.replace("*", "[*]");
            return this.convertExtendedSmiles(smiles);
        }
        catch (CDKException e) {
            throw new CTKException("unable to create smiles for the given molfile");
        }
    }

    public boolean isConnected(String molfile) throws CTKException {
        return ConnectivityChecker.isConnected((IAtomContainer)this.getIAtomContainerFromMolFile(molfile));
    }

    private String convertMolFile2SMILES(String molfile) throws CTKException {
        return this.convertMolecule(new CDKMolecule(this.getIAtomContainerFromMolFile(molfile)), AbstractChemistryManipulator.StType.SMILES);
    }

    private IAtomContainer getIAtomContainerFromMolFile(String molfile) throws CTKException {
        IAtomContainer result = null;
        try (StringReader stringReader = new StringReader(molfile);
             MDLV2000Reader reader = new MDLV2000Reader((Reader)stringReader);){
            IAtomContainer molecule = (IAtomContainer)reader.read((IChemObject)SilentChemObjectBuilder.getInstance().newInstance(IAtomContainer.class, new Object[0]));
            ElectronDonation model = ElectronDonation.cdk();
            CycleFinder cycles = Cycles.cdkAromaticSet();
            Aromaticity aromaticity = new Aromaticity(model, cycles);
            AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms((IAtomContainer)molecule);
            aromaticity.apply(molecule);
            for (IAtom atom : molecule.atoms()) {
                if (!(atom instanceof IPseudoAtom)) continue;
                atom.setSymbol("R");
            }
            result = molecule;
        }
        catch (IllegalArgumentException e) {
            throw new CTKException("illegal argument", (Throwable)e);
        }
        catch (CDKException e) {
            throw new CTKException("Unable to get a molecule from molfile", (Throwable)e);
        }
        catch (IOException e) {
            throw new CTKException("unable to invoke the MDL writers/readers", (Throwable)e);
        }
        return result;
    }

    public String convert(String data, AbstractChemistryManipulator.StType type) throws CTKException {
        String result = null;
        switch (type) {
            case SMILES: {
                result = this.convertSMILES2MolFile(data);
                break;
            }
            case MOLFILE: {
                result = this.convertMolFile2SMILES(data);
                break;
            }
            case SEQUENCE: {
                result = this.convertMolFile2SMILES(this.molecule2Smiles(this.getPolymer(data)));
                break;
            }
        }
        return result;
    }

    public String canonicalize(String smiles) throws CTKException, CTKSmilesException {
        IAtomContainer molecule = this.getIAtomContainer(smiles);
        SmilesGenerator generator = new SmilesGenerator(1793);
        String result = null;
        try {
            result = generator.create(molecule);
        }
        catch (CDKException e) {
            throw new CTKSmilesException("invalid smiles", (Throwable)e);
        }
        return result;
    }

    public byte[] renderMol(String molFile, AbstractChemistryManipulator.OutputType outputType, int width, int height, int rgb) throws CTKException {
        DepictionGenerator myGenerator = this.depictionGenerator.withBackgroundColor(new Color(rgb)).withSize((double)width, (double)height);
        IChemObjectBuilder bldr = SilentChemObjectBuilder.getInstance();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (StringReader stringReader = new StringReader(molFile);
             MDLV2000Reader molfileReader = new MDLV2000Reader((Reader)stringReader);){
            IAtomContainer mol = (IAtomContainer)molfileReader.read((IChemObject)bldr.newInstance(IAtomContainer.class, new Object[]{0, 0, 0, 0}));
            BufferedImage img = myGenerator.depict(mol).toImg();
            ImageIO.write((RenderedImage)img, outputType.toString(), baos);
        }
        catch (IOException e) {
            throw new CTKException("unable to invoke the reader", (Throwable)e);
        }
        catch (CDKException e) {
            throw new CTKException("invalid molfile", (Throwable)e);
        }
        byte[] result = baos.toByteArray();
        return result;
    }

    public byte[] renderSequence(String sequence, AbstractChemistryManipulator.OutputType outputType, int width, int height, int rgb) throws CTKException {
        IAtomContainer molecule = this.getPolymer(sequence);
        String molFile = this.convertSMILES2MolFile(this.molecule2Smiles(molecule));
        return this.renderMol(molFile, outputType, width, height, rgb);
    }

    private String molecule2Smiles(IAtomContainer molecule) throws CTKException {
        String result = null;
        SmilesGenerator generator = SmilesGenerator.isomeric();
        try {
            result = generator.create(molecule);
        }
        catch (CDKException e) {
            throw new CTKException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private IAtomContainer getPolymer(String sequence) throws CTKException {
        IBioPolymer polymer;
        try {
            polymer = ProteinBuilderTool.createProtein((String)sequence, (IChemObjectBuilder)SilentChemObjectBuilder.getInstance());
            CDKAtomTypeMatcher matcher = CDKAtomTypeMatcher.getInstance((IChemObjectBuilder)polymer.getBuilder());
            for (IAtom atom : polymer.atoms()) {
                IAtomType type = matcher.findMatchingAtomType((IAtomContainer)polymer, atom);
                AtomTypeManipulator.configure((IAtom)atom, (IAtomType)type);
            }
            CDKHydrogenAdder hydrogenAdder = CDKHydrogenAdder.getInstance((IChemObjectBuilder)polymer.getBuilder());
            hydrogenAdder.addImplicitHydrogens((IAtomContainer)polymer);
        }
        catch (CDKException e) {
            throw new CTKException(e.getMessage(), (Throwable)e);
        }
        return polymer;
    }

    public AbstractMolecule getMolecule(String data, AttachmentList attachments) throws CTKException {
        IAtomContainer molecule = null;
        molecule = this.validateSMILES(data) ? this.getIAtomContainer(data) : this.getIAtomContainerFromMolFile(data);
        CDKMolecule result = new CDKMolecule(molecule, attachments);
        return result;
    }

    private IAtomContainer getIAtomContainer(String smiles) throws CTKException {
        IAtomContainer molecule = null;
        LOG.debug("smiles= " + smiles);
        SmilesParser smilesParser = new SmilesParser(SilentChemObjectBuilder.getInstance());
        try {
            if (smiles.contains(".")) {
                throw new CTKException("Molecule not connected. Use ConnectivityChecker.partitionIntoMolecules() and do the layout for every single component");
            }
            molecule = smilesParser.parseSmiles(smiles);
            StructureDiagramGenerator sdg = new StructureDiagramGenerator();
            sdg.setMolecule(molecule);
            sdg.generateCoordinates();
            molecule = sdg.getMolecule();
            for (IAtom atom : molecule.atoms()) {
                int rnum;
                if (atom instanceof IPseudoAtom) {
                    String label = ((IPseudoAtom)atom).getLabel();
                    if (label.startsWith("_")) {
                        ((IPseudoAtom)atom).setLabel(label.substring(1));
                        continue;
                    }
                    if (!label.equals("*") || atom.getProperty((Object)"cdk:AtomAtomMapping") == null) continue;
                    rnum = (Integer)atom.getProperty((Object)"cdk:AtomAtomMapping");
                    this.setPseudoatomValues((IPseudoAtom)atom, rnum);
                    continue;
                }
                if (atom.getProperty((Object)"cdk:AtomAtomMapping") == null) continue;
                IPseudoAtom rGrp = (IPseudoAtom)atom.getBuilder().newInstance(IPseudoAtom.class, new Object[0]);
                rnum = (Integer)atom.getProperty((Object)"cdk:AtomAtomMapping");
                this.setPseudoatomValues(rGrp, rnum);
                AtomContainerManipulator.replaceAtomByAtom((IAtomContainer)molecule, (IAtom)atom, (IAtom)rGrp);
            }
        }
        catch (CDKException e) {
            throw new CTKException(e.getMessage(), (Throwable)e);
        }
        return molecule;
    }

    private void setPseudoatomValues(IPseudoAtom rGrp, int rnum) {
        rGrp.setAtomicNumber(Integer.valueOf(0));
        rGrp.setImplicitHydrogenCount(Integer.valueOf(0));
        rGrp.setLabel("R" + rnum);
        rGrp.setSymbol("R");
    }

    protected IBondBase bindAtoms(IAtomBase atom1, IAtomBase atom2) throws CTKException {
        CDKBond bond = null;
        if (!(atom1 instanceof CDKAtom) || !(atom1 instanceof CDKAtom)) {
            throw new CTKException("invalid atoms");
        }
        Bond newBond = new Bond(((CDKAtom)atom1).getMolAtom(), ((CDKAtom)atom2).getMolAtom());
        bond = new CDKBond((IBond)newBond);
        return bond;
    }

    protected IStereoElementBase getStereoInformation(AbstractMolecule molecule, IAtomBase rGroup, IAtomBase atom1, IAtomBase atom2) {
        TetrahedralChirality elementToAdd = null;
        Bond bondToAdd = null;
        for (IStereoElement element : ((CDKMolecule)molecule).getMolecule().stereoElements()) {
            if (!element.contains(((CDKAtom)rGroup).getMolAtom()) || !(element instanceof ITetrahedralChirality)) continue;
            IAtom[] atomArray = ((ITetrahedralChirality)element).getLigands();
            for (int i = 0; i < atomArray.length; ++i) {
                if (!atomArray[i].equals(((CDKAtom)rGroup).getMolAtom())) continue;
                IBond.Stereo st = null;
                try {
                    st = ((CDKBond)rGroup.getIBond((int)0)).bond.getStereo();
                }
                catch (CTKException e) {
                    e.printStackTrace();
                }
                bondToAdd = new Bond((IAtom)atom1.getMolAtom(), (IAtom)atom2.getMolAtom());
                bondToAdd.setStereo(st);
                atomArray[i] = (IAtom)atom1.getMolAtom();
                break;
            }
            elementToAdd = new TetrahedralChirality(((ITetrahedralChirality)element).getChiralAtom(), atomArray, ((ITetrahedralChirality)element).getStereo());
        }
        CDKStereoElement stereo = new CDKStereoElement((IStereoElement)elementToAdd);
        stereo.setBond((IBond)bondToAdd);
        return stereo;
    }

    public String convertMolecule(AbstractMolecule container, AbstractChemistryManipulator.StType type) throws CTKException {
        String result = null;
        IAtomContainer molecule = (IAtomContainer)container.getMolecule();
        switch (type) {
            case SMILES: {
                result = this.molecule2Smiles(molecule);
                break;
            }
            case MOLFILE: {
                result = this.molecule2Molfile(molecule);
            }
        }
        return result;
    }

    private String molecule2Molfile(IAtomContainer molecule) throws CTKException {
        String result = null;
        try (StringWriter stringWriter = new StringWriter();
             MDLV2000Writer writer = new MDLV2000Writer((Writer)stringWriter);){
            writer.writeMolecule(molecule);
            result = stringWriter.toString();
        }
        catch (CDKException e) {
            throw new CTKException("unable to generate coordinates", (Throwable)e);
        }
        catch (Exception e) {
            throw new CTKException("unable to write molecule", (Throwable)e);
        }
        return result;
    }

    protected boolean setStereoInformation(AbstractMolecule firstContainer, IAtomBase firstRgroup, AbstractMolecule secondContainer, IAtomBase secondRgroup, IAtomBase atom1, IAtomBase atom2) throws CTKException {
        boolean isStereo = super.setStereoInformation(firstContainer, firstRgroup, secondContainer, secondRgroup, atom1, atom2);
        if (!isStereo) {
            firstContainer.addIBase((IChemObjectBase)this.bindAtoms(atom1, atom2));
        }
        return isStereo;
    }
}

