/*
 * Decompiled with CFR 0.152.
 */
package org.helm.chemtoolkit.cdk;

import java.util.ArrayList;
import java.util.List;
import org.helm.chemtoolkit.IAtomBase;
import org.helm.chemtoolkit.IBondBase;
import org.helm.chemtoolkit.IStereoElementBase;
import org.helm.chemtoolkit.cdk.CDKAtom;
import org.helm.chemtoolkit.cdk.CDKStereoElement;
import org.openscience.cdk.interfaces.IBond;

public class CDKBond
implements IBondBase {
    protected IBond bond;
    protected CDKStereoElement stereoElement;
    protected List<IBond> bonds;

    public IBond getAtomBond() {
        return this.bond;
    }

    public CDKBond(IBond bond) {
        this.bond = bond;
        this.bonds = new ArrayList<IBond>();
        this.bonds.add(bond);
    }

    public CDKBond(IBond bond, IStereoElementBase stereo) {
        new CDKBond(bond);
        if (stereo != null && stereo instanceof CDKStereoElement) {
            this.stereoElement = (CDKStereoElement)stereo;
        }
    }

    public IAtomBase getIAtom1() {
        return new CDKAtom(this.bond.getAtom(0), 0, this.bonds);
    }

    public IAtomBase getIAtom2() {
        return new CDKAtom(this.bond.getAtom(1), 0, this.bonds);
    }

    public IStereoElementBase getStereoElement() {
        return this.stereoElement;
    }

    public int getType() {
        return this.bond.getOrder().numeric();
    }
}

