/*
 * Decompiled with CFR 0.152.
 */
package org.helm.chemtoolkit.cdk;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.helm.chemtoolkit.AbstractMolecule;
import org.helm.chemtoolkit.AttachmentList;
import org.helm.chemtoolkit.CTKException;
import org.helm.chemtoolkit.IAtomBase;
import org.helm.chemtoolkit.IBondBase;
import org.helm.chemtoolkit.IChemObjectBase;
import org.helm.chemtoolkit.cdk.CDKAtom;
import org.helm.chemtoolkit.cdk.CDKBond;
import org.helm.chemtoolkit.cdk.CDKStereoElement;
import org.openscience.cdk.aromaticity.Kekulization;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.interfaces.IStereoElement;
import org.openscience.cdk.layout.StructureDiagramGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CDKMolecule
extends AbstractMolecule {
    private static final Logger LOG = LoggerFactory.getLogger(CDKMolecule.class);
    private IAtomContainer molecule;

    public CDKMolecule(IAtomContainer molecule) {
        this(molecule, new AttachmentList());
    }

    public CDKMolecule(IAtomContainer molecule, AttachmentList attachments) {
        this.molecule = molecule;
        if (attachments != null) {
            this.setAttachments(attachments);
        } else {
            this.attachments = new AttachmentList();
        }
        this.atoms = new ArrayList();
        for (IAtom atom : molecule.atoms()) {
            int rGroupId = 0;
            if (atom instanceof IPseudoAtom) {
                atom.setSymbol("R");
                rGroupId = AbstractMolecule.getIdFromLabel((String)((IPseudoAtom)atom).getLabel());
            }
            List bonds = molecule.getConnectedBondsList(atom);
            this.atoms.add(new CDKAtom(atom, rGroupId, bonds));
        }
    }

    public Map<String, IAtomBase> getRgroups() throws CTKException {
        return super.getRgroups();
    }

    public void dearomatize() throws CTKException {
        try {
            Kekulization.kekulize((IAtomContainer)this.molecule);
        }
        catch (CDKException e) {
            throw new CTKException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeINode(IAtomBase node) throws CTKException {
        if (!(node instanceof CDKAtom)) throw new CTKException("invalid atom");
        if (!this.atoms.contains(node)) throw new CTKException("the atom not found in the molecule");
        this.molecule.removeAtomAndConnectedElectronContainers(((CDKAtom)node).atom);
        for (int i = 0; i < this.atoms.size(); ++i) {
            if (!((CDKAtom)((Object)this.atoms.get(i))).compare(node)) continue;
            this.atoms.remove(i);
            return;
        }
    }

    public void addIBase(IChemObjectBase object) {
        if (object instanceof CDKMolecule) {
            CDKMolecule container = (CDKMolecule)object;
            this.molecule.add(container.getMolecule());
            this.atoms.addAll(container.getIAtomArray());
        } else if (object instanceof CDKAtom) {
            CDKAtom atom = (CDKAtom)object;
            this.molecule.addAtom(atom.getMolAtom());
            this.atoms.add(atom);
        } else if (object instanceof CDKBond) {
            this.molecule.addBond(((CDKBond)object).bond);
        } else if (object instanceof CDKStereoElement) {
            this.molecule.addStereoElement(((CDKStereoElement)object).getStereoElement());
            this.molecule.addBond(((CDKStereoElement)object).getBond());
        }
    }

    public List<IBondBase> getIBondArray() {
        ArrayList<IBondBase> array = new ArrayList<IBondBase>();
        for (IBond item : this.molecule.bonds()) {
            array.add(new CDKBond(item));
        }
        return array;
    }

    public AbstractMolecule cloneMolecule() throws CTKException {
        CDKMolecule cloned = null;
        try {
            cloned = new CDKMolecule(this.molecule.clone(), this.attachments.cloneList());
        }
        catch (CloneNotSupportedException e) {
            throw new CTKException(e.getMessage(), (Throwable)e);
        }
        return cloned;
    }

    public void generateCoordinates(int dem) throws CTKException {
        StructureDiagramGenerator sdg = new StructureDiagramGenerator();
        sdg.setMolecule(this.molecule, false);
        try {
            sdg.generateCoordinates();
        }
        catch (CDKException e) {
            throw new CTKException(e.getMessage(), (Throwable)e);
        }
    }

    public IAtomContainer getMolecule() {
        return this.molecule;
    }

    public void changeAtomLabel(int index, int toIndex) throws CTKException {
        for (IAtomBase atom : this.getIAtomArray()) {
            int currIndex;
            if (atom.getFlag() == AbstractMolecule.Flag.PROCESSED || !(atom.getMolAtom() instanceof IPseudoAtom) || (currIndex = AbstractMolecule.getIdFromLabel((String)((IPseudoAtom)atom.getMolAtom()).getLabel())) != index) continue;
            atom.setRgroup(toIndex);
        }
    }

    public boolean isSingleStereo(IAtomBase atom) throws CTKException {
        if (atom instanceof CDKAtom) {
            if (atom.getIBondCount() != 1) {
                throw new CTKException("RGroup is allowed to have single connection to other atom");
            }
            IAtom rAtom = (IAtom)atom.getMolAtom();
            for (IStereoElement element : this.molecule.stereoElements()) {
                if (!element.contains(rAtom)) continue;
                return true;
            }
            return false;
        }
        throw new CTKException("invalid atom");
    }

    public void removeIBase(IChemObjectBase object) {
    }
}

