/*
 * Decompiled with CFR 0.152.
 */
package org.helm.chemtoolkit.cdk;

import java.util.ArrayList;
import java.util.List;
import org.helm.chemtoolkit.AbstractMolecule;
import org.helm.chemtoolkit.CTKException;
import org.helm.chemtoolkit.IAtomBase;
import org.helm.chemtoolkit.IBondBase;
import org.helm.chemtoolkit.cdk.CDKBond;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.silent.Atom;

public class CDKAtom
extends IAtomBase {
    protected IAtom atom;
    protected int rGroup;
    protected List<CDKBond> bonds;
    protected int boundCount;

    public IAtom getMolAtom() {
        return this.atom;
    }

    public CDKAtom(IAtom atom) {
        new CDKAtom(atom, 0, new ArrayList<IBond>(4));
    }

    public CDKAtom(IAtom atom, int rGroup) {
        new CDKAtom(atom, rGroup, new ArrayList<IBond>(4));
    }

    public CDKAtom(IAtom atom, int rGroup, List<IBond> bonds) {
        this.atom = atom;
        this.flag = AbstractMolecule.Flag.NONE;
        this.rGroup = rGroup;
        this.bonds = new ArrayList<CDKBond>(4);
        for (IBond bond : bonds) {
            this.bonds.add(new CDKBond(bond));
        }
    }

    public int getIBondCount() {
        return this.bonds.size();
    }

    public IBondBase getIBond(int arg0) throws CTKException {
        CDKBond bond = null;
        try {
            bond = this.bonds.get(arg0);
        }
        catch (IndexOutOfBoundsException e) {
            throw new CTKException("bond doesn't exist", (Throwable)e);
        }
        return bond;
    }

    public int getRgroup() {
        return this.rGroup;
    }

    public int getIAtno() {
        return this.atom.getAtomicNumber();
    }

    public boolean compare(Object obj) {
        if (!(obj instanceof CDKAtom)) {
            return false;
        }
        IAtom toCompare = ((CDKAtom)((Object)obj)).getMolAtom();
        if (toCompare instanceof IPseudoAtom && this.atom instanceof IPseudoAtom) {
            return ((IPseudoAtom)this.atom).getLabel().equals(((IPseudoAtom)toCompare).getLabel());
        }
        if (toCompare instanceof Atom && this.atom instanceof Atom) {
            return ((Atom)this.atom).compare(obj);
        }
        return false;
    }

    public void setRgroup(int rGroup) throws CTKException {
        if (!(this.atom instanceof IPseudoAtom)) {
            throw new CTKException("unable to set group id, the atom is not a PseudoAtom");
        }
        IPseudoAtom patom = (IPseudoAtom)this.atom;
        patom.setLabel("R" + rGroup);
        this.rGroup = rGroup;
        this.flag = AbstractMolecule.Flag.PROCESSED;
    }
}

