/*
 * Decompiled with CFR 0.152.
 */
package org.helm.chemtoolkit;

public class Attachment
implements Comparable<Attachment> {
    private String id;
    private String label;
    private String name;
    private String smiles;

    public int getCurrentIndex() {
        int result = 0;
        String[] array = this.label.split("R");
        try {
            result = Integer.parseInt(array[1]);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return result;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSmiles() {
        return this.smiles;
    }

    public void setSmiles(String smiles) {
        this.smiles = smiles;
    }

    public void changeIndex(int index) {
        String currIndex = String.valueOf(this.getCurrentIndex());
        String toIndex = String.valueOf(index);
        this.id = this.id.replace(currIndex, toIndex);
        this.label = this.label.replace(currIndex, toIndex);
        this.smiles = this.smiles.replace(currIndex, toIndex);
    }

    public Attachment cloneAttachment() {
        return new Attachment(this.id, this.label, this.name, this.smiles);
    }

    public Attachment(String id, String label, String name, String smiles) {
        this.id = id;
        this.label = label;
        this.name = name;
        this.smiles = smiles;
    }

    @Override
    public int compareTo(Attachment o) {
        int result = this.label.compareTo(o.getLabel());
        if (result != 0) {
            return result;
        }
        result = this.getCurrentIndex() - o.getCurrentIndex();
        if (result != 0) {
            return result / Math.abs(result);
        }
        return 0;
    }
}

