/*
 * Decompiled with CFR 0.152.
 */
package org.helm.chemtoolkit;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.helm.chemtoolkit.AttachmentList;
import org.helm.chemtoolkit.CTKException;
import org.helm.chemtoolkit.IAtomBase;
import org.helm.chemtoolkit.IBondBase;
import org.helm.chemtoolkit.IChemObjectBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMolecule
implements IChemObjectBase {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractMolecule.class);
    protected AttachmentList attachments;
    protected List<IAtomBase> atoms;

    public AttachmentList getAttachments() {
        return this.attachments.cloneList();
    }

    public void setAttachments(AttachmentList attachments) {
        this.attachments = attachments.cloneList();
    }

    protected AbstractMolecule() {
    }

    public Map<String, IAtomBase> getRgroups() throws CTKException {
        HashMap<String, IAtomBase> rgroupMap = new HashMap<String, IAtomBase>();
        List<IAtomBase> atoms = this.getIAtomArray();
        for (int i = 0; i < atoms.size(); ++i) {
            int rId = atoms.get(i).getRgroup();
            if (rId <= 0) continue;
            rgroupMap.put("R" + rId, atoms.get(i));
        }
        return rgroupMap;
    }

    public static int getIdFromLabel(String label) {
        int result = 0;
        String[] array = label.split("R");
        try {
            result = Integer.parseInt(array[1]);
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException runtimeException) {
            // empty catch block
        }
        return result;
    }

    public IAtomBase getRGroupAtom(int groupId, boolean rgatom) throws CTKException {
        IAtomBase result = null;
        for (IAtomBase atom : this.getIAtomArray()) {
            if (atom.getRgroup() != groupId) continue;
            if (rgatom) {
                result = atom;
                continue;
            }
            IBondBase bond = atom.getIBond(0);
            if (bond.getIAtom1().compare(atom)) {
                result = bond.getIAtom2();
                continue;
            }
            result = bond.getIAtom1();
        }
        return result;
    }

    public void clearFlags() {
        for (IAtomBase atom : this.getIAtomArray()) {
            atom.setFlag(Flag.NONE);
        }
    }

    public abstract Object getMolecule();

    public abstract void dearomatize() throws CTKException;

    public abstract void generateCoordinates(int var1) throws CTKException;

    public abstract void removeINode(IAtomBase var1) throws CTKException;

    public abstract void addIBase(IChemObjectBase var1);

    public abstract void removeIBase(IChemObjectBase var1);

    public abstract List<IBondBase> getIBondArray();

    public abstract AbstractMolecule cloneMolecule() throws CTKException;

    public abstract void changeAtomLabel(int var1, int var2) throws CTKException;

    public abstract boolean isSingleStereo(IAtomBase var1) throws CTKException;

    public void removeAttachment(IAtomBase toRemove) throws CTKException {
        Map<String, IAtomBase> groups = this.getRgroups();
        block0: for (String key : groups.keySet()) {
            if (!groups.get(key).compare(toRemove)) continue;
            for (int i = 0; i < this.attachments.size(); ++i) {
                if (!this.attachments.get(i).getLabel().equals(key)) continue;
                this.attachments.remove(i);
                continue block0;
            }
        }
    }

    public List<IAtomBase> getIAtomArray() {
        return this.atoms;
    }

    public static enum Flag {
        NONE,
        PROCESSED;

    }
}

