/*
 * Decompiled with CFR 0.152.
 */
package org.pistoiaalliance.helm.HELMSimilarityLibrary.gui.app;

import java.io.File;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.application.Platform;
import javafx.concurrent.Task;
import org.helm.notation2.parser.exceptionparser.ExceptionState;
import org.helm.notation2.parser.exceptionparser.NotationException;
import org.helm.notation2.parser.notation.HELM2Notation;
import org.pistoiaalliance.helm.HELMSimilarityLibrary.Fingerprinter;
import org.pistoiaalliance.helm.HELMSimilarityLibrary.HELM2Object;
import org.pistoiaalliance.helm.HELMSimilarityLibrary.PathGenerator;
import org.pistoiaalliance.helm.HELMSimilarityLibrary.Similarity;
import org.pistoiaalliance.helm.HELMSimilarityLibrary.exception.NaturalAnalogException;
import org.pistoiaalliance.helm.HELMSimilarityLibrary.gui.app.Database;
import org.pistoiaalliance.helm.HELMSimilarityLibrary.gui.app.Input;
import org.pistoiaalliance.helm.HELMSimilarityLibrary.gui.app.Options;
import org.pistoiaalliance.helm.HELMSimilarityLibrary.gui.app.Results;
import org.pistoiaalliance.helm.HELMSimilarityLibrary.gui.layout.AlertBox;
import org.pistoiaalliance.helm.HELMSimilarityLibrary.gui.layout.MyProgressBar;
import org.pistoiaalliance.helm.HELMSimilarityLibrary.utils.Graph;
import org.pistoiaalliance.helm.HELMSimilarityLibrary.utils.MoleculeGraphUtils;

public class SimilaritySearchTask
extends Task<Integer> {
    String url;
    BitSet queryFingerprint = new BitSet();
    BitSet queryNaturalFingerprint = new BitSet();
    private static Map<Integer, String> idWithHELM;
    protected static List<Integer> idList;
    protected static List<HELM2Notation> helmList;
    private static List<Graph> molecules;
    private static PathGenerator dfs;
    private static Set<String> allPaths;
    private static Set<String> allPathsNaturalAnalogs;
    private static List<BitSet> fingerprints;
    private static List<BitSet> fingerprintsNaturalAnalogs;
    protected static List<Double> tanimotoList;
    protected static List<Map<String, Object>> resultNotations;
    protected static MyProgressBar progressbar;
    private HELM2Notation queryNotation;
    private double desiredTanimoto;
    public static final double MAX_PROGRESS = 100.0;
    private double workDone = 0.0;
    private double steps;

    public SimilaritySearchTask(HELM2Notation queryNotation, double desiredTanimoto) {
        this.queryNotation = queryNotation;
        this.desiredTanimoto = desiredTanimoto;
    }

    protected Integer call() {
        this.doQuery(this.queryNotation, this.desiredTanimoto);
        return null;
    }

    public void doQuery(HELM2Notation queryNotation, double desiredTanimoto) {
        if (Input.getDatabasePath() == null) {
            this.updateUIerrorReport("File Error", "File not found.");
        } else if (!new File(Input.getDatabasePath()).exists()) {
            this.updateUIerrorReport("File Error", Input.getDatabasePath() + " not found or invalid.");
        } else {
            this.processQueryNotation(queryNotation);
            this.url = "jdbc:sqlite:" + Input.getDatabasePath();
            try {
                Database dbInstance = Database.getInstance();
                dbInstance.loadDriver("org.sqlite.JDBC");
                if (!this.columnExists(this.url, "HELMnotations", "OriginalFingerprint")) {
                    this.notationsToHELM2Object(dbInstance);
                    this.buildMoleculeGraphs();
                    this.generateFingerprints();
                    dbInstance.addColumn(this.url, "HELMnotations", "OriginalFingerprint");
                    dbInstance.addColumn(this.url, "HELMnotations", "NaturalFingerprint");
                    this.insertFingerprintsToDatabase(dbInstance, this.url);
                } else {
                    tanimotoList.clear();
                    this.steps = 100.0 / (double)(idList.size() * 3);
                    this.updateProgress(this.workDone, 100.0);
                }
                if (Options.radioSimSearch.isSelected()) {
                    if (Options.analogsCheckBox.isSelected()) {
                        this.calculateTanimotoToQuery(fingerprintsNaturalAnalogs, this.queryNaturalFingerprint);
                    } else {
                        this.calculateTanimotoToQuery(fingerprints, this.queryFingerprint);
                    }
                } else {
                    this.calculateTanimotoToQuery(fingerprints, this.queryFingerprint);
                }
                if (!this.columnExists(this.url, "HELMnotations", "Similarity")) {
                    dbInstance.addColumn(this.url, "HELMnotations", "Similarity");
                }
                this.insertTanimotoToDatabase(dbInstance, this.url);
                if (Options.radioSubset.isSelected()) {
                    this.doSubstructureFilter(dbInstance, this.url, this.queryFingerprint);
                    this.getSubsetNotationsFromDatabase(dbInstance, this.url, "HELMnotations", "hasSubset");
                } else {
                    this.getSimilarNotationsFromDatabase(dbInstance, this.url, "HELMnotations", "Similarity", desiredTanimoto);
                }
                Results.doResults(resultNotations);
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Results.exportButton.setDisable(false);
                    }
                });
            }
            catch (ClassNotFoundException e1) {
                this.updateUIerrorReport("Error", "");
            }
            catch (SQLException e) {
                this.updateUIerrorReport("SQL Error", "Couldn't add new column to database.");
            }
        }
    }

    private void processQueryNotation(HELM2Notation queryNotation) {
        ArrayList<Graph> queryMolecule = new ArrayList<Graph>();
        PathGenerator dfs = new PathGenerator();
        try {
            queryMolecule.add(MoleculeGraphUtils.buildMoleculeGraph(queryNotation.getListOfPolymers(), queryNotation.getListOfConnections()));
            Set<String> paths = dfs.getPaths();
            Set<String> naturalPaths = dfs.getNaturalPaths();
            dfs.findPaths((Graph)queryMolecule.get(0));
            this.queryFingerprint = Fingerprinter.getHashedFingerprint(paths);
            this.queryNaturalFingerprint = Fingerprinter.getHashedFingerprint(naturalPaths);
            this.queryNaturalFingerprint.or(this.queryFingerprint);
        }
        catch (NotationException e) {
            this.updateUIerrorReport("NotationException", "");
        }
        catch (NaturalAnalogException e) {
            this.updateUIerrorReport("NaturalAnalogException", "Couldn't find natural analog to monomer.");
        }
        catch (NoSuchAlgorithmException e) {
            this.updateUIerrorReport("NoSuchAlgorithmException", "");
        }
    }

    private void notationsToHELM2Object(Database dbInstance) {
        try {
            idWithHELM = new HashMap<Integer, String>();
            idList = new ArrayList<Integer>();
            helmList = new ArrayList<HELM2Notation>();
            this.updateUItextDisplay("Reading database...");
            idWithHELM = dbInstance.readIDandHELMRecords(this.url, "HELMnotations");
            this.steps = 100.0 / (double)(idWithHELM.size() * 7);
            this.updateUItextDisplay("Creating HELM2 objects...");
            idWithHELM.forEach((id, helm) -> {
                idList.add((Integer)id);
                try {
                    helmList.add(HELM2Object.makeHELM2NotationObject(helm));
                }
                catch (ExceptionState e) {
                    System.out.println(e.getMessage() + " at " + id + ": " + helm);
                    this.updateUIerrorReport("hier ExceptionState", e.getMessage() + " at " + id + ": " + helm);
                    this.updateUItextDisplay("");
                }
                this.workDone += this.steps;
                this.updateProgress(this.workDone, 100.0);
            });
        }
        catch (SQLException e) {
            this.updateUIerrorReport("SQL Exception", "Couldn't read ID and HELM from database.");
        }
    }

    private boolean columnExists(String url, String tablename, String columnname) {
        try {
            Connection con = DriverManager.getConnection(url);
            DatabaseMetaData md = con.getMetaData();
            ResultSet rs = md.getColumns(null, null, tablename, columnname);
            if (rs.next()) {
                return true;
            }
            rs.close();
            con.close();
        }
        catch (SQLException e) {
            this.updateUIerrorReport("SQLException", "Failed to check if column " + columnname + " exists.");
        }
        return false;
    }

    private void buildMoleculeGraphs() {
        this.updateUItextDisplay("Building molecule graphs...");
        molecules = new ArrayList<Graph>();
        helmList.forEach(helm -> {
            try {
                molecules.add(MoleculeGraphUtils.buildMoleculeGraph(helm.getListOfPolymers(), helm.getListOfConnections()));
                this.workDone += this.steps;
                this.updateProgress(this.workDone, 100.0);
            }
            catch (NotationException e) {
                this.updateUIerrorReport("NotationException", e.getMessage());
                this.updateUItextDisplay("");
            }
        });
        this.updateUItextDisplay("Molecule graphs built successfully.");
    }

    private void generateFingerprints() {
        this.updateUItextDisplay("Generating fingerprints...");
        dfs = new PathGenerator();
        allPaths = new HashSet<String>();
        allPathsNaturalAnalogs = new HashSet<String>();
        fingerprints = new ArrayList<BitSet>();
        fingerprintsNaturalAnalogs = new ArrayList<BitSet>();
        for (int j = 0; j < molecules.size(); ++j) {
            try {
                dfs.findPaths(molecules.get(j));
                allPaths = dfs.getPaths();
                allPathsNaturalAnalogs = dfs.getNaturalPaths();
                fingerprints.add(Fingerprinter.getHashedFingerprint(allPaths));
                fingerprintsNaturalAnalogs.add(Fingerprinter.getHashedFingerprint(allPathsNaturalAnalogs));
                dfs.clearPaths();
                allPaths.clear();
                allPathsNaturalAnalogs.clear();
                fingerprintsNaturalAnalogs.get(j).or(fingerprints.get(j));
                this.workDone += this.steps;
                this.updateProgress(this.workDone, 100.0);
                continue;
            }
            catch (NaturalAnalogException e) {
                this.updateUIerrorReport("NaturalAnalogException", "Couldn't find natural analog to monomer.");
                continue;
            }
            catch (NoSuchAlgorithmException e) {
                this.updateUIerrorReport("NoSuchAlgorithmException", "");
            }
        }
        this.updateUItextDisplay("Fingerprints generated successfully.");
    }

    private void insertFingerprintsToDatabase(Database dbInstance, String url) {
        this.updateUItextDisplay("Storing fingerprints in database...");
        try {
            dbInstance.insertFingerprints(url, fingerprints, fingerprintsNaturalAnalogs, idList, "HELMnotations");
            this.workDone += this.steps * (double)fingerprints.size();
            this.updateProgress(this.workDone, 100.0);
        }
        catch (SQLException e) {
            this.updateUIerrorReport("SQLException", "Couldn't insert fingerprints to database.");
        }
    }

    private void doSubstructureFilter(Database dbInstance, String url, BitSet queryFingerprint) {
        this.updateUItextDisplay("Checking for subset...");
        try {
            if (!this.columnExists(url, "HELMnotations", "hasSubset")) {
                dbInstance.addColumn(url, "HELMnotations", "hasSubset");
            }
            dbInstance.setSubset(url, queryFingerprint, idList, fingerprints);
            this.workDone += this.steps;
            this.updateProgress(this.workDone, 100.0);
        }
        catch (SQLException e) {
            this.updateUIerrorReport("SQLError", "Column 'hasSubset' could not be created");
        }
    }

    private void calculateTanimotoToQuery(List<BitSet> fingerprints, BitSet queryFingerprint) {
        this.updateUItextDisplay("Calculating similarity...");
        tanimotoList = new ArrayList<Double>();
        fingerprints.forEach(fprint -> {
            tanimotoList.add(Similarity.calculateSimilarity(queryFingerprint, fprint));
            this.workDone += this.steps;
            this.updateProgress(this.workDone, 100.0);
        });
    }

    private void insertTanimotoToDatabase(Database dbInstance, String url) {
        this.updateUItextDisplay("Storing similarity values in database...");
        try {
            dbInstance.fillHELMTanimotoTable(url, "HELMnotations", idList, tanimotoList);
            this.workDone += this.steps * (double)tanimotoList.size() - 1.0;
            this.updateProgress(this.workDone, 100.0);
        }
        catch (SQLException e) {
            this.updateUIerrorReport("SQLException", "Couldn't fill database with similarity values.");
        }
    }

    private void getSubsetNotationsFromDatabase(Database dbInstance, String url, String tablename, String columnname) {
        this.updateUItextDisplay("Selecting notations with subset from database...");
        resultNotations = new ArrayList<Map<String, Object>>();
        try {
            resultNotations = dbInstance.getNotationsWithSubset(url, tablename, columnname);
            this.updateProgress(100.0, 100.0);
            if (resultNotations.size() == 0) {
                this.updateUItextDisplay("Query notation is not a substructure of your set of notations.");
            } else if (resultNotations.size() == 1) {
                this.updateUItextDisplay("Query notation is a substructure of 1 notation.");
            } else {
                this.updateUItextDisplay("Query notation is a substructure of " + resultNotations.size() + " notations.");
            }
        }
        catch (SQLException e) {
            this.updateUIerrorReport("SQLError", "Couldn't select notations with subset.");
        }
    }

    private void getSimilarNotationsFromDatabase(final Database dbInstance, final String url, String tablename, String columnname, double desiredTanimoto) {
        resultNotations = new ArrayList<Map<String, Object>>();
        try {
            this.updateUItextDisplay("Selecting similar notations...");
            resultNotations = Options.tenSimilarCheckBox.isSelected() ? dbInstance.getMostSimilarNotations(url, tablename, columnname) : dbInstance.getNotationsWithSpecificTanimoto(url, tablename, columnname, desiredTanimoto);
            this.updateProgress(100.0, 100.0);
            if (resultNotations.size() == 0) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            double nextBiggestTanimoto = dbInstance.getBiggestTanimoto(url);
                            String tanimoto = new DecimalFormat("#0.0000").format(nextBiggestTanimoto * 100.0) + " %";
                            SimilaritySearchTask.this.updateUItextDisplay("No similar notations found.");
                            AlertBox.InfoBox("No similar notations found. The next similar notation has a similarity of " + tanimoto + " to the query.");
                        }
                        catch (SQLException e) {
                            SimilaritySearchTask.this.updateUIerrorReport("SQL Error", "Error while accessing similarity column.");
                        }
                    }
                });
            } else if (resultNotations.size() == 1) {
                this.updateUItextDisplay("1 similar notation found.");
            } else {
                this.updateUItextDisplay(resultNotations.size() + " similar notations found.");
            }
        }
        catch (SQLException e) {
            this.updateUIerrorReport("SQLException", "Couldn't get similar notations from database.");
        }
    }

    protected void updateProgress(double workDone, double max) {
        super.updateProgress(workDone, max);
    }

    void updateUItextDisplay(final String text) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                Results.changeInfoText(text);
            }
        });
    }

    void updateUIerrorReport(final String errorType, final String content) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                AlertBox.ErrorBox(errorType, content);
            }
        });
    }

    static {
        dfs = new PathGenerator();
        allPaths = new HashSet<String>();
        allPathsNaturalAnalogs = new HashSet<String>();
        fingerprints = new ArrayList<BitSet>();
        fingerprintsNaturalAnalogs = new ArrayList<BitSet>();
        progressbar = new MyProgressBar();
    }
}

