/*
 * Decompiled with CFR 0.152.
 */
package org.pistoiaalliance.helm.HELMSimilarityLibrary.gui.app;

import javafx.scene.control.ScrollBar;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.text.Font;
import org.helm.notation2.parser.exceptionparser.ExceptionState;
import org.helm.notation2.parser.notation.HELM2Notation;
import org.pistoiaalliance.helm.HELMSimilarityLibrary.HELM2Object;
import org.pistoiaalliance.helm.HELMSimilarityLibrary.gui.app.Main;
import org.pistoiaalliance.helm.HELMSimilarityLibrary.gui.app.SimilaritySearch;
import org.pistoiaalliance.helm.HELMSimilarityLibrary.gui.layout.AlertBox;
import org.pistoiaalliance.helm.HELMSimilarityLibrary.gui.layout.MyButton;
import org.pistoiaalliance.helm.HELMSimilarityLibrary.gui.layout.MyCheckBox;
import org.pistoiaalliance.helm.HELMSimilarityLibrary.gui.layout.MyLabel;
import org.pistoiaalliance.helm.HELMSimilarityLibrary.gui.layout.MyRadioButton;
import org.pistoiaalliance.helm.HELMSimilarityLibrary.gui.layout.MyText;
import org.pistoiaalliance.helm.HELMSimilarityLibrary.gui.layout.MyTextField;

public class Options
extends Main {
    private ToggleGroup radioButtonGroup = new ToggleGroup();
    private ToggleGroup simSearchGroup = new ToggleGroup();
    protected static MyRadioButton radioSimSearch;
    protected static MyRadioButton radioSubset;
    protected MyLabel title;
    protected MyLabel helmText;
    protected MyRadioButton scrollCheckBox;
    protected static MyButton button;
    protected MyTextField queryHelmTextField;
    private HELM2Notation queryNotation;
    protected MyTextField tanimotoTextField;
    private int defaultTanimoto = 50;
    private double desiredSimilarity;
    protected MyText tanimotoUnit;
    protected ScrollBar scrollBar;
    protected static MyRadioButton tenSimilarCheckBox;
    protected static MyCheckBox analogsCheckBox;

    public Options() {
        radioSimSearch = new MyRadioButton("Similarity search", 14.0, this.radioButtonGroup);
        this.radioButtSimSearchAction();
        radioSubset = new MyRadioButton("Substructure filter", 14.0, this.radioButtonGroup);
        this.radioButtSubsetAction();
        this.title = new MyLabel("Options");
        this.helmText = new MyLabel("Query HELM notation:");
        this.scrollCheckBox = new MyRadioButton("Show notations with a minimum similarity of", 13.0, this.simSearchGroup);
        this.scrollCheckBoxAction();
        button = new MyButton("Run query");
        button.setDisable(true);
        this.setButtonProperties();
        this.tanimotoUnit = new MyText("%");
        this.tanimotoUnit.setFont(Font.font((String)"Calibri", (double)13.0));
        this.tanimotoTextField = new MyTextField(Double.toString(this.defaultTanimoto), 35.0, 11.0);
        this.setTanimotoTextFieldAction();
        this.queryHelmTextField = new MyTextField("Paste HELM notation here.", 590.0, 12.0);
        this.setHelmTextFieldProperties();
        this.scrollBar = new ScrollBar();
        this.setScrollBarProperties();
        this.setBindingProperties();
        tenSimilarCheckBox = new MyRadioButton("Show 10 most similar notations", 13.0, this.simSearchGroup);
        this.tenSimilarCheckBoxAction();
        analogsCheckBox = new MyCheckBox("Consider natural analogs");
        analogsCheckBox.setSelected(false);
    }

    private void radioButtSimSearchAction() {
        radioSimSearch.setSelected(true);
        radioSimSearch.setOnAction(radioSimSearchAction -> {
            this.scrollCheckBox.setStyle("-fx-opacity: 1");
            this.scrollBar.setDisable(false);
            this.tanimotoUnit.setStyle("-fx-opacity: 1");
            this.tanimotoTextField.setDisable(false);
            tenSimilarCheckBox.setDisable(false);
            analogsCheckBox.setDisable(false);
        });
    }

    private void radioButtSubsetAction() {
        radioSubset.setOnAction(radioSubsetAction -> {
            if (radioSubset.isSelected()) {
                this.scrollCheckBox.setStyle("-fx-opacity: 0.4");
                this.scrollBar.setDisable(true);
                this.tanimotoUnit.setStyle("-fx-opacity: 0.4");
                this.tanimotoTextField.setDisable(true);
                tenSimilarCheckBox.setDisable(true);
                analogsCheckBox.setDisable(true);
            }
        });
    }

    private void scrollCheckBoxAction() {
        this.scrollCheckBox.setSelected(true);
        this.scrollCheckBox.setOnAction(event -> {
            tenSimilarCheckBox.setSelected(false);
            this.scrollBar.setDisable(false);
            this.tanimotoTextField.setDisable(false);
            this.tanimotoUnit.setStyle("-fx-opacity: 1");
        });
    }

    private void setButtonProperties() {
        button.setOnAction(helmEvent -> {
            if (this.queryHelmTextField.getCharacters().toString() == null || this.queryHelmTextField.getCharacters().toString() == "") {
                AlertBox.ErrorBox("Invalid HELM notation", "Please enter your query HELM notation.");
            }
            Tooltip queryHelmTooltip = new Tooltip();
            queryHelmTooltip.setText(this.queryHelmTextField.getText());
            this.queryHelmTextField.setTooltip(queryHelmTooltip);
            this.runQueryButton();
        });
    }

    private void setHelmTextFieldProperties() {
        this.queryHelmTextField.setMinWidth(600.0);
        this.queryHelmTextField.setMaxWidth(600.0);
        this.queryHelmTextField.setOnAction(this);
    }

    private void setTanimotoTextFieldAction() {
        this.tanimotoTextField.setText(Integer.toString(this.defaultTanimoto));
        this.tanimotoTextField.setEditable(false);
        this.tanimotoTextField.setOnAction(this);
    }

    private void setScrollBarProperties() {
        this.scrollBar.setMinWidth(200.0);
        this.scrollBar.setMin(0.0);
        this.scrollBar.setMax(100.0);
        this.scrollBar.setValue((double)this.defaultTanimoto);
    }

    private void setBindingProperties() {
        this.scrollBar.valueProperty().addListener((scrollTanimoto, oldScroll, newScroll) -> {
            int value = newScroll.intValue();
            String valueString = Integer.toString(value);
            this.tanimotoTextField.setText(valueString);
        });
    }

    private void tenSimilarCheckBoxAction() {
        tenSimilarCheckBox.setSelected(false);
        tenSimilarCheckBox.setOnAction(event -> {
            this.scrollCheckBox.setSelected(false);
            this.scrollBar.setDisable(true);
            this.tanimotoTextField.setDisable(true);
            this.tanimotoUnit.setStyle("-fx-opacity: 0.4");
        });
    }

    private void runQueryButton() {
        if (this.queryHelmTextField.getCharacters().toString() == null || this.queryHelmTextField.getCharacters().toString() == "") {
            AlertBox.ErrorBox("Invalid HELM notation", "Please enter your query HELM notation.");
        } else {
            try {
                this.queryNotation = HELM2Object.makeHELM2NotationObject(this.queryHelmTextField.getCharacters().toString());
                this.desiredSimilarity = Double.parseDouble(this.tanimotoTextField.getText());
                this.desiredSimilarity /= 100.0;
                SimilaritySearch similaritySearch = new SimilaritySearch(this.queryNotation, this.desiredSimilarity);
            }
            catch (ExceptionState e) {
                AlertBox.ErrorBox("Notation Error", "Invalid HELM notation.");
            }
        }
    }

    public HELM2Notation getQueryNotation() {
        return this.queryNotation;
    }

    public double getSimilarity() {
        return this.desiredSimilarity;
    }
}

