/*
 * Decompiled with CFR 0.152.
 */
package org.pistoiaalliance.helm.HELMSimilarityLibrary.gui.app;

import javafx.application.Application;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;
import org.pistoiaalliance.helm.HELMSimilarityLibrary.gui.app.ExportTask;
import org.pistoiaalliance.helm.HELMSimilarityLibrary.gui.app.FileToDatabase;
import org.pistoiaalliance.helm.HELMSimilarityLibrary.gui.app.Input;
import org.pistoiaalliance.helm.HELMSimilarityLibrary.gui.app.Options;
import org.pistoiaalliance.helm.HELMSimilarityLibrary.gui.app.Results;
import org.pistoiaalliance.helm.HELMSimilarityLibrary.gui.app.SimilaritySearchTask;

public class Main
extends Application
implements EventHandler<ActionEvent> {
    private BorderPane mainLayout;
    private GridPane topLayout;
    private GridPane centerLayout;
    private GridPane bottomLayout;

    public void init() {
        this.mainLayout = new BorderPane();
        this.topLayout = new GridPane();
        this.centerLayout = new GridPane();
        this.bottomLayout = new GridPane();
    }

    public void start(Stage stage) {
        try {
            Scene scene = new Scene((Parent)this.mainLayout, 700.0, 720.0);
            Options options = new Options();
            this.setMainLayout();
            this.setTopLayout(stage);
            this.setCenterLayout(options);
            this.setBottomLayout(options);
            stage.getIcons().add((Object)new Image("file:./images/HELM_logo.png"));
            stage.setTitle("HELMSimilarityLibrary");
            stage.setScene(scene);
            stage.show();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setMainLayout() {
        this.mainLayout.setTop((Node)this.topLayout);
        this.mainLayout.setCenter((Node)this.centerLayout);
        this.mainLayout.setBottom((Node)this.bottomLayout);
    }

    private void setTopLayout(Stage stage) {
        Input input = new Input(stage);
        Object[] objectArray = new Node[10];
        objectArray[0] = input.inputTitle;
        objectArray[1] = input.helpButton;
        objectArray[2] = input.textfileText;
        objectArray[3] = input.textfileButton;
        objectArray[4] = input.buildDatabaseButton;
        objectArray[5] = input.textfileNameDisplay;
        objectArray[6] = input.databaseText;
        objectArray[7] = Input.databaseNameDisplay;
        objectArray[8] = FileToDatabase.progress;
        objectArray[9] = FileToDatabase.infoText;
        this.topLayout.getChildren().addAll(objectArray);
        this.topLayout.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        this.topLayout.setVgap(8.0);
        this.topLayout.setHgap(10.0);
        GridPane.setConstraints((Node)input.inputTitle, (int)0, (int)0);
        GridPane.setConstraints((Node)input.helpButton, (int)1, (int)0);
        GridPane.setConstraints((Node)input.textfileText, (int)0, (int)1, (int)3, (int)1);
        GridPane.setConstraints((Node)input.textfileButton, (int)3, (int)1);
        GridPane.setConstraints((Node)input.textfileNameDisplay, (int)4, (int)1);
        GridPane.setConstraints((Node)input.buildDatabaseButton, (int)3, (int)2);
        GridPane.setConstraints((Node)input.databaseText, (int)0, (int)2, (int)3, (int)1);
        GridPane.setConstraints((Node)Input.databaseNameDisplay, (int)4, (int)2);
        GridPane.setConstraints((Node)FileToDatabase.progress, (int)0, (int)3, (int)5, (int)1);
        GridPane.setConstraints((Node)FileToDatabase.infoText, (int)0, (int)4, (int)2, (int)1);
    }

    private void setCenterLayout(Options options) {
        Object[] objectArray = new Node[9];
        objectArray[0] = options.title;
        objectArray[1] = Options.analogsCheckBox;
        objectArray[2] = Options.tenSimilarCheckBox;
        objectArray[3] = Options.radioSimSearch;
        objectArray[4] = Options.radioSubset;
        objectArray[5] = options.scrollCheckBox;
        objectArray[6] = options.tanimotoUnit;
        objectArray[7] = options.scrollBar;
        objectArray[8] = options.tanimotoTextField;
        this.centerLayout.getChildren().addAll(objectArray);
        this.centerLayout.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        this.centerLayout.setVgap(8.0);
        this.centerLayout.setHgap(10.0);
        GridPane.setConstraints((Node)options.title, (int)0, (int)0);
        GridPane.setConstraints((Node)Options.radioSimSearch, (int)0, (int)1);
        GridPane.setConstraints((Node)options.scrollCheckBox, (int)0, (int)2);
        GridPane.setMargin((Node)options.scrollCheckBox, (Insets)new Insets(0.0, 0.0, 0.0, 30.0));
        GridPane.setConstraints((Node)options.scrollBar, (int)1, (int)2);
        GridPane.setMargin((Node)options.scrollBar, (Insets)new Insets(0.0, 0.0, 0.0, 30.0));
        GridPane.setConstraints((Node)options.tanimotoTextField, (int)2, (int)2);
        GridPane.setConstraints((Node)options.tanimotoUnit, (int)3, (int)2);
        GridPane.setMargin((Node)options.tanimotoUnit, (Insets)new Insets(0.0, 20.0, 0.0, 0.0));
        GridPane.setConstraints((Node)Options.tenSimilarCheckBox, (int)0, (int)3);
        GridPane.setMargin((Node)Options.tenSimilarCheckBox, (Insets)new Insets(0.0, 0.0, 0.0, 30.0));
        GridPane.setConstraints((Node)Options.analogsCheckBox, (int)0, (int)4);
        GridPane.setMargin((Node)Options.analogsCheckBox, (Insets)new Insets(0.0, 0.0, 0.0, 30.0));
        GridPane.setConstraints((Node)Options.radioSubset, (int)0, (int)5);
    }

    private void setBottomLayout(Options options) {
        Results results = new Results();
        this.bottomLayout.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        this.bottomLayout.setVgap(8.0);
        this.bottomLayout.setHgap(10.0);
        Object[] objectArray = new Node[9];
        objectArray[0] = options.helmText;
        objectArray[1] = options.queryHelmTextField;
        objectArray[2] = Options.button;
        objectArray[3] = results.title;
        objectArray[4] = Results.infoText;
        objectArray[5] = Results.getResultNotations();
        objectArray[6] = SimilaritySearchTask.progressbar;
        objectArray[7] = Results.exportButton;
        objectArray[8] = ExportTask.exportInfoText;
        this.bottomLayout.getChildren().addAll(objectArray);
        this.bottomLayout.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        GridPane.setConstraints((Node)options.helmText, (int)0, (int)0, (int)2, (int)1);
        GridPane.setConstraints((Node)options.queryHelmTextField, (int)0, (int)1, (int)2, (int)1);
        GridPane.setConstraints((Node)Options.button, (int)1, (int)1);
        GridPane.setHalignment((Node)Options.button, (HPos)HPos.RIGHT);
        GridPane.setConstraints((Node)results.title, (int)0, (int)2);
        GridPane.setMargin((Node)results.title, (Insets)new Insets(7.0, 0.0, 0.0, 0.0));
        GridPane.setConstraints(Results.getResultNotations(), (int)0, (int)3, (int)3, (int)1);
        GridPane.setConstraints((Node)SimilaritySearchTask.progressbar, (int)0, (int)4, (int)2, (int)1);
        GridPane.setConstraints((Node)Results.infoText, (int)0, (int)5, (int)2, (int)1);
        GridPane.setConstraints((Node)Results.exportButton, (int)0, (int)6);
        GridPane.setConstraints((Node)ExportTask.exportInfoText, (int)1, (int)6);
    }

    public void stop() {
    }

    public static void main(String[] args) {
        Main.launch((String[])args);
    }

    public void handle(ActionEvent event) {
    }
}

