/*
 * Decompiled with CFR 0.152.
 */
package org.pistoiaalliance.helm.HELMSimilarityLibrary.gui.app;

import java.io.File;
import java.sql.SQLException;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import org.apache.commons.io.FilenameUtils;
import org.pistoiaalliance.helm.HELMSimilarityLibrary.gui.app.CreateDatabaseTask;
import org.pistoiaalliance.helm.HELMSimilarityLibrary.gui.app.Database;
import org.pistoiaalliance.helm.HELMSimilarityLibrary.gui.app.Input;
import org.pistoiaalliance.helm.HELMSimilarityLibrary.gui.app.Options;
import org.pistoiaalliance.helm.HELMSimilarityLibrary.gui.layout.AlertBox;
import org.pistoiaalliance.helm.HELMSimilarityLibrary.gui.layout.MyProgressBar;
import org.pistoiaalliance.helm.HELMSimilarityLibrary.gui.layout.MyText;

public class FileToDatabase {
    protected static MyText infoText = new MyText(true);
    protected static MyProgressBar progress = new MyProgressBar();

    protected static void processTextFile(String databaseDirPath) {
        Database dbInstance = Database.getInstance();
        FileToDatabase.createDatabaseWithTable(databaseDirPath, dbInstance);
        FileToDatabase.storeNotationsInDatabase(dbInstance);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                Options.button.setDisable(false);
            }
        });
    }

    private static void createDatabaseWithTable(String databaseDirPath, Database dbInstance) {
        try {
            infoText.setText("Creating database...");
            String rawfileName = FilenameUtils.getBaseName((String)Input.getTextfileName());
            String url = "jdbc:sqlite:" + databaseDirPath + "/" + rawfileName + ".db";
            File f = new File(Input.getDatabasePath());
            if (f.exists() && !f.isDirectory()) {
                dbInstance.deleteContentFromDB(url);
                f.delete();
            }
            dbInstance.createTable(url, "HELMnotations", "ID", "HELM");
        }
        catch (SQLException e) {
            FileToDatabase.updateUIerrorReport("SQLException", "Couldn't create or connect to database: " + Input.getDatabasePath());
        }
    }

    private static void storeNotationsInDatabase(Database dbInstance) {
        CreateDatabaseTask createDBtask = new CreateDatabaseTask(dbInstance);
        progress.progressProperty().bind((ObservableValue)createDBtask.progressProperty());
        infoText.setText("Filling database with HELM notations...");
        new Thread((Runnable)((Object)createDBtask)).start();
        infoText.setText("Database created successfully.");
    }

    static void updateUIerrorReport(final String errorType, final String content) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                AlertBox.ErrorBox(errorType, content);
            }
        });
    }
}

